/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class PrepareRamNearestTarget<E extends EntityCreature>
extends Behavior<E> {
    public static final int c = 160;
    private final ToIntFunction<E> d;
    private final int e;
    private final int f;
    private final float g;
    private final PathfinderTargetCondition h;
    private final int i;
    private final Function<E, SoundEffect> j;
    private Optional<Long> k = Optional.empty();
    private Optional<a> l = Optional.empty();

    public PrepareRamNearestTarget(ToIntFunction<E> tointfunction, int i2, int j2, float f2, PathfinderTargetCondition pathfindertargetcondition, int k2, Function<E, SoundEffect> function) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.U, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a), MemoryModuleType.V, (Object)((Object)MemoryStatus.b)), 160);
        this.d = tointfunction;
        this.e = i2;
        this.f = j2;
        this.g = f2;
        this.h = pathfindertargetcondition;
        this.i = k2;
        this.j = function;
    }

    protected void a(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        BehaviorController<?> behaviorcontroller = entitycreature.dK();
        behaviorcontroller.c(MemoryModuleType.h).flatMap(nearestvisiblelivingentities -> nearestvisiblelivingentities.a(entityliving -> this.h.a(entitycreature, (EntityLiving)entityliving))).ifPresent(entityliving -> {
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityliving, entityliving instanceof EntityPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled() || event.getTarget() == null) {
                return;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            this.b(entitycreature, (EntityLiving)entityliving);
        });
    }

    @Override
    protected void b(WorldServer worldserver, E e0, long i2) {
        BehaviorController<Vec3D> behaviorcontroller = ((EntityLiving)e0).dK();
        if (!behaviorcontroller.a(MemoryModuleType.V)) {
            worldserver.a((Entity)e0, (byte)59);
            behaviorcontroller.a(MemoryModuleType.U, Integer.valueOf(this.d.applyAsInt(e0)));
        }
    }

    protected boolean c(WorldServer worldserver, EntityCreature entitycreature, long i2) {
        return this.l.isPresent() && this.l.get().c().bs();
    }

    @Override
    protected void d(WorldServer worldserver, E e0, long i2) {
        if (!this.l.isEmpty()) {
            boolean flag;
            ((EntityLiving)e0).dK().a(MemoryModuleType.m, new MemoryTarget(this.l.get().a(), this.g, 0));
            ((EntityLiving)e0).dK().a(MemoryModuleType.n, new BehaviorPositionEntity(this.l.get().c(), true));
            boolean bl = flag = !this.l.get().c().di().equals(this.l.get().b());
            if (flag) {
                worldserver.a((Entity)e0, (byte)59);
                ((EntityInsentient)e0).J().n();
                this.b((EntityCreature)e0, this.l.get().c);
            } else {
                BlockPosition blockposition = ((Entity)e0).di();
                if (blockposition.equals(this.l.get().a())) {
                    worldserver.a((Entity)e0, (byte)58);
                    if (this.k.isEmpty()) {
                        this.k = Optional.of(i2);
                    }
                    if (i2 - this.k.get() >= (long)this.i) {
                        ((EntityLiving)e0).dK().a(MemoryModuleType.V, this.a(blockposition, this.l.get().b()));
                        worldserver.a(null, (Entity)e0, this.j.apply(e0), SoundCategory.g, 1.0f, ((EntityLiving)e0).eS());
                        this.l = Optional.empty();
                    }
                }
            }
        }
    }

    private Vec3D a(BlockPosition blockposition, BlockPosition blockposition1) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)MathHelper.j((double)(blockposition1.u() - blockposition.u()));
        double d2 = 0.5 * (double)MathHelper.j((double)(blockposition1.w() - blockposition.w()));
        return Vec3D.c(blockposition1).b(d1, 0.0, d2);
    }

    private Optional<BlockPosition> a(EntityCreature entitycreature, EntityLiving entityliving) {
        BlockPosition blockposition = entityliving.di();
        if (!this.a(entitycreature, blockposition)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.j();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            blockposition_mutableblockposition.g(blockposition);
            for (int i2 = 0; i2 < this.f; ++i2) {
                if (this.a(entitycreature, (BlockPosition)blockposition_mutableblockposition.c(enumdirection))) {
                    continue;
                }
                blockposition_mutableblockposition.c(enumdirection.g());
                break;
            }
            if (blockposition_mutableblockposition.k(blockposition) < this.e) continue;
            list.add(blockposition_mutableblockposition.i());
        }
        NavigationAbstract navigationabstract = entitycreature.J();
        Stream stream = list.stream();
        BlockPosition blockposition1 = entitycreature.di();
        Objects.requireNonNull(blockposition1);
        return stream.sorted(Comparator.comparingDouble(blockposition1::j)).filter(blockposition2 -> {
            PathEntity pathentity = navigationabstract.a((BlockPosition)blockposition2, 0);
            return pathentity != null && pathentity.j();
        }).findFirst();
    }

    private boolean a(EntityCreature entitycreature, BlockPosition blockposition) {
        return entitycreature.J().a(blockposition) && entitycreature.a(PathfinderNormal.a((IBlockAccess)entitycreature.dI(), blockposition.j())) == 0.0f;
    }

    private void b(EntityCreature entitycreature, EntityLiving entityliving) {
        this.k = Optional.empty();
        this.l = this.a(entitycreature, entityliving).map(blockposition -> new a((BlockPosition)blockposition, entityliving.di(), entityliving));
    }

    public static class a {
        private final BlockPosition a;
        private final BlockPosition b;
        final EntityLiving c;

        public a(BlockPosition blockposition, BlockPosition blockposition1, EntityLiving entityliving) {
            this.a = blockposition;
            this.b = blockposition1;
            this.c = entityliving;
        }

        public BlockPosition a() {
            return this.a;
        }

        public BlockPosition b() {
            return this.b;
        }

        public EntityLiving c() {
            return this.c;
        }
    }
}

