/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class TemptingSensor
extends Sensor<EntityCreature> {
    public static final int a = 10;
    private static final PathfinderTargetCondition c = PathfinderTargetCondition.b().a(10.0).d();
    private final RecipeItemStack d;

    public TemptingSensor(RecipeItemStack recipeitemstack) {
        this.d = recipeitemstack;
    }

    @Override
    protected void a(WorldServer worldserver, EntityCreature entitycreature) {
        BehaviorController<?> behaviorcontroller = entitycreature.dK();
        Stream<EntityPlayer> stream = worldserver.v().stream().filter(IEntitySelector.f).filter(entityplayer -> c.a(entitycreature, (EntityLiving)entityplayer)).filter(entityplayer -> entitycreature.a((Entity)entityplayer, 10.0)).filter(this::a).filter(entityplayer -> !entitycreature.u((Entity)entityplayer));
        Objects.requireNonNull(entitycreature);
        List list = stream.sorted(Comparator.comparingDouble(entitycreature::f)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            EntityHuman entityhuman = (EntityHuman)list.get(0);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityhuman, EntityTargetEvent.TargetReason.TEMPT);
            if (event.isCancelled()) {
                return;
            }
            if (event.getTarget() instanceof HumanEntity) {
                behaviorcontroller.a(MemoryModuleType.N, ((CraftHumanEntity)event.getTarget()).getHandle());
            } else {
                behaviorcontroller.b(MemoryModuleType.N);
            }
        } else {
            behaviorcontroller.b(MemoryModuleType.N);
        }
    }

    private boolean a(EntityHuman entityhuman) {
        return this.a(entityhuman.eO()) || this.a(entityhuman.eP());
    }

    private boolean a(ItemStack itemstack) {
        return this.d.a(itemstack);
    }

    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.N);
    }
}

