/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import org.slf4j.Logger;

public class VillagePlaceSection {
    private static final Logger a = LogUtils.getLogger();
    private final Short2ObjectMap<VillagePlaceRecord> b = new Short2ObjectOpenHashMap();
    private final Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> c = Maps.newHashMap();
    private final Runnable d;
    private boolean e;

    public static Codec<VillagePlaceSection> a(Runnable var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)RecordCodecBuilder.point((Object)var0), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(var0 -> var0.e), (App)VillagePlaceRecord.a(var0).listOf().fieldOf("Records").forGetter(var0 -> ImmutableList.copyOf((Collection)var0.b.values()))).apply((Applicative)var1, VillagePlaceSection::new)).orElseGet(SystemUtils.a("Failed to read POI section: ", arg_0 -> ((Logger)a).error(arg_0)), () -> new VillagePlaceSection(var0, false, (List<VillagePlaceRecord>)ImmutableList.of()));
    }

    public VillagePlaceSection(Runnable var0) {
        this(var0, true, (List<VillagePlaceRecord>)ImmutableList.of());
    }

    private VillagePlaceSection(Runnable var0, boolean var1, List<VillagePlaceRecord> var2) {
        this.d = var0;
        this.e = var1;
        var2.forEach(this::a);
    }

    public Stream<VillagePlaceRecord> a(Predicate<Holder<VillagePlaceType>> var02, VillagePlace.Occupancy var12) {
        return this.c.entrySet().stream().filter(var1 -> var02.test((Holder)var1.getKey())).flatMap(var0 -> ((Set)var0.getValue()).stream()).filter(var12.a());
    }

    public void a(BlockPosition var02, Holder<VillagePlaceType> var1) {
        if (this.a(new VillagePlaceRecord(var02, var1, this.d))) {
            a.debug("Added POI of type {} @ {}", (Object)var1.e().map(var0 -> var0.a().toString()).orElse("[unregistered]"), (Object)var02);
            this.d.run();
        }
    }

    private boolean a(VillagePlaceRecord var02) {
        BlockPosition var1 = var02.f();
        Holder<VillagePlaceType> var2 = var02.g();
        short var3 = SectionPosition.b(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)this.b.get(var3);
        if (var4 != null) {
            if (var2.equals(var4.g())) {
                return false;
            }
            SystemUtils.a("POI data mismatch: already registered at " + var1);
        }
        this.b.put(var3, (Object)var02);
        this.c.computeIfAbsent(var2, var0 -> Sets.newHashSet()).add(var02);
        return true;
    }

    public void a(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.b.remove(SectionPosition.b(var0));
        if (var1 == null) {
            a.error("POI data mismatch: never registered at {}", (Object)var0);
            return;
        }
        this.c.get(var1.g()).remove(var1);
        a.debug("Removed POI of type {} @ {}", LogUtils.defer(var1::g), LogUtils.defer(var1::f));
        this.d.run();
    }

    @Deprecated
    @VisibleForDebug
    public int b(BlockPosition var0) {
        return this.e(var0).map(VillagePlaceRecord::a).orElse(0);
    }

    public boolean c(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.b.get(SectionPosition.b(var0));
        if (var1 == null) {
            throw SystemUtils.b(new IllegalStateException("POI never registered at " + var0));
        }
        boolean var2 = var1.c();
        this.d.run();
        return var2;
    }

    public boolean a(BlockPosition var0, Predicate<Holder<VillagePlaceType>> var1) {
        return this.d(var0).filter(var1).isPresent();
    }

    public Optional<Holder<VillagePlaceType>> d(BlockPosition var0) {
        return this.e(var0).map(VillagePlaceRecord::g);
    }

    private Optional<VillagePlaceRecord> e(BlockPosition var0) {
        return Optional.ofNullable((VillagePlaceRecord)this.b.get(SectionPosition.b(var0)));
    }

    public void a(Consumer<BiConsumer<BlockPosition, Holder<VillagePlaceType>>> var0) {
        if (!this.e) {
            Short2ObjectOpenHashMap var1 = new Short2ObjectOpenHashMap(this.b);
            this.b();
            var0.accept((arg_0, arg_1) -> this.a((Short2ObjectMap)var1, arg_0, arg_1));
            this.e = true;
            this.d.run();
        }
    }

    private void b() {
        this.b.clear();
        this.c.clear();
    }

    boolean a() {
        return this.e;
    }

    private /* synthetic */ void a(Short2ObjectMap var0, BlockPosition var1, Holder var22) {
        short var3 = SectionPosition.b(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)var0.computeIfAbsent(var3, var2 -> new VillagePlaceRecord(var1, var22, this.d));
        this.a(var4);
    }
}

