/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int bV = 6000;
    public int bT;
    @Nullable
    public UUID bU;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void W() {
        if (this.h() != 0) {
            this.bT = 0;
        }
        super.W();
    }

    @Override
    public void b_() {
        super.b_();
        if (this.h() != 0) {
            this.bT = 0;
        }
        if (this.bT > 0) {
            --this.bT;
            if (this.bT % 10 == 0) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                this.dI().a(Particles.M, this.d(1.0), this.dq() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.d()).a(Blocks.i) ? 10.0f : iworldreader.v(blockposition);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("InLove", this.bT);
        if (this.bU != null) {
            nbttagcompound.a("LoveCause", this.bU);
        }
    }

    @Override
    public double bw() {
        return 0.14;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.bT = nbttagcompound.h("InLove");
        this.bU = nbttagcompound.b("LoveCause") ? nbttagcompound.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.d()).a(TagsBlock.bN) && EntityAnimal.a(generatoraccess, blockposition);
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int M() {
        return 120;
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    public int ea() {
        return 1 + this.dI().z.a(3);
    }

    public boolean m(ItemStack itemstack) {
        return itemstack.a(Items.oI);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.m(itemstack)) {
            int i2 = this.h();
            if (!this.dI().B && i2 == 0 && this.fZ()) {
                this.a(entityhuman, enumhand, itemstack);
                this.g(entityhuman);
                return EnumInteractionResult.a;
            }
            if (this.h_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                return EnumInteractionResult.a(this.dI().B);
            }
            if (this.dI().B) {
                return EnumInteractionResult.b;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        if (!entityhuman.fO().d) {
            itemstack.h(1);
        }
    }

    public boolean fZ() {
        return this.bT <= 0;
    }

    public void g(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.bT = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman != null) {
            this.bU = entityhuman.ct();
        }
        this.breedItem = entityhuman.fN().f();
        this.dI().a((Entity)this, (byte)18);
    }

    public void s(int i2) {
        this.bT = i2;
    }

    public int ga() {
        return this.bT;
    }

    @Nullable
    public EntityPlayer gb() {
        if (this.bU == null) {
            return null;
        }
        EntityHuman entityhuman = this.dI().b(this.bU);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gc() {
        return this.bT > 0;
    }

    public void gd() {
        this.bT = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.gc() && entityanimal.gc());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dn(), this.dp(), this.dt(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gb()).or(() -> Optional.ofNullable(entityanimal.gb())).orElse(null);
            int experience = this.ec().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.ec().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.gb()).or(() -> Optional.ofNullable(entityanimal.gb())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.o.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.c_(6000);
        entityanimal.c_(6000);
        this.gd();
        entityanimal.gd();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.X().b(GameRules.f) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dn(), this.dp(), this.dt(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            int i2 = 0;
            while (i2 < 7) {
                double d0 = this.af.k() * 0.02;
                double d1 = this.af.k() * 0.02;
                double d2 = this.af.k() * 0.02;
                this.dI().a(Particles.M, this.d(1.0), this.dq() + 0.5, this.g(1.0), d0, d1, d2);
                ++i2;
            }
        } else {
            super.b(b0);
        }
    }
}

