/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> bY = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int bZ = 1;
    public static final int bT = 4;
    public static final int bU = 8;
    public static final int bW = 16;
    private static final int ca = 32;
    private static final int cb = 64;
    private static final int cc = 128;
    public static final DataWatcherObject<Optional<UUID>> cd = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    public static final DataWatcherObject<Optional<UUID>> ce = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    static final Predicate<EntityItem> cf = entityitem -> !entityitem.r() && entityitem.bs();
    private static final Predicate<Entity> cg = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.ef() != null && entityliving.eg() < entityliving.ag + 600;
    };
    static final Predicate<Entity> ch = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> ci = entity -> !entity.bS() && IEntitySelector.e.test((Entity)entity);
    private static final int cj = 600;
    private PathfinderGoal ck;
    private PathfinderGoal cl;
    private PathfinderGoal cm;
    private float cn;
    private float co;
    float cp;
    float cq;
    private int cr;

    public EntityFox(EntityTypes<? extends EntityFox> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.bK = new k();
        this.bL = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.s(true);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cd, Optional.empty());
        this.am.a(ce, Optional.empty());
        this.am.a(bX, 0);
        this.am.a(bY, (byte)0);
    }

    @Override
    protected void x() {
        this.ck = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cl = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bU);
        this.cm = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bO.a(0, new g());
        this.bO.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dI()));
        this.bO.a(1, new b());
        this.bO.a(2, new n(2.2));
        this.bO.a(3, new e(1.0));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> ci.test((Entity)entityliving) && !this.c(entityliving.ct()) && !this.gk()));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).q() && !this.gk()));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gk()));
        this.bO.a(5, new u());
        this.bO.a(6, new o());
        this.bO.a(6, new s(1.25));
        this.bO.a(7, new l((double)1.2f, true));
        this.bO.a(7, new t());
        this.bO.a(8, new h(this, 1.25));
        this.bO.a(9, new q(32, 200));
        this.bO.a(10, new f((double)1.2f, 12, 1));
        this.bO.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bO.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(11, new p());
        this.bO.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bO.a(13, new r());
        this.bP.a(3, new a(EntityLiving.class, false, false, entityliving -> cg.test((Entity)entityliving) && !this.c(entityliving.ct())));
    }

    @Override
    public SoundEffect d(ItemStack itemstack) {
        return SoundEffects.ic;
    }

    @Override
    public void b_() {
        if (!this.dI().B && this.bs() && this.cV()) {
            EntityLiving entityliving;
            ++this.cr;
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (this.l(itemstack)) {
                if (this.cr > 600) {
                    ItemStack itemstack1 = itemstack.a(this.dI(), this);
                    if (!itemstack1.b()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cr = 0;
                } else if (this.cr > 560 && this.af.i() < 0.1f) {
                    this.a(this.d(itemstack), 1.0f, 1.0f);
                    this.dI().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.j()) == null || !entityliving.bs()) {
                this.y(false);
                this.z(false);
            }
        }
        if (this.fy() || this.eT()) {
            this.bk = false;
            this.bl = 0.0f;
            this.bn = 0.0f;
        }
        super.b_();
        if (this.gk() && this.af.i() < 0.05f) {
            this.a(SoundEffects.hY, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean eT() {
        return this.es();
    }

    private boolean l(ItemStack itemstack) {
        return itemstack.d().u() && this.j() == null && this.ay() && !this.fy();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.2f) {
            float f2 = randomsource.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.nL) : (f2 < 0.2f ? new ItemStack(Items.qd) : (f2 < 0.4f ? (randomsource.h() ? new ItemStack(Items.tJ) : new ItemStack(Items.tK)) : (f2 < 0.6f ? new ItemStack(Items.oI) : (f2 < 0.8f ? new ItemStack(Items.pP) : new ItemStack(Items.oF)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 45) {
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (!itemstack.b()) {
                int i2 = 0;
                while (i2 < 8) {
                    Vec3D vec3d = new Vec3D(((double)this.af.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dA() * ((float)Math.PI / 180)).b(-this.dy() * ((float)Math.PI / 180));
                    this.dI().a(new ParticleParamItem(Particles.O, itemstack), this.dn() + this.bD().c / 2.0, this.dp(), this.dt() + this.bD().e / 2.0, vec3d.c, vec3d.d + 0.05, vec3d.e);
                    ++i2;
                }
            }
        } else {
            super.b(b0);
        }
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 32.0).a(GenericAttributes.f, 2.0);
    }

    @Nullable
    public EntityFox b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityFox entityfox = EntityTypes.N.a(worldserver);
        if (entityfox != null) {
            entityfox.a(this.af.h() ? this.r() : ((EntityFox)entityageable).r());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.d()).a(TagsBlock.bU) && EntityFox.a(generatoraccess, blockposition);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        Holder<BiomeBase> holder = worldaccess.s(this.di());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (groupdataentity instanceof i) {
            i entityfox_i = (i)groupdataentity;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (worldaccess instanceof WorldServer) {
            this.gi();
        }
        this.a(worldaccess.y_(), difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    private void gi() {
        if (this.r() == Type.a) {
            this.bP.a(4, this.ck);
            this.bP.a(4, this.cl);
            this.bP.a(6, this.cm);
        } else {
            this.bP.a(4, this.cm);
            this.bP.a(6, this.ck);
            this.bP.a(6, this.cl);
        }
    }

    @Override
    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        if (this.m(itemstack)) {
            this.a(this.d(itemstack), 1.0f, 1.0f);
        }
        super.a(entityhuman, enumhand, itemstack);
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return this.h_() ? entitysize.b * 0.85f : 0.4f;
    }

    public Type r() {
        return Type.a(this.am.b(bX));
    }

    @Override
    public void a(Type entityfox_type) {
        this.am.b(bX, entityfox_type.a());
    }

    List<UUID> gj() {
        ArrayList list = Lists.newArrayList();
        list.add(this.am.b(cd).orElse(null));
        list.add(this.am.b(ce).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.am.b(cd).isPresent()) {
            this.am.b(ce, Optional.ofNullable(uuid));
        } else {
            this.am.b(cd, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        List<UUID> list = this.gj();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbttagcompound.a("Trusted", nbttaglist);
        nbttagcompound.a("Sleeping", this.fy());
        nbttagcompound.a("Type", this.r().c());
        nbttagcompound.a("Sitting", this.w());
        nbttagcompound.a("Crouching", this.bU());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.c("Trusted", 11);
        int i2 = 0;
        while (i2 < nbttaglist.size()) {
            this.b(GameProfileSerializer.a(nbttaglist.k(i2)));
            ++i2;
        }
        this.C(nbttagcompound.q("Sleeping"));
        this.a(Type.a(nbttagcompound.l("Type")));
        this.w(nbttagcompound.q("Sitting"));
        this.y(nbttagcompound.q("Crouching"));
        if (this.dI() instanceof WorldServer) {
            this.gi();
        }
    }

    public boolean w() {
        return this.t(1);
    }

    public void w(boolean flag) {
        this.d(1, flag);
    }

    public boolean fY() {
        return this.t(64);
    }

    void A(boolean flag) {
        this.d(64, flag);
    }

    boolean gk() {
        return this.t(128);
    }

    void B(boolean flag) {
        this.d(128, flag);
    }

    @Override
    public boolean fy() {
        return this.t(32);
    }

    public void C(boolean flag) {
        this.d(32, flag);
    }

    private void d(int i2, boolean flag) {
        if (flag) {
            this.am.b(bY, (byte)(this.am.b(bY) | i2));
        } else {
            this.am.b(bY, (byte)(this.am.b(bY) & ~i2));
        }
    }

    private boolean t(int i2) {
        return (this.am.b(bY) & i2) != 0;
    }

    @Override
    public boolean f(ItemStack itemstack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
        return !this.c(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.f(itemstack);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        Item item = itemstack.d();
        ItemStack itemstack1 = this.c(EnumItemSlot.a);
        return itemstack1.b() || this.cr > 0 && item.u() && !itemstack1.d().u();
    }

    private void n(ItemStack itemstack) {
        if (!itemstack.b() && !this.dI().B) {
            EntityItem entityitem = new EntityItem(this.dI(), this.dn() + this.bD().c, this.dp() + 1.0, this.dt() + this.bD().e, itemstack);
            entityitem.b(40);
            entityitem.c(this.ct());
            this.a(SoundEffects.ih, 1.0f, 1.0f);
            this.dI().b(entityitem);
        }
    }

    private void o(ItemStack itemstack) {
        EntityItem entityitem = new EntityItem(this.dI(), this.dn(), this.dp(), this.dt(), itemstack);
        this.dI().b(entityitem);
    }

    @Override
    protected void b(EntityItem entityitem) {
        ItemStack itemstack = entityitem.j();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, itemstack.L() - 1, !this.j(itemstack)).isCancelled()) {
            itemstack = entityitem.j();
            int i2 = itemstack.L();
            if (i2 > 1) {
                this.o(itemstack.a(i2 - 1));
            }
            this.n(this.c(EnumItemSlot.a));
            this.a(entityitem);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.e(EnumItemSlot.a);
            this.a((Entity)entityitem, itemstack.L());
            entityitem.ai();
            this.cr = 0;
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.cV()) {
            boolean flag = this.aV();
            if (flag || this.j() != null || this.dI().Y()) {
                this.gl();
            }
            if (flag || this.fy()) {
                this.w(false);
            }
            if (this.fY() && this.dI().z.i() < 0.2f) {
                BlockPosition blockposition = this.di();
                IBlockData iblockdata = this.dI().a_(blockposition);
                this.dI().c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.co = this.cn;
        this.cn = this.gh() ? (this.cn += (1.0f - this.cn) * 0.4f) : (this.cn += (0.0f - this.cn) * 0.4f);
        this.cq = this.cp;
        if (this.bU()) {
            this.cp += 0.2f;
            if (this.cp > 3.0f) {
                this.cp = 3.0f;
            }
        } else {
            this.cp = 0.0f;
        }
    }

    @Override
    public boolean m(ItemStack itemstack) {
        return itemstack.a(TagsItem.X);
    }

    @Override
    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
        ((EntityFox)entityinsentient).b(entityhuman.ct());
    }

    public boolean ge() {
        return this.t(16);
    }

    public void x(boolean flag) {
        this.d(16, flag);
    }

    public boolean gf() {
        return this.bk;
    }

    public boolean gg() {
        return this.cp == 3.0f;
    }

    public void y(boolean flag) {
        this.d(4, flag);
    }

    @Override
    public boolean bU() {
        return this.t(4);
    }

    public void z(boolean flag) {
        this.d(8, flag);
    }

    public boolean gh() {
        return this.t(8);
    }

    public float D(float f2) {
        return MathHelper.i(f2, this.co, this.cn) * 0.11f * (float)Math.PI;
    }

    public float E(float f2) {
        return MathHelper.i(f2, this.cq, this.cp);
    }

    @Override
    public void h(@Nullable EntityLiving entityliving) {
        if (this.gk() && entityliving == null) {
            this.B(false);
        }
        super.h(entityliving);
    }

    @Override
    protected int d(float f2, float f1) {
        return MathHelper.f((f2 - 5.0f) * f1);
    }

    void gl() {
        this.C(false);
    }

    void gm() {
        this.z(false);
        this.y(false);
        this.w(false);
        this.C(false);
        this.B(false);
        this.A(false);
    }

    boolean gn() {
        return !this.fy() && !this.w() && !this.fY();
    }

    @Override
    public void N() {
        SoundEffect soundeffect = this.s();
        if (soundeffect == SoundEffects.ie) {
            this.a(soundeffect, 2.0f, this.eS());
        } else {
            super.N();
        }
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        List<Entity> list;
        if (this.fy()) {
            return SoundEffects.if;
        }
        if (!this.dI().N() && this.af.i() < 0.1f && (list = this.dI().a(EntityHuman.class, this.cE().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.ie;
        }
        return SoundEffects.hZ;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.id;
    }

    @Override
    @Nullable
    protected SoundEffect g_() {
        return SoundEffects.ib;
    }

    boolean c(UUID uuid) {
        return this.gj().contains(uuid);
    }

    @Override
    protected void g(DamageSource damagesource) {
        ItemStack itemstack = this.c(EnumItemSlot.a);
        if (!itemstack.b()) {
            this.b(itemstack);
            this.a(EnumItemSlot.a, ItemStack.b);
        }
        super.g(damagesource);
    }

    public static boolean a(EntityFox entityfox, EntityLiving entityliving) {
        double d0 = entityliving.dt() - entityfox.dt();
        double d1 = entityliving.dn() - entityfox.dn();
        double d2 = d0 / d1;
        boolean flag = true;
        int i2 = 0;
        while (i2 < 6) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            int j2 = 1;
            while (j2 < 4) {
                if (!entityfox.dI().a_(BlockPosition.a(entityfox.dn() + d4, entityfox.dp() + (double)j2, entityfox.dt() + d3)).r()) {
                    return false;
                }
                ++j2;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.55f * this.cF(), this.dd() * 0.4f);
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;

        static {
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String s2) {
            return c.a(s2, a);
        }

        public static Type a(int i2) {
            return d.apply(i2);
        }

        public static Type a(Holder<BiomeBase> holder) {
            return holder.a(BiomeTags.aq) ? b : a;
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean a() {
            if (this.b > 0 && this.e.ec().a(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.gj()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.dI() instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.dI()).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.ed();
                int i2 = entityliving.ee();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void c() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.ee();
            }
            EntityFox.this.a(SoundEffects.hY, 1.0f, 1.0f);
            EntityFox.this.B(true);
            EntityFox.this.gl();
            super.c();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityFox.this.fY();
        }

        @Override
        public boolean b() {
            return this.a() && this.a > 0;
        }

        @Override
        public void c() {
            this.a = this.a(40);
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
        }

        @Override
        public void e() {
            --this.a;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).q() : (entityliving instanceof EntityHuman && (entityliving.G_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.ct()) ? false : !entityliving.fy() && !entityliving.bS()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dn(), EntityFox.this.cE().e, EntityFox.this.dt());
            return !EntityFox.this.dI().g(blockposition) && EntityFox.this.h(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.dI().a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cE().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public void c() {
            ((EntityFox)this.a).gm();
            ((EntityFox)this.c).gm();
            super.c();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gb();
                EntityPlayer entityplayer1 = this.c.gb();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.ct());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.ct());
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dn(), this.a.dp(), this.a.dt(), 0.0f, 0.0f);
                int experience = this.a.ec().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.o.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gd();
                this.c.gd();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.X().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dn(), this.a.dp(), this.a.dt(), experience));
                }
            }
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.a_(blockposition);
            return iblockdata.a(Blocks.oi) && iblockdata.c(BlockSweetBerryBush.b) >= 2 || CaveVines.h_(iblockdata);
        }

        @Override
        public void e() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.af.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.ig, 1.0f, 1.0f);
            }
            super.e();
        }

        protected void o() {
            if (EntityFox.this.dI().X().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.dI().a_(this.e);
                if (iblockdata.a(Blocks.oi)) {
                    this.b(iblockdata);
                } else if (CaveVines.h_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData iblockdata) {
            CaveVines.a(EntityFox.this, iblockdata, EntityFox.this.dI(), this.e);
        }

        private void b(IBlockData iblockdata) {
            int i2 = iblockdata.c(BlockSweetBerryBush.b);
            iblockdata.a(BlockSweetBerryBush.b, 1);
            if (CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)iblockdata.a(BlockSweetBerryBush.b, 1)).isCancelled()) {
                return;
            }
            int j2 = 1 + EntityFox.this.dI().z.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.vv));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.dI(), this.e, new ItemStack(Items.vv, j2));
            }
            EntityFox.this.a(SoundEffects.xz, 1.0f, 1.0f);
            EntityFox.this.dI().a(this.e, (IBlockData)iblockdata.a(BlockSweetBerryBush.b, 1), 2);
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fy() && super.a();
        }

        @Override
        public void c() {
            this.g = 0;
            EntityFox.this.w(false);
            super.c();
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void c() {
            super.c();
            EntityFox.this.gm();
        }

        @Override
        public boolean a() {
            return EntityFox.this.aV() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bi();
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox e;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.e = entityfox;
        }

        @Override
        public boolean a() {
            return !this.e.gk() && super.a();
        }

        @Override
        public boolean b() {
            return !this.e.gk() && super.b();
        }

        @Override
        public void c() {
            this.e.gm();
            super.c();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type entityfox_type) {
            super(false);
            this.a = entityfox_type;
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient entityinsentient, Class oclass, float f2) {
            super(entityinsentient, oclass, f2);
        }

        @Override
        public boolean a() {
            return super.a() && !EntityFox.this.fY() && !EntityFox.this.gh();
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.fY() && !EntityFox.this.gh();
        }
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fy()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.ge() && !EntityFox.this.bU() && !EntityFox.this.gh() && !EntityFox.this.fY();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving entityliving, double d0) {
            double d1 = this.a(entityliving);
            if (d0 <= d1 && this.i()) {
                this.h();
                this.a.z(entityliving);
                EntityFox.this.a(SoundEffects.ia, 1.0f, 1.0f);
            }
        }

        @Override
        public void c() {
            EntityFox.this.z(false);
            super.c();
        }

        @Override
        public boolean a() {
            return !EntityFox.this.w() && !EntityFox.this.fy() && !EntityFox.this.bU() && !EntityFox.this.fY() && super.a();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gn()) {
                super.a();
            }
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gk() && super.h();
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean a() {
            if (!EntityFox.this.gg()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null && entityliving.bs()) {
                if (entityliving.cC() != entityliving.cB()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.J().a((Entity)entityliving, 0);
                    EntityFox.this.y(false);
                    EntityFox.this.z(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null && entityliving.bs()) {
                double d0 = EntityFox.this.dl().d;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dA()) >= 15.0f || !EntityFox.this.ay()) && !EntityFox.this.fY();
            }
            return false;
        }

        @Override
        public boolean J_() {
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.r(true);
            EntityFox.this.x(true);
            EntityFox.this.z(false);
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null) {
                EntityFox.this.E().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dn() - EntityFox.this.dn(), entityliving.dp() - EntityFox.this.dp(), entityliving.dt() - EntityFox.this.dt()).d();
                EntityFox.this.f(EntityFox.this.dl().b(vec3d.c * 0.8, 0.9, vec3d.e * 0.8));
            }
            EntityFox.this.J().n();
        }

        @Override
        public void d() {
            EntityFox.this.y(false);
            EntityFox.this.cp = 0.0f;
            EntityFox.this.cq = 0.0f;
            EntityFox.this.z(false);
            EntityFox.this.x(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null) {
                EntityFox.this.E().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.fY()) {
                Vec3D vec3d = EntityFox.this.dl();
                if (vec3d.d * vec3d.d < (double)0.03f && EntityFox.this.dA() != 0.0f) {
                    EntityFox.this.b_(MathHelper.j(0.2f, EntityFox.this.dA(), 0.0f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.d) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.b_((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.e((Entity)entityliving) <= 2.0f) {
                EntityFox.this.z(entityliving);
            } else if (EntityFox.this.dA() > 0.0f && EntityFox.this.ay() && (float)EntityFox.this.dl().d != 0.0f && EntityFox.this.dI().a_(EntityFox.this.di()).a(Blocks.dN)) {
                EntityFox.this.b_(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.A(true);
            }
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.c(EnumItemSlot.a).b()) {
                return false;
            }
            if (EntityFox.this.j() == null && EntityFox.this.ed() == null) {
                if (!EntityFox.this.gn()) {
                    return false;
                }
                if (EntityFox.this.ec().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.dI().a(EntityItem.class, EntityFox.this.cE().c(8.0, 8.0, 8.0), cf);
                return !list.isEmpty() && EntityFox.this.c(EnumItemSlot.a).b();
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityFox.this.dI().a(EntityItem.class, EntityFox.this.cE().c(8.0, 8.0, 8.0), cf);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b() && !list.isEmpty()) {
                EntityFox.this.J().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityFox.this.dI().a(EntityItem.class, EntityFox.this.cE().c(8.0, 8.0, 8.0), cf);
            if (!list.isEmpty()) {
                EntityFox.this.J().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void c() {
            EntityFox.this.gm();
            super.c();
        }

        @Override
        public boolean a() {
            return super.a() && this.h();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fy() && !EntityFox.this.w() && !EntityFox.this.gk() && EntityFox.this.j() == null;
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityFox.this.ed() == null && EntityFox.this.ec().i() < 0.02f && !EntityFox.this.fy() && EntityFox.this.j() == null && EntityFox.this.J().l() && !this.i() && !EntityFox.this.ge() && !EntityFox.this.bU();
        }

        @Override
        public boolean b() {
            return this.f > 0;
        }

        @Override
        public void c() {
            this.k();
            this.f = 2 + EntityFox.this.ec().a(3);
            EntityFox.this.w(true);
            EntityFox.this.J().n();
        }

        @Override
        public void d() {
            EntityFox.this.w(false);
        }

        @Override
        public void e() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.E().a(EntityFox.this.dn() + this.c, EntityFox.this.dr(), EntityFox.this.dt() + this.d, EntityFox.this.fC(), EntityFox.this.X());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.ec().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.ec().a(20));
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.fy() && this.a.j() == null) {
                if (EntityFox.this.dI().Y() && EntityFox.this.dI().g(this.a.di())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.di();
                return EntityFox.this.dI().N() && EntityFox.this.dI().g(blockposition) && !((WorldServer)EntityFox.this.dI()).b(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.gm();
            super.c();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.af.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean a() {
            return EntityFox.this.bl == 0.0f && EntityFox.this.bm == 0.0f && EntityFox.this.bn == 0.0f ? this.k() || EntityFox.this.fy() : false;
        }

        @Override
        public boolean b() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dI().N() && this.h() && !this.i() && !EntityFox.this.az;
        }

        @Override
        public void d() {
            this.d = EntityFox.this.af.a(c);
            EntityFox.this.gm();
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.y(false);
            EntityFox.this.z(false);
            EntityFox.this.r(false);
            EntityFox.this.C(true);
            EntityFox.this.J().n();
            EntityFox.this.G().a(EntityFox.this.dn(), EntityFox.this.dp(), EntityFox.this.dt(), 0.0);
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            if (EntityFox.this.fy()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.j();
            return entityliving != null && entityliving.bs() && ch.test(entityliving) && EntityFox.this.f((Entity)entityliving) > 36.0 && !EntityFox.this.bU() && !EntityFox.this.gh() && !EntityFox.this.bk;
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.A(false);
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.z(true);
                EntityFox.this.y(true);
                EntityFox.this.J().n();
                EntityFox.this.E().a(entityliving, (float)EntityFox.this.fC(), (float)EntityFox.this.X());
            } else {
                EntityFox.this.z(false);
                EntityFox.this.y(false);
            }
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.j();
            if (entityliving != null) {
                EntityFox.this.E().a(entityliving, (float)EntityFox.this.fC(), (float)EntityFox.this.X());
                if (EntityFox.this.f((Entity)entityliving) <= 36.0) {
                    EntityFox.this.z(true);
                    EntityFox.this.y(true);
                    EntityFox.this.J().n();
                } else {
                    EntityFox.this.J().a((Entity)entityliving, 1.5);
                }
            }
        }
    }
}

