/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bT = DataWatcher.a(EntityPig.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final RecipeItemStack bW = RecipeItemStack.a(Items.tl, Items.tm, Items.uq);
    public final SaddleStorage bX;

    public EntityPig(EntityTypes<? extends EntityPig> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.bX = new SaddleStorage(this.am, bU, bT);
    }

    @Override
    protected void x() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bO.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(4, new PathfinderGoalTempt(this, 1.2, RecipeItemStack.a(Items.nf), false));
        this.bO.a(4, new PathfinderGoalTempt(this, 1.2, bW, false));
        this.bO.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.i() && (entity = this.cO()) instanceof EntityHuman && ((entityhuman = (EntityHuman)entity).eO().a(Items.nf) || entityhuman.eP().a(Items.nf))) {
            return entityhuman;
        }
        return null;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bU.equals(datawatcherobject) && this.dI().B) {
            this.bX.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bT, false);
        this.am.a(bU, 0);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        this.bX.a(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.bX.b(nbttagcompound);
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.rO;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.rQ;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.rP;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.rS, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.m(entityhuman.b(enumhand));
        if (!flag && this.i() && !this.bN() && !entityhuman.fD()) {
            if (!this.dI().B) {
                entityhuman.k(this);
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return itemstack.a(Items.mZ) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.d;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean g() {
        return this.bs() && !this.h_();
    }

    @Override
    protected void eu() {
        super.eu();
        if (this.i()) {
            this.a((IMaterial)Items.mZ);
        }
    }

    @Override
    public boolean i() {
        return this.bX.d();
    }

    @Override
    public void a(@Nullable SoundCategory soundcategory) {
        this.bX.a(true);
        if (soundcategory != null) {
            this.dI().a(null, this, SoundEffects.rR, soundcategory, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        EnumDirection enumdirection = this.cC();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(entityliving);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.di();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : entityliving.fv()) {
            AxisAlignedBB axisalignedbb = entityliving.g(entitypose);
            int[][] aint1 = aint;
            int i2 = aint.length;
            int j2 = 0;
            while (j2 < i2) {
                int[] aint2 = aint1[j2];
                blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v(), blockposition.w() + aint2[1]);
                double d0 = this.dI().i(blockposition_mutableblockposition);
                if (DismountUtil.a(d0)) {
                    Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                    if (DismountUtil.a(this.dI(), entityliving, axisalignedbb.c(vec3d))) {
                        entityliving.b(entitypose);
                        return vec3d;
                    }
                }
                ++j2;
            }
        }
        return super.b(entityliving);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.ai() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = EntityTypes.bs.a(worldserver);
            if (entitypigzombie != null) {
                entitypigzombie.a(EnumItemSlot.a, new ItemStack(Items.oh));
                entitypigzombie.b(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
                entitypigzombie.t(this.fQ());
                entitypigzombie.a(this.h_());
                if (this.aa()) {
                    entitypigzombie.b(this.ab());
                    entitypigzombie.n(this.cy());
                }
                entitypigzombie.fF();
                if (CraftEventFactory.callPigZapEvent(this, entitylightning, entitypigzombie).isCancelled()) {
                    return;
                }
                worldserver.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.ai();
            } else {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        super.a(entityhuman, vec3d);
        this.a(entityhuman.dy(), entityhuman.dA() * 0.5f);
        this.aV = this.aX = this.dy();
        this.M = this.aX;
        this.bX.b();
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman entityhuman) {
        return (float)(this.b(GenericAttributes.d) * 0.225 * (double)this.bX.c());
    }

    @Override
    public boolean a() {
        return this.bX.a(this.ec());
    }

    @Nullable
    public EntityPig b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.av.a(worldserver);
    }

    @Override
    public boolean m(ItemStack itemstack) {
        return bW.a(itemstack);
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.6f * this.cF(), this.dd() * 0.4f);
    }
}

