/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte c = 16;
    private static final float d = 1.7f;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> entitytypes, World world) {
        super((EntityTypes<? extends EntityGolem>)entitytypes, world);
    }

    @Override
    protected void x() {
        this.bO.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bO.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bO.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(4, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.y().a(GenericAttributes.a, 4.0).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Pumpkin", this.r());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.e("Pumpkin")) {
            this.w(nbttagcompound.q("Pumpkin"));
        }
    }

    @Override
    public boolean fb() {
        return true;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.dI().B) {
            if (this.dI().s(this.di()).a(BiomeTags.ad)) {
                this.a(this.dJ().melting, 1.0f);
            }
            if (!this.dI().X().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.dN.n();
            int i2 = 0;
            while (i2 < 4) {
                int j2 = MathHelper.a(this.dn() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.a(this.dp());
                int l2 = MathHelper.a(this.dt() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (this.dI().a_(blockposition).i() && iblockdata.a((IWorldReader)this.dI(), blockposition) && CraftEventFactory.handleBlockFormEvent(this.dI(), blockposition, iblockdata, this)) {
                    this.dI().a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
                }
                ++i2;
            }
        }
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        EntitySnowball entitysnowball = new EntitySnowball(this.dI(), this);
        double d0 = entityliving.dr() - (double)1.1f;
        double d1 = entityliving.dn() - this.dn();
        double d2 = d0 - entitysnowball.dp();
        double d3 = entityliving.dt() - this.dt();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.c(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.a(SoundEffects.wT, 1.0f, 0.4f / (this.ec().i() * 0.4f + 0.8f));
        this.dI().b(entitysnowball);
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return 1.7f;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.rg) && this.a()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                return EnumInteractionResult.d;
            }
            this.a(SoundCategory.h);
            this.a(GameEvent.N, (Entity)entityhuman);
            if (!this.dI().B) {
                itemstack.a(1, entityhuman, (T entityhuman1) -> entityhuman1.d(enumhand));
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(SoundCategory soundcategory) {
        this.dI().a(null, this, SoundEffects.wU, soundcategory, 1.0f, 1.0f);
        if (!this.dI().r_()) {
            this.w(false);
            this.forceDrops = true;
            this.a(new ItemStack(Items.eP), 1.7f);
            this.forceDrops = false;
        }
    }

    @Override
    public boolean a() {
        return this.bs() && this.r();
    }

    public boolean r() {
        return (this.am.b(b) & 0x10) != 0;
    }

    public void w(boolean flag) {
        byte b0 = this.am.b(b);
        if (flag) {
            this.am.b(b, (byte)(b0 | 0x10));
        } else {
            this.am.b(b, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return SoundEffects.wQ;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.wS;
    }

    @Override
    @Nullable
    protected SoundEffect g_() {
        return SoundEffects.wR;
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.75f * this.cF(), this.dd() * 0.4f);
    }
}

