/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    public static final Predicate<EntityLiving> bW = entityliving -> {
        EntityTypes<?> entitytypes = entityliving.ae();
        return entitytypes == EntityTypes.aF || entitytypes == EntityTypes.aC || entitytypes == EntityTypes.N;
    };
    private static final float ca = 8.0f;
    private static final float cb = 20.0f;
    private float cc;
    private float cd;
    private boolean ce;
    private boolean cf;
    private float cg;
    private float ch;
    private static final UniformInt ci = TimeRange.a(20, 39);
    @Nullable
    private UUID cj;

    public EntityWolf(EntityTypes<? extends EntityWolf> entitytypes, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)entitytypes, world);
        this.x(false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void x() {
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(1, new b(1.5));
        this.bO.a(2, new PathfinderGoalSit(this));
        this.bO.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bO.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bO.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bO.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.bO.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(10, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bP.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bP.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bP.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bW));
        this.bP.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bU));
        this.bP.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bP.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public static AttributeProvider.Builder ge() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 8.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fire) {
        if (!super.setTarget(entityliving, reason, fire)) {
            return false;
        }
        entityliving = this.j();
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bX, false);
        this.am.a(bY, EnumColor.o.a());
        this.am.a(bZ, 0);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Ap, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("CollarColor", (byte)this.gh().a());
        this.c(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbttagcompound.h("CollarColor")));
        }
        this.a(this.dI(), nbttagcompound);
    }

    @Override
    protected SoundEffect s() {
        return this.S_() ? SoundEffects.Ak : (this.af.a(3) == 0 ? (this.q() && this.er() < 10.0f ? SoundEffects.Aq : SoundEffects.An) : SoundEffects.Ai);
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.Am;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.Aj;
    }

    @Override
    protected float eR() {
        return 0.4f;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.dI().B && this.ce && !this.cf && !this.fV() && this.ay()) {
            this.cf = true;
            this.cg = 0.0f;
            this.ch = 0.0f;
            this.dI().a((Entity)this, (byte)8);
        }
        if (!this.dI().B) {
            this.a((WorldServer)this.dI(), true);
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.bs()) {
            this.cd = this.cc;
            this.cc = this.gi() ? (this.cc += (1.0f - this.cc) * 0.4f) : (this.cc += (0.0f - this.cc) * 0.4f);
            if (this.aX()) {
                this.ce = true;
                if (this.cf && !this.dI().B) {
                    this.dI().a((Entity)this, (byte)56);
                    this.gj();
                }
            } else if ((this.ce || this.cf) && this.cf) {
                if (this.cg == 0.0f) {
                    this.a(SoundEffects.Ao, this.eR(), (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                    this.a(GameEvent.v);
                }
                this.ch = this.cg;
                this.cg += 0.05f;
                if (this.ch >= 2.0f) {
                    this.ce = false;
                    this.cf = false;
                    this.ch = 0.0f;
                    this.cg = 0.0f;
                }
                if (this.cg > 0.4f) {
                    float f2 = (float)this.dp();
                    int i2 = (int)(MathHelper.a((this.cg - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dl();
                    int j2 = 0;
                    while (j2 < i2) {
                        float f1 = (this.af.i() * 2.0f - 1.0f) * this.dd() * 0.5f;
                        float f22 = (this.af.i() * 2.0f - 1.0f) * this.dd() * 0.5f;
                        this.dI().a(Particles.ag, this.dn() + (double)f1, (double)(f2 + 0.8f), this.dt() + (double)f22, vec3d.c, vec3d.d, vec3d.e);
                        ++j2;
                    }
                }
            }
        }
    }

    private void gj() {
        this.cf = false;
        this.cg = 0.0f;
        this.ch = 0.0f;
    }

    @Override
    public void a(DamageSource damagesource) {
        this.ce = false;
        this.cf = false;
        this.ch = 0.0f;
        this.cg = 0.0f;
        super.a(damagesource);
    }

    public boolean gf() {
        return this.ce;
    }

    public float D(float f2) {
        return Math.min(0.5f + MathHelper.i(f2, this.ch, this.cg) / 2.0f * 0.5f, 1.0f);
    }

    public float f(float f2, float f1) {
        float f22 = (MathHelper.i(f2, this.ch, this.cg) + f1) / 1.8f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        } else if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        return MathHelper.a(f22 * (float)Math.PI) * MathHelper.a(f22 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float E(float f2) {
        return MathHelper.i(f2, this.cd, this.cc) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return entitysize.b * 0.8f;
    }

    @Override
    public int X() {
        return this.w() ? 20 : super.X();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        Entity entity = damagesource.d();
        boolean cfr_ignored_0 = this.dI().B;
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            f2 = (f2 + 1.0f) / 2.0f;
        }
        return super.a(damagesource, f2);
    }

    @Override
    public boolean z(Entity entity) {
        boolean flag = entity.a(this.dJ().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, entity);
        }
        return flag;
    }

    @Override
    public void x(boolean flag) {
        super.x(flag);
        if (flag) {
            this.a(GenericAttributes.a).a(20.0);
            this.t(this.eI());
        } else {
            this.a(GenericAttributes.a).a(8.0);
        }
        this.a(GenericAttributes.f).a(4.0);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        Item item = itemstack.d();
        if (this.dI().B) {
            boolean flag = this.l(entityhuman) || this.q() || itemstack.a(Items.qL) && !this.q() && !this.S_();
            return flag ? EnumInteractionResult.b : EnumInteractionResult.d;
        }
        if (this.q()) {
            EnumInteractionResult enuminteractionresult;
            if (this.m(itemstack) && this.er() < this.eI()) {
                if (!entityhuman.fO().d) {
                    itemstack.h(1);
                }
                this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.l(entityhuman)) {
                    EnumColor enumcolor = itemdye.d();
                    if (enumcolor != this.gh()) {
                        this.a(enumcolor);
                        if (!entityhuman.fO().d) {
                            itemstack.h(1);
                        }
                        return EnumInteractionResult.a;
                    }
                    return super.b(entityhuman, enumhand);
                }
            }
            if ((!(enuminteractionresult = super.b(entityhuman, enumhand)).a() || this.h_()) && this.l(entityhuman)) {
                this.z(!this.fY());
                this.bk = false;
                this.bN.n();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.a;
            }
            return enuminteractionresult;
        }
        if (itemstack.a(Items.qL) && !this.S_()) {
            if (!entityhuman.fO().d) {
                itemstack.h(1);
            }
            if (this.af.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
                this.f(entityhuman);
                this.bN.n();
                this.h((EntityLiving)null);
                this.z(true);
                this.dI().a((Entity)this, (byte)7);
            } else {
                this.dI().a((Entity)this, (byte)6);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 8) {
            this.cf = true;
            this.cg = 0.0f;
            this.ch = 0.0f;
        } else if (b0 == 56) {
            this.gj();
        } else {
            super.b(b0);
        }
    }

    public float gg() {
        return this.S_() ? 1.5393804f : (this.q() ? (0.55f - (this.eI() - this.er()) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    @Override
    public boolean m(ItemStack itemstack) {
        Item item = itemstack.d();
        return item.u() && item.v().c();
    }

    @Override
    public int fE() {
        return 8;
    }

    @Override
    public int a() {
        return this.am.b(bZ);
    }

    @Override
    public void a(int i2) {
        this.am.b(bZ, i2);
    }

    @Override
    public void c() {
        this.a(ci.a(this.af));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cj;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cj = uuid;
    }

    public EnumColor gh() {
        return EnumColor.a(this.am.b(bY));
    }

    public void a(EnumColor enumcolor) {
        this.am.b(bY, enumcolor.a());
    }

    @Nullable
    public EntityWolf b(WorldServer worldserver, EntityAgeable entityageable) {
        UUID uuid;
        EntityWolf entitywolf = EntityTypes.bn.a(worldserver);
        if (entitywolf != null && (uuid = this.U_()) != null) {
            entitywolf.b(uuid);
            entitywolf.x(true);
        }
        return entitywolf;
    }

    public void A(boolean flag) {
        this.am.b(bX, flag);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (entityanimal == this) {
            return false;
        }
        if (!this.q()) {
            return false;
        }
        if (!(entityanimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)entityanimal;
        return !entitywolf.q() ? false : (entitywolf.w() ? false : this.gc() && entitywolf.gc());
    }

    public boolean gi() {
        return this.am.b(bX);
    }

    @Override
    public boolean a(EntityLiving entityliving, EntityLiving entityliving1) {
        if (!(entityliving instanceof EntityCreeper) && !(entityliving instanceof EntityGhast)) {
            if (entityliving instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)entityliving;
                return !entitywolf.q() || entitywolf.I_() != entityliving1;
            }
            return entityliving instanceof EntityHuman && entityliving1 instanceof EntityHuman && !((EntityHuman)entityliving1).a((EntityHuman)entityliving) ? false : (entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gn() ? false : !(entityliving instanceof EntityTameableAnimal) || !((EntityTameableAnimal)entityliving).q());
        }
        return false;
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.S_() && super.a(entityhuman);
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.6f * this.cF(), this.dd() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.d()).a(TagsBlock.bV) && EntityWolf.a(generatoraccess, blockposition);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean a() {
            return super.a() && this.b instanceof EntityLlama ? !this.j.q() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama entityllama) {
            return entityllama.gi() >= EntityWolf.this.af.a(5);
        }

        @Override
        public void c() {
            EntityWolf.this.h((EntityLiving)null);
            super.c();
        }

        @Override
        public void e() {
            EntityWolf.this.h((EntityLiving)null);
            super.e();
        }
    }

    private class b
    extends PathfinderGoalPanic {
        public b(double d0) {
            super(EntityWolf.this, d0);
        }

        @Override
        protected boolean h() {
            return this.b.dx() || this.b.bL();
        }
    }
}

