/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bT = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int ca = 2;
    private static final int cb = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bU = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.au, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.U, MemoryModuleType.V, MemoryModuleType.Y});
    public static final int bX = 10;
    public static final double bY = 0.02;
    public static final double bZ = (double)0.1f;
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cd = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> ce = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean cf;
    private int cg;

    public Goat(EntityTypes<? extends Goat> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.J().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack q() {
        RandomSource randomsource = RandomSource.a(this.ct().hashCode());
        TagKey<Instrument> tagkey = this.gi() ? InstrumentTags.b : InstrumentTags.a;
        HolderSet.Named<Instrument> holderset = BuiltInRegistries.am.a(tagkey);
        return InstrumentItem.a(Items.vi, holderset.a(randomsource).get());
    }

    protected BehaviorController.b<Goat> dL() {
        return BehaviorController.a(bW, bU);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.dL().a(dynamic));
    }

    public static AttributeProvider.Builder r() {
        return EntityInsentient.y().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.2f).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void m() {
        if (this.h_()) {
            this.a(GenericAttributes.f).a(1.0);
            this.gh();
        } else {
            this.a(GenericAttributes.f).a(2.0);
            this.gg();
        }
    }

    @Override
    protected int d(float f2, float f1) {
        return super.d(f2, f1) - 10;
    }

    @Override
    protected SoundEffect s() {
        return this.gi() ? SoundEffects.jN : SoundEffects.jD;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return this.gi() ? SoundEffects.jQ : SoundEffects.jG;
    }

    @Override
    protected SoundEffect g_() {
        return this.gi() ? SoundEffects.jO : SoundEffects.jE;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.jW, 0.15f, 1.0f);
    }

    protected SoundEffect w() {
        return this.gi() ? SoundEffects.jS : SoundEffects.jI;
    }

    @Nullable
    public Goat b(WorldServer worldserver, EntityAgeable entityageable) {
        Goat goat = EntityTypes.U.a(worldserver);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, worldserver.y_());
            EntityAgeable object = worldserver.y_().h() ? this : entityageable;
            boolean flag = object instanceof Goat && ((Goat)(goat1 = object)).gi() || !(worldserver.y_().j() >= 0.02);
            boolean flag1 = flag;
            goat.w(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> dK() {
        return super.dK();
    }

    @Override
    protected void W() {
        this.dI().ad().a("goatBrain");
        this.dK().a((WorldServer)this.dI(), this);
        this.dI().ad().c();
        this.dI().ad().a("goatActivityUpdate");
        GoatAi.a(this);
        this.dI().ad().c();
        super.W();
    }

    @Override
    public int fC() {
        return 15;
    }

    @Override
    public void n(float f2) {
        int i2 = this.fC();
        float f1 = MathHelper.c(this.aV, f2);
        float f22 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.n(this.aV + f22);
    }

    @Override
    public SoundEffect d(ItemStack itemstack) {
        return this.gi() ? SoundEffects.jP : SoundEffects.jF;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.pK) && !this.h_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.dI(), entityhuman, this.di(), this.di(), null, itemstack, Items.pQ, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            entityhuman.a(this.w(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a(this.dI().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && this.m(itemstack)) {
            this.dI().a(null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dI().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        RandomSource randomsource = worldaccess.y_();
        GoatAi.a(this, randomsource);
        this.w(randomsource.j() < 0.02);
        this.m();
        if (!this.h_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cd : ce;
            this.am.b(datawatcherobject, false);
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    @Override
    protected void V() {
        super.V();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return entitypose == EntityPose.g ? bT.a(this.dV()) : super.a(entitypose);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsScreamingGoat", this.gi());
        nbttagcompound.a("HasLeftHorn", this.fY());
        nbttagcompound.a("HasRightHorn", this.ge());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w(nbttagcompound.q("IsScreamingGoat"));
        this.am.b(cd, nbttagcompound.q("HasLeftHorn"));
        this.am.b(ce, nbttagcompound.q("HasRightHorn"));
    }

    @Override
    public void b(byte b0) {
        if (b0 == 58) {
            this.cf = true;
        } else if (b0 == 59) {
            this.cf = false;
        } else {
            super.b(b0);
        }
    }

    @Override
    public void b_() {
        this.cg = this.cf ? ++this.cg : (this.cg -= 2);
        this.cg = MathHelper.a(this.cg, 0, 20);
        super.b_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cc, false);
        this.am.a(cd, true);
        this.am.a(ce, true);
    }

    public boolean fY() {
        return this.am.b(cd);
    }

    public boolean ge() {
        return this.am.b(ce);
    }

    public boolean gf() {
        boolean flag = this.fY();
        boolean flag1 = this.ge();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? ce : (!flag1 ? cd : (this.af.h() ? cd : ce));
        this.am.b(datawatcherobject, false);
        Vec3D vec3d = this.dg();
        ItemStack itemstack = this.q();
        double d0 = MathHelper.b(this.af, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.af, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.af, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.dI(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        this.dI().b(entityitem);
        return true;
    }

    public void gg() {
        this.am.b(cd, true);
        this.am.b(ce, true);
    }

    public void gh() {
        this.am.b(cd, false);
        this.am.b(ce, false);
    }

    public boolean gi() {
        return this.am.b(cc);
    }

    public void w(boolean flag) {
        this.am.b(cc, flag);
    }

    public float gj() {
        return (float)this.cg / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.d()).a(TagsBlock.bP) && Goat.a(generatoraccess, blockposition);
    }
}

