/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int ce = 400;
    public static final int cf = 499;
    public static final int cg = 500;
    public static final double ch = 0.15;
    private static final float bT = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bU = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float bW = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float bX = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float bY = EntityHorseAbstract.a((int i2) -> 0);
    private static final float bZ = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float ca = 0.25f;
    private static final float cb = 0.5f;
    private static final Predicate<EntityLiving> cc = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gs();
    private static final PathfinderTargetCondition cd = PathfinderTargetCondition.b().a(16.0).d().a(cc);
    private static final RecipeItemStack cu = RecipeItemStack.a(Items.oI, Items.qM, Blocks.ij.k(), Items.nF, Items.tq, Items.pm, Items.pn);
    private static final DataWatcherObject<Byte> cv = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cw = 2;
    private static final int cx = 4;
    private static final int cy = 8;
    private static final int cz = 16;
    private static final int cA = 32;
    private static final int cB = 64;
    public static final int ci = 0;
    public static final int cj = 1;
    public static final int ck = 2;
    private int cC;
    private int cD;
    private int cE;
    public int cl;
    public int cm;
    protected boolean cn;
    public InventorySubcontainer co;
    protected int cp;
    protected float cq;
    protected boolean cr;
    private float cF;
    private float cG;
    private float cH;
    private float cI;
    private float cJ;
    private float cK;
    protected boolean cs = true;
    protected int ct;
    @Nullable
    private UUID cL;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.r(1.0f);
        this.gu();
    }

    @Override
    protected void x() {
        this.bO.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bO.a(1, new PathfinderGoalTame(this, 1.2));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.ge()) {
            this.bO.a(9, new RandomStandGoal(this));
        }
        this.go();
    }

    protected void go() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.tq, Items.pm, Items.pn), false));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(cv, (byte)0);
    }

    protected boolean t(int i2) {
        return (this.am.b(cv) & i2) != 0;
    }

    protected void d(int i2, boolean flag) {
        byte b0 = this.am.b(cv);
        if (flag) {
            this.am.b(cv, (byte)(b0 | i2));
        } else {
            this.am.b(cv, (byte)(b0 & ~i2));
        }
    }

    public boolean gn() {
        return this.t(2);
    }

    @Override
    @Nullable
    public UUID U_() {
        return this.cL;
    }

    public void b(@Nullable UUID uuid) {
        this.cL = uuid;
    }

    public boolean gp() {
        return this.cn;
    }

    public void x(boolean flag) {
        this.d(2, flag);
    }

    public void y(boolean flag) {
        this.cn = flag;
    }

    @Override
    protected void C(float f2) {
        if (f2 > 6.0f && this.gq()) {
            this.A(false);
        }
    }

    public boolean gq() {
        return this.t(16);
    }

    public boolean gr() {
        return this.t(32);
    }

    public boolean gs() {
        return this.t(8);
    }

    public void z(boolean flag) {
        this.d(8, flag);
    }

    @Override
    public boolean g() {
        return this.bs() && !this.h_() && this.gn();
    }

    @Override
    public void a(@Nullable SoundCategory soundcategory) {
        this.co.a(0, new ItemStack(Items.mZ));
    }

    public void b(EntityHuman entityhuman, ItemStack itemstack) {
        if (this.l(itemstack)) {
            this.co.a(1, itemstack.c(1));
            if (!entityhuman.fO().d) {
                itemstack.h(1);
            }
        }
    }

    @Override
    public boolean i() {
        return this.t(4);
    }

    public int gt() {
        return this.cp;
    }

    public void u(int i2) {
        this.cp = i2;
    }

    public int v(int i2) {
        int j2 = MathHelper.a(this.gt() + i2, 0, this.gz());
        this.u(j2);
        return j2;
    }

    @Override
    public boolean bp() {
        return !this.bN();
    }

    private void q() {
        SoundEffect soundeffect;
        this.fY();
        if (!this.aQ() && (soundeffect = this.gf()) != null) {
            this.dI().a(null, this.dn(), this.dp(), this.dt(), soundeffect, this.cY(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        int i2;
        if (f2 > 1.0f) {
            this.a(SoundEffects.ln, 0.4f, 1.0f);
        }
        if ((i2 = this.d(f2, f1)) <= 0) {
            return false;
        }
        this.a(damagesource, (float)i2);
        if (this.bN()) {
            for (Entity entity : this.cR()) {
                entity.a(damagesource, (float)i2);
            }
        }
        this.eE();
        return true;
    }

    @Override
    protected int d(float f2, float f1) {
        return MathHelper.f((f2 * 0.5f - 3.0f) * f1);
    }

    protected int V_() {
        return 2;
    }

    public void gu() {
        InventorySubcontainer inventorysubcontainer = this.co;
        this.co = new InventorySubcontainer(this.V_(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.co.b());
            int j2 = 0;
            while (j2 < i2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (!itemstack.b()) {
                    this.co.a(j2, itemstack.p());
                }
                ++j2;
            }
        }
        this.co.a(this);
        this.gv();
    }

    protected void gv() {
        if (!this.dI().B) {
            this.d(4, !this.co.a(0).b());
        }
    }

    @Override
    public void a(IInventory iinventory) {
        boolean flag = this.i();
        this.gv();
        if (this.ag > 20 && !flag && this.i()) {
            this.a(this.R_(), 0.5f, 1.0f);
        }
    }

    public double gw() {
        return this.b(GenericAttributes.m);
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        boolean flag = super.a(damagesource, f2);
        if (flag && this.af.a(3) == 0) {
            this.gD();
        }
        return flag;
    }

    protected boolean ge() {
        return true;
    }

    @Nullable
    protected SoundEffect gf() {
        return null;
    }

    @Nullable
    protected SoundEffect gx() {
        return null;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (!iblockdata.k()) {
            IBlockData iblockdata1 = this.dI().a_(blockposition.c());
            SoundEffectType soundeffecttype = iblockdata.w();
            if (iblockdata1.a(Blocks.dN)) {
                soundeffecttype = iblockdata1.w();
            }
            if (this.bN() && this.cs) {
                ++this.ct;
                if (this.ct > 5 && this.ct % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.ct <= 5) {
                    this.a(SoundEffects.lq, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (this.b(soundeffecttype)) {
                this.a(SoundEffects.lq, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.lp, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    private boolean b(SoundEffectType soundeffecttype) {
        return soundeffecttype == SoundEffectType.b || soundeffecttype == SoundEffectType.aP || soundeffecttype == SoundEffectType.B || soundeffecttype == SoundEffectType.aQ || soundeffecttype == SoundEffectType.aO;
    }

    protected void a(SoundEffectType soundeffecttype) {
        this.a(SoundEffects.lk, soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    public static AttributeProvider.Builder gy() {
        return EntityInsentient.y().a(GenericAttributes.m).a(GenericAttributes.a, 53.0).a(GenericAttributes.d, 0.225f);
    }

    @Override
    public int fE() {
        return 6;
    }

    public int gz() {
        return this.maxDomestication;
    }

    @Override
    protected float eR() {
        return 0.8f;
    }

    @Override
    public int M() {
        return 400;
    }

    @Override
    public void b(EntityHuman entityhuman) {
        if (!this.dI().B && (!this.bN() || this.u(entityhuman)) && this.gn()) {
            entityhuman.a(this, this.co);
        }
    }

    public EnumInteractionResult c(EntityHuman entityhuman, ItemStack itemstack) {
        boolean flag = this.a(entityhuman, itemstack);
        if (!entityhuman.fO().d) {
            itemstack.h(1);
        }
        return this.dI().B ? EnumInteractionResult.b : (flag ? EnumInteractionResult.a : EnumInteractionResult.d);
    }

    protected boolean a(EntityHuman entityhuman, ItemStack itemstack) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (itemstack.a(Items.oI)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (itemstack.a(Items.qM)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (itemstack.a(Blocks.ij.k())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (itemstack.a(Items.nF)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (itemstack.a(Items.tq)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.dI().B && this.gn() && this.h() == 0 && !this.gc()) {
                flag = true;
                this.g(entityhuman);
            }
        } else if (itemstack.a(Items.pm) || itemstack.a(Items.pn)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.dI().B && this.gn() && this.h() == 0 && !this.gc()) {
                flag = true;
                this.g(entityhuman);
            }
        }
        if (this.er() < this.eI() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.h_() && short0 > 0) {
            this.dI().a(Particles.K, this.d(1.0), this.dq() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dI().B) {
                this.b_(short0);
            }
            flag = true;
        }
        if (b0 > 0 && (flag || !this.gn()) && this.gt() < this.gz()) {
            flag = true;
            if (!this.dI().B) {
                this.v(b0);
            }
        }
        if (flag) {
            this.q();
            this.a(GameEvent.m);
        }
        return flag;
    }

    protected void f(EntityHuman entityhuman) {
        this.A(false);
        this.B(false);
        if (!this.dI().B) {
            entityhuman.a_(this.dy());
            entityhuman.b_(this.dA());
            entityhuman.k(this);
        }
    }

    @Override
    public boolean eT() {
        return super.eT() && this.bN() && this.i() || this.gq() || this.gr();
    }

    @Override
    public boolean m(ItemStack itemstack) {
        return cu.a(itemstack);
    }

    private void r() {
        this.cl = 1;
    }

    @Override
    protected void eu() {
        super.eu();
        if (this.co != null) {
            int i2 = 0;
            while (i2 < this.co.b()) {
                ItemStack itemstack = this.co.a(i2);
                if (!itemstack.b() && !EnchantmentManager.e(itemstack)) {
                    this.b(itemstack);
                }
                ++i2;
            }
        }
    }

    @Override
    public void b_() {
        if (this.af.a(200) == 0) {
            this.r();
        }
        super.b_();
        if (!this.dI().B && this.bs()) {
            if (this.af.a(900) == 0 && this.aN == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.gB()) {
                if (!this.gq() && !this.bN() && this.af.a(300) == 0 && this.dI().a_(this.di().d()).a(Blocks.i)) {
                    this.A(true);
                }
                if (this.gq() && ++this.cC > 50) {
                    this.cC = 0;
                    this.A(false);
                }
            }
            this.gA();
        }
    }

    protected void gA() {
        EntityHorseAbstract entityliving;
        if (this.gs() && this.h_() && !this.gq() && (entityliving = this.dI().a(EntityHorseAbstract.class, cd, this, this.dn(), this.dp(), this.dt(), this.cE().g(16.0))) != null && this.f((Entity)entityliving) > 4.0) {
            this.bN.a((Entity)entityliving, 0);
        }
    }

    public boolean gB() {
        return true;
    }

    @Override
    public void l() {
        super.l();
        if (this.cD > 0 && ++this.cD > 30) {
            this.cD = 0;
            this.d(64, false);
        }
        if (this.cV() && this.cE > 0 && ++this.cE > 20) {
            this.cE = 0;
            this.B(false);
        }
        if (this.cl > 0 && ++this.cl > 8) {
            this.cl = 0;
        }
        if (this.cm > 0) {
            ++this.cm;
            if (this.cm > 300) {
                this.cm = 0;
            }
        }
        this.cG = this.cF;
        if (this.gq()) {
            this.cF += (1.0f - this.cF) * 0.4f + 0.05f;
            if (this.cF > 1.0f) {
                this.cF = 1.0f;
            }
        } else {
            this.cF += (0.0f - this.cF) * 0.4f - 0.05f;
            if (this.cF < 0.0f) {
                this.cF = 0.0f;
            }
        }
        this.cI = this.cH;
        if (this.gr()) {
            this.cG = this.cF = 0.0f;
            this.cH += (1.0f - this.cH) * 0.4f + 0.05f;
            if (this.cH > 1.0f) {
                this.cH = 1.0f;
            }
        } else {
            this.cr = false;
            this.cH += (0.8f * this.cH * this.cH * this.cH - this.cH) * 0.6f - 0.05f;
            if (this.cH < 0.0f) {
                this.cH = 0.0f;
            }
        }
        this.cK = this.cJ;
        if (this.t(64)) {
            this.cJ += (1.0f - this.cJ) * 0.7f + 0.05f;
            if (this.cJ > 1.0f) {
                this.cJ = 1.0f;
            }
        } else {
            this.cJ += (0.0f - this.cJ) * 0.7f - 0.05f;
            if (this.cJ < 0.0f) {
                this.cJ = 0.0f;
            }
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.bN() && !this.h_()) {
            if (this.gn() && entityhuman.fD()) {
                this.b(entityhuman);
                return EnumInteractionResult.a(this.dI().B);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (!itemstack.b()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.gH() && this.l(itemstack) && !this.gI()) {
                    this.b(entityhuman, itemstack);
                    return EnumInteractionResult.a(this.dI().B);
                }
            }
            this.f(entityhuman);
            return EnumInteractionResult.a(this.dI().B);
        }
        return super.b(entityhuman, enumhand);
    }

    private void fY() {
        if (!this.dI().B) {
            this.cD = 1;
            this.d(64, true);
        }
    }

    public void A(boolean flag) {
        this.d(16, flag);
    }

    public void B(boolean flag) {
        if (flag) {
            this.A(false);
        }
        this.d(32, flag);
    }

    @Nullable
    public SoundEffect gC() {
        return this.s();
    }

    public void gD() {
        if (this.ge() && this.cV()) {
            this.cE = 1;
            this.B(true);
        }
    }

    public void gE() {
        if (!this.gr()) {
            this.gD();
            SoundEffect soundeffect = this.gx();
            if (soundeffect != null) {
                this.a(soundeffect, this.eR(), this.eS());
            }
        }
    }

    public boolean h(EntityHuman entityhuman) {
        this.b(entityhuman.ct());
        this.x(true);
        if (entityhuman instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)entityhuman, this);
        }
        this.dI().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        super.a(entityhuman, vec3d);
        Vec2F vec2f = this.l(entityhuman);
        this.a(vec2f.j, vec2f.i);
        this.aV = this.aX = this.dy();
        this.M = this.aX;
        if (this.cU()) {
            if (vec3d.e <= 0.0) {
                this.ct = 0;
            }
            if (this.ay()) {
                this.y(false);
                if (this.cq > 0.0f && !this.gp()) {
                    this.b(this.cq, vec3d);
                }
                this.cq = 0.0f;
            }
        }
    }

    protected Vec2F l(EntityLiving entityliving) {
        return new Vec2F(entityliving.dA() * 0.5f, entityliving.dy());
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        if (this.ay() && this.cq == 0.0f && this.gr() && !this.cr) {
            return Vec3D.b;
        }
        float f2 = entityhuman.bl * 0.5f;
        float f1 = entityhuman.bn;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman entityhuman) {
        return (float)this.b(GenericAttributes.d);
    }

    protected void b(float f2, Vec3D vec3d) {
        double d0 = this.gw() * (double)f2 * (double)this.aG();
        double d1 = d0 + (double)this.eV();
        Vec3D vec3d1 = this.dl();
        this.o(vec3d1.c, d1, vec3d1.e);
        this.y(true);
        this.at = true;
        if (vec3d.e > 0.0) {
            float f1 = MathHelper.a(this.dy() * ((float)Math.PI / 180));
            float f22 = MathHelper.b(this.dy() * ((float)Math.PI / 180));
            this.f(this.dl().b(-0.4f * f1 * f2, 0.0, 0.4f * f22 * f2));
        }
    }

    protected void gF() {
        this.a(SoundEffects.lm, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("EatingHaystack", this.gq());
        nbttagcompound.a("Bred", this.gs());
        nbttagcompound.a("Temper", this.gt());
        nbttagcompound.a("Tame", this.gn());
        if (this.U_() != null) {
            nbttagcompound.a("Owner", this.U_());
        }
        nbttagcompound.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.co.a(0).b()) {
            nbttagcompound.a("SaddleItem", this.co.a(0).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbttagcompound);
        this.A(nbttagcompound.q("EatingHaystack"));
        this.z(nbttagcompound.q("Bred"));
        this.u(nbttagcompound.h("Temper"));
        this.x(nbttagcompound.q("Tame"));
        if (nbttagcompound.b("Owner")) {
            uuid = nbttagcompound.a("Owner");
        } else {
            String s2 = nbttagcompound.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cI(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbttagcompound.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbttagcompound.h("Bukkit.MaxDomestication");
        }
        if (nbttagcompound.b("SaddleItem", 10) && (itemstack = ItemStack.a(nbttagcompound.p("SaddleItem"))).a(Items.mZ)) {
            this.co.a(0, itemstack);
        }
        this.gv();
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        return false;
    }

    protected boolean gG() {
        return !this.bN() && !this.bM() && this.gn() && !this.h_() && this.er() >= this.eI() && this.gc();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return null;
    }

    protected void a(EntityAgeable entityageable, EntityHorseAbstract entityhorseabstract) {
        this.a(entityageable, entityhorseabstract, GenericAttributes.a, (double)bY, (double)bZ);
        this.a(entityageable, entityhorseabstract, GenericAttributes.m, (double)bW, (double)bX);
        this.a(entityageable, entityhorseabstract, GenericAttributes.d, (double)bT, (double)bU);
    }

    private void a(EntityAgeable entityageable, EntityHorseAbstract entityhorseabstract, AttributeBase attributebase, double d0, double d1) {
        double d2 = EntityHorseAbstract.a(this.c(attributebase), entityageable.c(attributebase), d0, d1, this.af);
        entityhorseabstract.a(attributebase).a(d2);
    }

    static double a(double d0, double d1, double d2, double d3, RandomSource randomsource) {
        double d7;
        if (d3 <= d2) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        d0 = MathHelper.a(d0, d2, d3);
        d1 = MathHelper.a(d1, d2, d3);
        double d4 = 0.15 * (d3 - d2);
        double d6 = (d0 + d1) / 2.0;
        double d5 = Math.abs(d0 - d1) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (randomsource.j() + randomsource.j() + randomsource.j()) / 3.0 - 0.5);
        if (d8 > d3) {
            double d9 = d8 - d3;
            return d3 - d9;
        }
        if (d8 < d2) {
            double d9 = d2 - d8;
            return d2 + d9;
        }
        return d8;
    }

    public float D(float f2) {
        return MathHelper.i(f2, this.cG, this.cF);
    }

    public float E(float f2) {
        return MathHelper.i(f2, this.cI, this.cH);
    }

    public float F(float f2) {
        return MathHelper.i(f2, this.cK, this.cJ);
    }

    @Override
    public void b(int i2) {
        if (this.i()) {
            if (i2 < 0) {
                i2 = 0;
            } else {
                this.cr = true;
                this.gD();
            }
            this.cq = i2 >= 90 ? 1.0f : 0.4f + 0.4f * (float)i2 / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.i();
    }

    @Override
    public void c(int i2) {
        float power = i2 >= 90 ? 1.0f : 0.4f + 0.4f * (float)i2 / 90.0f;
        HorseJumpEvent event = CraftEventFactory.callHorseJumpEvent(this, power);
        if (event.isCancelled()) {
            return;
        }
        this.cr = true;
        this.gD();
        this.gF();
    }

    @Override
    public void b() {
    }

    protected void C(boolean flag) {
        ParticleType particletype = flag ? Particles.M : Particles.Z;
        int i2 = 0;
        while (i2 < 7) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(particletype, this.d(1.0), this.dq() + 0.5, this.g(1.0), d0, d1, d2);
            ++i2;
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 7) {
            this.C(true);
        } else if (b0 == 6) {
            this.C(false);
        } else {
            super.b(b0);
        }
    }

    @Override
    protected void a(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.a(entity, entity_movefunction);
        if (this.cI > 0.0f) {
            float f2 = MathHelper.a(this.aV * ((float)Math.PI / 180));
            float f1 = MathHelper.b(this.aV * ((float)Math.PI / 180));
            float f22 = 0.7f * this.cI;
            float f3 = 0.15f * this.cI;
            entity_movefunction.accept(entity, this.dn() + (double)(f22 * f2), this.dp() + this.bx() + entity.bw() + (double)f3, this.dt() - (double)(f22 * f1));
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).aV = this.aV;
            }
        }
    }

    protected static float a(IntUnaryOperator intunaryoperator) {
        return 15.0f + (float)intunaryoperator.applyAsInt(8) + (float)intunaryoperator.applyAsInt(9);
    }

    protected static double a(DoubleSupplier doublesupplier) {
        return (double)0.4f + doublesupplier.getAsDouble() * 0.2 + doublesupplier.getAsDouble() * 0.2 + doublesupplier.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier doublesupplier) {
        return ((double)0.45f + doublesupplier.getAsDouble() * 0.3 + doublesupplier.getAsDouble() * 0.3 + doublesupplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean i_() {
        return false;
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return entitysize.b * 0.95f;
    }

    public boolean gH() {
        return false;
    }

    public boolean gI() {
        return !this.c(EnumItemSlot.e).b();
    }

    public boolean l(ItemStack itemstack) {
        return false;
    }

    private SlotAccess a(final int i2, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseAbstract.this.co.a(i2);
            }

            @Override
            public boolean a(ItemStack itemstack) {
                if (!predicate.test(itemstack)) {
                    return false;
                }
                EntityHorseAbstract.this.co.a(i2, itemstack);
                EntityHorseAbstract.this.gv();
                return true;
            }
        };
    }

    @Override
    public SlotAccess a_(int i2) {
        int k2;
        int j2 = i2 - 400;
        if (j2 >= 0 && j2 < 2 && j2 < this.co.b()) {
            if (j2 == 0) {
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || itemstack.a(Items.mZ));
            }
            if (j2 == 1) {
                if (!this.gH()) {
                    return SlotAccess.b;
                }
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || this.l((ItemStack)itemstack));
            }
        }
        return (k2 = i2 - 500 + 2) >= 2 && k2 < this.co.b() ? SlotAccess.a(this.co, k2) : super.a_(i2);
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        Entity entity = this.cO();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient;
        }
        if (this.i() && (entity = this.cO()) instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman;
        }
        return null;
    }

    @Nullable
    private Vec3D a(Vec3D vec3d, EntityLiving entityliving) {
        double d0 = this.dn() + vec3d.c;
        double d1 = this.cE().b;
        double d2 = this.dt() + vec3d.e;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : entityliving.fv()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cE().e + 0.75;
            do {
                double d4 = this.dI().i(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4)) {
                    AxisAlignedBB axisalignedbb = entityliving.g(entitypose);
                    Vec3D vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2);
                    if (DismountUtil.a(this.dI(), entityliving, axisalignedbb.c(vec3d1))) {
                        entityliving.b(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        Vec3D vec3d = EntityHorseAbstract.a(this.dd(), (double)entityliving.dd(), this.dy() + (entityliving.fh() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, entityliving);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.dd(), (double)entityliving.dd(), this.dy() + (entityliving.fh() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, entityliving);
        return vec3d3 != null ? vec3d3 : this.dg();
    }

    protected void a(RandomSource randomsource) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(0.2f);
        }
        this.a(worldaccess.y_());
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    public boolean b(IInventory iinventory) {
        return this.co != iinventory;
    }

    public int gJ() {
        return this.M();
    }
}

