/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger bY = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition bZ = PathfinderTargetCondition.a().a(64.0);
    private static final int ca = 200;
    private static final int cb = 400;
    private static final float cc = 0.25f;
    private static final String cd = "DragonDeathTime";
    private static final String ce = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] cf;
    public final EntityComplexPart e;
    private final EntityComplexPart cg;
    private final EntityComplexPart ch;
    private final EntityComplexPart ci;
    private final EntityComplexPart cj;
    private final EntityComplexPart ck;
    private final EntityComplexPart cl;
    private final EntityComplexPart cm;
    public float bS;
    public float bT;
    public boolean bU;
    public int bV;
    public float bW;
    @Nullable
    public EntityEnderCrystal bX;
    @Nullable
    private EnderDragonBattle cn;
    private BlockPosition co = BlockPosition.b;
    private final DragonControllerManager cp;
    private int cq = 100;
    private float cr;
    private final PathPoint[] cs = new PathPoint[24];
    private final int[] ct = new int[24];
    private final Path cu = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.C, world);
        this.e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cg = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.ch = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.ci = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cj = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.ck = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cl = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cm = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cf = new EntityComplexPart[]{this.e, this.cg, this.ch, this.ci, this.cj, this.ck, this.cl, this.cm};
        this.t(this.eI());
        this.ae = true;
        this.as = true;
        this.cp = new DragonControllerManager(this);
        this.explosionSource = new Explosion(world, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle enderdragonbattle) {
        this.cn = enderdragonbattle;
    }

    public void h(BlockPosition blockposition) {
        this.co = blockposition;
    }

    public BlockPosition q() {
        return this.co;
    }

    public static AttributeProvider.Builder r() {
        return EntityInsentient.y().a(GenericAttributes.a, 200.0);
    }

    @Override
    public boolean aP() {
        float f2 = MathHelper.b(this.bT * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.bS * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aO() {
        if (this.dI().B && !this.aQ()) {
            this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.gW, this.cY(), 5.0f, 0.8f + this.af.i() * 0.3f, false);
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.aj().a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int i2, float f2) {
        if (this.es()) {
            f2 = 0.0f;
        }
        f2 = 1.0f - f2;
        int j2 = this.d - i2 & 0x3F;
        int k2 = this.d - i2 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.d(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)f2;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)f2;
        adouble[2] = MathHelper.d((double)f2, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void b_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.aC();
        if (this.dI().B) {
            this.t(this.er());
            if (!this.aQ() && !this.cp.a().a() && --this.cq < 0) {
                this.dI().a(this.dn(), this.dp(), this.dt(), SoundEffects.gX, this.cY(), 2.5f, 0.8f + this.af.i() * 0.3f, false);
                this.cq = 200 + this.af.a(200);
            }
        }
        if (this.cn == null && (world = this.dI()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).B()) != null && this.ct().equals(enderdragonbattle.i())) {
            this.cn = enderdragonbattle;
        }
        this.bS = this.bT;
        if (this.es()) {
            float f1 = (this.af.i() - 0.5f) * 8.0f;
            float f2 = (this.af.i() - 0.5f) * 4.0f;
            float f22 = (this.af.i() - 0.5f) * 8.0f;
            this.dI().a(Particles.x, this.dn() + (double)f1, this.dp() + 2.0 + (double)f2, this.dt() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.fZ();
            Vec3D vec3d = this.dl();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.bT = this.cp.a().a() ? (this.bT += 0.1f) : (this.bU ? (this.bT += f3 * 0.5f) : (this.bT += (f3 *= (float)Math.pow(2.0, vec3d.d))));
            this.a_(MathHelper.g(this.dy()));
            if (this.fQ()) {
                this.bT = 0.5f;
            } else {
                float f5;
                float f4;
                float f32;
                if (this.d < 0) {
                    int i2 = 0;
                    while (i2 < this.c.length) {
                        this.c[i2][0] = this.dy();
                        this.c[i2][1] = this.dp();
                        ++i2;
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dy();
                this.c[this.d][1] = this.dp();
                if (this.dI().B) {
                    if (this.bo > 0) {
                        double d3 = this.dn() + (this.bp - this.dn()) / (double)this.bo;
                        double d0 = this.dp() + (this.bq - this.dp()) / (double)this.bo;
                        d1 = this.dt() + (this.br - this.dt()) / (double)this.bo;
                        d2 = MathHelper.d(this.bs - (double)this.dy());
                        this.a_(this.dy() + (float)d2 / (float)this.bo);
                        this.b_(this.dA() + (float)(this.bt - (double)this.dA()) / (float)this.bo);
                        --this.bo;
                        this.e(d3, d0, d1);
                        this.a(this.dy(), this.dA());
                    }
                    this.cp.a().b();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cp.a();
                    idragoncontroller.c();
                    if (this.cp.a() != idragoncontroller) {
                        idragoncontroller = this.cp.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.c - this.dn();
                        d1 = vec3d1.d - this.dp();
                        d2 = vec3d1.e - this.dt();
                        double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d5 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d5 > 0.0) {
                            d1 = MathHelper.a(d1 / d5, (double)(-f6), (double)f6);
                        }
                        this.f(this.dl().b(0.0, d1 * 0.01, 0.0));
                        this.a_(MathHelper.g(this.dy()));
                        Vec3D vec3d2 = vec3d1.a(this.dn(), this.dp(), this.dt()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dy() * ((float)Math.PI / 180)), this.dl().d, -MathHelper.b(this.dy() * ((float)Math.PI / 180))).d();
                        f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.g(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dy()), -50.0f, 50.0f);
                            this.bW *= 0.8f;
                            this.bW += f4 * idragoncontroller.h();
                            this.a_(this.dy() + this.bW * 0.1f);
                        }
                        f4 = (float)(2.0 / (d4 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bU) {
                            this.a(EnumMoveType.a, this.dl().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dl());
                        }
                        Vec3D vec3d4 = this.dl().d();
                        double d6 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.f(this.dl().d(d6, 0.91f, d6));
                    }
                }
                this.aV = this.dy();
                Vec3D[] avec3d = new Vec3D[this.cf.length];
                int j2 = 0;
                while (j2 < this.cf.length) {
                    avec3d[j2] = new Vec3D(this.cf[j2].dn(), this.cf[j2].dp(), this.cf[j2].dt());
                    ++j2;
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dy() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.ch, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.cl, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cm, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                if (!this.dI().B && this.aL == 0) {
                    this.b(this.dI().a((Entity)this, this.cl.cE().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.b(this.dI().a((Entity)this, this.cm.cE().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.c(this.dI().a((Entity)this, this.e.cE().g(1.0), IEntitySelector.e));
                    this.c(this.dI().a((Entity)this, this.cg.cE().g(1.0), IEntitySelector.e));
                }
                float f13 = MathHelper.a(this.dy() * ((float)Math.PI / 180) - this.bW * 0.01f);
                float f14 = MathHelper.b(this.dy() * ((float)Math.PI / 180) - this.bW * 0.01f);
                float f15 = this.fY();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cg, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                int k2 = 0;
                while (k2 < 3) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.ci;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.cj;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.ck;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dy() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    f32 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f32 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                    ++k2;
                }
                if (!this.dI().B) {
                    this.bU = this.b(this.e.cE()) | this.b(this.cg.cE()) | this.b(this.ch.cE());
                    if (this.cn != null) {
                        this.cn.b(this);
                    }
                }
                k2 = 0;
                while (k2 < this.cf.length) {
                    this.cf[k2].J = avec3d[k2].c;
                    this.cf[k2].K = avec3d[k2].d;
                    this.cf[k2].L = avec3d[k2].e;
                    this.cf[k2].ab = avec3d[k2].c;
                    this.cf[k2].ac = avec3d[k2].d;
                    this.cf[k2].ad = avec3d[k2].e;
                    ++k2;
                }
            }
        }
    }

    private void a(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.e(this.dn() + d0, this.dp() + d1, this.dt() + d2);
    }

    private float fY() {
        if (this.cp.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void fZ() {
        if (this.bX != null) {
            if (this.bX.dD()) {
                this.bX = null;
            } else if (this.ag % 10 == 0 && this.er() < this.eI()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.t((float)((double)this.er() + event.getAmount()));
                }
            }
        }
        if (this.af.a(10) == 0) {
            List<EntityEnderCrystal> list = this.dI().a(EntityEnderCrystal.class, this.cE().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.f(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.bX = entityendercrystal;
        }
    }

    private void b(List<Entity> list) {
        double d0 = (this.ch.cE().a + this.ch.cE().d) / 2.0;
        double d1 = (this.ch.cE().c + this.ch.cE().f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.dn() - d0;
            double d3 = entity.dt() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.j(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cp.a().a() || ((EntityLiving)entity).ee() >= entity.ag - 2) continue;
            entity.a(this.dJ().b(this), 5.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private void c(List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            entity.a(this.dJ().b(this), 10.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private float i(double d0) {
        return (float)MathHelper.d(d0);
    }

    private boolean b(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.a(axisalignedbb.b);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.a(axisalignedbb.d);
        int i1 = MathHelper.a(axisalignedbb.e);
        int j1 = MathHelper.a(axisalignedbb.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<CraftBlock> destroyedBlocks = new ArrayList<CraftBlock>();
        int k1 = i2;
        while (k1 <= l2) {
            int l1 = j2;
            while (l1 <= i1) {
                int i22 = k2;
                while (i22 <= j1) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.dI().a_(blockposition);
                    if (!iblockdata.i() && !iblockdata.a(TagsBlock.aB)) {
                        if (this.dI().X().b(GameRules.c) && !iblockdata.a(TagsBlock.aA)) {
                            flag1 = true;
                            destroyedBlocks.add(CraftBlock.at(this.dI(), blockposition));
                        } else {
                            flag = true;
                        }
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        if (!flag1) {
            return flag;
        }
        CraftEntity bukkitEntity = this.getBukkitEntity();
        EntityExplodeEvent event = new EntityExplodeEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), destroyedBlocks, 0.0f);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.dI().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().t() ? this.dI().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.dI()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.b).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.dI(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.dI(), blockposition, ItemStack.b, false);
                }
                nmsBlock.a(this.dI(), blockposition, this.explosionSource);
                this.dI().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.af.a(l2 - i2 + 1), j2 + this.af.a(i1 - j2 + 1), k2 + this.af.a(j1 - k2 + 1));
            this.dI().c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.cp.a().i() == DragonControllerPhase.j) {
            return false;
        }
        f2 = this.cp.a().a(damagesource, f2);
        if (entitycomplexpart != this.e) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.d() instanceof EntityHuman || damagesource.a(DamageTypeTags.y)) {
            float f1 = this.er();
            this.g(damagesource, f2);
            if (this.es() && !this.cp.a().a()) {
                this.t(1.0f);
                this.cp.a(DragonControllerPhase.j);
            }
            if (this.cp.a().a()) {
                this.cr = this.cr + f1 - this.er();
                if (this.cr > 0.25f * this.eI()) {
                    this.cr = 0.0f;
                    this.cp.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        return !this.dI().B ? this.a(this.ch, damagesource, f2) : false;
    }

    protected boolean g(DamageSource damagesource, float f2) {
        return super.a(damagesource, f2);
    }

    @Override
    public void ah() {
        this.a(Entity.RemovalReason.a);
        this.a(GameEvent.p);
        if (this.cn != null) {
            this.cn.b(this);
            this.cn.a(this);
        }
    }

    @Override
    public int getExpReward() {
        boolean flag = this.dI().X().b(GameRules.f);
        int short0 = 500;
        if (this.cn != null && !this.cn.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void dX() {
        if (this.cn != null) {
            this.cn.b(this);
        }
        ++this.bV;
        if (this.bV >= 180 && this.bV <= 200) {
            float f2 = (this.af.i() - 0.5f) * 8.0f;
            float f1 = (this.af.i() - 0.5f) * 4.0f;
            float f22 = (this.af.i() - 0.5f) * 8.0f;
            this.dI().a(Particles.w, this.dn() + (double)f2, this.dp() + 2.0 + (double)f1, this.dt() + (double)f22, 0.0, 0.0, 0.0);
        }
        int short0 = this.expToDrop;
        if (this.dI() instanceof WorldServer) {
            if (this.bV > 150 && this.bV % 5 == 0) {
                EntityExperienceOrb.a((WorldServer)this.dI(), this.dg(), MathHelper.d((float)short0 * 0.08f));
            }
            if (this.bV == 1 && !this.aQ()) {
                int viewDistance = ((WorldServer)this.dI()).getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : this.dI().n().ac().k) {
                    double deltaX = this.dn() - player.dn();
                    double deltaZ = this.dt() - player.dt();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.dI().spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.dI().spigotConfig.dragonDeathSoundRadius * this.dI().spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dn() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dt() + deltaZ / deltaLength * (double)viewDistance;
                        player.c.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dp(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.c.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dn(), (int)this.dp(), (int)this.dt()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        if (this.bV == 200 && this.dI() instanceof WorldServer) {
            EntityExperienceOrb.a((WorldServer)this.dI(), this.dg(), MathHelper.d((float)short0 * 0.2f));
            if (this.cn != null) {
                this.cn.a(this);
            }
            this.a(Entity.RemovalReason.a);
            this.a(GameEvent.p);
        }
    }

    public int w() {
        if (this.cs[0] == null) {
            int i2 = 0;
            while (i2 < 24) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.dI().t_() + 10, this.dI().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cs[i2] = new PathPoint(k2, j1, l2);
                ++i2;
            }
            this.ct[0] = 6146;
            this.ct[1] = 8197;
            this.ct[2] = 8202;
            this.ct[3] = 16404;
            this.ct[4] = 32808;
            this.ct[5] = 32848;
            this.ct[6] = 65696;
            this.ct[7] = 131392;
            this.ct[8] = 131712;
            this.ct[9] = 263424;
            this.ct[10] = 526848;
            this.ct[11] = 525313;
            this.ct[12] = 1581057;
            this.ct[13] = 3166214;
            this.ct[14] = 2138120;
            this.ct[15] = 6373424;
            this.ct[16] = 4358208;
            this.ct[17] = 12910976;
            this.ct[18] = 9044480;
            this.ct[19] = 9706496;
            this.ct[20] = 15216640;
            this.ct[21] = 0xD0E000;
            this.ct[22] = 11763712;
            this.ct[23] = 0x7E0000;
        }
        return this.r(this.dn(), this.dp(), this.dt());
    }

    public int r(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(d0), MathHelper.a(d1), MathHelper.a(d2));
        int b0 = 0;
        if (this.cn == null || this.cn.e() == 0) {
            b0 = 12;
        }
        int j2 = b0;
        while (j2 < 24) {
            float f1;
            if (this.cs[j2] != null && (f1 = this.cs[j2].c(pathpoint)) < f2) {
                f2 = f1;
                i2 = j2;
            }
            ++j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int i2, int j2, @Nullable PathPoint pathpoint) {
        PathPoint pathpoint1;
        int k2 = 0;
        while (k2 < 24) {
            pathpoint1 = this.cs[k2];
            pathpoint1.i = false;
            pathpoint1.g = 0.0f;
            pathpoint1.e = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
            ++k2;
        }
        PathPoint pathpoint2 = this.cs[i2];
        pathpoint1 = this.cs[j2];
        pathpoint2.e = 0.0f;
        pathpoint2.g = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cu.a();
        this.cu.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cn == null || this.cn.e() == 0) {
            b0 = 12;
        }
        while (!this.cu.e()) {
            int i1;
            PathPoint pathpoint4 = this.cu.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathpoint != null) {
                    pathpoint.h = pathpoint1;
                    pathpoint1 = pathpoint;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cs[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.ct[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cs[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.e + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.e)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.e = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cu.a(pathpoint5, pathpoint5.e + pathpoint5.f);
                    continue;
                }
                pathpoint5.g = pathpoint5.e + pathpoint5.f;
                this.cu.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        bY.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.h = pathpoint3;
            pathpoint3 = pathpoint;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.a, pathpoint1.b, pathpoint1.c), true);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a(ce, this.cp.a().i().b());
        nbttagcompound.a(cd, this.bV);
        nbttagcompound.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.e(ce)) {
            this.cp.a(DragonControllerPhase.a(nbttagcompound.h(ce)));
        }
        if (nbttagcompound.e(cd)) {
            this.bV = nbttagcompound.h(cd);
        }
        if (nbttagcompound.e("Bukkit.expToDrop")) {
            this.expToDrop = nbttagcompound.h("Bukkit.expToDrop");
        }
    }

    @Override
    public void du() {
    }

    public EntityComplexPart[] fV() {
        return this.cf;
    }

    @Override
    public boolean bo() {
        return false;
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.gT;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.gY;
    }

    @Override
    protected float eR() {
        return 5.0f;
    }

    public float a(int i2, double[] adouble, double[] adouble1) {
        double d0;
        IDragonController idragoncontroller = this.cp.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)i2 : (i2 == 6 ? 0.0 : adouble1[1] - adouble[1]);
        } else {
            BlockPosition blockposition = this.dI().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.co));
            double d1 = Math.max(Math.sqrt(blockposition.b(this.dg())) / 4.0, 1.0);
            d0 = (double)i2 / d1;
        }
        return (float)d0;
    }

    public Vec3D C(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cp.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f22 = this.dA();
                float f1 = 1.5f;
                this.b_(-45.0f);
                vec3d = this.f(f2);
                this.b_(f22);
            } else {
                vec3d = this.f(f2);
            }
        } else {
            BlockPosition blockposition = this.dI().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.co));
            float f1 = Math.max((float)Math.sqrt(blockposition.b(this.dg())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dA();
            float f5 = 1.5f;
            this.b_(-f3 * 1.5f * 5.0f);
            vec3d = this.f(f2);
            this.b_(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman = damagesource.d() instanceof EntityHuman ? (EntityHuman)damagesource.d() : this.dI().a(bZ, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (entityendercrystal == this.bX) {
            this.a(this.e, this.dJ().d(entityendercrystal, entityhuman), 10.0f);
        }
        this.cp.a().a(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (b.equals(datawatcherobject) && this.dI().B) {
            this.cp.a(DragonControllerPhase.a(this.aj().b(b)));
        }
        super.a(datawatcherobject);
    }

    public DragonControllerManager fW() {
        return this.cp;
    }

    @Nullable
    public EnderDragonBattle fX() {
        return this.cn;
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean cq() {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.fV();
        int i2 = 0;
        while (i2 < aentitycomplexpart.length) {
            aentitycomplexpart[i2].e(i2 + packetplayoutspawnentity.a());
            ++i2;
        }
    }

    @Override
    public boolean c(EntityLiving entityliving) {
        return entityliving.ek();
    }

    @Override
    public double bx() {
        return this.ch.de();
    }
}

