/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class EntityHanging
extends Entity {
    private static final Logger e = LogUtils.getLogger();
    protected static final Predicate<Entity> b = entity -> entity instanceof EntityHanging;
    private int f;
    public BlockPosition c;
    protected EnumDirection d = EnumDirection.d;

    protected EntityHanging(EntityTypes<? extends EntityHanging> entitytypes, World world) {
        super(entitytypes, world);
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> entitytypes, World world, BlockPosition blockposition) {
        this(entitytypes, world);
        this.c = blockposition;
    }

    @Override
    protected void a_() {
    }

    public void a(EnumDirection enumdirection) {
        Validate.notNull((Object)enumdirection);
        Validate.isTrue((boolean)enumdirection.o().d());
        this.d = enumdirection;
        this.a_((float)(this.d.e() * 90));
        this.M = this.dy();
        this.s();
    }

    protected void s() {
        if (this.d != null) {
            this.a(EntityHanging.calculateBoundingBox(this, this.c, this.d, this.v(), this.w()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = (double)blockPosition.u() + 0.5;
        double d1 = (double)blockPosition.v() + 0.5;
        double d2 = (double)blockPosition.w() + 0.5;
        double d3 = 0.46875;
        double d4 = EntityHanging.b(width);
        double d5 = EntityHanging.b(height);
        d0 -= (double)direction.j() * 0.46875;
        d2 -= (double)direction.l() * 0.46875;
        d1 += d5;
        EnumDirection enumdirection = direction.i();
        d0 += d4 * (double)enumdirection.j();
        d2 += d4 * (double)enumdirection.l();
        if (entity != null) {
            entity.p(d0, d1, d2);
        }
        double d6 = width;
        double d7 = height;
        double d8 = width;
        if (direction.o() == EnumDirection.EnumAxis.c) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        return new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8);
    }

    private static double b(int i2) {
        return i2 % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void l() {
        if (!this.dI().B) {
            this.ap();
            if (this.f++ == this.dI().spigotConfig.hangingTickFrequency) {
                this.f = 0;
                if (!this.dD() && !this.t()) {
                    IBlockData material = this.dI().a_(this.di());
                    HangingBreakEvent.RemoveCause cause = !material.i() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dD() || event.isCancelled()) {
                        return;
                    }
                    this.ai();
                    this.a((Entity)null);
                }
            }
        }
    }

    public boolean t() {
        if (!this.dI().g(this)) {
            return false;
        }
        int i2 = Math.max(1, this.v() / 16);
        int j2 = Math.max(1, this.w() / 16);
        BlockPosition blockposition = this.c.a(this.d.g());
        EnumDirection enumdirection = this.d.i();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int k2 = 0;
        while (k2 < i2) {
            int l2 = 0;
            while (l2 < j2) {
                int i1 = (i2 - 1) / -2;
                int j1 = (j2 - 1) / -2;
                blockposition_mutableblockposition.g(blockposition).c(enumdirection, k2 + i1).c(EnumDirection.b, l2 + j1);
                IBlockData iblockdata = this.dI().a_(blockposition_mutableblockposition);
                if (!iblockdata.e() && !BlockDiodeAbstract.h(iblockdata)) {
                    return false;
                }
                ++l2;
            }
            ++k2;
        }
        return this.dI().a((Entity)this, this.cE(), b).isEmpty();
    }

    @Override
    public boolean bo() {
        return true;
    }

    @Override
    public boolean r(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return !this.dI().a(entityhuman, this.c) ? true : this.a(this.dJ().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public EnumDirection cB() {
        return this.d;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        if (!this.dD() && !this.dI().B) {
            Entity damager;
            Entity entity = damager = damagesource.b() ? damagesource.d() : damagesource.c();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dD() || event.isCancelled()) {
                return true;
            }
            this.ah();
            this.bl();
            this.a(damagesource.d());
        }
        return true;
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (!this.dI().B && !this.dD() && vec3d.g() > 0.0) {
            if (this.dD()) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dD() || event.isCancelled()) {
                return;
            }
            this.ah();
            this.a((Entity)null);
        }
    }

    @Override
    public void j(double d0, double d1, double d2) {
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition = this.y();
        nbttagcompound.a("TileX", blockposition.u());
        nbttagcompound.a("TileY", blockposition.v());
        nbttagcompound.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition = new BlockPosition(nbttagcompound.h("TileX"), nbttagcompound.h("TileY"), nbttagcompound.h("TileZ"));
        if (!blockposition.a(this.di(), 16.0)) {
            e.error("Hanging entity at invalid position: {}", (Object)blockposition);
        } else {
            this.c = blockposition;
        }
    }

    public abstract int v();

    public abstract int w();

    public abstract void a(@Nullable Entity var1);

    public abstract void x();

    @Override
    public EntityItem a(ItemStack itemstack, float f2) {
        EntityItem entityitem = new EntityItem(this.dI(), this.dn() + (double)((float)this.d.j() * 0.15f), this.dp() + (double)f2, this.dt() + (double)((float)this.d.l() * 0.15f), itemstack);
        entityitem.o();
        this.dI().b(entityitem);
        return entityitem;
    }

    @Override
    protected boolean bq() {
        return false;
    }

    @Override
    public void e(double d0, double d1, double d2) {
        this.c = BlockPosition.a(d0, d1, d2);
        this.s();
        this.at = true;
    }

    public BlockPosition y() {
        return this.c;
    }

    @Override
    public float a(EnumBlockRotation enumblockrotation) {
        if (this.d.o() != EnumDirection.EnumAxis.b) {
            switch (enumblockrotation) {
                case c: {
                    this.d = this.d.g();
                    break;
                }
                case d: {
                    this.d = this.d.i();
                    break;
                }
                case b: {
                    this.d = this.d.h();
                }
            }
        }
        float f2 = MathHelper.g(this.dy());
        switch (enumblockrotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 90.0f;
            }
            case b: {
                return f2 + 270.0f;
            }
        }
        return f2;
    }

    @Override
    public float a(EnumBlockMirror enumblockmirror) {
        return this.a(enumblockmirror.a(this.d));
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
    }

    @Override
    public void d_() {
    }
}

