/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.slf4j.Logger;

public class EntityItemFrame
extends EntityHanging {
    private static final Logger f = LogUtils.getLogger();
    public static final DataWatcherObject<ItemStack> g = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.h);
    public static final DataWatcherObject<Integer> h = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int e = 8;
    public float i = 1.0f;
    public boolean j;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world) {
        super((EntityTypes<? extends EntityHanging>)entitytypes, world);
    }

    public EntityItemFrame(World world, BlockPosition blockposition, EnumDirection enumdirection) {
        this(EntityTypes.af, world, blockposition, enumdirection);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> entitytypes, World world, BlockPosition blockposition, EnumDirection enumdirection) {
        super(entitytypes, world, blockposition);
        this.a(enumdirection);
    }

    @Override
    protected float a(EntityPose entitypose, EntitySize entitysize) {
        return 0.0f;
    }

    @Override
    protected void a_() {
        this.aj().a(g, ItemStack.b);
        this.aj().a(h, 0);
    }

    @Override
    public void a(EnumDirection enumdirection) {
        Validate.notNull((Object)enumdirection);
        this.d = enumdirection;
        if (enumdirection.o().d()) {
            this.b_(0.0f);
            this.a_((float)(this.d.e() * 90));
        } else {
            this.b_(-90 * enumdirection.f().a());
            this.a_(0.0f);
        }
        this.N = this.dA();
        this.M = this.dy();
        this.s();
    }

    @Override
    protected void s() {
        if (this.d != null) {
            this.a(EntityItemFrame.calculateBoundingBox(this, this.c, this.d, this.v(), this.w()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = 0.46875;
        double d1 = (double)blockPosition.u() + 0.5 - (double)direction.j() * 0.46875;
        double d2 = (double)blockPosition.v() + 0.5 - (double)direction.k() * 0.46875;
        double d3 = (double)blockPosition.w() + 0.5 - (double)direction.l() * 0.46875;
        if (entity != null) {
            entity.p(d1, d2, d3);
        }
        double d4 = width;
        double d5 = height;
        double d6 = width;
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.o();
        switch (enumdirection_enumaxis) {
            case a: {
                d4 = 1.0;
                break;
            }
            case b: {
                d5 = 1.0;
                break;
            }
            case c: {
                d6 = 1.0;
            }
        }
        return new AxisAlignedBB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    @Override
    public boolean t() {
        if (this.j) {
            return true;
        }
        if (!this.dI().g(this)) {
            return false;
        }
        IBlockData iblockdata = this.dI().a_(this.c.a(this.d.g()));
        return !iblockdata.e() && (!this.d.o().d() || !BlockDiodeAbstract.h(iblockdata)) ? false : this.dI().a((Entity)this, this.cE(), b).isEmpty();
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (!this.j) {
            super.a(enummovetype, vec3d);
        }
    }

    @Override
    public void j(double d0, double d1, double d2) {
        if (!this.j) {
            super.j(d0, d1, d2);
        }
    }

    @Override
    public float bC() {
        return 0.0f;
    }

    @Override
    public void ah() {
        this.c(this.z());
        super.ah();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.j) {
            return !damagesource.a(DamageTypeTags.d) && !damagesource.g() ? false : super.a(damagesource, f2);
        }
        if (this.b(damagesource)) {
            return false;
        }
        if (!damagesource.a(DamageTypeTags.l) && !this.z().b()) {
            if (!this.dI().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false) || this.dD()) {
                    return true;
                }
                this.b(damagesource.d(), false);
                this.a(GameEvent.c, damagesource.d());
                this.a(this.j(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.a(damagesource, f2);
    }

    public SoundEffect j() {
        return SoundEffects.lX;
    }

    @Override
    public int v() {
        return 12;
    }

    @Override
    public int w() {
        return 12;
    }

    @Override
    public boolean a(double d0) {
        double d1 = 16.0;
        return d0 < (d1 *= 64.0 * EntityItemFrame.cx()) * d1;
    }

    @Override
    public void a(@Nullable Entity entity) {
        this.a(this.k(), 1.0f, 1.0f);
        this.b(entity, true);
        this.a(GameEvent.c, entity);
    }

    public SoundEffect k() {
        return SoundEffects.lV;
    }

    @Override
    public void x() {
        this.a(this.o(), 1.0f, 1.0f);
    }

    public SoundEffect o() {
        return SoundEffects.lW;
    }

    private void b(@Nullable Entity entity, boolean flag) {
        if (!this.j) {
            ItemStack itemstack = this.z();
            this.a(ItemStack.b);
            if (!this.dI().X().b(GameRules.h)) {
                if (entity == null) {
                    this.c(itemstack);
                }
            } else {
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (entityhuman.fO().d) {
                        this.c(itemstack);
                        return;
                    }
                }
                if (flag) {
                    this.b(this.r());
                }
                if (!itemstack.b()) {
                    itemstack = itemstack.p();
                    this.c(itemstack);
                    if (this.af.i() < this.i) {
                        this.b(itemstack);
                    }
                }
            }
        }
    }

    private void c(ItemStack itemstack) {
        this.A().ifPresent(i2 -> {
            WorldMap worldmap = ItemWorldMap.a(i2, this.dI());
            if (worldmap != null) {
                worldmap.a(this.c, this.af());
                worldmap.a(true);
            }
        });
        itemstack.a((Entity)null);
    }

    public ItemStack z() {
        return this.aj().b(g);
    }

    public OptionalInt A() {
        Integer integer;
        ItemStack itemstack = this.z();
        if (itemstack.a(Items.rf) && (integer = ItemWorldMap.d(itemstack)) != null) {
            return OptionalInt.of(integer);
        }
        return OptionalInt.empty();
    }

    public boolean C() {
        return this.A().isPresent();
    }

    public void a(ItemStack itemstack) {
        this.a(itemstack, true);
    }

    public void a(ItemStack itemstack, boolean flag) {
        this.setItem(itemstack, flag, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.b()) {
            itemstack = itemstack.c(1);
        }
        this.d(itemstack);
        this.aj().b(g, itemstack);
        if (!itemstack.b() && playSound) {
            this.a(this.p(), 1.0f, 1.0f);
        }
        if (flag && this.c != null) {
            this.dI().c(this.c, Blocks.a);
        }
    }

    public SoundEffect p() {
        return SoundEffects.lU;
    }

    @Override
    public SlotAccess a_(int i2) {
        return i2 == 0 ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityItemFrame.this.z();
            }

            @Override
            public boolean a(ItemStack itemstack) {
                EntityItemFrame.this.a(itemstack);
                return true;
            }
        } : super.a_(i2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (datawatcherobject.equals(g)) {
            this.d(this.z());
        }
    }

    private void d(ItemStack itemstack) {
        if (!itemstack.b() && itemstack.G() != this) {
            itemstack.a(this);
        }
        this.s();
    }

    public int D() {
        return this.aj().b(h);
    }

    public void b(int i2) {
        this.a(i2, true);
    }

    private void a(int i2, boolean flag) {
        this.aj().b(h, i2 % 8);
        if (flag && this.c != null) {
            this.dI().c(this.c, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (!this.z().b()) {
            nbttagcompound.a("Item", this.z().b(new NBTTagCompound()));
            nbttagcompound.a("ItemRotation", (byte)this.D());
            nbttagcompound.a("ItemDropChance", this.i);
        }
        nbttagcompound.a("Facing", (byte)this.d.d());
        nbttagcompound.a("Invisible", this.cb());
        nbttagcompound.a("Fixed", this.j);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("Item");
        if (nbttagcompound1 != null && !nbttagcompound1.g()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.a(nbttagcompound1);
            if (itemstack.b()) {
                f.warn("Unable to load item from: {}", (Object)nbttagcompound1);
            }
            if (!(itemstack1 = this.z()).b() && !ItemStack.a(itemstack, itemstack1)) {
                this.c(itemstack1);
            }
            this.a(itemstack, false);
            this.a(nbttagcompound.f("ItemRotation"), false);
            if (nbttagcompound.b("ItemDropChance", 99)) {
                this.i = nbttagcompound.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbttagcompound.f("Facing")));
        this.j(nbttagcompound.q("Invisible"));
        this.j = nbttagcompound.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag1;
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = !this.z().b();
        boolean bl = flag1 = !itemstack.b();
        if (this.j) {
            return EnumInteractionResult.d;
        }
        if (!this.dI().B) {
            if (!flag) {
                if (flag1 && !this.dD()) {
                    WorldMap worldmap;
                    if (itemstack.a(Items.rf) && (worldmap = ItemWorldMap.a(itemstack, this.dI())) != null && worldmap.b(256)) {
                        return EnumInteractionResult.e;
                    }
                    this.a(itemstack);
                    this.a(GameEvent.c, (Entity)entityhuman);
                    if (!entityhuman.fO().d) {
                        itemstack.h(1);
                    }
                }
            } else {
                this.a(this.q(), 1.0f, 1.0f);
                this.b(this.D() + 1);
                this.a(GameEvent.c, (Entity)entityhuman);
            }
            return EnumInteractionResult.b;
        }
        return !flag && !flag1 ? EnumInteractionResult.d : EnumInteractionResult.a;
    }

    public SoundEffect q() {
        return SoundEffects.lY;
    }

    public int E() {
        return this.z().b() ? 0 : this.D() % 8 + 1;
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutSpawnEntity(this, this.d.d(), this.y());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.a(EnumDirection.a(packetplayoutspawnentity.n()));
    }

    @Override
    public ItemStack dv() {
        ItemStack itemstack = this.z();
        return itemstack.b() ? this.r() : itemstack.p();
    }

    protected ItemStack r() {
        return new ItemStack(Items.ti);
    }

    @Override
    public float dz() {
        EnumDirection enumdirection = this.cB();
        int i2 = enumdirection.o().b() ? 90 * enumdirection.f().a() : 0;
        return MathHelper.b(180 + enumdirection.e() * 90 + this.D() * 45 + i2);
    }
}

