/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int g;
    public int h;
    private int i = 5;
    @Nullable
    public UUID j;
    @Nullable
    public UUID k;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;

    public EntityItem(EntityTypes<? extends EntityItem> entitytypes, World world) {
        super(entitytypes, world);
        this.b = this.af.i() * (float)Math.PI * 2.0f;
        this.a_(this.af.i() * 360.0f);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack, world.z.j() * 0.2 - 0.1, 0.2, world.z.j() * 0.2 - 0.1);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack, double d3, double d4, double d5) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        this.e(d0, d1, d2);
        this.o(d3, d4, d5);
        this.a(itemstack);
    }

    private EntityItem(EntityItem entityitem) {
        super(entityitem.ae(), entityitem.dI());
        this.a(entityitem.j().p());
        this.s(entityitem);
        this.g = entityitem.g;
        this.b = entityitem.b;
    }

    @Override
    public boolean aT() {
        return this.j().a(TagsItem.aB);
    }

    @Override
    @Nullable
    public Entity v() {
        World world;
        if (this.j != null && (world = this.dI()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return worldserver.a(this.j);
        }
        return null;
    }

    @Override
    protected Entity.MovementEmission aS() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.aj().a(c, ItemStack.b);
    }

    @Override
    public void l() {
        if (this.j().b()) {
            this.ai();
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.h != Short.MAX_VALUE) {
                this.h -= elapsedTicks;
            }
            if (this.g != Short.MIN_VALUE) {
                this.g += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.J = this.dn();
            this.K = this.dp();
            this.L = this.dt();
            Vec3D vec3d = this.dl();
            float f2 = this.cF() - 0.11111111f;
            if (this.aV() && this.b(TagsFluid.a) > (double)f2) {
                this.y();
            } else if (this.bi() && this.b(TagsFluid.b) > (double)f2) {
                this.z();
            } else if (!this.aR()) {
                this.f(this.dl().b(0.0, -0.04, 0.0));
            }
            if (this.dI().B) {
                this.ae = false;
            } else {
                boolean bl = this.ae = !this.dI().a((Entity)this, this.cE().h(1.0E-7));
                if (this.ae) {
                    this.m(this.dn(), (this.cE().b + this.cE().e) / 2.0, this.dt());
                }
            }
            if (!this.ay() || this.dl().i() > (double)1.0E-5f || (this.ag + this.af()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dl());
                float f1 = 0.98f;
                if (this.ay()) {
                    f1 = this.dI().a_(this.aE()).b().h() * 0.98f;
                }
                this.f(this.dl().d(f1, 0.98, f1));
                if (this.ay()) {
                    Vec3D vec3d1 = this.dl();
                    if (vec3d1.d < 0.0) {
                        this.f(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.J) != MathHelper.a(this.dn()) || MathHelper.a(this.K) != MathHelper.a(this.dp()) || MathHelper.a(this.L) != MathHelper.a(this.dt());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ag % i2 == 0 && !this.dI().B && this.C()) {
                this.A();
            }
            this.at |= this.bb();
            if (!this.dI().B && (d0 = this.dl().d(vec3d).g()) > 0.01) {
                this.at = true;
            }
            if (!this.dI().B && this.g >= this.dI().spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.g = 0;
                    return;
                }
                this.ai();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.h != Short.MAX_VALUE) {
            this.h -= elapsedTicks;
        }
        if (this.g != Short.MIN_VALUE) {
            this.g += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dI().B && this.g >= this.dI().spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.g = 0;
                return;
            }
            this.ai();
        }
    }

    @Override
    protected BlockPosition aE() {
        return this.d(0.999999f);
    }

    private void y() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void z() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void A() {
        if (this.C()) {
            double radius = this.dI().spigotConfig.itemMerge;
            List<EntityItem> list = this.dI().a(EntityItem.class, this.cE().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.C());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.C()) continue;
                this.a(entityitem2);
                if (this.dD()) break;
            }
        }
    }

    private boolean C() {
        ItemStack itemstack = this.j();
        return this.bs() && this.h != Short.MAX_VALUE && this.g != Short.MIN_VALUE && this.g < 6000 && itemstack.L() < itemstack.g();
    }

    private void a(EntityItem entityitem) {
        ItemStack itemstack = this.j();
        ItemStack itemstack1 = entityitem.j();
        if (Objects.equals(this.k, entityitem.k) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, entityitem, itemstack1);
        }
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack1.a(itemstack.d()) ? false : (itemstack1.L() + itemstack.L() > itemstack1.g() ? false : (itemstack1.u() ^ itemstack.u() ? false : !itemstack1.u() || itemstack1.v().equals(itemstack.v())));
    }

    public static ItemStack a(ItemStack itemstack, ItemStack itemstack1, int i2) {
        int j2 = Math.min(Math.min(itemstack.g(), i2) - itemstack.L(), itemstack1.L());
        ItemStack itemstack2 = itemstack.c(itemstack.L() + j2);
        itemstack1.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2 = EntityItem.a(itemstack, itemstack1, 64);
        if (!itemstack2.b()) {
            entityitem.a(itemstack2);
        }
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, EntityItem entityitem1, ItemStack itemstack1) {
        if (CraftEventFactory.callItemMergeEvent(entityitem1, entityitem).isCancelled()) {
            return;
        }
        EntityItem.a(entityitem, itemstack, itemstack1);
        entityitem.h = Math.max(entityitem.h, entityitem1.h);
        entityitem.g = Math.min(entityitem.g, entityitem1.g);
        if (itemstack1.b()) {
            entityitem1.ai();
        }
    }

    @Override
    public boolean aU() {
        return this.j().d().w() || super.aU();
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        if (!this.j().b() && this.j().a(Items.ty) && damagesource.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.j().d().a(damagesource)) {
            return false;
        }
        if (this.dI().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
            return false;
        }
        this.bl();
        this.i = (int)((float)this.i - f2);
        this.a(GameEvent.o, damagesource.d());
        if (this.i <= 0) {
            this.j().a(this);
            this.ai();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Health", (short)this.i);
        nbttagcompound.a("Age", (short)this.g);
        nbttagcompound.a("PickupDelay", (short)this.h);
        if (this.j != null) {
            nbttagcompound.a("Thrower", this.j);
        }
        if (this.k != null) {
            nbttagcompound.a("Owner", this.k);
        }
        if (!this.j().b()) {
            nbttagcompound.a("Item", this.j().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.i = nbttagcompound.g("Health");
        this.g = nbttagcompound.g("Age");
        if (nbttagcompound.e("PickupDelay")) {
            this.h = nbttagcompound.g("PickupDelay");
        }
        if (nbttagcompound.b("Owner")) {
            this.k = nbttagcompound.a("Owner");
        }
        if (nbttagcompound.b("Thrower")) {
            this.j = nbttagcompound.a("Thrower");
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.j().b()) {
            this.ai();
        }
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (!this.dI().B) {
            ItemStack itemstack = this.j();
            Item item = itemstack.d();
            int i2 = itemstack.L();
            int canHold = entityhuman.fN().canHold(itemstack);
            int remaining = i2 - canHold;
            if (this.h <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.f(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dI().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)entityhuman.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dI().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                ItemStack current = this.j();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.f(canHold + remaining);
                }
                this.h = 0;
            } else if (this.h == 0) {
                this.h = -1;
            }
            if (this.h == 0 && (this.k == null || this.k.equals(entityhuman.ct())) && entityhuman.fN().e(itemstack)) {
                entityhuman.a((Entity)this, i2);
                if (itemstack.b()) {
                    this.ai();
                    itemstack.f(i2);
                }
                entityhuman.a(StatisticList.e.b(item), i2);
                entityhuman.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent Z() {
        IChatBaseComponent ichatbasecomponent = this.ab();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.j().q());
    }

    @Override
    public boolean cn() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer worldserver) {
        Entity entity = super.b(worldserver);
        if (!this.dI().B && entity instanceof EntityItem) {
            ((EntityItem)entity).A();
        }
        return entity;
    }

    public ItemStack j() {
        return this.aj().b(c);
    }

    public void a(ItemStack itemstack) {
        Preconditions.checkArgument((!itemstack.b() ? 1 : 0) != 0, (Object)"Cannot drop air");
        this.aj().b(c, itemstack);
        this.aj().markDirty(c);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (c.equals(datawatcherobject)) {
            this.j().a((Entity)this);
        }
    }

    public void b(@Nullable UUID uuid) {
        this.k = uuid;
    }

    public void c(@Nullable UUID uuid) {
        this.j = uuid;
    }

    public int k() {
        return this.g;
    }

    public void o() {
        this.h = 10;
    }

    public void p() {
        this.h = 0;
    }

    public void q() {
        this.h = Short.MAX_VALUE;
    }

    public void b(int i2) {
        this.h = i2;
    }

    public boolean r() {
        return this.h > 0;
    }

    public void s() {
        this.g = Short.MIN_VALUE;
    }

    public void t() {
        this.g = -6000;
    }

    public void w() {
        this.q();
        this.g = this.dI().spigotConfig.itemDespawnRate - 1;
    }

    public float a(float f2) {
        return ((float)this.k() + f2) / 20.0f + this.b;
    }

    public EntityItem x() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory cY() {
        return SoundCategory.i;
    }

    @Override
    public float dz() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }
}

