/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int e;
    public int bT;
    public int bU = 30;
    public int bV = 3;
    private int bW;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void x() {
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(2, new PathfinderGoalSwell(this));
        this.bO.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bO.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bO.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(6, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.ge().a(GenericAttributes.d, 0.25);
    }

    @Override
    public int cr() {
        return this.j() == null ? 3 : 3 + (int)(this.er() - 1.0f);
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        boolean flag = super.a(f2, f1, damagesource);
        this.bT += (int)(f2 * 1.5f);
        if (this.bT > this.bU - 5) {
            this.bT = this.bU - 5;
        }
        return flag;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(b, -1);
        this.am.a(c, false);
        this.am.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (this.am.b(c).booleanValue()) {
            nbttagcompound.a("powered", true);
        }
        nbttagcompound.a("Fuse", (short)this.bU);
        nbttagcompound.a("ExplosionRadius", (byte)this.bV);
        nbttagcompound.a("ignited", this.w());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.am.b(c, nbttagcompound.q("powered"));
        if (nbttagcompound.b("Fuse", 99)) {
            this.bU = nbttagcompound.g("Fuse");
        }
        if (nbttagcompound.b("ExplosionRadius", 99)) {
            this.bV = nbttagcompound.f("ExplosionRadius");
        }
        if (nbttagcompound.q("ignited")) {
            this.fY();
        }
    }

    @Override
    public void l() {
        if (this.bs()) {
            int i2;
            this.e = this.bT;
            if (this.w()) {
                this.b(1);
            }
            if ((i2 = this.r()) > 0 && this.bT == 0) {
                this.a(SoundEffects.fg, 1.0f, 0.5f);
                this.a(GameEvent.J);
            }
            this.bT += i2;
            if (this.bT < 0) {
                this.bT = 0;
            }
            if (this.bT >= this.bU) {
                this.bT = this.bU;
                this.gb();
            }
        }
        super.l();
    }

    @Override
    public void h(@Nullable EntityLiving entityliving) {
        if (!(entityliving instanceof Goat)) {
            super.h(entityliving);
        }
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.ff;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.fe;
    }

    @Override
    protected void a(DamageSource damagesource, int i2, boolean flag) {
        EntityCreeper entitycreeper;
        super.a(damagesource, i2, flag);
        Entity entity = damagesource.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fZ()) {
            entitycreeper.ga();
            this.a((IMaterial)Items.tv);
        }
    }

    @Override
    public boolean z(Entity entity) {
        return true;
    }

    @Override
    public boolean a() {
        return this.am.b(c);
    }

    public float D(float f2) {
        return MathHelper.i(f2, this.e, this.bT) / (float)(this.bU - 2);
    }

    public int r() {
        return this.am.b(b);
    }

    public void b(int i2) {
        this.am.b(b, i2);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        super.a(worldserver, entitylightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, entitylightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.setPowered(true);
    }

    public void setPowered(boolean powered) {
        this.am.b(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(TagsItem.aF)) {
            SoundEffect soundeffect = itemstack.a(Items.tf) ? SoundEffects.hD : SoundEffects.hS;
            this.dI().a(entityhuman, this.dn(), this.dp(), this.dt(), soundeffect, this.cY(), 1.0f, this.af.i() * 0.4f + 0.8f);
            if (!this.dI().B) {
                this.fY();
                if (!itemstack.i()) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, entityhuman, (T entityhuman1) -> entityhuman1.d(enumhand));
                }
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        return super.b(entityhuman, enumhand);
    }

    public void gb() {
        if (!this.dI().B) {
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)this.bV * f2, false);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.bb = true;
                this.dI().a((Entity)this, this.dn(), this.dp(), this.dt(), event.getRadius(), event.getFire(), World.a.c);
                this.ai();
                this.gc();
            } else {
                this.bT = 0;
            }
        }
    }

    private void gc() {
        Collection<MobEffect> collection = this.eo();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dI(), this.dn(), this.dp(), this.dt());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.d(10);
            entityareaeffectcloud.b(entityareaeffectcloud.m() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.m());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dI().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean w() {
        return this.am.b(d);
    }

    public void fY() {
        this.am.b(d, true);
    }

    public boolean fZ() {
        return this.a() && this.bW < 1;
    }

    public void ga() {
        ++this.bW;
    }
}

