/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final UUID c = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier d = new AttributeModifier(c, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int bT = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bU = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int bX = Integer.MIN_VALUE;
    private int bY;
    private static final UniformInt bZ = TimeRange.a(20, 39);
    private int ca;
    @Nullable
    private UUID cb;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.r(1.0f);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void x() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new a(this));
        this.bO.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bO.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bO.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bO.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bP.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a_));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bP.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.ge().a(GenericAttributes.a, 40.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 7.0).a(GenericAttributes.b, 64.0);
    }

    @Override
    public void h(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.j();
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (entityliving == null) {
            this.bY = 0;
            this.am.b(bV, false);
            this.am.b(bW, false);
            attributemodifiable.d(d);
        } else {
            this.bY = this.ag;
            this.am.b(bV, true);
            if (!attributemodifiable.a(d)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bU, Optional.empty());
        this.am.a(bV, false);
        this.am.a(bW, false);
    }

    @Override
    public void c() {
        this.a(bZ.a(this.af));
    }

    @Override
    public void a(int i2) {
        this.ca = i2;
    }

    @Override
    public int a() {
        return this.ca;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cb = uuid;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cb;
    }

    public void r() {
        if (this.ag >= this.bX + 400) {
            this.bX = this.ag;
            if (!this.aQ()) {
                this.dI().a(this.dn(), this.dr(), this.dt(), SoundEffects.hg, this.cY(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bV.equals(datawatcherobject) && this.ga() && this.dI().B) {
            this.r();
        }
        super.a(datawatcherobject);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        IBlockData iblockdata = this.fY();
        if (iblockdata != null) {
            nbttagcompound.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.c(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        IBlockData iblockdata = null;
        if (nbttagcompound.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.a(this.dI().a(Registries.e), nbttagcompound.p("carriedBlockState"))).i()) {
            iblockdata = null;
        }
        this.d(iblockdata);
        this.a(this.dI(), nbttagcompound);
    }

    boolean g(EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.fN().j.get(3);
        if (itemstack.a(Blocks.ef.k())) {
            return false;
        }
        Vec3D vec3d = entityhuman.f(1.0f).d();
        Vec3D vec3d1 = new Vec3D(this.dn() - entityhuman.dn(), this.dr() - entityhuman.dr(), this.dt() - entityhuman.dt());
        double d0 = vec3d1.f();
        double d1 = vec3d.b(vec3d1 = vec3d1.d());
        return d1 > 1.0 - 0.025 / d0 ? entityhuman.B(this) : false;
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return 2.55f;
    }

    @Override
    public void b_() {
        if (this.dI().B) {
            int i2 = 0;
            while (i2 < 2) {
                this.dI().a(Particles.X, this.d(0.5), this.dq() - 0.25, this.g(0.5), (this.af.j() - 0.5) * 2.0, -this.af.j(), (this.af.j() - 0.5) * 2.0);
                ++i2;
            }
        }
        this.bk = false;
        if (!this.dI().B) {
            this.a((WorldServer)this.dI(), true);
        }
        super.b_();
    }

    @Override
    public boolean fb() {
        return true;
    }

    @Override
    protected void W() {
        float f2;
        if (this.dI().N() && this.ag >= this.bY + 600 && (f2 = this.bj()) > 0.5f && this.dI().g(this.di()) && this.af.i() * 30.0f < (f2 - 0.4f) * 2.0f) {
            this.h((EntityLiving)null);
            this.w();
        }
        super.W();
    }

    protected boolean w() {
        if (!this.dI().r_() && this.bs()) {
            double d0 = this.dn() + (this.af.j() - 0.5) * 64.0;
            double d1 = this.dp() + (double)(this.af.a(64) - 32);
            double d2 = this.dt() + (this.af.j() - 0.5) * 64.0;
            return this.r(d0, d1, d2);
        }
        return false;
    }

    boolean a(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dn() - entity.dn(), this.e(0.5) - entity.dr(), this.dt() - entity.dt());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dn() + (this.af.j() - 0.5) * 8.0 - vec3d.c * 16.0;
        double d2 = this.dp() + (double)(this.af.a(16) - 8) - vec3d.d * 16.0;
        double d3 = this.dt() + (this.af.j() - 0.5) * 8.0 - vec3d.e * 16.0;
        return this.r(d1, d2, d3);
    }

    private boolean r(double d0, double d1, double d2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(d0, d1, d2);
        while (blockposition_mutableblockposition.v() > this.dI().C_() && !this.dI().a_(blockposition_mutableblockposition).d()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.dI().a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.u().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.dg();
            boolean flag2 = this.b(d0, d1, d2, true);
            if (flag2) {
                this.dI().a(GameEvent.S, vec3d, GameEvent.a.a(this));
                if (!this.aQ()) {
                    this.dI().a(null, this.J, this.K, this.L, SoundEffects.hh, this.cY(), 1.0f, 1.0f);
                    this.a(SoundEffects.hh, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect s() {
        return this.fZ() ? SoundEffects.hf : SoundEffects.hc;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.he;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.hd;
    }

    @Override
    protected void a(DamageSource damagesource, int i2, boolean flag) {
        super.a(damagesource, i2, flag);
        IBlockData iblockdata = this.fY();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.ou);
            itemstack.a(Enchantments.v, 1);
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.dI()).a(LootContextParameters.f, this.dg()).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, this);
            List<ItemStack> list = iblockdata.a(lootparams_a);
            for (ItemStack itemstack1 : list) {
                this.b(itemstack1);
            }
        }
    }

    public void d(@Nullable IBlockData iblockdata) {
        this.am.b(bU, Optional.ofNullable(iblockdata));
    }

    @Nullable
    public IBlockData fY() {
        return this.am.b(bU).orElse(null);
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        boolean flag = damagesource.c() instanceof EntityPotion;
        if (!damagesource.a(DamageTypeTags.j) && !flag) {
            boolean flag1 = super.a(damagesource, f2);
            if (!this.dI().r_() && !(damagesource.d() instanceof EntityLiving) && this.af.a(10) != 0) {
                this.w();
            }
            return flag1;
        }
        boolean flag1 = flag && this.a(damagesource, (EntityPotion)damagesource.c(), f2);
        int i2 = 0;
        while (i2 < 64) {
            if (this.w()) {
                return true;
            }
            ++i2;
        }
        return flag1;
    }

    private boolean a(DamageSource damagesource, EntityPotion entitypotion, float f2) {
        ItemStack itemstack = entitypotion.j();
        PotionRegistry potionregistry = PotionUtil.d(itemstack);
        List<MobEffect> list = PotionUtil.a(itemstack);
        boolean flag = potionregistry == Potions.c && list.isEmpty();
        return flag ? super.a(damagesource, f2) : false;
    }

    public boolean fZ() {
        return this.am.b(bV);
    }

    public boolean ga() {
        return this.am.b(bW);
    }

    public void gb() {
        this.am.b(bW, true);
    }

    @Override
    public boolean T() {
        return super.T() || this.fY() != null;
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean a() {
            return this.a.fY() != null ? false : (!this.a.dI().X().b(GameRules.c) ? false : this.a.ec().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void e() {
            RandomSource randomsource = this.a.ec();
            World world = this.a.dI();
            int i2 = MathHelper.a(this.a.dn() - 2.0 + randomsource.j() * 4.0);
            int j2 = MathHelper.a(this.a.dp() + randomsource.j() * 3.0);
            int k2 = MathHelper.a(this.a.dt() - 2.0 + randomsource.j() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            Vec3D vec3d = new Vec3D((double)this.a.dm() + 0.5, (double)j2 + 0.5, (double)this.a.ds() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.a().equals(blockposition);
            if (iblockdata.a(TagsBlock.aj) && flag && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.n()).isCancelled()) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.d(iblockdata.b().n());
            }
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean a() {
            return this.a.fY() == null ? false : (!this.a.dI().X().b(GameRules.c) ? false : this.a.ec().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void e() {
            RandomSource randomsource = this.a.ec();
            World world = this.a.dI();
            int i2 = MathHelper.a(this.a.dn() - 1.0 + randomsource.j() * 2.0);
            int j2 = MathHelper.a(this.a.dp() + randomsource.j() * 2.0);
            int k2 = MathHelper.a(this.a.dt() - 1.0 + randomsource.j() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            BlockPosition blockposition1 = blockposition.d();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.fY();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.dI(), blockposition), iblockdata, iblockdata1, blockposition1) && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2).isCancelled()) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.d((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, IBlockData iblockdata2, BlockPosition blockposition1) {
            return iblockdata1.i() && !iblockdata2.i() && !iblockdata2.a(Blocks.F) && iblockdata2.r(world, blockposition1) && iblockdata.a((IWorldReader)world, blockposition) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(blockposition))).isEmpty();
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final Predicate<EntityLiving> o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman entityenderman, @Nullable Predicate<EntityLiving> predicate) {
            super(entityenderman, EntityHuman.class, 10, false, false, predicate);
            this.i = entityenderman;
            this.o = entityliving -> (entityenderman.g((EntityHuman)entityliving) || entityenderman.a_((EntityLiving)entityliving)) && !entityenderman.w((Entity)entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean a() {
            this.j = this.i.dI().a(this.m, this.i);
            return this.j != null;
        }

        @Override
        public void c() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gb();
        }

        @Override
        public void d() {
            this.j = null;
            super.d();
        }

        @Override
        public boolean b() {
            if (this.j != null) {
                if (!this.o.test(this.j)) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.w(this.c)) {
                    return false;
                }
                if (this.n.a(this.i, this.c)) {
                    return true;
                }
            }
            return super.b();
        }

        @Override
        public void e() {
            if (this.i.j() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.c();
                }
            } else {
                if (this.c != null && !this.i.bM()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.f((Entity)this.i) < 16.0) {
                            this.i.w();
                        }
                        this.l = 0;
                    } else if (this.c.f((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.a((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.e();
            }
        }
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman entityenderman) {
            this.a = entityenderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.b = this.a.j();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.f((Entity)this.a);
            return d0 > 256.0 ? false : this.a.g((EntityHuman)this.b);
        }

        @Override
        public void c() {
            this.a.J().n();
        }

        @Override
        public void e() {
            this.a.E().a(this.b.dn(), this.b.dr(), this.b.dt());
        }
    }
}

