/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> b = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack c = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.v(false);
        }

        @Override
        public void c() {
            super.c();
            EntitySkeletonAbstract.this.v(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.w();
    }

    @Override
    protected void x() {
        this.bO.a(2, new PathfinderGoalRestrictSun(this));
        this.bO.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.bO.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(6, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bU));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.ge().a(GenericAttributes.d, 0.25);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.r(), 0.15f, 1.0f);
    }

    abstract SoundEffect r();

    @Override
    public EnumMonsterType eN() {
        return EnumMonsterType.b;
    }

    @Override
    public void b_() {
        boolean flag = this.fT();
        if (flag) {
            ItemStack itemstack = this.c(EnumItemSlot.f);
            if (!itemstack.b()) {
                if (itemstack.i()) {
                    itemstack.b(itemstack.k() + this.af.a(2));
                    if (itemstack.k() >= itemstack.l()) {
                        this.d(EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.b);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.g(8);
            }
        }
        super.b_();
    }

    @Override
    public void bv() {
        super.bv();
        Entity entity = this.cX();
        if (entity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)entity;
            this.aV = entitycreature.aV;
        }
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        this.a(EnumItemSlot.a, new ItemStack(Items.nG));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        groupdataentity = super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
        RandomSource randomsource = worldaccess.y_();
        this.a(randomsource, difficultydamagescaler);
        this.b(randomsource, difficultydamagescaler);
        this.w();
        this.s(randomsource.i() < 0.55f * difficultydamagescaler.d());
        if (this.c(EnumItemSlot.f).b()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eg : Blocks.ef));
                this.bR[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        return groupdataentity;
    }

    public void w() {
        if (this.dI() != null && !this.dI().B) {
            this.bO.a(this.c);
            this.bO.a(this.b);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.nG));
            if (itemstack.a(Items.nG)) {
                int b0 = 20;
                if (this.dI().ai() != EnumDifficulty.d) {
                    b0 = 40;
                }
                this.b.c(b0);
                this.bO.a(4, this.b);
            } else {
                this.bO.a(4, this.c);
            }
        }
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        ItemStack itemstack = this.g(this.b(ProjectileHelper.a(this, Items.nG)));
        EntityArrow entityarrow = this.b(itemstack, f2);
        double d0 = entityliving.dn() - this.dn();
        double d1 = entityliving.e(0.3333333333333333) - entityarrow.dp();
        double d2 = entityliving.dt() - this.dt();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entityarrow.c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.dI().ai().a() * 4);
        EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.eO(), null, entityarrow, EnumHand.a, 0.8f, true);
        if (event.isCancelled()) {
            event.getProjectile().remove();
            return;
        }
        if (event.getProjectile() == entityarrow.getBukkitEntity()) {
            this.dI().b(entityarrow);
        }
        this.a(SoundEffects.vA, 1.0f, 1.0f / (this.ec().i() * 0.4f + 0.8f));
    }

    protected EntityArrow b(ItemStack itemstack, float f2) {
        return ProjectileHelper.a(this, itemstack, f2);
    }

    @Override
    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return itemprojectileweapon == Items.nG;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.w();
    }

    @Override
    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        super.a(enumitemslot, itemstack);
        if (!this.dI().B) {
            this.w();
        }
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return 1.74f;
    }

    @Override
    public double bw() {
        return -0.6;
    }

    public boolean fY() {
        return this.ci();
    }
}

