/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public float d;
    public float e;
    public float bS;
    private boolean bU;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.cA();
        this.bL = new ControllerMoveSlime(this);
    }

    @Override
    protected void x() {
        this.bO.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bO.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bO.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bO.a(5, new PathfinderGoalSlimeIdle(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.dp() - this.dp()) <= 4.0));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bT, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.am.b(bT, j2);
        this.an();
        this.d_();
        this.a(GenericAttributes.a).a(j2 * j2);
        this.a(GenericAttributes.d).a(0.2f + 0.1f * (float)j2);
        this.a(GenericAttributes.f).a(j2);
        if (flag) {
            this.t(this.eI());
        }
        this.bJ = j2;
    }

    public int ga() {
        return this.am.b(bT);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Size", this.ga() - 1);
        nbttagcompound.a("wasOnGround", this.bU);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        this.a(nbttagcompound.h("Size") + 1, false);
        super.a(nbttagcompound);
        this.bU = nbttagcompound.q("wasOnGround");
    }

    public boolean gb() {
        return this.ga() <= 1;
    }

    protected ParticleParam r() {
        return Particles.Q;
    }

    @Override
    protected boolean U() {
        return this.ga() > 0;
    }

    @Override
    public void l() {
        this.e += (this.d - this.e) * 0.5f;
        this.bS = this.e;
        super.l();
        if (this.ay() && !this.bU) {
            int i2 = this.ga();
            int j2 = 0;
            while (j2 < i2 * 8) {
                float f2 = this.af.i() * ((float)Math.PI * 2);
                float f1 = this.af.i() * 0.5f + 0.5f;
                float f22 = MathHelper.a(f2) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.b(f2) * (float)i2 * 0.5f * f1;
                this.dI().a(this.r(), this.dn() + (double)f22, this.dp(), this.dt() + (double)f3, 0.0, 0.0, 0.0);
                ++j2;
            }
            this.a(this.fY(), this.eR(), ((this.af.i() - this.af.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.ay() && this.bU) {
            this.d = 1.0f;
        }
        this.bU = this.ay();
        this.fV();
    }

    protected void fV() {
        this.d *= 0.6f;
    }

    protected int w() {
        return this.af.a(20) + 10;
    }

    @Override
    public void d_() {
        double d0 = this.dn();
        double d1 = this.dp();
        double d2 = this.dt();
        super.d_();
        this.e(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (bT.equals(datawatcherobject)) {
            this.d_();
            this.a_(this.aX);
            this.aV = this.aX;
            if (this.aV() && this.af.a(20) == 0) {
                this.bd();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> ae() {
        return super.ae();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        int i2 = this.ga();
        if (!this.dI().B && i2 > 1 && this.es()) {
            IChatBaseComponent ichatbasecomponent = this.ab();
            boolean flag = this.fQ();
            float f2 = (float)i2 / 4.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.af.a(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.a(entity_removalreason);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            int l2 = 0;
            while (l2 < k2) {
                float f1 = ((float)(l2 % 2) - 0.5f) * f2;
                float f22 = ((float)(l2 / 2) - 0.5f) * f2;
                EntitySlime entityslime = this.ae().a(this.dI());
                if (entityslime != null) {
                    if (this.fH()) {
                        entityslime.fF();
                    }
                    entityslime.b(ichatbasecomponent);
                    entityslime.t(flag);
                    entityslime.m(this.co());
                    entityslime.a(j2, true);
                    entityslime.b(this.dn() + (double)f1, this.dp() + 0.5, this.dt() + (double)f22, this.af.i() * 360.0f, 0.0f);
                    slimes.add(entityslime);
                }
                ++l2;
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.a(entity_removalreason);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dI().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.a(entity_removalreason);
    }

    @Override
    public void g(Entity entity) {
        super.g(entity);
        if (entity instanceof EntityIronGolem && this.fW()) {
            this.l((EntityLiving)entity);
        }
    }

    @Override
    public void b_(EntityHuman entityhuman) {
        if (this.fW()) {
            this.l(entityhuman);
        }
    }

    protected void l(EntityLiving entityliving) {
        if (this.bs()) {
            int i2 = this.ga();
            if (this.f((Entity)entityliving) < 0.6 * (double)i2 * 0.6 * (double)i2 && this.B(entityliving) && entityliving.a(this.dJ().b(this), this.fX())) {
                this.a(SoundEffects.vC, 1.0f, (this.af.i() - this.af.i()) * 0.2f + 1.0f);
                this.a((EntityLiving)this, (Entity)entityliving);
            }
        }
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return 0.625f * entitysize.b;
    }

    protected boolean fW() {
        return !this.gb() && this.cV();
    }

    protected float fX() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return this.gb() ? SoundEffects.wt : SoundEffects.vE;
    }

    @Override
    protected SoundEffect g_() {
        return this.gb() ? SoundEffects.ws : SoundEffects.vD;
    }

    protected SoundEffect fY() {
        return this.gb() ? SoundEffects.wv : SoundEffects.vG;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        if (generatoraccess.ai() != EnumDifficulty.a) {
            boolean flag;
            if (generatoraccess.s(blockposition).a(BiomeTags.ap) && blockposition.v() > 50 && blockposition.v() < 70 && randomsource.i() < 0.5f && randomsource.i() < generatoraccess.an() && generatoraccess.z(blockposition) <= randomsource.a(8)) {
                return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.e, chunkcoordintpair.f, ((GeneratorAccessSeed)generatoraccess).A(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, enummobspawn, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float eR() {
        return 0.4f * (float)this.ga();
    }

    @Override
    public int X() {
        return 0;
    }

    protected boolean gc() {
        return this.ga() > 0;
    }

    @Override
    protected void eW() {
        Vec3D vec3d = this.dl();
        this.o(vec3d.c, this.eU(), vec3d.e);
        this.at = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        RandomSource randomsource = worldaccess.y_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    float q() {
        float f2 = this.gb() ? 1.4f : 0.8f;
        return ((this.af.i() - this.af.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect fZ() {
        return this.gb() ? SoundEffects.wu : SoundEffects.vF;
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return super.a(entitypose).a(0.255f * (float)this.ga());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.dy() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.a_(this.a(this.d.dy(), this.l, 90.0f));
            this.d.aX = this.d.dy();
            this.d.aV = this.d.dy();
            if (this.k != ControllerMove.Operation.b) {
                this.d.z(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.ay()) {
                    this.d.w((float)(this.h * this.d.b(GenericAttributes.d)));
                    if (this.m-- <= 0) {
                        this.m = this.n.w();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.I().a();
                        if (this.n.gc()) {
                            this.n.a(this.n.fZ(), this.n.eR(), this.n.q());
                        }
                    } else {
                        this.n.bl = 0.0f;
                        this.n.bn = 0.0f;
                        this.d.w(0.0f);
                    }
                } else {
                    this.d.w((float)(this.h * this.d.b(GenericAttributes.d)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !this.a.bM();
        }

        @Override
        public void e() {
            ControllerMove controllermove = this.a.G();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.j();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.G() instanceof ControllerMoveSlime);
        }

        @Override
        public void c() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.c();
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.j();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean K_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.j();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.G()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dy(), this.a.fW());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return this.a.j() == null && (this.a.ay() || this.a.aV() || this.a.bi() || this.a.a(MobEffects.y)) && this.a.G() instanceof ControllerMoveSlime;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ec().a(60));
                this.b = this.a.ec().a(360);
            }
            if ((controllermove = this.a.G()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.J().a(true);
        }

        @Override
        public boolean a() {
            return (this.a.aV() || this.a.bi()) && this.a.G() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean K_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (this.a.ec().i() < 0.8f) {
                this.a.I().a();
            }
            if ((controllermove = this.a.G()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }
}

