/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final UUID bT = UUID.fromString("9e362924-01de-4ddd-a2b2-d0f7a405a174");
    private static final AttributeModifier bU = new AttributeModifier(bT, "Strider suffocating modifier", (double)-0.34f, AttributeModifier.Operation.b);
    private static final float bW = 0.35f;
    private static final float bX = 0.55f;
    private static final RecipeItemStack bY = RecipeItemStack.a(Items.dh);
    private static final RecipeItemStack bZ = RecipeItemStack.a(Items.dh, Items.ng);
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cd;
    @Nullable
    private PathfinderGoalTempt ce;
    @Nullable
    private PathfinderGoalPanic cf;

    public EntityStrider(EntityTypes<? extends EntityStrider> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cd = new SaddleStorage(this.am, ca, cc);
        this.H = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entitytypes, GeneratorAccess generatoraccess, EnumMobSpawn enummobspawn, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.j();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (generatoraccess.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return generatoraccess.a_(blockposition_mutableblockposition).i();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (ca.equals(datawatcherobject) && this.dI().B) {
            this.cd.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(ca, 0);
        this.am.a(cb, false);
        this.am.a(cc, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        this.cd.a(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.cd.b(nbttagcompound);
    }

    @Override
    public boolean i() {
        return this.cd.d();
    }

    @Override
    public boolean g() {
        return this.bs() && !this.h_();
    }

    @Override
    public void a(@Nullable SoundCategory soundcategory) {
        this.cd.a(true);
        if (soundcategory != null) {
            this.dI().a(null, this, SoundEffects.wr, soundcategory, 0.5f, 1.0f);
        }
    }

    @Override
    protected void x() {
        this.cf = new PathfinderGoalPanic(this, 1.65);
        this.bO.a(1, this.cf);
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        this.ce = new PathfinderGoalTempt(this, 1.4, bZ, false);
        this.bO.a(3, this.ce);
        this.bO.a(4, new a(this, 1.0));
        this.bO.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.bO.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void w(boolean flag) {
        this.am.b(cb, flag);
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (attributemodifiable != null) {
            attributemodifiable.b(bT);
            if (flag) {
                attributemodifiable.b(bU);
            }
        }
    }

    public boolean q() {
        return this.am.b(cb);
    }

    @Override
    public boolean a(Fluid fluid) {
        return fluid.a(TagsFluid.b);
    }

    @Override
    public double bx() {
        float f2 = Math.min(0.25f, this.aR.a());
        float f1 = this.aR.b();
        return (double)this.de() - 0.19 + (double)(0.12f * MathHelper.b(f1 * 1.5f) * 2.0f * f2);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    @Nullable
    public EntityLiving cL() {
        EntityHuman entityhuman;
        Entity entity = this.cO();
        if (entity instanceof EntityHuman && ((entityhuman = (EntityHuman)entity).eO().a(Items.ng) || entityhuman.eP().a(Items.ng))) {
            return entityhuman;
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dd(), (double)entityliving.dd(), entityliving.dy()), EntityStrider.a(this.dd(), (double)entityliving.dd(), entityliving.dy() - 22.5f), EntityStrider.a(this.dd(), (double)entityliving.dd(), entityliving.dy() + 22.5f), EntityStrider.a(this.dd(), (double)entityliving.dd(), entityliving.dy() - 45.0f), EntityStrider.a(this.dd(), (double)entityliving.dd(), entityliving.dy() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cE().e;
        double d1 = this.cE().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        int j2 = 0;
        while (j2 < i2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.b(this.dn() + vec3d.c, d0, this.dt() + vec3d.e);
            double d2 = d0;
            while (d2 > d1) {
                set.add(blockposition_mutableblockposition.i());
                blockposition_mutableblockposition.c(EnumDirection.a);
                d2 -= 1.0;
            }
            ++j2;
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.dI().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.dI().i(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : entityliving.fv()) {
                AxisAlignedBB axisalignedbb = entityliving.g(entitypose);
                if (!DismountUtil.a(this.dI(), entityliving, axisalignedbb.c(vec3d1))) continue;
                entityliving.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dn(), this.cE().e, this.dt());
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        this.a(entityhuman.dy(), entityhuman.dA() * 0.5f);
        this.aV = this.aX = this.dy();
        this.M = this.aX;
        this.cd.b();
        super.a(entityhuman, vec3d);
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman entityhuman) {
        return (float)(this.b(GenericAttributes.d) * (double)(this.q() ? 0.35f : 0.55f) * (double)this.cd.c());
    }

    @Override
    protected float aI() {
        return this.Y + 0.6f;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.bi() ? SoundEffects.wp : SoundEffects.wo, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cd.a(this.ec());
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        this.aM();
        if (this.bi()) {
            this.n();
        } else {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void l() {
        if (this.fY() && this.af.a(140) == 0) {
            this.a(SoundEffects.wk, 1.0f, this.eS());
        } else if (this.w() && this.af.a(60) == 0) {
            this.a(SoundEffects.wl, 1.0f, this.eS());
        }
        if (!this.fQ()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.dI().a_(this.di());
            IBlockData iblockdata1 = this.be();
            boolean flag = iblockdata.a(TagsBlock.aS) || iblockdata1.a(TagsBlock.aS) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.cW();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).q();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.q() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.w(suffocating);
            }
        }
        super.l();
        this.ge();
        this.aM();
    }

    private boolean w() {
        return this.cf != null && this.cf.k();
    }

    private boolean fY() {
        return this.ce != null && this.ce.i();
    }

    @Override
    protected boolean z() {
        return true;
    }

    private void ge() {
        if (this.bi()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.c, this.di(), true) && !this.dI().b_(this.di().c()).a(TagsFluid.b)) {
                this.c(true);
            } else {
                this.f(this.dl().a(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder r() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.175f).a(GenericAttributes.b, 16.0);
    }

    @Override
    protected SoundEffect s() {
        return !this.w() && !this.fY() ? SoundEffects.wj : null;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.wn;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.wm;
    }

    @Override
    protected boolean o(Entity entity) {
        return !this.bN() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fb() {
        return true;
    }

    @Override
    public boolean bL() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition).u().a(TagsFluid.b) ? 10.0f : (this.bi() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    @Nullable
    public EntityStrider b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.aV.a(worldserver);
    }

    @Override
    public boolean m(ItemStack itemstack) {
        return bY.a(itemstack);
    }

    @Override
    protected void eu() {
        super.eu();
        if (this.i()) {
            this.a((IMaterial)Items.mZ);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.m(entityhuman.b(enumhand));
        if (!flag && this.i() && !this.bN() && !entityhuman.fD()) {
            if (!this.dI().B) {
                entityhuman.k(this);
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return itemstack.a(Items.mZ) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.d;
        }
        if (flag && !this.aQ()) {
            this.dI().a(null, this.dn(), this.dp(), this.dt(), SoundEffects.wq, this.cY(), 1.0f, 1.0f + (this.af.i() - this.af.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cG() {
        return new Vec3D(0.0, 0.6f * this.cF(), this.dd() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        if (this.h_()) {
            return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
        }
        RandomSource randomsource = worldaccess.y_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bs.a(worldaccess.C());
            if (entityinsentient != null) {
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityinsentient, new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.ng));
                this.a((SoundCategory)null);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.aV.a(worldaccess.C());
            if (entityageable != null) {
                entityageable.c_(-24000);
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityageable, null);
            }
        } else {
            groupdataentity = new EntityAgeable.a(0.5f);
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    private GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntityInsentient entityinsentient, @Nullable GroupDataEntity groupdataentity) {
        entityinsentient.b(this.dn(), this.dp(), this.dt(), this.dy(), 0.0f);
        entityinsentient.a(worldaccess, difficultydamagescaler, EnumMobSpawn.g, groupdataentity, null);
        entityinsentient.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.g = entitystrider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean b() {
            return !this.g.bi() && this.a(this.g.dI(), this.e);
        }

        @Override
        public boolean a() {
            return !this.g.bi() && super.a();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return iworldreader.a_(blockposition).a(Blocks.H) && iworldreader.a_(blockposition.c()).a((IBlockAccess)iworldreader, blockposition, PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entitystrider, World world) {
            super(entitystrider, world);
        }

        @Override
        protected Pathfinder a(int i2) {
            this.o = new PathfinderNormal();
            this.o.a(true);
            return new Pathfinder(this.o, i2);
        }

        @Override
        protected boolean a(PathType pathtype) {
            return pathtype != PathType.i && pathtype != PathType.o && pathtype != PathType.n ? super.a(pathtype) : true;
        }

        @Override
        public boolean a(BlockPosition blockposition) {
            return this.b.a_(blockposition).a(Blocks.H) || super.a(blockposition);
        }
    }
}

