/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityZombie
extends EntityMonster {
    private static final UUID b = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier c = new AttributeModifier(b, "Baby speed boost", 0.5, AttributeModifier.Operation.b);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float e = 0.05f;
    public static final int bT = 50;
    public static final int bU = 40;
    public static final int bV = 7;
    protected static final float bW = 0.81f;
    private static final float bZ = 0.1f;
    private static final Predicate<EnumDifficulty> ca = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor cb;
    private boolean cc;
    private int cd;
    public int ce;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.cb = new PathfinderGoalBreakDoor(this, ca);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bp, world);
    }

    @Override
    protected void x() {
        this.bO.a(4, new a((EntityCreature)this, 1.0, 3));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.q();
    }

    protected void q() {
        this.bO.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bO.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gg));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dI().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bP.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bU));
    }

    public static AttributeProvider.Builder gc() {
        return EntityMonster.ge().a(GenericAttributes.b, 35.0).a(GenericAttributes.d, 0.23f).a(GenericAttributes.f, 3.0).a(GenericAttributes.i, 2.0).a(GenericAttributes.l);
    }

    @Override
    protected void a_() {
        super.a_();
        this.aj().a(d, false);
        this.aj().a(bX, 0);
        this.aj().a(bY, false);
    }

    public boolean gf() {
        return this.aj().b(bY);
    }

    public boolean gg() {
        return this.cc;
    }

    public void x(boolean flag) {
        if (this.r() && PathfinderGoalUtil.a(this)) {
            if (this.cc != flag) {
                this.cc = flag;
                ((Navigation)this.J()).b(flag);
                if (flag) {
                    this.bO.a(1, this.cb);
                } else {
                    this.bO.a(this.cb);
                }
            }
        } else if (this.cc) {
            this.bO.a(this.cb);
            this.cc = false;
        }
    }

    protected boolean r() {
        return true;
    }

    @Override
    public boolean h_() {
        return this.aj().b(d);
    }

    @Override
    public int ea() {
        if (this.h_()) {
            this.bJ = (int)((double)this.bJ * 2.5);
        }
        return super.ea();
    }

    @Override
    public void a(boolean flag) {
        this.aj().b(d, flag);
        if (this.dI() != null && !this.dI().B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.d(c);
            if (flag) {
                attributemodifiable.b(c);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (d.equals(datawatcherobject)) {
            this.d_();
        }
        super.a(datawatcherobject);
    }

    protected boolean fZ() {
        return true;
    }

    @Override
    public void l() {
        if (!this.dI().B && this.bs() && !this.fQ()) {
            if (this.gf()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.ce -= elapsedTicks;
                if (this.ce < 0) {
                    this.gb();
                }
            } else if (this.fZ()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cd;
                    if (this.cd >= 600) {
                        this.b(300);
                    }
                } else {
                    this.cd = -1;
                }
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void b_() {
        if (this.bs()) {
            boolean flag;
            boolean bl = flag = this.X_() && this.fT();
            if (flag) {
                ItemStack itemstack = this.c(EnumItemSlot.f);
                if (!itemstack.b()) {
                    if (itemstack.i()) {
                        itemstack.b(itemstack.k() + this.af.a(2));
                        if (itemstack.k() >= itemstack.l()) {
                            this.d(EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.b);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.g(8);
                }
            }
        }
        super.b_();
    }

    public void b(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.ce = i2;
        this.aj().b(bY, true);
    }

    protected void gb() {
        this.b(EntityTypes.y);
        if (!this.aQ()) {
            this.dI().a(null, 1040, this.di(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie entityzombie = this.convertTo(entitytypes, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.D(entityzombie.dI().d_(entityzombie.di()).d());
            entityzombie.x(entityzombie.r() && this.gg());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    protected boolean X_() {
        return true;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (!super.a(damagesource, f2)) {
            return false;
        }
        if (!(this.dI() instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.dI();
        EntityLiving entityliving = this.j();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && this.dI().ai() == EnumDifficulty.d && (double)this.af.i() < this.b(GenericAttributes.l) && this.dI().X().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dn());
            int j2 = MathHelper.a(this.dp());
            int k2 = MathHelper.a(this.dt());
            EntityZombie entityzombie = new EntityZombie(this.dI());
            int l2 = 0;
            while (l2 < 50) {
                int i1 = i2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                int j1 = j2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                int k1 = k2 + MathHelper.a(this.af, 7, 40) * MathHelper.a(this.af, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.ae();
                EntityPositionTypes.Surface entitypositiontypes_surface = EntityPositionTypes.a(entitytypes);
                if (SpawnerCreature.a(entitypositiontypes_surface, this.dI(), blockposition, entitytypes) && EntityPositionTypes.a(entitytypes, worldserver, EnumMobSpawn.j, blockposition, this.dI().z)) {
                    entityzombie.e(i1, j1, k1);
                    if (!this.dI().a((double)i1, (double)j1, (double)k1, 7.0) && this.dI().f(entityzombie) && this.dI().g(entityzombie) && !this.dI().d(entityzombie.cE())) {
                        entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                        entityzombie.a(worldserver, this.dI().d_(entityzombie.di()), EnumMobSpawn.j, null, null);
                        worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                        this.a(GenericAttributes.l).c(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.a));
                        entityzombie.a(GenericAttributes.l).c(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.a));
                        break;
                    }
                }
                ++l2;
            }
        }
        return true;
    }

    @Override
    public boolean z(Entity entity) {
        boolean flag = super.z(entity);
        if (flag) {
            float f2 = this.dI().d_(this.di()).b();
            if (this.eO().b() && this.bL() && this.af.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 2 * (int)f2);
                this.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.setSecondsOnFire(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect s() {
        return SoundEffects.AP;
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.AZ;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.AU;
    }

    protected SoundEffect w() {
        return SoundEffects.Bf;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.w(), 0.15f, 1.0f);
    }

    @Override
    public EnumMonsterType eN() {
        return EnumMonsterType.b;
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.dI().ai() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.om));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.on));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsBaby", this.h_());
        nbttagcompound.a("CanBreakDoors", this.gg());
        nbttagcompound.a("InWaterTime", this.aV() ? this.cd : -1);
        nbttagcompound.a("DrownedConversionTime", this.gf() ? this.ce : -1);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a(nbttagcompound.q("IsBaby"));
        this.x(nbttagcompound.q("CanBreakDoors"));
        this.cd = nbttagcompound.h("InWaterTime");
        if (nbttagcompound.b("DrownedConversionTime", 99) && nbttagcompound.h("DrownedConversionTime") > -1) {
            this.b(nbttagcompound.h("DrownedConversionTime"));
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        boolean flag = super.a(worldserver, entityliving);
        if ((worldserver.ai() == EnumDifficulty.c || worldserver.ai() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.ai() != EnumDifficulty.d && this.af.h()) {
                return flag;
            }
            flag = EntityZombie.zombifyVillager(worldserver, entityvillager, this.di(), this.aQ(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.br, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.a(worldserver, worldserver.d_(entityzombievillager.di()), EnumMobSpawn.i, new GroupDataZombie(false, true), null);
            entityzombievillager.a(entityvillager.gj());
            entityzombievillager.a(entityvillager.gt().a(DynamicOpsNBT.a));
            entityzombievillager.c(entityvillager.ga().a());
            entityzombievillager.b(entityvillager.r());
            if (!silent) {
                worldserver.a(null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return this.h_() ? 0.93f : 1.74f;
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(Items.qd) && this.h_() && this.bM() ? false : super.j(itemstack);
    }

    @Override
    public boolean k(ItemStack itemstack) {
        return itemstack.a(Items.qs) ? false : super.k(itemstack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        RandomSource randomsource = worldaccess.y_();
        GroupDataEntity object = super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
        float f2 = difficultydamagescaler.d();
        this.s(randomsource.i() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.cE().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.w(true);
                            this.k((Entity)entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.q.a(this.dI())) != null) {
                        entitychicken1.b(this.dn(), this.dp(), this.dt(), this.dy(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EnumMobSpawn.g, null, null);
                        entitychicken1.w(true);
                        this.k((Entity)entitychicken1);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.x(this.r() && randomsource.i() < f2 * 0.1f);
            this.a(randomsource, difficultydamagescaler);
            this.b(randomsource, difficultydamagescaler);
        }
        if (this.c(EnumItemSlot.f).b()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eg : Blocks.ef));
                this.bR[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.D(f2);
        return object;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void D(float f2) {
        this.gh();
        this.a(GenericAttributes.c).c(new AttributeModifier("Random spawn bonus", this.af.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.af.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.a(GenericAttributes.b).c(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.c));
        }
        if (this.af.i() < f2 * 0.05f) {
            this.a(GenericAttributes.l).c(new AttributeModifier("Leader zombie bonus", this.af.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.a(GenericAttributes.a).c(new AttributeModifier("Leader zombie bonus", this.af.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(this.r());
        }
    }

    protected void gh() {
        this.a(GenericAttributes.l).a(this.af.j() * (double)0.1f);
    }

    @Override
    public double bw() {
        return this.h_() ? 0.0 : -0.45;
    }

    @Override
    protected void a(DamageSource damagesource, int i2, boolean flag) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(damagesource, i2, flag);
        Entity entity = damagesource.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fZ() && !(itemstack = this.fY()).b()) {
            entitycreeper.ga();
            this.b(itemstack);
        }
    }

    protected ItemStack fY() {
        return new ItemStack(Items.tu);
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.a = flag;
            this.b = flag1;
        }
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.mf, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a(null, blockposition, SoundEffects.AV, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.af.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a(null, blockposition, SoundEffects.yf, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }
}

