/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger b = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> d = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int bX = 3600;
    private static final int bY = 6000;
    private static final int bZ = 14;
    private static final int ca = 4;
    public int cb;
    @Nullable
    public UUID cc;
    @Nullable
    private NBTBase cd;
    @Nullable
    private NBTTagCompound ce;
    private int cf;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entitytypes, World world) {
        super((EntityTypes<? extends EntityZombie>)entitytypes, world);
        BuiltInRegistries.A.a(this.af).ifPresent(holder_c -> this.a(this.gj().a((VillagerProfession)holder_c.a())));
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(c, false);
        this.am.a(d, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gj());
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("VillagerData", (NBTBase)nbtbase));
        if (this.ce != null) {
            nbttagcompound.a("Offers", this.ce);
        }
        if (this.cd != null) {
            nbttagcompound.a("Gossips", this.cd);
        }
        nbttagcompound.a("ConversionTime", this.gi() ? this.cb : -1);
        if (this.cc != null) {
            nbttagcompound.a("ConversionPlayer", this.cc);
        }
        nbttagcompound.a("Xp", this.cf);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("VillagerData")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbttagcompound.b("Offers", 10)) {
            this.ce = nbttagcompound.p("Offers");
        }
        if (nbttagcompound.b("Gossips", 9)) {
            this.cd = nbttagcompound.c("Gossips", 10);
        }
        if (nbttagcompound.b("ConversionTime", 99) && nbttagcompound.h("ConversionTime") > -1) {
            this.a(nbttagcompound.b("ConversionPlayer") ? nbttagcompound.a("ConversionPlayer") : null, nbttagcompound.h("ConversionTime"));
        }
        if (nbttagcompound.b("Xp", 3)) {
            this.cf = nbttagcompound.h("Xp");
        }
    }

    @Override
    public void l() {
        if (!this.dI().B && this.bs() && this.gi()) {
            int i2 = this.gl();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cb -= (i2 *= elapsedTicks);
            if (this.cb <= 0) {
                this.c((WorldServer)this.dI());
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.pm)) {
            if (this.a(MobEffects.r)) {
                if (!entityhuman.fO().d) {
                    itemstack.h(1);
                }
                if (!this.dI().B) {
                    this.a(entityhuman.ct(), this.af.a(2401) + 3600);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    protected boolean fZ() {
        return false;
    }

    @Override
    public boolean h(double d0) {
        return !this.gi() && this.cf == 0;
    }

    public boolean gi() {
        return this.aj().b(c);
    }

    public void a(@Nullable UUID uuid, int i2) {
        this.cc = uuid;
        this.cb = i2;
        this.aj().b(c, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, i2, Math.min(this.dI().ai().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.dI().a((Entity)this, (byte)16);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 16) {
            if (!this.aQ()) {
                this.dI().a(this.dn(), this.dr(), this.dt(), SoundEffects.Bi, this.cY(), 1.0f + this.af.i(), this.af.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(b0);
        }
    }

    private void c(WorldServer worldserver) {
        EntityHuman entityhuman;
        EntityVillager entityvillager = this.convertTo(EntityTypes.bf, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
        int i2 = aenumitemslot.length;
        int j2 = 0;
        while (j2 < i2) {
            EnumItemSlot enumitemslot = aenumitemslot[j2];
            ItemStack itemstack = this.c(enumitemslot);
            if (!itemstack.b()) {
                if (EnchantmentManager.d(itemstack)) {
                    entityvillager.a_(enumitemslot.b() + 300).a(itemstack);
                } else {
                    double d0 = this.f(enumitemslot);
                    if (d0 > 1.0) {
                        this.forceDrops = true;
                        this.b(itemstack);
                        this.forceDrops = false;
                    }
                }
            }
            ++j2;
        }
        entityvillager.a(this.gj());
        if (this.cd != null) {
            entityvillager.a(this.cd);
        }
        if (this.ce != null) {
            entityvillager.b(new MerchantRecipeList(this.ce));
        }
        entityvillager.u(this.cf);
        entityvillager.a(worldserver, worldserver.d_(entityvillager.di()), EnumMobSpawn.i, null, null);
        entityvillager.c(worldserver);
        if (this.cc != null && (entityhuman = worldserver.b(this.cc)) instanceof EntityPlayer) {
            CriterionTriggers.r.a((EntityPlayer)entityhuman, this, entityvillager);
            worldserver.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
        }
        entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
        if (!this.aQ()) {
            worldserver.a(null, 1027, this.di(), 0);
        }
    }

    private int gl() {
        int i2 = 1;
        if (this.af.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int k2 = (int)this.dn() - 4;
            while (k2 < (int)this.dn() + 4 && j2 < 14) {
                int l2 = (int)this.dp() - 4;
                while (l2 < (int)this.dp() + 4 && j2 < 14) {
                    int i1 = (int)this.dt() - 4;
                    while (i1 < (int)this.dt() + 4 && j2 < 14) {
                        IBlockData iblockdata = this.dI().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (iblockdata.a(Blocks.eX) || iblockdata.b() instanceof BlockBed) {
                            if (this.af.i() < 0.3f) {
                                ++i2;
                            }
                            ++j2;
                        }
                        ++i1;
                    }
                    ++l2;
                }
                ++k2;
            }
        }
        return i2;
    }

    @Override
    public float eS() {
        return this.h_() ? (this.af.i() - this.af.i()) * 0.2f + 2.0f : (this.af.i() - this.af.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect s() {
        return SoundEffects.Bg;
    }

    @Override
    public SoundEffect d(DamageSource damagesource) {
        return SoundEffects.Bk;
    }

    @Override
    public SoundEffect g_() {
        return SoundEffects.Bj;
    }

    @Override
    public SoundEffect w() {
        return SoundEffects.Bl;
    }

    @Override
    protected ItemStack fY() {
        return ItemStack.b;
    }

    public void c(NBTTagCompound nbttagcompound) {
        this.ce = nbttagcompound;
    }

    @Override
    public void a(NBTBase nbtbase) {
        this.cd = nbtbase;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        this.a(this.gj().a(VillagerType.a(worldaccess.s(this.di()))));
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gj();
        if (villagerdata1.b() != villagerdata.b()) {
            this.ce = null;
        }
        this.am.b(d, villagerdata);
    }

    @Override
    public VillagerData gj() {
        return this.am.b(d);
    }

    public int gk() {
        return this.cf;
    }

    @Override
    public void b(int i2) {
        this.cf = i2;
    }
}

