/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger bZ = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> ca = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int bV = 12;
    public static final Map<Item, Integer> bW = ImmutableMap.of((Object)Items.oJ, (Object)4, (Object)Items.tm, (Object)1, (Object)Items.tl, (Object)1, (Object)Items.uq, (Object)1);
    private static final int cb = 2;
    private static final Set<Item> cc = ImmutableSet.of((Object)Items.oJ, (Object)Items.tm, (Object)Items.tl, (Object)Items.oI, (Object)Items.oH, (Object)Items.uq, (Object[])new Item[]{Items.ur, Items.uo, Items.up});
    private static final int cd = 10;
    private static final int ce = 1200;
    private static final int cf = 24000;
    private static final int cg = 25;
    private static final int ch = 10;
    private static final int ci = 5;
    private static final long cj = 24000L;
    @VisibleForTesting
    public static final float bX = 0.5f;
    private int ck;
    private boolean cl;
    @Nullable
    private EntityHuman cm;
    private boolean cn;
    private int co;
    private final Reputation cp = new Reputation();
    private long cq;
    private long cr;
    private int cs;
    private long ct;
    private int cu;
    private long cv;
    private boolean cw;
    private static final ImmutableList<MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.K, MemoryModuleType.aO, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.G, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cy = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> bY = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gj().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, VillagerType villagertype) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        ((Navigation)this.J()).b(true);
        this.J().a(true);
        this.s(true);
        this.a(this.gj().a(villagertype).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> dK() {
        return super.dK();
    }

    protected BehaviorController.b<EntityVillager> dL() {
        return BehaviorController.a(cx, cy);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dL().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void c(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dK();
        behaviorcontroller.b(worldserver, this);
        this.bA = behaviorcontroller.i();
        this.a(this.dK());
    }

    @Override
    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        VillagerProfession villagerprofession = this.gj().b();
        if (this.h_()) {
            behaviorcontroller.a(Schedule.e);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(Schedule.f);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.dI().W(), this.dI().V());
    }

    @Override
    protected void m() {
        super.m();
        if (this.dI() instanceof WorldServer) {
            this.c((WorldServer)this.dI());
        }
    }

    public static AttributeProvider.Builder gh() {
        return EntityInsentient.y().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 48.0);
    }

    public boolean gi() {
        return this.cw;
    }

    @Override
    public void inactiveTick() {
        if (this.dI().spigotConfig.tickInactiveVillagers && this.cV()) {
            this.W();
        }
        super.inactiveTick();
    }

    @Override
    protected void W() {
        Raid raid;
        this.dI().ad().a("villagerBrain");
        this.dK().a((WorldServer)this.dI(), this);
        this.dI().ad().c();
        if (this.cw) {
            this.cw = false;
        }
        if (!this.fZ() && this.ck > 0) {
            --this.ck;
            if (this.ck <= 0) {
                if (this.cl) {
                    this.gF();
                    this.cl = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cm != null && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(ReputationEvent.e, (Entity)this.cm, this);
            this.dI().a((Entity)this, (byte)14);
            this.cm = null;
        }
        if (!this.fQ() && this.af.a(100) == 0 && (raid = ((WorldServer)this.dI()).c(this.di())) != null && raid.v() && !raid.a()) {
            this.dI().a((Entity)this, (byte)42);
        }
        if (this.gj().b() == VillagerProfession.b && this.fZ()) {
            this.ge();
        }
        super.W();
    }

    @Override
    public void l() {
        super.l();
        if (this.q() > 0) {
            this.s(this.q() - 1);
        }
        this.gH();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.sR) && this.bs() && !this.fZ() && !this.fy()) {
            if (this.h_()) {
                this.gu();
                return EnumInteractionResult.a(this.dI().B);
            }
            boolean flag = this.ga().isEmpty();
            if (enumhand == EnumHand.a) {
                if (flag && !this.dI().B) {
                    this.gu();
                }
                entityhuman.a(StatisticList.S);
            }
            if (flag) {
                return EnumInteractionResult.a(this.dI().B);
            }
            if (!this.dI().B && !this.bU.isEmpty()) {
                this.h(entityhuman);
            }
            return EnumInteractionResult.a(this.dI().B);
        }
        return super.b(entityhuman, enumhand);
    }

    public void gu() {
        this.s(40);
        if (!this.dI().r_()) {
            this.a(SoundEffects.yF, this.eR(), this.eS());
        }
    }

    private void h(EntityHuman entityhuman) {
        this.i(entityhuman);
        this.f(entityhuman);
        this.a(entityhuman, this.H_(), this.gj().c());
    }

    @Override
    public void f(@Nullable EntityHuman entityhuman) {
        boolean flag = this.fY() != null && entityhuman == null;
        super.f(entityhuman);
        if (flag) {
            this.ge();
        }
    }

    @Override
    protected void ge() {
        super.ge();
        this.gv();
    }

    private void gv() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            merchantrecipe.l();
        }
    }

    @Override
    public boolean gk() {
        return true;
    }

    @Override
    public boolean gg() {
        return this.dI().B;
    }

    public void gl() {
        this.gA();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.h();
        }
        this.gw();
        this.ct = this.dI().V();
        ++this.cu;
    }

    private void gw() {
        MerchantRecipeList merchantrecipelist = this.ga();
        EntityHuman entityhuman = this.fY();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.bR.j, merchantrecipelist, this.gj().c(), this.r(), this.gb(), this.gk());
        }
    }

    private boolean gx() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.ga().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).r());
        return true;
    }

    private boolean gy() {
        return this.cu == 0 || this.cu < 2 && this.dI().V() > this.ct + 2400L;
    }

    public boolean gm() {
        long i2 = this.ct + 12000L;
        long j2 = this.dI().V();
        boolean flag = j2 > i2;
        long k2 = this.dI().W();
        if (this.cv > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cv / 24000L;
            flag |= i1 > l2;
        }
        this.cv = k2;
        if (flag) {
            this.ct = j2;
            this.gI();
        }
        return this.gy() && this.gx();
    }

    private void gz() {
        int i2 = 2 - this.cu;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.h();
            }
        }
        int j2 = 0;
        while (j2 < i2) {
            this.gA();
            ++j2;
        }
        this.gw();
    }

    private void gA() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
            merchantrecipe.e();
        }
    }

    private void i(EntityHuman entityhuman) {
        int i2 = this.g(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.ga()) {
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.n()));
            }
        }
        if (entityhuman.a(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.b(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.ga()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().L());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(ca, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gj());
        Logger logger = bZ;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("VillagerData", (NBTBase)nbtbase));
        nbttagcompound.a("FoodLevel", (byte)this.co);
        nbttagcompound.a("Gossips", this.cp.a(DynamicOpsNBT.a));
        nbttagcompound.a("Xp", this.cs);
        nbttagcompound.a("LastRestock", this.ct);
        nbttagcompound.a("LastGossipDecay", this.cr);
        nbttagcompound.a("RestocksToday", this.cu);
        if (this.cw) {
            nbttagcompound.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("VillagerData")));
            Logger logger = bZ;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbttagcompound.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbttagcompound.p("Offers"));
        }
        if (nbttagcompound.b("FoodLevel", 1)) {
            this.co = nbttagcompound.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbttagcompound.c("Gossips", 10);
        this.cp.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttaglist));
        if (nbttagcompound.b("Xp", 3)) {
            this.cs = nbttagcompound.h("Xp");
        }
        this.ct = nbttagcompound.i("LastRestock");
        this.cr = nbttagcompound.i("LastGossipDecay");
        this.s(true);
        if (this.dI() instanceof WorldServer) {
            this.c((WorldServer)this.dI());
        }
        this.cu = nbttagcompound.h("RestocksToday");
        if (nbttagcompound.e("AssignProfessionWhenSpawned")) {
            this.cw = nbttagcompound.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect s() {
        return this.fy() ? null : (this.fZ() ? SoundEffects.yG : SoundEffects.yB);
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.yE;
    }

    @Override
    protected SoundEffect g_() {
        return SoundEffects.yD;
    }

    public void gn() {
        SoundEffect soundeffect = this.gj().b().f();
        if (soundeffect != null) {
            this.a(soundeffect, this.eR(), this.eS());
        }
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gj();
        if (villagerdata1.b() != villagerdata.b()) {
            this.bU = null;
        }
        this.am.b(ca, villagerdata);
    }

    @Override
    public VillagerData gj() {
        return this.am.b(ca);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.af.a(4);
        this.cs += merchantrecipe.o();
        this.cm = this.fY();
        if (this.gE()) {
            this.ck = 40;
            this.cl = true;
            i2 += 5;
        }
        if (merchantrecipe.s()) {
            this.dI().b(new EntityExperienceOrb(this.dI(), this.dn(), this.dp() + 0.5, this.dt(), i2));
        }
    }

    public void x(boolean flag) {
        this.cn = flag;
    }

    public boolean go() {
        return this.cn;
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.dI() instanceof WorldServer) {
            ((WorldServer)this.dI()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.bs() && entityliving instanceof EntityHuman) {
                this.dI().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            bZ.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.a(entity);
        }
        this.gB();
        super.a(damagesource);
    }

    public void gB() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    @Override
    private void a(Entity entity) {
        World world = this.dI();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bA.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.dI() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dI()).n();
            this.bA.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.w();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = bY.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean P_() {
        return this.co + this.gG() >= 12 && !this.fy() && this.h() == 0;
    }

    private boolean gC() {
        return this.co < 12;
    }

    private void gD() {
        if (this.gC() && this.gG() != 0) {
            int i2 = 0;
            while (i2 < this.w().b()) {
                Integer integer;
                ItemStack itemstack = this.w().a(i2);
                if (!itemstack.b() && (integer = bW.get(itemstack.d())) != null) {
                    int j2;
                    int k2 = j2 = itemstack.L();
                    while (k2 > 0) {
                        this.co += integer.intValue();
                        this.w().a(i2, 1);
                        if (!this.gC()) {
                            return;
                        }
                        --k2;
                    }
                }
                ++i2;
            }
        }
    }

    public int g(EntityHuman entityhuman) {
        return this.cp.a(entityhuman.ct(), (ReputationType reputationtype) -> true);
    }

    private void v(int i2) {
        this.co -= i2;
    }

    public void gp() {
        this.gD();
        this.v(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.bU = merchantrecipelist;
    }

    private boolean gE() {
        int i2 = this.gj().c();
        return VillagerData.d(i2) && this.cs >= VillagerData.c(i2);
    }

    public void gF() {
        this.a(this.gj().a(this.gj().c() + 1));
        this.gf();
    }

    @Override
    protected IChatBaseComponent cl() {
        String s2 = this.ae().g();
        return IChatBaseComponent.c(String.valueOf(s2) + "." + BuiltInRegistries.A.b(this.gj().b()).a());
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.M);
        } else if (b0 == 13) {
            this.a(Particles.b);
        } else if (b0 == 14) {
            this.a(Particles.K);
        } else if (b0 == 42) {
            this.a(Particles.ag);
        } else {
            super.b(b0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        if (enummobspawn == EnumMobSpawn.e) {
            this.a(this.gj().a(VillagerProfession.b));
        }
        if (enummobspawn == EnumMobSpawn.n || enummobspawn == EnumMobSpawn.m || enummobspawn == EnumMobSpawn.c || enummobspawn == EnumMobSpawn.o) {
            this.a(this.gj().a(VillagerType.a(worldaccess.s(this.di()))));
        }
        if (enummobspawn == EnumMobSpawn.d) {
            this.cw = true;
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    @Nullable
    public EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.af.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(worldserver.s(this.di())) : (d0 < 0.75 ? this.gj().a() : ((EntityVillager)entityageable).gj().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bf, worldserver, villagertype);
        entityvillager.a(worldserver, worldserver.d_(entityvillager.di()), EnumMobSpawn.e, null, null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.ai() != EnumDifficulty.a) {
            bZ.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = EntityTypes.bj.a(worldserver);
            if (entitywitch != null) {
                entitywitch.b(this.dn(), this.dp(), this.dt(), this.dy(), this.dA());
                entitywitch.a(worldserver, worldserver.d_(entitywitch.di()), EnumMobSpawn.i, null, null);
                entitywitch.t(this.fQ());
                if (this.aa()) {
                    entitywitch.b(this.ab());
                    entitywitch.n(this.cy());
                }
                entitywitch.fF();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                    return;
                }
                worldserver.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.gB();
                this.ai();
            } else {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void b(EntityItem entityitem) {
        InventoryCarrier.a(this, this, entityitem);
    }

    @Override
    public boolean k(ItemStack itemstack) {
        Item item = itemstack.d();
        return (cc.contains(item) || this.gj().b().d().contains((Object)item)) && this.w().b(itemstack);
    }

    public boolean gq() {
        return this.gG() >= 24;
    }

    public boolean gr() {
        return this.gG() < 12;
    }

    private int gG() {
        InventorySubcontainer inventorysubcontainer = this.w();
        return bW.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gs() {
        return this.w().a_((ItemStack itemstack) -> itemstack.a(TagsItem.aU));
    }

    @Override
    protected void gf() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        VillagerData villagerdata = this.gj();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.ga();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cq && i2 < this.cq + 1200L || i2 >= entityvillager.cq && i2 < entityvillager.cq + 1200L)) {
            this.cp.a(entityvillager.cp, this.af, 10);
            this.cq = i2;
            entityvillager.cq = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void gH() {
        long i2 = this.dI().V();
        if (this.cr == 0L) {
            this.cr = i2;
        } else if (i2 >= this.cr + 24000L) {
            this.cp.b();
            this.cr = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.cE().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).collect(Collectors.toList())).size() >= j2 && SpawnUtil.trySpawnMob(EntityTypes.ac, EnumMobSpawn.f, worldserver, this.di(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isPresent()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.dI().V()) ? false : !this.bA.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        if (reputationevent == ReputationEvent.a) {
            this.cp.a(entity.ct(), ReputationType.d, 20);
            this.cp.a(entity.ct(), ReputationType.c, 25);
        } else if (reputationevent == ReputationEvent.e) {
            this.cp.a(entity.ct(), ReputationType.e, 2);
        } else if (reputationevent == ReputationEvent.c) {
            this.cp.a(entity.ct(), ReputationType.b, 25);
        } else if (reputationevent == ReputationEvent.d) {
            this.cp.a(entity.ct(), ReputationType.a, 25);
        }
    }

    @Override
    public int r() {
        return this.cs;
    }

    public void u(int i2) {
        this.cs = i2;
    }

    private void gI() {
        this.gz();
        this.cu = 0;
    }

    public Reputation gt() {
        return this.cp;
    }

    @Override
    public void a(NBTBase nbtbase) {
        this.cp.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbtbase));
    }

    @Override
    protected void V() {
        super.V();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.bA.a(MemoryModuleType.G, Long.valueOf(this.dI().V()));
        this.bA.b(MemoryModuleType.m);
        this.bA.b(MemoryModuleType.E);
    }

    @Override
    public void fz() {
        super.fz();
        this.bA.a(MemoryModuleType.H, Long.valueOf(this.dI().V()));
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.bA.c(MemoryModuleType.G);
        return optional.isPresent() ? i2 - optional.get() < 24000L : false;
    }
}

