/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private CraftMerchant craftMerchant;
    private static final DataWatcherObject<Integer> bV = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bT = 300;
    private static final int bW = 8;
    @Nullable
    private EntityHuman bX;
    @Nullable
    protected MerchantRecipeList bU;
    private final InventorySubcontainer bY = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return this.craftMerchant == null ? (this.craftMerchant = new CraftMerchant(this)) : this.craftMerchant;
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity, @Nullable NBTTagCompound nbttagcompound) {
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity, nbttagcompound);
    }

    public int q() {
        return this.am.b(bV);
    }

    public void s(int i2) {
        this.am.b(bV, i2);
    }

    @Override
    public int r() {
        return 0;
    }

    @Override
    protected float b(EntityPose entitypose, EntitySize entitysize) {
        return this.h_() ? 0.81f : 1.62f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.am.a(bV, 0);
    }

    @Override
    public void f(@Nullable EntityHuman entityhuman) {
        this.bX = entityhuman;
    }

    @Override
    @Nullable
    public EntityHuman fY() {
        return this.bX;
    }

    public boolean fZ() {
        return this.bX != null;
    }

    @Override
    public MerchantRecipeList ga() {
        if (this.bU == null) {
            this.bU = new MerchantRecipeList();
            this.gf();
        }
        return this.bU;
    }

    @Override
    public void a(@Nullable MerchantRecipeList merchantrecipelist) {
    }

    @Override
    public void t(int i2) {
    }

    @Override
    public void a(MerchantRecipe merchantrecipe) {
        merchantrecipe.j();
        this.bI = -this.M();
        this.b(merchantrecipe);
        if (this.bX instanceof EntityPlayer) {
            CriterionTriggers.s.a((EntityPlayer)this.bX, this, merchantrecipe.d());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gb() {
        return true;
    }

    @Override
    public void l(ItemStack itemstack) {
        if (!this.dI().B && this.bI > -this.M() + 20) {
            this.bI = -this.M();
            this.a(this.w(!itemstack.b()), this.eR(), this.eS());
        }
    }

    @Override
    public SoundEffect gc() {
        return SoundEffects.yH;
    }

    protected SoundEffect w(boolean flag) {
        return flag ? SoundEffects.yH : SoundEffects.yF;
    }

    public void gd() {
        this.a(SoundEffects.yC, this.eR(), this.eS());
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        MerchantRecipeList merchantrecipelist = this.ga();
        if (!merchantrecipelist.isEmpty()) {
            nbttagcompound.a("Offers", merchantrecipelist.a());
        }
        this.a_(nbttagcompound);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbttagcompound.p("Offers"));
        }
        this.c(nbttagcompound);
    }

    @Override
    @Nullable
    public Entity b(WorldServer worldserver) {
        this.ge();
        return super.b(worldserver);
    }

    protected void ge() {
        this.f((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damagesource) {
        super.a(damagesource);
        this.ge();
    }

    protected void a(ParticleParam particleparam) {
        int i2 = 0;
        while (i2 < 5) {
            double d0 = this.af.k() * 0.02;
            double d1 = this.af.k() * 0.02;
            double d2 = this.af.k() * 0.02;
            this.dI().a(particleparam, this.d(1.0), this.dq() + 1.0, this.g(1.0), d0, d1, d2);
            ++i2;
        }
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return false;
    }

    @Override
    public InventorySubcontainer w() {
        return this.bY;
    }

    @Override
    public SlotAccess a_(int i2) {
        int j2 = i2 - 300;
        return j2 >= 0 && j2 < this.bY.b() ? SlotAccess.a(this.bY, j2) : super.a_(i2);
    }

    protected abstract void gf();

    protected void a(MerchantRecipeList merchantrecipelist, VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption, int i2) {
        HashSet set = Sets.newHashSet();
        if (avillagertrades_imerchantrecipeoption.length > i2) {
            while (set.size() < i2) {
                set.add(this.af.a(avillagertrades_imerchantrecipeoption.length));
            }
        } else {
            int j2 = 0;
            while (j2 < avillagertrades_imerchantrecipeoption.length) {
                set.add(j2);
                ++j2;
            }
        }
        for (Integer integer : set) {
            VillagerTrades.IMerchantRecipeOption villagertrades_imerchantrecipeoption = avillagertrades_imerchantrecipeoption[integer];
            MerchantRecipe merchantrecipe = villagertrades_imerchantrecipeoption.a(this, this.af);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) continue;
            merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
        }
    }

    @Override
    public Vec3D q(float f2) {
        float f1 = MathHelper.i(f2, this.aW, this.aV) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cE().c() - 1.0, 0.2);
        return this.l(f2).e(vec3d.b(-f1));
    }

    @Override
    public boolean gg() {
        return this.dI().B;
    }
}

