/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;

public abstract class EntityFireball
extends IProjectile {
    public double b;
    public double c;
    public double d;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> entitytypes, double d0, double d1, double d2, double d3, double d4, double d5, World world) {
        this(entitytypes, world);
        this.b(d0, d1, d2, this.dy(), this.dA());
        this.an();
        this.setDirection(d3, d4, d5);
    }

    public void setDirection(double d3, double d4, double d5) {
        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
        if (d6 != 0.0) {
            this.b = d3 / d6 * 0.1;
            this.c = d4 / d6 * 0.1;
            this.d = d5 / d6 * 0.1;
        }
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> entitytypes, EntityLiving entityliving, double d0, double d1, double d2, World world) {
        this(entitytypes, entityliving.dn(), entityliving.dp(), entityliving.dt(), d0, d1, d2, world);
        this.b((Entity)entityliving);
        this.a(entityliving.dy(), entityliving.dA());
    }

    @Override
    protected void a_() {
    }

    @Override
    public boolean a(double d0) {
        double d1 = this.cE().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    @Override
    public void l() {
        Entity entity = this.v();
        if (!this.dI().B && (entity != null && entity.dD() || !this.dI().A(this.di()))) {
            this.ai();
        } else {
            MovingObjectPosition movingobjectposition;
            super.l();
            if (this.aa_()) {
                this.g(1);
            }
            if ((movingobjectposition = ProjectileHelper.a((Entity)this, this::a)).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                this.preOnHit(movingobjectposition);
                if (this.dD()) {
                    CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
                }
            }
            this.aM();
            Vec3D vec3d = this.dl();
            double d0 = this.dn() + vec3d.c;
            double d1 = this.dp() + vec3d.d;
            double d2 = this.dt() + vec3d.e;
            ProjectileHelper.a((Entity)this, 0.2f);
            float f2 = this.o();
            if (this.aV()) {
                int i2 = 0;
                while (i2 < 4) {
                    float f1 = 0.25f;
                    this.dI().a(Particles.e, d0 - vec3d.c * 0.25, d1 - vec3d.d * 0.25, d2 - vec3d.e * 0.25, vec3d.c, vec3d.d, vec3d.e);
                    ++i2;
                }
                f2 = 0.8f;
            }
            this.f(vec3d.b(this.b, this.c, this.d).a((double)f2));
            this.dI().a(this.k(), d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            this.e(d0, d1, d2);
        }
    }

    @Override
    protected boolean a(Entity entity) {
        return super.a(entity) && !entity.ae;
    }

    protected boolean aa_() {
        return true;
    }

    protected ParticleParam k() {
        return Particles.Z;
    }

    protected float o() {
        return 0.95f;
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("power", this.a(new double[]{this.b, this.c, this.d}));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist;
        super.a(nbttagcompound);
        if (nbttagcompound.b("power", 9) && (nbttaglist = nbttagcompound.c("power", 6)).size() == 3) {
            this.b = nbttaglist.h(0);
            this.c = nbttaglist.h(1);
            this.d = nbttaglist.h(2);
        }
    }

    @Override
    public boolean bo() {
        return true;
    }

    @Override
    public float bC() {
        return 1.0f;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        this.bl();
        Entity entity = damagesource.d();
        if (entity != null) {
            if (!this.dI().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2, false)) {
                    return false;
                }
                Vec3D vec3d = entity.bD();
                this.f(vec3d);
                this.b = vec3d.c * 0.1;
                this.c = vec3d.d * 0.1;
                this.d = vec3d.e * 0.1;
                this.b(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public float bj() {
        return 1.0f;
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        Entity entity = this.v();
        int i2 = entity == null ? 0 : entity.af();
        return new PacketPlayOutSpawnEntity(this.af(), this.ct(), this.dn(), this.dp(), this.dt(), this.dA(), this.dy(), this.ae(), i2, new Vec3D(this.b, this.c, this.d), 0.0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        double d0 = packetplayoutspawnentity.h();
        double d1 = packetplayoutspawnentity.i();
        double d2 = packetplayoutspawnentity.j();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.b = d0 / d3 * 0.1;
            this.c = d1 / d3 * 0.1;
            this.d = d2 / d3 * 0.1;
        }
    }
}

