/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double b = 4.0;
    private static final double d = 16.0;
    public static final Predicate<EntityLiving> c = entityliving -> entityliving.fb() || entityliving.bL();

    public EntityPotion(EntityTypes<? extends EntityPotion> entitytypes, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)entitytypes, world);
    }

    public EntityPotion(World world, EntityLiving entityliving) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aA, entityliving, world);
    }

    public EntityPotion(World world, double d0, double d1, double d2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.aA, d0, d1, d2, world);
    }

    @Override
    protected Item k() {
        return Items.uu;
    }

    @Override
    protected float p() {
        return 0.05f;
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        if (!this.dI().B) {
            ItemStack itemstack = this.j();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean flag = potionregistry == Potions.c && list.isEmpty();
            EnumDirection enumdirection = movingobjectpositionblock.b();
            BlockPosition blockposition = movingobjectpositionblock.a();
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (flag) {
                this.a(blockposition1);
                this.a(blockposition1.a(enumdirection.g()));
                for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                    this.a(blockposition1.a(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition movingobjectposition) {
        super.a(movingobjectposition);
        if (!this.dI().B) {
            boolean flag;
            ItemStack itemstack = this.j();
            PotionRegistry potionregistry = PotionUtil.d(itemstack);
            List<MobEffect> list = PotionUtil.a(itemstack);
            boolean bl = flag = potionregistry == Potions.c && list.isEmpty();
            if (flag) {
                this.q();
            } else if (this.r()) {
                this.a(itemstack, potionregistry);
            } else {
                this.a(list, movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.c ? ((MovingObjectPositionEntity)movingobjectposition).a() : null);
            }
            int i2 = potionregistry.b() ? 2007 : 2002;
            this.dI().c(i2, this.di(), PotionUtil.c(itemstack));
            this.ai();
        }
    }

    private void q() {
        AxisAlignedBB axisalignedbb = this.cE().c(4.0, 2.0, 4.0);
        List<EntityLiving> list = this.dI().a(EntityLiving.class, axisalignedbb, c);
        for (EntityLiving entityliving : list) {
            double d0 = this.f(entityliving);
            if (!(d0 < 16.0)) continue;
            if (entityliving.fb()) {
                entityliving.a(this.dJ().c(this, this.v()), 1.0f);
            }
            if (!entityliving.bL() || !entityliving.bs()) continue;
            entityliving.aB();
        }
        List<Axolotl> list1 = this.dI().a(Axolotl.class, axisalignedbb);
        for (Axolotl axolotl : list1) {
            axolotl.q();
        }
    }

    private void a(List<MobEffect> list, @Nullable Entity entity) {
        PotionSplashEvent event;
        double d1;
        AxisAlignedBB axisalignedbb = this.cE().c(4.0, 2.0, 4.0);
        List<EntityLiving> list1 = this.dI().a(EntityLiving.class, axisalignedbb);
        HashMap<LivingEntity, Double> affected = new HashMap<LivingEntity, Double>();
        if (!list1.isEmpty()) {
            Entity entity1 = this.A();
            for (EntityLiving entityliving : list1) {
                double d0;
                if (!entityliving.ft() || !((d0 = this.f(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.A();
            for (LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                EntityLiving entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffect mobeffect : list) {
                    int i2;
                    MobEffectList mobeffectlist = mobeffect.c();
                    if (!this.dI().pvpMode && this.v() instanceof EntityPlayer && entityliving instanceof EntityPlayer && entityliving != this.v() && ((i2 = MobEffectList.a(mobeffectlist)) == 2 || i2 == 4 || i2 == 7 || i2 == 15 || i2 == 17 || i2 == 18 || i2 == 19)) continue;
                    if (mobeffectlist.a()) {
                        mobeffectlist.a(this, this.v(), entityliving, mobeffect.e(), d1);
                        continue;
                    }
                    i2 = mobeffect.a(j2 -> (int)(d1 * (double)j2 + 0.5));
                    MobEffect mobeffect1 = new MobEffect(mobeffectlist, i2, mobeffect.e(), mobeffect.f(), mobeffect.g());
                    if (mobeffect1.a(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void a(ItemStack itemstack, PotionRegistry potionregistry) {
        LingeringPotionSplashEvent event;
        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dI(), this.dn(), this.dp(), this.dt());
        Entity entity = this.v();
        if (entity instanceof EntityLiving) {
            entityareaeffectcloud.a((EntityLiving)entity);
        }
        entityareaeffectcloud.a(3.0f);
        entityareaeffectcloud.b(-0.5f);
        entityareaeffectcloud.d(10);
        entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.m());
        entityareaeffectcloud.a(potionregistry);
        for (MobEffect mobeffect : PotionUtil.b(itemstack)) {
            entityareaeffectcloud.a(new MobEffect(mobeffect));
        }
        NBTTagCompound nbttagcompound = itemstack.v();
        if (nbttagcompound != null && nbttagcompound.b("CustomPotionColor", 99)) {
            entityareaeffectcloud.a(nbttagcompound.h("CustomPotionColor"));
        }
        if (!(event = CraftEventFactory.callLingeringPotionSplashEvent(this, entityareaeffectcloud)).isCancelled() && !entityareaeffectcloud.dD()) {
            this.dI().b(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.ai();
        }
    }

    public boolean r() {
        return this.j().a(Items.ux);
    }

    private void a(BlockPosition blockposition) {
        IBlockData iblockdata = this.dI().a_(blockposition);
        if (iblockdata.a(TagsBlock.aI)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.n()).isCancelled()) {
                this.dI().a(blockposition, false);
            }
        } else if (AbstractCandleBlock.c(iblockdata)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.a(AbstractCandleBlock.b, false)).isCancelled()) {
                AbstractCandleBlock.a(null, iblockdata, (GeneratorAccess)this.dI(), blockposition);
            }
        } else if (BlockCampfire.g(iblockdata) && !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (IBlockData)iblockdata.a(BlockCampfire.b, false)).isCancelled()) {
            this.dI().a(null, 1009, blockposition, 0);
            BlockCampfire.a(this.v(), (GeneratorAccess)this.dI(), blockposition, iblockdata);
            this.dI().b(blockposition, (IBlockData)iblockdata.a(BlockCampfire.b, false));
        }
    }
}

