/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger a = LogUtils.getLogger();
    private final FeatureFlagUniverse b;
    public final Map<MinecraftKey, FeatureFlag> c;
    private final FeatureFlagSet d;

    FeatureFlagRegistry(FeatureFlagUniverse var0, FeatureFlagSet var1, Map<MinecraftKey, FeatureFlag> var2) {
        this.b = var0;
        this.c = var2;
        this.d = var1;
    }

    public boolean a(FeatureFlagSet var0) {
        return var0.a(this.d);
    }

    public FeatureFlagSet a() {
        return this.d;
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> var02) {
        return this.a(var02, (MinecraftKey var0) -> a.warn("Unknown feature flag: {}", var0));
    }

    public FeatureFlagSet a(FeatureFlag ... var0) {
        return FeatureFlagSet.a(this.b, Arrays.asList(var0));
    }

    public FeatureFlagSet a(Iterable<MinecraftKey> var0, Consumer<MinecraftKey> var1) {
        Set var2 = Sets.newIdentityHashSet();
        for (MinecraftKey var4 : var0) {
            FeatureFlag var5 = this.c.get(var4);
            if (var5 == null) {
                var1.accept(var4);
                continue;
            }
            var2.add(var5);
        }
        return FeatureFlagSet.a(this.b, var2);
    }

    public Set<MinecraftKey> b(FeatureFlagSet var0) {
        HashSet<MinecraftKey> var1 = new HashSet<MinecraftKey>();
        this.c.forEach((var2, var3) -> {
            if (var0.b((FeatureFlag)var3)) {
                var1.add((MinecraftKey)var2);
            }
        });
        return var1;
    }

    public Codec<FeatureFlagSet> b() {
        return MinecraftKey.a.listOf().comapFlatMap(var0 -> {
            HashSet var1 = new HashSet();
            FeatureFlagSet var2 = this.a((Iterable<MinecraftKey>)var0, var1::add);
            if (!var1.isEmpty()) {
                return DataResult.error(() -> "Unknown feature ids: " + var1, (Object)var2);
            }
            return DataResult.success((Object)var2);
        }, var0 -> List.copyOf(this.b((FeatureFlagSet)var0)));
    }

    public static class a {
        private final FeatureFlagUniverse a;
        private int b;
        private final Map<MinecraftKey, FeatureFlag> c = new LinkedHashMap<MinecraftKey, FeatureFlag>();

        public a(String var0) {
            this.a = new FeatureFlagUniverse(var0);
        }

        public FeatureFlag a(String var0) {
            return this.a(new MinecraftKey("minecraft", var0));
        }

        public FeatureFlag a(MinecraftKey var0) {
            FeatureFlag var1;
            FeatureFlag var2;
            if (this.b >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((var2 = this.c.put(var0, var1 = new FeatureFlag(this.a, this.b++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + var0);
            }
            return var1;
        }

        public FeatureFlagRegistry a() {
            FeatureFlagSet var0 = FeatureFlagSet.a(this.a, this.c.values());
            return new FeatureFlagRegistry(this.a, var0, Map.copyOf(this.c));
        }
    }
}

