/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger k = LogUtils.getLogger();
    public static final int a = -999;
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 0;
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = Integer.MAX_VALUE;
    public NonNullList<net.minecraft.world.item.ItemStack> l = NonNullList.a();
    public NonNullList<Slot> i = NonNullList.a();
    private final List<ContainerProperty> m = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack n = net.minecraft.world.item.ItemStack.b;
    public NonNullList<net.minecraft.world.item.ItemStack> o = NonNullList.a();
    private final IntList p = new IntArrayList();
    private net.minecraft.world.item.ItemStack q = net.minecraft.world.item.ItemStack.b;
    private int r;
    @Nullable
    private final Containers<?> s;
    public final int j;
    private int t = -1;
    private int u;
    private final Set<Slot> v = Sets.newHashSet();
    private final List<ICrafting> w = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer x;
    private boolean y;
    public boolean checkReachable = true;
    private IChatBaseComponent title;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title not set");
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    protected Container(@Nullable Containers<?> containers, int i2) {
        this.s = containers;
        this.j = i2;
    }

    protected static boolean a(ContainerAccess containeraccess, EntityHuman entityhuman, Block block) {
        return containeraccess.a((World world, BlockPosition blockposition) -> !world.a_((BlockPosition)blockposition).a(block) ? false : entityhuman.i((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) <= 64.0, true);
    }

    public Containers<?> a() {
        if (this.s == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.s;
    }

    protected static void a(IInventory iinventory, int i2) {
        int j2 = iinventory.b();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container size " + j2 + " is smaller than expected " + i2);
        }
    }

    protected static void a(IContainerProperties icontainerproperties, int i2) {
        int j2 = icontainerproperties.a();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container data count " + j2 + " is smaller than expected " + i2);
        }
    }

    public boolean a(int i2) {
        return i2 == -1 || i2 == -999 || i2 < this.i.size();
    }

    protected Slot a(Slot slot) {
        slot.e = this.i.size();
        this.i.add(slot);
        this.l.add(net.minecraft.world.item.ItemStack.b);
        this.o.add(net.minecraft.world.item.ItemStack.b);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty containerproperty) {
        this.m.add(containerproperty);
        this.p.add(0);
        return containerproperty;
    }

    protected void a(IContainerProperties icontainerproperties) {
        int i2 = 0;
        while (i2 < icontainerproperties.a()) {
            this.a(ContainerProperty.a(icontainerproperties, i2));
            ++i2;
        }
    }

    public void a(ICrafting icrafting) {
        if (!this.w.contains(icrafting)) {
            this.w.add(icrafting);
            this.d();
        }
    }

    public void a(ContainerSynchronizer containersynchronizer) {
        this.x = containersynchronizer;
        this.b();
    }

    public void b() {
        int i2 = 0;
        int j2 = this.i.size();
        while (i2 < j2) {
            this.o.set(i2, this.i.get(i2).e().p());
            ++i2;
        }
        this.q = this.g().p();
        i2 = 0;
        j2 = this.m.size();
        while (i2 < j2) {
            this.p.set(i2, this.m.get(i2).b());
            ++i2;
        }
        if (this.x != null) {
            this.x.a(this, this.o, this.q, this.p.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        this.q = this.g().p();
        if (this.x != null) {
            this.x.a(this, this.q);
        }
    }

    public void b(ICrafting icrafting) {
        this.w.remove(icrafting);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.a();
        for (Slot slot : this.i) {
            nonnulllist.add(slot.e());
        }
        return nonnulllist;
    }

    public void d() {
        int i2 = 0;
        while (i2 < this.i.size()) {
            net.minecraft.world.item.ItemStack itemstack = this.i.get(i2).e();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::p);
            this.a(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.b(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            ++i2;
        }
        this.l();
        i2 = 0;
        while (i2 < this.m.size()) {
            ContainerProperty containerproperty = this.m.get(i2);
            int j2 = containerproperty.b();
            if (containerproperty.c()) {
                this.c(i2, j2);
            }
            this.d(i2, j2);
            ++i2;
        }
    }

    public void e() {
        int i2 = 0;
        while (i2 < this.i.size()) {
            net.minecraft.world.item.ItemStack itemstack = this.i.get(i2).e();
            Objects.requireNonNull(itemstack);
            this.a(i2, itemstack, itemstack::p);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m.size()) {
            ContainerProperty containerproperty = this.m.get(i2);
            if (containerproperty.c()) {
                this.c(i2, containerproperty.b());
            }
            ++i2;
        }
        this.b();
    }

    private void c(int i2, int j2) {
        for (ICrafting icrafting : this.w) {
            icrafting.a(this, i2, j2);
        }
    }

    private void a(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(i2);
        if (!net.minecraft.world.item.ItemStack.a(itemstack1, itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.l.set(i2, itemstack2);
            for (ICrafting icrafting : this.w) {
                icrafting.a(this, i2, itemstack2);
            }
        }
    }

    private void b(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1;
        if (!this.y && !net.minecraft.world.item.ItemStack.a(itemstack1 = this.o.get(i2), itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.o.set(i2, itemstack2);
            if (this.x != null) {
                this.x.a(this, i2, itemstack2);
            }
        }
    }

    private void d(int i2, int j2) {
        int k2;
        if (!this.y && (k2 = this.p.getInt(i2)) != j2) {
            this.p.set(i2, j2);
            if (this.x != null) {
                this.x.a(this, i2, j2);
            }
        }
    }

    private void l() {
        if (!this.y && !net.minecraft.world.item.ItemStack.a(this.g(), this.q)) {
            this.q = this.g().p();
            if (this.x != null) {
                this.x.a(this, this.q);
            }
        }
    }

    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.o.set(i2, itemstack.p());
    }

    public void b(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 >= 0 && i2 < this.o.size()) {
            this.o.set(i2, itemstack);
        } else {
            k.debug("Incorrect slot index: {} available slots: {}", (Object)i2, (Object)this.o.size());
        }
    }

    public void a(net.minecraft.world.item.ItemStack itemstack) {
        this.q = itemstack.p();
    }

    public boolean b(EntityHuman entityhuman, int i2) {
        return false;
    }

    public Slot b(int i2) {
        return this.i.get(i2);
    }

    public abstract net.minecraft.world.item.ItemStack a(EntityHuman var1, int var2);

    public void a(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        try {
            this.b(i2, j2, inventoryclicktype, entityhuman);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Container click");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Click info");
            crashreportsystemdetails.a("Menu Type", () -> this.s != null ? BuiltInRegistries.s.b(this.s).toString() : "<no type>");
            crashreportsystemdetails.a("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.a("Slot Count", this.i.size());
            crashreportsystemdetails.a("Slot", i2);
            crashreportsystemdetails.a("Button", j2);
            crashreportsystemdetails.a("Type", (Object)inventoryclicktype);
            throw new ReportedException(crashreport);
        }
    }

    private void b(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        block45: {
            block57: {
                block53: {
                    net.minecraft.world.item.ItemStack itemstack;
                    net.minecraft.world.item.ItemStack itemstack1;
                    Slot slot2;
                    PlayerInventory playerinventory;
                    block56: {
                        block55: {
                            block54: {
                                block50: {
                                    ClickAction clickaction;
                                    block52: {
                                        block51: {
                                            block49: {
                                                block43: {
                                                    block48: {
                                                        net.minecraft.world.item.ItemStack itemstack2;
                                                        block47: {
                                                            block46: {
                                                                block44: {
                                                                    playerinventory = entityhuman.fN();
                                                                    if (inventoryclicktype != InventoryClickType.f) break block43;
                                                                    int i1 = this.u;
                                                                    this.u = Container.d(j2);
                                                                    if (i1 == 1 && this.u == 2 || i1 == this.u) break block44;
                                                                    this.f();
                                                                    break block45;
                                                                }
                                                                if (!this.g().b()) break block46;
                                                                this.f();
                                                                break block45;
                                                            }
                                                            if (this.u != 0) break block47;
                                                            this.t = Container.c(j2);
                                                            if (Container.a(this.t, entityhuman)) {
                                                                this.u = 1;
                                                                this.v.clear();
                                                            } else {
                                                                this.f();
                                                            }
                                                            break block45;
                                                        }
                                                        if (this.u != 1) break block48;
                                                        Slot slot = this.i.get(i2);
                                                        if (!Container.a(slot, itemstack2 = this.g(), true) || !slot.a(itemstack2) || this.t != 2 && itemstack2.L() <= this.v.size() || !this.b(slot)) break block45;
                                                        this.v.add(slot);
                                                        break block45;
                                                    }
                                                    if (this.u == 2) {
                                                        if (!this.v.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack12 = this.g().p();
                                                            if (itemstack12.b()) {
                                                                this.f();
                                                                return;
                                                            }
                                                            int l2 = this.g().L();
                                                            Iterator<Slot> iterator = this.v.iterator();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            while (iterator.hasNext()) {
                                                                Slot slot1 = iterator.next();
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.g();
                                                                if (slot1 == null || !Container.a(slot1, itemstack2, true) || !slot1.a(itemstack2) || this.t != 2 && itemstack2.L() < this.v.size() || !this.b(slot1)) continue;
                                                                int j1 = slot1.f() ? slot1.e().L() : 0;
                                                                int k1 = Math.min(itemstack12.g(), slot1.a_(itemstack12));
                                                                int l1 = Math.min(Container.a(this.v, this.t, itemstack12) + j1, k1);
                                                                l2 -= l1 - j1;
                                                                draggedSlots.put(slot1.e, itemstack12.c(l1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack12);
                                                            newcursor.setAmount(l2);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.g();
                                                            this.b(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.t == 1, eventmap);
                                                            entityhuman.dI().getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.g() != null) {
                                                                    this.b(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.b(oldCursor);
                                                            }
                                                            if (needsUpdate && entityhuman instanceof EntityPlayer) {
                                                                this.b();
                                                            }
                                                        }
                                                        this.f();
                                                    } else {
                                                        this.f();
                                                    }
                                                    break block45;
                                                }
                                                if (this.u == 0) break block49;
                                                this.f();
                                                break block45;
                                            }
                                            if (inventoryclicktype != InventoryClickType.a && inventoryclicktype != InventoryClickType.b || j2 != 0 && j2 != 1) break block50;
                                            ClickAction clickAction = clickaction = j2 == 0 ? ClickAction.a : ClickAction.b;
                                            if (i2 != -999) break block51;
                                            if (this.g().b()) break block45;
                                            if (clickaction == ClickAction.a) {
                                                net.minecraft.world.item.ItemStack carried = this.g();
                                                this.b(net.minecraft.world.item.ItemStack.b);
                                                entityhuman.a(carried, true);
                                            } else {
                                                entityhuman.a(this.g().a(1), true);
                                            }
                                            break block45;
                                        }
                                        if (inventoryclicktype != InventoryClickType.b) break block52;
                                        if (i2 < 0) {
                                            return;
                                        }
                                        Slot slot = this.i.get(i2);
                                        if (!slot.a(entityhuman)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.a(entityhuman, i2);
                                        while (!itemstack3.b() && net.minecraft.world.item.ItemStack.b(slot.e(), itemstack3)) {
                                            itemstack3 = this.a(entityhuman, i2);
                                        }
                                        break block45;
                                    }
                                    if (i2 < 0) {
                                        return;
                                    }
                                    Slot slot = this.i.get(i2);
                                    net.minecraft.world.item.ItemStack itemstack5 = slot.e();
                                    net.minecraft.world.item.ItemStack itemstack3 = this.g();
                                    entityhuman.a(itemstack3, slot.e(), clickaction);
                                    if (!this.a(entityhuman, clickaction, slot, itemstack5, itemstack3)) {
                                        if (itemstack5.b()) {
                                            if (!itemstack3.b()) {
                                                int i22 = clickaction == ClickAction.a ? itemstack3.L() : 1;
                                                this.b(slot.b(itemstack3, i22));
                                            }
                                        } else if (slot.a(entityhuman)) {
                                            if (itemstack3.b()) {
                                                int i23 = clickaction == ClickAction.a ? itemstack5.L() : (itemstack5.L() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot.a(i23, Integer.MAX_VALUE, entityhuman);
                                                optional.ifPresent(itemstack4 -> {
                                                    this.b((net.minecraft.world.item.ItemStack)itemstack4);
                                                    slot.a(entityhuman, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            } else if (slot.a(itemstack3)) {
                                                if (net.minecraft.world.item.ItemStack.c(itemstack5, itemstack3)) {
                                                    int i24 = clickaction == ClickAction.a ? itemstack3.L() : 1;
                                                    this.b(slot.b(itemstack3, i24));
                                                } else if (itemstack3.L() <= slot.a_(itemstack3)) {
                                                    this.b(itemstack5);
                                                    slot.d(itemstack3);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.c(itemstack5, itemstack3)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot.a(itemstack5.L(), itemstack3.g() - itemstack3.L(), entityhuman);
                                                optional1.ifPresent(itemstack4 -> {
                                                    itemstack3.g(itemstack4.L());
                                                    slot.a(entityhuman, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            }
                                        }
                                    }
                                    slot.d();
                                    if (!(entityhuman instanceof EntityPlayer) || slot.a() == 64) break block45;
                                    ((EntityPlayer)entityhuman).c.a(new PacketPlayOutSetSlot(this.j, this.k(), slot.e, slot.e()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((EntityPlayer)entityhuman).c.a(new PacketPlayOutSetSlot(this.j, this.k(), 0, this.b(0).e()));
                                    }
                                    break block45;
                                }
                                if (inventoryclicktype != InventoryClickType.c) break block53;
                                slot2 = this.i.get(i2);
                                itemstack1 = playerinventory.a(j2);
                                itemstack = slot2.e();
                                if (itemstack1.b() && itemstack.b()) break block45;
                                if (!itemstack1.b()) break block54;
                                if (!slot2.a(entityhuman)) break block45;
                                playerinventory.a(j2, itemstack);
                                slot2.b(itemstack.L());
                                slot2.d(net.minecraft.world.item.ItemStack.b);
                                slot2.a(entityhuman, itemstack);
                                break block45;
                            }
                            if (!itemstack.b()) break block55;
                            if (!slot2.a(itemstack1)) break block45;
                            int j22 = slot2.a_(itemstack1);
                            if (itemstack1.L() > j22) {
                                slot2.d(itemstack1.a(j22));
                            } else {
                                playerinventory.a(j2, net.minecraft.world.item.ItemStack.b);
                                slot2.d(itemstack1);
                            }
                            break block45;
                        }
                        if (!slot2.a(entityhuman) || !slot2.a(itemstack1)) break block45;
                        int j23 = slot2.a_(itemstack1);
                        if (itemstack1.L() <= j23) break block56;
                        slot2.d(itemstack1.a(j23));
                        slot2.a(entityhuman, itemstack);
                        if (playerinventory.e(itemstack)) break block45;
                        entityhuman.a(itemstack, true);
                        break block45;
                    }
                    playerinventory.a(j2, itemstack);
                    slot2.d(itemstack1);
                    slot2.a(entityhuman, itemstack);
                    break block45;
                }
                if (inventoryclicktype != InventoryClickType.d || !entityhuman.fO().d || !this.g().b() || i2 < 0) break block57;
                Slot slot2 = this.i.get(i2);
                if (!slot2.f()) break block45;
                net.minecraft.world.item.ItemStack itemstack1 = slot2.e();
                this.b(itemstack1.c(itemstack1.g()));
                break block45;
            }
            if (inventoryclicktype == InventoryClickType.e && this.g().b() && i2 >= 0) {
                Slot slot2 = this.i.get(i2);
                int k2 = j2 == 0 ? 1 : slot2.e().L();
                net.minecraft.world.item.ItemStack itemstack = slot2.b(k2, Integer.MAX_VALUE, entityhuman);
                entityhuman.a(itemstack, true);
            } else if (inventoryclicktype == InventoryClickType.g && i2 >= 0) {
                Slot slot2 = this.i.get(i2);
                net.minecraft.world.item.ItemStack itemstack1 = this.g();
                if (!(itemstack1.b() || slot2.f() && slot2.a(entityhuman))) {
                    int l3 = j2 == 0 ? 0 : this.i.size() - 1;
                    int j24 = j2 == 0 ? 1 : -1;
                    int i25 = 0;
                    while (i25 < 2) {
                        int k2 = l3;
                        while (k2 >= 0 && k2 < this.i.size() && itemstack1.L() < itemstack1.g()) {
                            Slot slot3 = this.i.get(k2);
                            if (slot3.f() && Container.a(slot3, itemstack1, true) && slot3.a(entityhuman) && this.a(itemstack1, slot3)) {
                                net.minecraft.world.item.ItemStack itemstack42 = slot3.e();
                                if (i25 != 0 || itemstack42.L() != itemstack42.g()) {
                                    net.minecraft.world.item.ItemStack itemstack5 = slot3.b(itemstack42.L(), itemstack1.g() - itemstack1.L(), entityhuman);
                                    itemstack1.g(itemstack5.L());
                                }
                            }
                            k2 += j24;
                        }
                        ++i25;
                    }
                }
            }
        }
    }

    private boolean a(EntityHuman entityhuman, ClickAction clickaction, Slot slot, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        FeatureFlagSet featureflagset = entityhuman.dI().G();
        return itemstack1.a(featureflagset) && itemstack1.a(slot, clickaction, entityhuman) ? true : itemstack.a(featureflagset) && itemstack.a(itemstack1, slot, clickaction, entityhuman, this.m());
    }

    private SlotAccess m() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack a() {
                return Container.this.g();
            }

            @Override
            public boolean a(net.minecraft.world.item.ItemStack itemstack) {
                Container.this.b(itemstack);
                return true;
            }
        };
    }

    public boolean a(net.minecraft.world.item.ItemStack itemstack, Slot slot) {
        return true;
    }

    public void b(EntityHuman entityhuman) {
        net.minecraft.world.item.ItemStack itemstack;
        if (entityhuman instanceof EntityPlayer && !(itemstack = this.g()).b()) {
            this.b(net.minecraft.world.item.ItemStack.b);
            if (entityhuman.bs() && !((EntityPlayer)entityhuman).t()) {
                entityhuman.fN().f(itemstack);
            } else {
                entityhuman.a(itemstack, false);
            }
        }
    }

    protected void a(EntityHuman entityhuman, IInventory iinventory) {
        if (!(!entityhuman.bs() || entityhuman instanceof EntityPlayer && ((EntityPlayer)entityhuman).t())) {
            int i2 = 0;
            while (i2 < iinventory.b()) {
                PlayerInventory playerinventory = entityhuman.fN();
                if (playerinventory.m instanceof EntityPlayer) {
                    playerinventory.f(iinventory.b(i2));
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < iinventory.b()) {
                entityhuman.a(iinventory.b(i3), false);
                ++i3;
            }
        }
    }

    public void a(IInventory iinventory) {
        this.d();
    }

    public void a(int i2, int j2, net.minecraft.world.item.ItemStack itemstack) {
        this.b(i2).e(itemstack);
        this.r = j2;
    }

    public void a(int i2, List<net.minecraft.world.item.ItemStack> list, net.minecraft.world.item.ItemStack itemstack) {
        int j2 = 0;
        while (j2 < list.size()) {
            this.b(j2).e(list.get(j2));
            ++j2;
        }
        this.n = itemstack;
        this.r = i2;
    }

    public void a(int i2, int j2) {
        this.m.get(i2).a(j2);
    }

    public abstract boolean a(EntityHuman var1);

    protected boolean a(net.minecraft.world.item.ItemStack itemstack, int i2, int j2, boolean flag) {
        net.minecraft.world.item.ItemStack itemstack1;
        Slot slot;
        boolean flag1 = false;
        int k2 = i2;
        if (flag) {
            k2 = j2 - 1;
        }
        if (itemstack.h()) {
            while (!itemstack.b()) {
                if (!flag ? k2 >= j2 : k2 < i2) break;
                slot = this.i.get(k2);
                itemstack1 = slot.e();
                if (!itemstack1.b() && net.minecraft.world.item.ItemStack.c(itemstack, itemstack1)) {
                    int l2 = itemstack1.L() + itemstack.L();
                    if (l2 <= itemstack.g()) {
                        itemstack.f(0);
                        itemstack1.f(l2);
                        slot.d();
                        flag1 = true;
                    } else if (itemstack1.L() < itemstack.g()) {
                        itemstack.h(itemstack.g() - itemstack1.L());
                        itemstack1.f(itemstack.g());
                        slot.d();
                        flag1 = true;
                    }
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        if (!itemstack.b()) {
            k2 = flag ? j2 - 1 : i2;
            while (!(!flag ? k2 >= j2 : k2 < i2)) {
                slot = this.i.get(k2);
                itemstack1 = slot.e();
                if (itemstack1.b() && slot.a(itemstack)) {
                    if (itemstack.L() > slot.a()) {
                        slot.d(itemstack.a(slot.a()));
                    } else {
                        slot.d(itemstack.a(itemstack.L()));
                    }
                    slot.d();
                    flag1 = true;
                    break;
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        return flag1;
    }

    public static int c(int i2) {
        return i2 >> 2 & 3;
    }

    public static int d(int i2) {
        return i2 & 3;
    }

    public static int b(int i2, int j2) {
        return i2 & 3 | (j2 & 3) << 2;
    }

    public static boolean a(int i2, EntityHuman entityhuman) {
        return i2 == 0 ? true : (i2 == 1 ? true : i2 == 2 && entityhuman.fO().d);
    }

    protected void f() {
        this.u = 0;
        this.v.clear();
    }

    public static boolean a(@Nullable Slot slot, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.f();
        return !flag1 && net.minecraft.world.item.ItemStack.c(itemstack, slot.e()) ? slot.e().L() + (flag ? 0 : itemstack.L()) <= itemstack.g() : flag1;
    }

    public static int a(Set<Slot> set, int i2, net.minecraft.world.item.ItemStack itemstack) {
        return switch (i2) {
            case 0 -> MathHelper.d((float)itemstack.L() / (float)set.size());
            case 1 -> 1;
            case 2 -> itemstack.d().l();
            default -> itemstack.L();
        };
    }

    public boolean b(Slot slot) {
        return true;
    }

    public static int a(@Nullable TileEntity tileentity) {
        return tileentity instanceof IInventory ? Container.b((IInventory)((Object)tileentity)) : 0;
    }

    public static int b(@Nullable IInventory iinventory) {
        if (iinventory == null) {
            return 0;
        }
        int i2 = 0;
        float f2 = 0.0f;
        int j2 = 0;
        while (j2 < iinventory.b()) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.a(j2);
            if (!itemstack.b()) {
                f2 += (float)itemstack.L() / (float)Math.min(iinventory.ac_(), itemstack.g());
                ++i2;
            }
            ++j2;
        }
        return MathHelper.d((f2 /= (float)iinventory.b()) * 14.0f) + (i2 > 0 ? 1 : 0);
    }

    public void b(net.minecraft.world.item.ItemStack itemstack) {
        this.n = itemstack;
    }

    public net.minecraft.world.item.ItemStack g() {
        if (this.n.b()) {
            this.b(net.minecraft.world.item.ItemStack.b);
        }
        return this.n;
    }

    public void h() {
        this.y = true;
    }

    public void i() {
        this.y = false;
    }

    public void a(Container container) {
        Slot slot;
        HashBasedTable table = HashBasedTable.create();
        int i2 = 0;
        while (i2 < container.i.size()) {
            slot = container.i.get(i2);
            table.put((Object)slot.d, (Object)slot.g(), (Object)i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.i.size()) {
            slot = this.i.get(i2);
            Integer integer = (Integer)table.get((Object)slot.d, (Object)slot.g());
            if (integer != null) {
                this.l.set(i2, container.l.get(integer));
                this.o.set(i2, container.o.get(integer));
            }
            ++i2;
        }
    }

    public OptionalInt b(IInventory iinventory, int i2) {
        int j2 = 0;
        while (j2 < this.i.size()) {
            Slot slot = this.i.get(j2);
            if (slot.d == iinventory && i2 == slot.g()) {
                return OptionalInt.of(j2);
            }
            ++j2;
        }
        return OptionalInt.empty();
    }

    public int j() {
        return this.r;
    }

    public int k() {
        this.r = this.r + 1 & Short.MAX_VALUE;
        return this.r;
    }
}

