/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.i.q().fieldOf("id").forGetter(ItemStack::d), (App)Codec.INT.fieldOf("Count").forGetter(ItemStack::L), (App)NBTTagCompound.a.optionalFieldOf("tag").forGetter(itemstack -> Optional.ofNullable(itemstack.v()))).apply((Applicative)instance, ItemStack::new));
    private static final Logger j = LogUtils.getLogger();
    public static final ItemStack b = new ItemStack(null);
    public static final DecimalFormat c = SystemUtils.a(new DecimalFormat("#.##"), (T decimalformat) -> decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String d = "Enchantments";
    public static final String e = "display";
    public static final String f = "Name";
    public static final String g = "Lore";
    public static final String h = "Damage";
    public static final String i = "color";
    private static final String k = "Unbreakable";
    private static final String l = "RepairCost";
    private static final String m = "CanDestroy";
    private static final String n = "CanPlaceOn";
    private static final String o = "HideFlags";
    private static final IChatBaseComponent p = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private static final int q = 0;
    private static final ChatModifier r = ChatModifier.a.a(EnumChatFormat.f).b(true);
    private int s;
    private int t;
    @Deprecated
    @Nullable
    private Item u;
    @Nullable
    private NBTTagCompound v;
    @Nullable
    private Entity w;
    @Nullable
    private AdventureModeCheck x;
    @Nullable
    private AdventureModeCheck y;

    public Optional<TooltipComponent> a() {
        return this.d().h(this);
    }

    public ItemStack(IMaterial imaterial) {
        this(imaterial, 1);
    }

    public ItemStack(Holder<Item> holder) {
        this(holder.a(), 1);
    }

    private ItemStack(IMaterial imaterial, int i2, Optional<NBTTagCompound> optional) {
        this(imaterial, i2);
        optional.ifPresent(this::c);
    }

    public ItemStack(Holder<Item> holder, int i2) {
        this(holder.a(), i2);
    }

    public ItemStack(IMaterial imaterial, int i2) {
        this.u = imaterial.k();
        this.s = i2;
        if (this.u.o()) {
            this.b(this.k());
        }
    }

    private ItemStack(@Nullable Void ovoid) {
        this.u = null;
    }

    public void convertStack(int version) {
        if (version > 0 && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            NBTTagCompound savedStack = new NBTTagCompound();
            this.b(savedStack);
            savedStack = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.m, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)savedStack), version, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            this.load(savedStack);
        }
    }

    private void load(NBTTagCompound nbttagcompound) {
        this.u = BuiltInRegistries.i.a(new MinecraftKey(nbttagcompound.l("id")));
        this.s = nbttagcompound.f("Count");
        if (nbttagcompound.b("tag", 10)) {
            this.v = nbttagcompound.p("tag").h();
            this.d().b(this.v);
        }
        if (this.d().o()) {
            this.b(this.k());
        }
    }

    private ItemStack(NBTTagCompound nbttagcompound) {
        this.load(nbttagcompound);
    }

    public static ItemStack a(NBTTagCompound nbttagcompound) {
        try {
            return new ItemStack(nbttagcompound);
        }
        catch (RuntimeException runtimeexception) {
            j.debug("Tried to load invalid item: {}", (Object)nbttagcompound, (Object)runtimeexception);
            return b;
        }
    }

    public boolean b() {
        return this == b || this.u == Items.a || this.s <= 0;
    }

    public boolean a(FeatureFlagSet featureflagset) {
        return this.b() || this.d().a(featureflagset);
    }

    public ItemStack a(int i2) {
        int j2 = Math.min(i2, this.L());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack c() {
        if (this.b()) {
            return b;
        }
        ItemStack itemstack = this.p();
        this.f(0);
        return itemstack;
    }

    public Item d() {
        return this.b() ? Items.a : this.u;
    }

    public Holder<Item> e() {
        return this.d().j();
    }

    public boolean a(TagKey<Item> tagkey) {
        return this.d().j().a(tagkey);
    }

    public boolean a(Item item) {
        return this.d() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.d().j());
    }

    public boolean a(Holder<Item> holder) {
        return this.d().j() == holder;
    }

    public Stream<TagKey<Item>> f() {
        return this.d().j().c();
    }

    /*
     * WARNING - void declaration
     */
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext, EnumHand enumhand) {
        EntityHuman entityhuman = itemactioncontext.o();
        BlockPosition blockposition = itemactioncontext.a();
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(itemactioncontext.q(), blockposition, false);
        if (entityhuman != null && !entityhuman.fO().e && !this.a(itemactioncontext.q().B_().d(Registries.e), shapedetectorblock)) {
            return EnumInteractionResult.d;
        }
        NBTTagCompound oldData = this.getTagClone();
        int oldCount = this.L();
        WorldServer world = (WorldServer)itemactioncontext.q();
        if (!(this.d() instanceof ItemBucket) && !(this.d() instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (this.d() == Items.qK) {
                world.captureTreeGeneration = true;
            }
        }
        Item item = this.d();
        EnumInteractionResult enuminteractionresult = item.a(itemactioncontext);
        NBTTagCompound newData = this.getTagClone();
        int newCount = this.L();
        this.f(oldCount);
        this.setTagClone(oldData);
        world.captureBlockStates = false;
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.d() == Items.qK;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.L() == oldCount && Objects.equals(this.v, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    world.a(blockstate.getPosition(), blockstate.getHandle(), blockstate.getFlag());
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.e;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                EnumDirection[] enumDirectionArray = EnumDirection.values();
                int blockstate = enumDirectionArray.length;
                int fertilizeEvent = 0;
                while (fertilizeEvent < blockstate) {
                    EnumDirection dir = enumDirectionArray[fertilizeEvent];
                    ((EntityPlayer)entityhuman).c.a(new PacketPlayOutBlockChange(world, placedPos.a(dir)));
                    ++fertilizeEvent;
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData blockData;
                Object bp;
                Object oldBlock;
                if (this.L() == oldCount && Objects.equals(this.v, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (Map.Entry e2 : world.capturedTileEntities.entrySet()) {
                    world.a((TileEntity)e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.b().b(block, world, newblockposition, (IBlockData)oldBlock, true);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, (IBlockData)oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.u instanceof ItemRecord) {
                    TileEntity tileentity = world.c_(blockposition);
                    if (tileentity instanceof TileEntityJukeBox) {
                        TileEntityJukeBox tileentityjukebox = (TileEntityJukeBox)tileentity;
                        ItemStack record = this.p();
                        if (!record.b()) {
                            record.f(1);
                        }
                        tileentityjukebox.b(record);
                        world.a(GameEvent.c, blockposition, GameEvent.a.a(entityhuman, world.a_(blockposition)));
                    }
                    this.h(1);
                    entityhuman.a(StatisticList.al);
                }
                if (this.u == Items.ts) {
                    TileEntity te;
                    bp = blockposition;
                    if (!world.a_(blockposition).r()) {
                        bp = !world.a_(blockposition).e() ? null : ((BlockPosition)bp).a(itemactioncontext.k());
                    }
                    if (bp != null && (te = world.c_((BlockPosition)bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, (BlockPosition)bp, (TileEntitySkull)te);
                    }
                }
                if (this.u instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        Block block;
                        TileEntity tileEntity = world.c_(ItemSign.openSign);
                        if (tileEntity instanceof TileEntitySign && (bp = (TileEntitySign)tileEntity) == (TileEntitySign)tileEntity && (block = world.a_(ItemSign.openSign).b()) instanceof BlockSign && (oldBlock = (BlockSign)block) == (BlockSign)block) {
                            void tileentitysign;
                            void blocksign;
                            blocksign.a(entityhuman, (TileEntitySign)tileentitysign, true);
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.u instanceof ItemBed && (blockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    blockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.u instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.u).e().m(null);
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData iblockdata) {
        return this.d().a(this, iblockdata);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman entityhuman, EnumHand enumhand) {
        return this.d().a(world, entityhuman, enumhand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving entityliving) {
        return this.d().a(this, world, entityliving);
    }

    public NBTTagCompound b(NBTTagCompound nbttagcompound) {
        MinecraftKey minecraftkey = BuiltInRegistries.i.b(this.d());
        nbttagcompound.a("id", minecraftkey == null ? "minecraft:air" : minecraftkey.toString());
        nbttagcompound.a("Count", (byte)this.s);
        if (this.v != null) {
            nbttagcompound.a("tag", this.v.h());
        }
        return nbttagcompound;
    }

    public int g() {
        return this.d().l();
    }

    public boolean h() {
        return this.g() > 1 && (!this.i() || !this.j());
    }

    public boolean i() {
        if (!this.b() && this.d().n() > 0) {
            NBTTagCompound nbttagcompound = this.v();
            return nbttagcompound == null || !nbttagcompound.q(k);
        }
        return false;
    }

    public boolean j() {
        return this.i() && this.k() > 0;
    }

    public int k() {
        return this.v == null ? 0 : this.v.h(h);
    }

    public void b(int i2) {
        this.w().a(h, Math.max(0, i2));
    }

    public int l() {
        return this.d().n();
    }

    public boolean a(int i2, RandomSource randomsource, @Nullable EntityPlayer entityplayer) {
        int j2;
        if (!this.i()) {
            return false;
        }
        if (i2 > 0) {
            j2 = EnchantmentManager.a(Enchantments.w, this);
            int k2 = 0;
            int l2 = 0;
            while (j2 > 0 && l2 < i2) {
                if (EnchantmentDurability.a(this, j2, randomsource)) {
                    ++k2;
                }
                ++l2;
            }
            i2 -= k2;
            if (entityplayer != null) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)entityplayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
                event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                if (i2 != event.getDamage() || event.isCancelled()) {
                    event.getPlayer().updateInventory();
                }
                if (event.isCancelled()) {
                    return false;
                }
                i2 = event.getDamage();
            }
            if (i2 <= 0) {
                return false;
            }
        }
        if (entityplayer != null && i2 != 0) {
            CriterionTriggers.t.a(entityplayer, this, this.k() + i2);
        }
        j2 = this.k() + i2;
        this.b(j2);
        return j2 >= this.l();
    }

    public <T extends EntityLiving> void a(int i2, T t0, Consumer<T> consumer) {
        if (!(t0.dI().B || t0 instanceof EntityHuman && ((EntityHuman)t0).fO().d || !this.i() || !this.a(i2, t0.ec(), t0 instanceof EntityPlayer ? (EntityPlayer)t0 : null))) {
            consumer.accept(t0);
            Item item = this.d();
            if (this.s == 1 && t0 instanceof EntityHuman) {
                CraftEventFactory.callPlayerItemBreakEvent((EntityHuman)t0, this);
            }
            this.h(1);
            if (t0 instanceof EntityHuman) {
                ((EntityHuman)t0).b(StatisticList.d.b(item));
            }
            this.b(0);
        }
    }

    public boolean m() {
        return this.d().e(this);
    }

    public int n() {
        return this.d().f(this);
    }

    public int o() {
        return this.d().g(this);
    }

    public boolean a(Slot slot, ClickAction clickaction, EntityHuman entityhuman) {
        return this.d().a(this, slot, clickaction, entityhuman);
    }

    public boolean a(ItemStack itemstack, Slot slot, ClickAction clickaction, EntityHuman entityhuman, SlotAccess slotaccess) {
        return this.d().a(this, itemstack, slot, clickaction, entityhuman, slotaccess);
    }

    public void a(EntityLiving entityliving, EntityHuman entityhuman) {
        Item item = this.d();
        if (item.a(this, entityliving, (EntityLiving)entityhuman)) {
            entityhuman.b(StatisticList.c.b(item));
        }
    }

    public void a(net.minecraft.world.level.World world, IBlockData iblockdata, BlockPosition blockposition, EntityHuman entityhuman) {
        Item item = this.d();
        if (item.a(this, world, iblockdata, blockposition, entityhuman)) {
            entityhuman.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.d().a_(iblockdata);
    }

    public EnumInteractionResult a(EntityHuman entityhuman, EntityLiving entityliving, EnumHand enumhand) {
        return this.d().a(this, entityhuman, entityliving, enumhand);
    }

    public ItemStack p() {
        if (this.b()) {
            return b;
        }
        ItemStack itemstack = new ItemStack(this.d(), this.s);
        itemstack.e(this.K());
        if (this.v != null) {
            itemstack.v = this.v.h();
        }
        return itemstack;
    }

    public ItemStack c(int i2) {
        if (this.b()) {
            return b;
        }
        ItemStack itemstack = this.p();
        itemstack.f(i2);
        return itemstack;
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack == itemstack1 ? true : (itemstack.L() != itemstack1.L() ? false : ItemStack.c(itemstack, itemstack1));
    }

    public static boolean b(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.a(itemstack1.d());
    }

    public static boolean c(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.a(itemstack1.d()) ? false : (itemstack.b() && itemstack1.b() ? true : Objects.equals(itemstack.v, itemstack1.v));
    }

    public String q() {
        return this.d().j(this);
    }

    public String toString() {
        int i2 = this.L();
        return String.valueOf(i2) + " " + this.d();
    }

    public void a(net.minecraft.world.level.World world, Entity entity, int i2, boolean flag) {
        if (this.t > 0) {
            --this.t;
        }
        if (this.d() != null) {
            this.d().a(this, world, entity, i2, flag);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman entityhuman, int i2) {
        entityhuman.a(StatisticList.b.b(this.d()), i2);
        this.d().b(this, world, entityhuman);
    }

    public int r() {
        return this.d().b(this);
    }

    public EnumAnimation s() {
        return this.d().c(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.d().a(this, world, entityliving, i2);
    }

    public boolean t() {
        return this.d().l(this);
    }

    public boolean u() {
        return !this.b() && this.v != null && !this.v.g();
    }

    @Nullable
    public NBTTagCompound v() {
        return this.v;
    }

    @Nullable
    private NBTTagCompound getTagClone() {
        return this.v == null ? null : this.v.h();
    }

    private void setTagClone(@Nullable NBTTagCompound nbtttagcompound) {
        this.c(nbtttagcompound == null ? null : nbtttagcompound.h());
    }

    public NBTTagCompound w() {
        if (this.v == null) {
            this.c(new NBTTagCompound());
        }
        return this.v;
    }

    public NBTTagCompound a(String s2) {
        if (this.v != null && this.v.b(s2, 10)) {
            return this.v.p(s2);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a(s2, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound b(String s2) {
        return this.v != null && this.v.b(s2, 10) ? this.v.p(s2) : null;
    }

    public void c(String s2) {
        if (this.v != null && this.v.e(s2)) {
            this.v.r(s2);
            if (this.v.g()) {
                this.v = null;
            }
        }
    }

    public NBTTagList x() {
        return this.v != null ? this.v.c(d, 10) : new NBTTagList();
    }

    public void c(@Nullable NBTTagCompound nbttagcompound) {
        this.v = nbttagcompound;
        if (this.d().o()) {
            this.b(this.k());
        }
        if (nbttagcompound != null) {
            this.d().b(nbttagcompound);
        }
    }

    public IChatBaseComponent y() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null && nbttagcompound.b(f, 8)) {
            try {
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(nbttagcompound.l(f));
                if (ichatmutablecomponent != null) {
                    return ichatmutablecomponent;
                }
                nbttagcompound.r(f);
            }
            catch (Exception exception) {
                nbttagcompound.r(f);
            }
        }
        return this.d().m(this);
    }

    public ItemStack a(@Nullable IChatBaseComponent ichatbasecomponent) {
        NBTTagCompound nbttagcompound = this.a(e);
        if (ichatbasecomponent != null) {
            nbttagcompound.a(f, IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
        } else {
            nbttagcompound.r(f);
        }
        return this;
    }

    public void z() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null) {
            nbttagcompound.r(f);
            if (nbttagcompound.g()) {
                this.c(e);
            }
        }
        if (this.v != null && this.v.g()) {
            this.v = null;
        }
    }

    public boolean A() {
        NBTTagCompound nbttagcompound = this.b(e);
        return nbttagcompound != null && nbttagcompound.b(f, 8);
    }

    public List<IChatBaseComponent> a(@Nullable EntityHuman entityhuman, TooltipFlag tooltipflag) {
        int j2;
        int i2;
        Integer integer;
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.h().b(this.y()).a(this.C().e);
        if (this.A()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!tooltipflag.a() && !this.A() && this.a(Items.rf) && (integer = ItemWorldMap.d(this)) != null) {
            list.add(IChatBaseComponent.b("#" + integer).a(EnumChatFormat.h));
        }
        if (ItemStack.a(i2 = this.P(), HideFlags.f)) {
            this.d().a(this, entityhuman == null ? null : entityhuman.dI(), list, tooltipflag);
        }
        if (this.u()) {
            if (ItemStack.a(i2, HideFlags.h) && entityhuman != null) {
                ArmorTrim.a(this, entityhuman.dI().B_(), list);
            }
            if (ItemStack.a(i2, HideFlags.a)) {
                ItemStack.a(list, this.x());
            }
            if (this.v.b(e, 10)) {
                NBTTagCompound nbttagcompound = this.v.p(e);
                if (ItemStack.a(i2, HideFlags.g) && nbttagcompound.b(i, 99)) {
                    if (tooltipflag.a()) {
                        list.add(IChatBaseComponent.a("item.color", new Object[]{String.format(Locale.ROOT, "#%06X", nbttagcompound.h(i))}).a(EnumChatFormat.h));
                    } else {
                        list.add(IChatBaseComponent.c("item.dyed").a(EnumChatFormat.h, EnumChatFormat.u));
                    }
                }
                if (nbttagcompound.d(g) == 9) {
                    NBTTagList nbttaglist = nbttagcompound.c(g, 8);
                    j2 = 0;
                    while (j2 < nbttaglist.size()) {
                        String s2 = nbttaglist.j(j2);
                        try {
                            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.ChatSerializer.a(s2);
                            if (ichatmutablecomponent1 != null) {
                                list.add(ChatComponentUtils.a(ichatmutablecomponent1, r));
                            }
                        }
                        catch (Exception exception) {
                            nbttagcompound.r(g);
                        }
                        ++j2;
                    }
                }
            }
        }
        if (ItemStack.a(i2, HideFlags.b)) {
            EnumItemSlot[] aenumitemslot = EnumItemSlot.values();
            int k2 = aenumitemslot.length;
            j2 = 0;
            while (j2 < k2) {
                EnumItemSlot enumitemslot = aenumitemslot[j2];
                Multimap<AttributeBase, AttributeModifier> multimap = this.a(enumitemslot);
                if (!multimap.isEmpty()) {
                    list.add(CommonComponents.a);
                    list.add(IChatBaseComponent.c("item.modifiers." + enumitemslot.d()).a(EnumChatFormat.h));
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double d0 = attributemodifier.d();
                        boolean flag = false;
                        if (entityhuman != null) {
                            if (attributemodifier.a() == Item.m) {
                                d0 += entityhuman.c(GenericAttributes.f);
                                d0 += (double)EnchantmentManager.a(this, EnumMonsterType.a);
                                flag = true;
                            } else if (attributemodifier.a() == Item.n) {
                                d0 += entityhuman.c(GenericAttributes.h);
                                flag = true;
                            }
                        }
                        double d1 = attributemodifier.c() != AttributeModifier.Operation.b && attributemodifier.c() != AttributeModifier.Operation.c ? (((AttributeBase)entry.getKey()).equals(GenericAttributes.c) ? d0 * 10.0 : d0) : d0 * 100.0;
                        if (flag) {
                            list.add(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + attributemodifier.c().a(), new Object[]{c.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())})).a(EnumChatFormat.c));
                            continue;
                        }
                        if (d0 > 0.0) {
                            list.add(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier.c().a(), new Object[]{c.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.j));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        list.add(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier.c().a(), new Object[]{c.format(d1 *= -1.0), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.m));
                    }
                }
                ++j2;
            }
        }
        if (this.u()) {
            NBTTagList nbttaglist1;
            if (ItemStack.a(i2, HideFlags.c) && this.v.q(k)) {
                list.add(IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j));
            }
            if (ItemStack.a(i2, HideFlags.d) && this.v.b(m, 9) && !(nbttaglist1 = this.v.c(m, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h));
                int k3 = 0;
                while (k3 < nbttaglist1.size()) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k3)));
                    ++k3;
                }
            }
            if (ItemStack.a(i2, HideFlags.e) && this.v.b(n, 9) && !(nbttaglist1 = this.v.c(n, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h));
                int k4 = 0;
                while (k4 < nbttaglist1.size()) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k4)));
                    ++k4;
                }
            }
        }
        if (tooltipflag.a()) {
            if (this.j()) {
                list.add(IChatBaseComponent.a("item.durability", this.l() - this.k(), this.l()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.i.b(this.d()).toString()).a(EnumChatFormat.i));
            if (this.u()) {
                list.add(IChatBaseComponent.a("item.nbt_tags", this.v.e().size()).a(EnumChatFormat.i));
            }
        }
        if (entityhuman != null && !this.d().a(entityhuman.dI().G())) {
            list.add(p);
        }
        return list;
    }

    private static boolean a(int i2, HideFlags itemstack_hideflags) {
        return (i2 & itemstack_hideflags.a()) == 0;
    }

    private int P() {
        return this.u() && this.v.b(o, 99) ? this.v.h(o) : 0;
    }

    public void a(HideFlags itemstack_hideflags) {
        NBTTagCompound nbttagcompound = this.w();
        nbttagcompound.a(o, nbttagcompound.h(o) | itemstack_hideflags.a());
    }

    public static void a(List<IChatBaseComponent> list, NBTTagList nbttaglist) {
        int i2 = 0;
        while (i2 < nbttaglist.size()) {
            NBTTagCompound nbttagcompound = nbttaglist.a(i2);
            BuiltInRegistries.g.b(EnchantmentManager.b(nbttagcompound)).ifPresent(enchantment -> list.add(enchantment.d(EnchantmentManager.a(nbttagcompound))));
            ++i2;
        }
    }

    private static Collection<IChatBaseComponent> d(String s2) {
        try {
            return (Collection)ArgumentBlock.b(BuiltInRegistries.f.p(), s2, true).map(argumentblock_a -> Lists.newArrayList((Object[])new IChatBaseComponent[]{argumentblock_a.a().b().e().a(EnumChatFormat.i)}), argumentblock_b -> argumentblock_b.a().a().map(holder -> ((Block)holder.a()).e().a(EnumChatFormat.i)).collect(Collectors.toList()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return Lists.newArrayList((Object[])new IChatBaseComponent[]{IChatBaseComponent.b("missingno").a(EnumChatFormat.i)});
        }
    }

    public boolean B() {
        return this.d().i(this);
    }

    public EnumItemRarity C() {
        return this.d().n(this);
    }

    public boolean D() {
        return !this.d().d_(this) ? false : !this.E();
    }

    public void a(Enchantment enchantment, int i2) {
        this.w();
        if (!this.v.b(d, 9)) {
            this.v.a(d, new NBTTagList());
        }
        NBTTagList nbttaglist = this.v.c(d, 10);
        nbttaglist.add(EnchantmentManager.a(EnchantmentManager.a(enchantment), (int)((byte)i2)));
    }

    public boolean E() {
        return this.v != null && this.v.b(d, 9) ? !this.v.c(d, 10).isEmpty() : false;
    }

    public void a(String s2, NBTBase nbtbase) {
        this.w().a(s2, nbtbase);
    }

    public boolean F() {
        return this.w instanceof EntityItemFrame;
    }

    public void a(@Nullable Entity entity) {
        this.w = entity;
    }

    @Nullable
    public EntityItemFrame G() {
        return this.w instanceof EntityItemFrame ? (EntityItemFrame)this.H() : null;
    }

    @Nullable
    public Entity H() {
        return !this.b() ? this.w : null;
    }

    public int I() {
        return this.u() && this.v.b(l, 3) ? this.v.h(l) : 0;
    }

    public void d(int i2) {
        if (i2 == 0) {
            this.c(l);
            return;
        }
        this.w().a(l, i2);
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot enumitemslot) {
        HashMultimap object;
        if (this.u() && this.v.b("AttributeModifiers", 9)) {
            object = HashMultimap.create();
            NBTTagList nbttaglist = this.v.c("AttributeModifiers", 10);
            int i2 = 0;
            while (i2 < nbttaglist.size()) {
                AttributeModifier attributemodifier;
                Optional<AttributeBase> optional;
                NBTTagCompound nbttagcompound = nbttaglist.a(i2);
                if ((!nbttagcompound.b("Slot", 8) || nbttagcompound.l("Slot").equals(enumitemslot.d())) && (optional = BuiltInRegistries.v.b(MinecraftKey.a(nbttagcompound.l("AttributeName")))).isPresent() && (attributemodifier = AttributeModifier.a(nbttagcompound)) != null && attributemodifier.a().getLeastSignificantBits() != 0L && attributemodifier.a().getMostSignificantBits() != 0L) {
                    ((Multimap)object).put((Object)optional.get(), (Object)attributemodifier);
                }
                ++i2;
            }
        } else {
            object = this.d().a(enumitemslot);
        }
        return object;
    }

    public void a(AttributeBase attributebase, AttributeModifier attributemodifier, @Nullable EnumItemSlot enumitemslot) {
        this.w();
        if (!this.v.b("AttributeModifiers", 9)) {
            this.v.a("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.v.c("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = attributemodifier.e();
        nbttagcompound.a("AttributeName", BuiltInRegistries.v.b(attributebase).toString());
        if (enumitemslot != null) {
            nbttagcompound.a("Slot", enumitemslot.d());
        }
        nbttaglist.add(nbttagcompound);
    }

    @Deprecated
    public void setItem(Item item) {
        this.u = item;
    }

    public IChatBaseComponent J() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.h().b(this.y());
        if (this.A()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.b()) {
            ichatmutablecomponent1.a(this.C().e).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(IRegistry<Block> iregistry, ShapeDetectorBlock shapedetectorblock) {
        if (this.y == null) {
            this.y = new AdventureModeCheck(n);
        }
        return this.y.a(this, iregistry, shapedetectorblock);
    }

    public boolean b(IRegistry<Block> iregistry, ShapeDetectorBlock shapedetectorblock) {
        if (this.x == null) {
            this.x = new AdventureModeCheck(m);
        }
        return this.x.a(this, iregistry, shapedetectorblock);
    }

    public int K() {
        return this.t;
    }

    public void e(int i2) {
        this.t = i2;
    }

    public int L() {
        return this.b() ? 0 : this.s;
    }

    public void f(int i2) {
        this.s = i2;
    }

    public void g(int i2) {
        this.f(this.L() + i2);
    }

    public void h(int i2) {
        this.g(-i2);
    }

    public void b(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.d().a(world, entityliving, this, i2);
    }

    public void a(EntityItem entityitem) {
        this.d().a(entityitem);
    }

    public boolean M() {
        return this.d().u();
    }

    public SoundEffect N() {
        return this.d().af_();
    }

    public SoundEffect O() {
        return this.d().ag_();
    }

    public static enum HideFlags {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h;

        private final int i = 1 << this.ordinal();

        public int a() {
            return this.i;
        }
    }
}

