/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack a = new RecipeItemStack(Stream.empty());
    private final Provider[] b;
    @Nullable
    public ItemStack[] c;
    @Nullable
    private IntList d;
    public boolean exact;

    public RecipeItemStack(Stream<? extends Provider> stream) {
        this.b = (Provider[])stream.toArray(Provider[]::new);
    }

    public ItemStack[] a() {
        if (this.c == null) {
            this.c = (ItemStack[])Arrays.stream(this.b).flatMap(recipeitemstack_provider -> recipeitemstack_provider.a().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.c;
    }

    public boolean a(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.d()) {
            return itemstack.b();
        }
        ItemStack[] aitemstack = this.a();
        int i2 = aitemstack.length;
        int j2 = 0;
        while (j2 < i2) {
            ItemStack itemstack1 = aitemstack[j2];
            if (this.exact ? itemstack1.d() == itemstack.d() && ItemStack.c(itemstack, itemstack1) : itemstack1.a(itemstack.d())) {
                return true;
            }
            ++j2;
        }
        return false;
    }

    public IntList b() {
        if (this.d == null) {
            ItemStack[] aitemstack = this.a();
            this.d = new IntArrayList(aitemstack.length);
            ItemStack[] aitemstack1 = aitemstack;
            int i2 = aitemstack.length;
            int j2 = 0;
            while (j2 < i2) {
                ItemStack itemstack = aitemstack1[j2];
                this.d.add(AutoRecipeStackManager.c(itemstack));
                ++j2;
            }
            this.d.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.d;
    }

    public void a(PacketDataSerializer packetdataserializer) {
        packetdataserializer.a(Arrays.asList(this.a()), PacketDataSerializer::a);
    }

    public JsonElement c() {
        if (this.b.length == 1) {
            return this.b[0].b();
        }
        JsonArray jsonarray = new JsonArray();
        Provider[] arecipeitemstack_provider = this.b;
        int i2 = arecipeitemstack_provider.length;
        int j2 = 0;
        while (j2 < i2) {
            Provider recipeitemstack_provider = arecipeitemstack_provider[j2];
            jsonarray.add((JsonElement)recipeitemstack_provider.b());
            ++j2;
        }
        return jsonarray;
    }

    public boolean d() {
        return this.b.length == 0;
    }

    private static RecipeItemStack b(Stream<? extends Provider> stream) {
        RecipeItemStack recipeitemstack = new RecipeItemStack(stream);
        return recipeitemstack.d() ? a : recipeitemstack;
    }

    public static RecipeItemStack e() {
        return a;
    }

    public static RecipeItemStack a(IMaterial ... aimaterial) {
        return RecipeItemStack.a(Arrays.stream(aimaterial).map(ItemStack::new));
    }

    public static RecipeItemStack a(ItemStack ... aitemstack) {
        return RecipeItemStack.a(Arrays.stream(aitemstack));
    }

    public static RecipeItemStack a(Stream<ItemStack> stream) {
        return RecipeItemStack.b(stream.filter(itemstack -> !itemstack.b()).map(StackProvider::new));
    }

    public static RecipeItemStack a(TagKey<Item> tagkey) {
        return RecipeItemStack.b(Stream.of(new b(tagkey)));
    }

    public static RecipeItemStack b(PacketDataSerializer packetdataserializer) {
        return RecipeItemStack.b(packetdataserializer.a(PacketDataSerializer::r).stream().map(StackProvider::new));
    }

    public static RecipeItemStack a(@Nullable JsonElement jsonelement) {
        return RecipeItemStack.a(jsonelement, true);
    }

    public static RecipeItemStack a(@Nullable JsonElement jsonelement, boolean flag) {
        if (jsonelement != null && !jsonelement.isJsonNull()) {
            if (jsonelement.isJsonObject()) {
                return RecipeItemStack.b(Stream.of(RecipeItemStack.a(jsonelement.getAsJsonObject())));
            }
            if (jsonelement.isJsonArray()) {
                JsonArray jsonarray = jsonelement.getAsJsonArray();
                if (jsonarray.size() == 0 && !flag) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return RecipeItemStack.b(StreamSupport.stream(jsonarray.spliterator(), false).map(jsonelement1 -> RecipeItemStack.a(ChatDeserializer.m(jsonelement1, "item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    private static Provider a(JsonObject jsonobject) {
        if (jsonobject.has("item") && jsonobject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (jsonobject.has("item")) {
            Item item = ShapedRecipes.b(jsonobject);
            return new StackProvider(new ItemStack(item));
        }
        if (jsonobject.has("tag")) {
            MinecraftKey minecraftkey = new MinecraftKey(ChatDeserializer.i(jsonobject, "tag"));
            TagKey<Item> tagkey = TagKey.a(Registries.D, minecraftkey);
            return new b(tagkey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static interface Provider {
        public Collection<ItemStack> a();

        public JsonObject b();
    }

    public static class StackProvider
    implements Provider {
        private final ItemStack a;

        public StackProvider(ItemStack itemstack) {
            this.a = itemstack;
        }

        @Override
        public Collection<ItemStack> a() {
            return Collections.singleton(this.a);
        }

        @Override
        public JsonObject b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.i.b(this.a.d()).toString());
            return jsonobject;
        }
    }

    private static class b
    implements Provider {
        private final TagKey<Item> a;

        b(TagKey<Item> tagkey) {
            this.a = tagkey;
        }

        @Override
        public Collection<ItemStack> a() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.i.c(this.a)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }

        @Override
        public JsonObject b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.a.b().toString());
            return jsonobject;
        }
    }
}

