/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ShapedRecipes
implements RecipeCrafting {
    final int a;
    final int b;
    final NonNullList<RecipeItemStack> c;
    final ItemStack d;
    private final MinecraftKey e;
    final String f;
    final CraftingBookCategory g;
    final boolean h;

    public ShapedRecipes(MinecraftKey minecraftkey, String s2, CraftingBookCategory craftingbookcategory, int i2, int j2, NonNullList<RecipeItemStack> nonnulllist, ItemStack itemstack, boolean flag) {
        this.e = minecraftkey;
        this.f = s2;
        this.g = craftingbookcategory;
        this.a = i2;
        this.b = j2;
        this.c = nonnulllist;
        this.d = itemstack;
        this.h = flag;
    }

    public ShapedRecipes(MinecraftKey minecraftkey, String s2, CraftingBookCategory craftingbookcategory, int i2, int j2, NonNullList<RecipeItemStack> nonnulllist, ItemStack itemstack) {
        this(minecraftkey, s2, craftingbookcategory, i2, j2, nonnulllist, itemstack, true);
    }

    public ShapedRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapedRecipe recipe = new CraftShapedRecipe(result, this);
        recipe.setGroup(this.f);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        block0 : switch (this.b) {
            case 1: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (RecipeItemStack list : this.c) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != null) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    @Override
    public MinecraftKey e() {
        return this.e;
    }

    @Override
    public RecipeSerializer<?> aj_() {
        return RecipeSerializer.a;
    }

    @Override
    public String c() {
        return this.f;
    }

    @Override
    public CraftingBookCategory d() {
        return this.g;
    }

    @Override
    public ItemStack a(IRegistryCustom iregistrycustom) {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.c;
    }

    @Override
    public boolean i() {
        return this.h;
    }

    @Override
    public boolean a(int i2, int j2) {
        return i2 >= this.a && j2 >= this.b;
    }

    @Override
    public boolean a(InventoryCrafting inventorycrafting, World world) {
        int i2 = 0;
        while (i2 <= inventorycrafting.f() - this.a) {
            int j2 = 0;
            while (j2 <= inventorycrafting.g() - this.b) {
                if (this.a(inventorycrafting, i2, j2, true)) {
                    return true;
                }
                if (this.a(inventorycrafting, i2, j2, false)) {
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }

    private boolean a(InventoryCrafting inventorycrafting, int i2, int j2, boolean flag) {
        int k2 = 0;
        while (k2 < inventorycrafting.f()) {
            int l2 = 0;
            while (l2 < inventorycrafting.g()) {
                int i1 = k2 - i2;
                int j1 = l2 - j2;
                RecipeItemStack recipeitemstack = RecipeItemStack.a;
                if (i1 >= 0 && j1 >= 0 && i1 < this.a && j1 < this.b) {
                    recipeitemstack = flag ? this.c.get(this.a - i1 - 1 + j1 * this.a) : this.c.get(i1 + j1 * this.a);
                }
                if (!recipeitemstack.a(inventorycrafting.a(k2 + l2 * inventorycrafting.f()))) {
                    return false;
                }
                ++l2;
            }
            ++k2;
        }
        return true;
    }

    @Override
    public ItemStack a(InventoryCrafting inventorycrafting, IRegistryCustom iregistrycustom) {
        return this.a(iregistrycustom).p();
    }

    public int k() {
        return this.a;
    }

    public int l() {
        return this.b;
    }

    static NonNullList<RecipeItemStack> a(String[] astring, Map<String, RecipeItemStack> map, int i2, int j2) {
        NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2 * j2, RecipeItemStack.a);
        HashSet set = Sets.newHashSet(map.keySet());
        set.remove(" ");
        int k2 = 0;
        while (k2 < astring.length) {
            int l2 = 0;
            while (l2 < astring[k2].length()) {
                String s2 = astring[k2].substring(l2, l2 + 1);
                RecipeItemStack recipeitemstack = map.get(s2);
                if (recipeitemstack == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s2 + "' but it's not defined in the key");
                }
                set.remove(s2);
                nonnulllist.set(l2 + i2 * k2, recipeitemstack);
                ++l2;
            }
            ++k2;
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] a(String ... astring) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        int i1 = 0;
        while (i1 < astring.length) {
            String s2 = astring[i1];
            i2 = Math.min(i2, ShapedRecipes.a(s2));
            int j1 = ShapedRecipes.b(s2);
            j2 = Math.max(j2, j1);
            if (j1 < 0) {
                if (k2 == i1) {
                    ++k2;
                }
                ++l2;
            } else {
                l2 = 0;
            }
            ++i1;
        }
        if (astring.length == l2) {
            return new String[0];
        }
        String[] astring1 = new String[astring.length - l2 - k2];
        int k1 = 0;
        while (k1 < astring1.length) {
            astring1[k1] = astring[k1 + k2].substring(i2, j2 + 1);
            ++k1;
        }
        return astring1;
    }

    @Override
    public boolean j() {
        NonNullList<RecipeItemStack> nonnulllist = this.a();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(recipeitemstack -> !recipeitemstack.d()).anyMatch(recipeitemstack -> recipeitemstack.a().length == 0);
    }

    private static int a(String s2) {
        int i2 = 0;
        while (i2 < s2.length() && s2.charAt(i2) == ' ') {
            ++i2;
        }
        return i2;
    }

    private static int b(String s2) {
        int i2 = s2.length() - 1;
        while (i2 >= 0 && s2.charAt(i2) == ' ') {
            --i2;
        }
        return i2;
    }

    static String[] a(JsonArray jsonarray) {
        String[] astring = new String[jsonarray.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        int i2 = 0;
        while (i2 < astring.length) {
            String s2 = ChatDeserializer.a(jsonarray.get(i2), "pattern[" + i2 + "]");
            if (s2.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i2 > 0 && astring[0].length() != s2.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i2] = s2;
            ++i2;
        }
        return astring;
    }

    static Map<String, RecipeItemStack> c(JsonObject jsonobject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonobject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), RecipeItemStack.a((JsonElement)entry.getValue(), false));
        }
        map.put(" ", RecipeItemStack.a);
        return map;
    }

    public static ItemStack a(JsonObject jsonobject) {
        Item item = ShapedRecipes.b(jsonobject);
        if (jsonobject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i2 = ChatDeserializer.a(jsonobject, "count", 1);
        if (i2 < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i2);
        }
        return new ItemStack(item, i2);
    }

    public static Item b(JsonObject jsonobject) {
        String s2 = ChatDeserializer.i(jsonobject, "item");
        Item item = (Item)BuiltInRegistries.i.b(MinecraftKey.a(s2)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s2 + "'"));
        if (item == Items.a) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public static class a
    implements RecipeSerializer<ShapedRecipes> {
        public ShapedRecipes b(MinecraftKey minecraftkey, JsonObject jsonobject) {
            String s2 = ChatDeserializer.a(jsonobject, "group", "");
            CraftingBookCategory craftingbookcategory = CraftingBookCategory.e.a(ChatDeserializer.a(jsonobject, "category", null), CraftingBookCategory.d);
            Map<String, RecipeItemStack> map = ShapedRecipes.c(ChatDeserializer.u(jsonobject, "key"));
            String[] astring = ShapedRecipes.a(ShapedRecipes.a(ChatDeserializer.v(jsonobject, "pattern")));
            int i2 = astring[0].length();
            int j2 = astring.length;
            NonNullList<RecipeItemStack> nonnulllist = ShapedRecipes.a(astring, map, i2, j2);
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.u(jsonobject, "result"));
            boolean flag = ChatDeserializer.a(jsonobject, "show_notification", true);
            return new ShapedRecipes(minecraftkey, s2, craftingbookcategory, i2, j2, nonnulllist, itemstack, flag);
        }

        public ShapedRecipes b(MinecraftKey minecraftkey, PacketDataSerializer packetdataserializer) {
            int i2 = packetdataserializer.m();
            int j2 = packetdataserializer.m();
            String s2 = packetdataserializer.s();
            CraftingBookCategory craftingbookcategory = packetdataserializer.b(CraftingBookCategory.class);
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2 * j2, RecipeItemStack.a);
            int k2 = 0;
            while (k2 < nonnulllist.size()) {
                nonnulllist.set(k2, RecipeItemStack.b(packetdataserializer));
                ++k2;
            }
            ItemStack itemstack = packetdataserializer.r();
            boolean flag = packetdataserializer.readBoolean();
            return new ShapedRecipes(minecraftkey, s2, craftingbookcategory, i2, j2, nonnulllist, itemstack, flag);
        }

        @Override
        public void a(PacketDataSerializer packetdataserializer, ShapedRecipes shapedrecipes) {
            packetdataserializer.d(shapedrecipes.a);
            packetdataserializer.d(shapedrecipes.b);
            packetdataserializer.a(shapedrecipes.f);
            packetdataserializer.a(shapedrecipes.g);
            for (RecipeItemStack recipeitemstack : shapedrecipes.c) {
                recipeitemstack.a(packetdataserializer);
            }
            packetdataserializer.a(shapedrecipes.d);
            packetdataserializer.writeBoolean(shapedrecipes.h);
        }
    }
}

