/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
implements RecipeCrafting {
    private final MinecraftKey a;
    final String b;
    final CraftingBookCategory c;
    final ItemStack d;
    final NonNullList<RecipeItemStack> e;

    public ShapelessRecipes(MinecraftKey minecraftkey, String s2, CraftingBookCategory craftingbookcategory, ItemStack itemstack, NonNullList<RecipeItemStack> nonnulllist) {
        this.a = minecraftkey;
        this.b = s2;
        this.c = craftingbookcategory;
        this.d = itemstack;
        this.e = nonnulllist;
    }

    public ShapelessRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(result, this);
        recipe.setGroup(this.b);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        for (RecipeItemStack list : this.e) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public MinecraftKey e() {
        return this.a;
    }

    @Override
    public RecipeSerializer<?> aj_() {
        return RecipeSerializer.b;
    }

    @Override
    public String c() {
        return this.b;
    }

    @Override
    public CraftingBookCategory d() {
        return this.c;
    }

    @Override
    public ItemStack a(IRegistryCustom iregistrycustom) {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.e;
    }

    @Override
    public boolean a(InventoryCrafting inventorycrafting, World world) {
        AutoRecipeStackManager autorecipestackmanager = new AutoRecipeStackManager();
        int i2 = 0;
        int j2 = 0;
        while (j2 < inventorycrafting.b()) {
            ItemStack itemstack = inventorycrafting.a(j2);
            if (!itemstack.b()) {
                ++i2;
                autorecipestackmanager.a(itemstack, 1);
            }
            ++j2;
        }
        return i2 == this.e.size() && autorecipestackmanager.a(this, null);
    }

    @Override
    public ItemStack a(InventoryCrafting inventorycrafting, IRegistryCustom iregistrycustom) {
        return this.d.p();
    }

    @Override
    public boolean a(int i2, int j2) {
        return i2 * j2 >= this.e.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        public ShapelessRecipes b(MinecraftKey minecraftkey, JsonObject jsonobject) {
            String s2 = ChatDeserializer.a(jsonobject, "group", "");
            CraftingBookCategory craftingbookcategory = CraftingBookCategory.e.a(ChatDeserializer.a(jsonobject, "category", null), CraftingBookCategory.d);
            NonNullList<RecipeItemStack> nonnulllist = net.minecraft.world.item.crafting.ShapelessRecipes$a.a(ChatDeserializer.v(jsonobject, "ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.u(jsonobject, "result"));
            return new ShapelessRecipes(minecraftkey, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        private static NonNullList<RecipeItemStack> a(JsonArray jsonarray) {
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a();
            int i2 = 0;
            while (i2 < jsonarray.size()) {
                RecipeItemStack recipeitemstack = RecipeItemStack.a(jsonarray.get(i2), false);
                if (!recipeitemstack.d()) {
                    nonnulllist.add(recipeitemstack);
                }
                ++i2;
            }
            return nonnulllist;
        }

        public ShapelessRecipes b(MinecraftKey minecraftkey, PacketDataSerializer packetdataserializer) {
            String s2 = packetdataserializer.s();
            CraftingBookCategory craftingbookcategory = packetdataserializer.b(CraftingBookCategory.class);
            int i2 = packetdataserializer.m();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2, RecipeItemStack.a);
            int j2 = 0;
            while (j2 < nonnulllist.size()) {
                nonnulllist.set(j2, RecipeItemStack.b(packetdataserializer));
                ++j2;
            }
            ItemStack itemstack = packetdataserializer.r();
            return new ShapelessRecipes(minecraftkey, s2, craftingbookcategory, itemstack, nonnulllist);
        }

        @Override
        public void a(PacketDataSerializer packetdataserializer, ShapelessRecipes shapelessrecipes) {
            packetdataserializer.a(shapelessrecipes.b);
            packetdataserializer.a(shapelessrecipes.c);
            packetdataserializer.d(shapelessrecipes.e.size());
            for (RecipeItemStack recipeitemstack : shapelessrecipes.e) {
                recipeitemstack.a(packetdataserializer);
            }
            packetdataserializer.a(shapelessrecipes.d);
        }
    }
}

