/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private final boolean c;
    private final Effect d;
    private final RandomSource e = RandomSource.a();
    private final World f;
    private final double g;
    private final double h;
    private final double i;
    @Nullable
    public final net.minecraft.world.entity.Entity j;
    private final float k;
    private final DamageSource l;
    private final ExplosionDamageCalculator m;
    private final ObjectArrayList<BlockPosition> n = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> o = Maps.newHashMap();
    public boolean wasCanceled = false;

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double d0, double d1, double d2, float f2, List<BlockPosition> list) {
        this(world, entity, d0, d1, d2, f2, false, Effect.c, list);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect, List<BlockPosition> list) {
        this(world, entity, d0, d1, d2, f2, flag, explosion_effect);
        this.n.addAll(list);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect) {
        this(world, entity, null, null, d0, d1, d2, f2, flag, explosion_effect);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect) {
        this.f = world;
        this.j = entity;
        this.k = (float)Math.max((double)f2, 0.0);
        this.g = d0;
        this.h = d1;
        this.i = d2;
        this.c = flag;
        this.d = explosion_effect;
        this.l = damagesource == null ? world.ag().a(this) : damagesource;
        this.m = explosiondamagecalculator == null ? this.a(entity) : explosiondamagecalculator;
    }

    private ExplosionDamageCalculator a(@Nullable net.minecraft.world.entity.Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D vec3d, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cE();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            double d5 = 0.0;
            while (d5 <= 1.0) {
                double d6 = 0.0;
                while (d6 <= 1.0) {
                    double d7 = 0.0;
                    while (d7 <= 1.0) {
                        double d8 = MathHelper.d(d5, axisalignedbb.a, axisalignedbb.d);
                        double d9 = MathHelper.d(d6, axisalignedbb.b, axisalignedbb.e);
                        double d10 = MathHelper.d(d7, axisalignedbb.c, axisalignedbb.f);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dI().a(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                        d7 += d2;
                    }
                    d6 += d1;
                }
                d5 += d0;
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public void a() {
        int j2;
        int i2;
        if (this.k < 0.1f) {
            return;
        }
        this.f.a(this.j, GameEvent.x, new Vec3D(this.g, this.h, this.i));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        int k2 = 0;
        while (k2 < 16) {
            i2 = 0;
            while (i2 < 16) {
                j2 = 0;
                while (j2 < 16) {
                    if (k2 == 0 || k2 == 15 || i2 == 0 || i2 == 15 || j2 == 0 || j2 == 15) {
                        double d0 = (float)k2 / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)i2 / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)j2 / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        float f2 = this.k * (0.7f + this.f.z.i() * 0.6f);
                        double d4 = this.g;
                        double d5 = this.h;
                        double d6 = this.i;
                        float f1 = 0.3f;
                        while (f2 > 0.0f) {
                            BlockPosition blockposition = BlockPosition.a(d4, d5, d6);
                            IBlockData iblockdata = this.f.a_(blockposition);
                            Fluid fluid = this.f.b_(blockposition);
                            if (!this.f.j(blockposition)) break;
                            Optional<Float> optional = this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, fluid);
                            if (optional.isPresent()) {
                                f2 -= (optional.get().floatValue() + 0.3f) * 0.3f;
                            }
                            if (f2 > 0.0f && this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, f2)) {
                                set.add(blockposition);
                            }
                            d4 += d0 * (double)0.3f;
                            d5 += d1 * (double)0.3f;
                            d6 += d2 * (double)0.3f;
                            f2 -= 0.22500001f;
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            ++k2;
        }
        this.n.addAll((Collection)set);
        float f2 = this.k * 2.0f;
        i2 = MathHelper.a(this.g - (double)f2 - 1.0);
        j2 = MathHelper.a(this.g + (double)f2 + 1.0);
        int l2 = MathHelper.a(this.h - (double)f2 - 1.0);
        int i1 = MathHelper.a(this.h + (double)f2 + 1.0);
        int j1 = MathHelper.a(this.i - (double)f2 - 1.0);
        int k1 = MathHelper.a(this.i + (double)f2 + 1.0);
        List<net.minecraft.world.entity.Entity> list = this.f.a_(this.j, new AxisAlignedBB(i2, l2, j1, j2, i1, k1));
        Vec3D vec3d = new Vec3D(this.g, this.h, this.i);
        int l1 = 0;
        while (l1 < list.size()) {
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            net.minecraft.world.entity.Entity entity = list.get(l1);
            if (!entity.cJ() && (d7 = Math.sqrt(entity.e(vec3d)) / (double)f2) <= 1.0 && (d11 = Math.sqrt((d8 = entity.dn() - this.g) * d8 + (d9 = (entity instanceof EntityTNTPrimed ? entity.dp() : entity.dr()) - this.h) * d9 + (d10 = entity.dt() - this.i) * d10)) != 0.0) {
                d8 /= d11;
                d9 /= d11;
                d10 /= d11;
                double d12 = Explosion.a(vec3d, entity);
                double d13 = (1.0 - d7) * d12;
                if (!(entity instanceof EntityComplexPart)) {
                    CraftEventFactory.entityDamage = this.j;
                    entity.lastDamageCancelled = false;
                    if (entity instanceof EntityEnderDragon) {
                        EntityComplexPart[] entityComplexPartArray = ((EntityEnderDragon)entity).cf;
                        int n2 = ((EntityEnderDragon)entity).cf.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            EntityComplexPart entityComplexPart = entityComplexPartArray[n3];
                            if (list.contains(entityComplexPart)) {
                                double d2;
                                double d7part = Math.sqrt(entityComplexPart.e(vec3d)) / (double)f2;
                                if (d2 <= 1.0) {
                                    double d13part = (1.0 - d7part) * (double)Explosion.a(vec3d, entityComplexPart);
                                    entityComplexPart.a(this.c(), (float)((int)((d13part * d13part + d13part) / 2.0 * 7.0 * (double)f2 + 1.0)));
                                }
                            }
                            ++n3;
                        }
                    } else {
                        entity.a(this.c(), (float)((int)((d13 * d13 + d13) / 2.0 * 7.0 * (double)f2 + 1.0)));
                    }
                    CraftEventFactory.entityDamage = null;
                    if (!entity.lastDamageCancelled) {
                        EntityHuman entityhuman;
                        double d14;
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving = (EntityLiving)entity;
                            d14 = EnchantmentProtection.a(entityliving, d13);
                        } else {
                            d14 = d13;
                        }
                        Vec3D vec3d1 = new Vec3D(d8 *= d14, d9 *= d14, d10 *= d14);
                        entity.f(entity.dl().e(vec3d1));
                        if (!(!(entity instanceof EntityHuman) || (entityhuman = (EntityHuman)entity).G_() || entityhuman.f() && entityhuman.fO().b)) {
                            this.o.put(entityhuman, vec3d1);
                        }
                    }
                }
            }
            ++l1;
        }
    }

    public void a(boolean flag) {
        if (this.f.B) {
            this.f.a(this.g, this.h, this.i, SoundEffects.iX, SoundCategory.e, 4.0f, (1.0f + (this.f.z.i() - this.f.z.i()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.b();
        if (flag) {
            if (this.k >= 2.0f && flag1) {
                this.f.a(Particles.w, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            } else {
                this.f.a(Particles.x, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            }
        }
        if (flag1) {
            float yield;
            List bukkitBlocks;
            boolean cancelled;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag2 = this.e() instanceof EntityHuman;
            SystemUtils.b(this.n, this.f.z);
            ObjectListIterator objectlistiterator = this.n.iterator();
            CraftWorld bworld = this.f.getWorld();
            CraftEntity explode = this.j == null ? null : this.j.getBukkitEntity();
            Location location = new Location((org.bukkit.World)bworld, this.g, this.h, this.i);
            ObjectArrayList blockList = new ObjectArrayList();
            int i1 = this.n.size() - 1;
            while (i1 >= 0) {
                BlockPosition cpos = (BlockPosition)this.n.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
                if (!bblock.getType().isAir()) {
                    blockList.add(bblock);
                }
                --i1;
            }
            if (explode != null) {
                event = new EntityExplodeEvent((Entity)explode, location, (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            } else {
                event = new BlockExplodeEvent(location.getBlock(), (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            }
            this.n.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.n.add((Object)coords);
            }
            if (cancelled) {
                this.wasCanceled = true;
                return;
            }
            for (BlockPosition blockposition : this.n) {
                World world;
                IBlockData iblockdata = this.f.a_(blockposition);
                Block block = iblockdata.b();
                if (block instanceof BlockTNT) {
                    BlockPosition sourceBlock;
                    net.minecraft.world.entity.Entity sourceEntity = this.j == null ? null : this.j;
                    BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.a(this.g, this.h, this.i) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.f.a(blockposition, Blocks.a.n(), iblockdata, 3);
                        continue;
                    }
                }
                if (iblockdata.i()) continue;
                BlockPosition blockposition1 = blockposition.i();
                this.f.ad().a("explosion_blocks");
                if (block.a(this) && (world = this.f) instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    TileEntity tileentity = iblockdata.t() ? this.f.c_(blockposition) : null;
                    LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.b).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, this.j);
                    if (yield < 1.0f) {
                        lootparams_a.a(LootContextParameters.j, Float.valueOf(1.0f / yield));
                    }
                    iblockdata.a(worldserver, blockposition, ItemStack.b, flag2);
                    iblockdata.a(lootparams_a).forEach(itemstack -> Explosion.a((ObjectArrayList<Pair<ItemStack, BlockPosition>>)objectarraylist, itemstack, blockposition1));
                }
                this.f.a(blockposition, Blocks.a.n(), 3);
                block.a(this.f, blockposition, this);
                this.f.ad().c();
            }
            for (Pair pair : objectarraylist) {
                Block.a(this.f, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
        }
        if (this.c) {
            for (BlockPosition blockposition2 : this.n) {
                if (this.e.a(3) != 0 || !this.f.a_(blockposition2).i() || !this.f.a_(blockposition2.d()).i(this.f, blockposition2.d()) || CraftEventFactory.callBlockIgniteEvent(this.f, blockposition2.u(), blockposition2.v(), blockposition2.w(), this).isCancelled()) continue;
                this.f.b(blockposition2, BlockFireAbstract.a(this.f, blockposition2));
            }
        }
    }

    public boolean b() {
        return this.d != Effect.a;
    }

    private static void a(ObjectArrayList<Pair<ItemStack, BlockPosition>> objectarraylist, ItemStack itemstack, BlockPosition blockposition) {
        if (itemstack.b()) {
            return;
        }
        int i2 = objectarraylist.size();
        int j2 = 0;
        while (j2 < i2) {
            Pair pair = (Pair)objectarraylist.get(j2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (EntityItem.a(itemstack1, itemstack)) {
                ItemStack itemstack2 = EntityItem.a(itemstack1, itemstack, 16);
                objectarraylist.set(j2, (Object)Pair.of((Object)itemstack2, (Object)((BlockPosition)pair.getSecond())));
                if (itemstack.b()) {
                    return;
                }
            }
            ++j2;
        }
        objectarraylist.add((Object)Pair.of((Object)itemstack, (Object)blockposition));
    }

    public DamageSource c() {
        return this.l;
    }

    public Map<EntityHuman, Vec3D> d() {
        return this.o;
    }

    @Nullable
    public EntityLiving e() {
        IProjectile iprojectile;
        if (this.j == null) {
            return null;
        }
        net.minecraft.world.entity.Entity entity = this.j;
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            return entitytntprimed.j();
        }
        entity = this.j;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving;
        }
        entity = this.j;
        if (entity instanceof IProjectile && (entity = (iprojectile = (IProjectile)entity).v()) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity f() {
        return this.j;
    }

    public void g() {
        this.n.clear();
    }

    public List<BlockPosition> h() {
        return this.n;
    }

    public static enum Effect {
        a,
        b,
        c;

    }
}

