/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.slf4j.Logger;

public class GameRules {
    public static final int a = 3;
    static final Logger U = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> V = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.a));
    public static final GameRuleKey<GameRuleBoolean> b = GameRules.a("doFireTick", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> c = GameRules.a("mobGriefing", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> d = GameRules.a("keepInventory", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> e = GameRules.a("doMobSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> f = GameRules.a("doMobLoot", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> g = GameRules.a("doTileDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> h = GameRules.a("doEntityDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> i = GameRules.a("commandBlockOutput", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> j = GameRules.a("naturalRegeneration", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> k = GameRules.a("doDaylightCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> l = GameRules.a("logAdminCommands", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> m = GameRules.a("showDeathMessages", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> n = GameRules.a("randomTickSpeed", GameRuleCategory.e, GameRuleInt.a(3));
    public static final GameRuleKey<GameRuleBoolean> o = GameRules.a("sendCommandFeedback", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> p = GameRules.a("reducedDebugInfo", GameRuleCategory.g, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        int i2 = gamerules_gameruleboolean.a() ? 22 : 23;
        for (EntityPlayer entityplayer : minecraftserver.ac().t()) {
            entityplayer.c.a(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> q = GameRules.a("spectatorsGenerateChunks", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> r = GameRules.a("spawnRadius", GameRuleCategory.a, GameRuleInt.a(10));
    public static final GameRuleKey<GameRuleBoolean> s = GameRules.a("disableElytraMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> t = GameRules.a("maxEntityCramming", GameRuleCategory.b, GameRuleInt.a(24));
    public static final GameRuleKey<GameRuleBoolean> u = GameRules.a("doWeatherCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> v = GameRules.a("doLimitedCrafting", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> w = GameRules.a("maxCommandChainLength", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> x = GameRules.a("commandModificationBlockLimit", GameRuleCategory.g, GameRuleInt.a(32768));
    public static final GameRuleKey<GameRuleBoolean> y = GameRules.a("announceAdvancements", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> z = GameRules.a("disableRaids", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> A = GameRules.a("doInsomnia", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> B = GameRules.a("doImmediateRespawn", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.ac().t()) {
            entityplayer.c.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> C = GameRules.a("drowningDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> D = GameRules.a("fallDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> E = GameRules.a("fireDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> F = GameRules.a("freezeDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> G = GameRules.a("doPatrolSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> H = GameRules.a("doTraderSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> I = GameRules.a("doWardenSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> J = GameRules.a("forgiveDeadPlayers", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> K = GameRules.a("universalAnger", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> L = GameRules.a("playersSleepingPercentage", GameRuleCategory.a, GameRuleInt.a(100));
    public static final GameRuleKey<GameRuleBoolean> M = GameRules.a("blockExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> N = GameRules.a("mobExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> O = GameRules.a("tntExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> P = GameRules.a("snowAccumulationHeight", GameRuleCategory.e, GameRuleInt.a(1));
    public static final GameRuleKey<GameRuleBoolean> Q = GameRules.a("waterSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> R = GameRules.a("lavaSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> S = GameRules.a("globalSoundEvents", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> T = GameRules.a("doVinesSpread", GameRuleCategory.e, GameRuleBoolean.a(true));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> W;

    private static <T extends GameRuleValue<T>> GameRuleKey<T> a(String s2, GameRuleCategory gamerules_gamerulecategory, GameRuleDefinition<T> gamerules_gameruledefinition) {
        GameRuleKey gamerules_gamerulekey = new GameRuleKey(s2, gamerules_gamerulecategory);
        GameRuleDefinition<T> gamerules_gameruledefinition1 = V.put(gamerules_gamerulekey, gamerules_gameruledefinition);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + s2);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(DynamicLike<?> dynamiclike) {
        this();
        this.a(dynamiclike);
    }

    public GameRules() {
        this.W = (Map)V.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).a()));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> map) {
        this.W = map;
    }

    public <T extends GameRuleValue<T>> T a(GameRuleKey<T> gamerules_gamerulekey) {
        return (T)this.W.get(gamerules_gamerulekey);
    }

    public NBTTagCompound a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.W.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.a(gamerules_gamerulekey.a, gamerules_gamerulevalue.b()));
        return nbttagcompound;
    }

    private void a(DynamicLike<?> dynamiclike) {
        this.W.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            Optional optional = dynamiclike.get(gamerules_gamerulekey.a).asString().result();
            Objects.requireNonNull(gamerules_gamerulevalue);
            optional.ifPresent(gamerules_gamerulevalue::a);
        });
    }

    public GameRules b() {
        return new GameRules((Map)this.W.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleValue)entry.getValue()).f())));
    }

    public static void a(GameRuleVisitor gamerules_gamerulevisitor) {
        V.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> GameRules.a(gamerules_gamerulevisitor, gamerules_gamerulekey, gamerules_gameruledefinition));
    }

    private static <T extends GameRuleValue<T>> void a(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<?> gamerules_gamerulekey, GameRuleDefinition<?> gamerules_gameruledefinition) {
        gamerules_gamerulevisitor.a(gamerules_gamerulekey, gamerules_gameruledefinition);
        gamerules_gameruledefinition.a(gamerules_gamerulevisitor, gamerules_gamerulekey);
    }

    public void a(GameRules gamerules, @Nullable MinecraftServer minecraftserver) {
        gamerules.W.keySet().forEach(gamerules_gamerulekey -> this.a((GameRuleKey)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends GameRuleValue<T>> void a(GameRuleKey<T> gamerules_gamerulekey, GameRules gamerules, @Nullable MinecraftServer minecraftserver) {
        T t0 = gamerules.a(gamerules_gamerulekey);
        ((GameRuleValue)this.a(gamerules_gamerulekey)).a(t0, minecraftserver);
    }

    public boolean b(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey) {
        return this.a(gamerules_gamerulekey).a();
    }

    public int c(GameRuleKey<GameRuleInt> gamerules_gamerulekey) {
        return this.a(gamerules_gamerulekey).a();
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean b;

        static GameRuleDefinition<GameRuleBoolean> a(boolean flag, BiConsumer<MinecraftServer, GameRuleBoolean> biconsumer) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, flag), biconsumer, GameRuleVisitor::b);
        }

        static GameRuleDefinition<GameRuleBoolean> a(boolean flag) {
            return GameRuleBoolean.a(flag, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition, boolean flag) {
            super(gamerules_gameruledefinition);
            this.b = flag;
        }

        @Override
        protected void a(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.b = BoolArgumentType.getBool(commandcontext, (String)s2);
        }

        public boolean a() {
            return this.b;
        }

        @Override
        public void a(boolean flag, @Nullable MinecraftServer minecraftserver) {
            this.b = flag;
            this.a(minecraftserver);
        }

        @Override
        public String b() {
            return Boolean.toString(this.b);
        }

        @Override
        public void a(String s2) {
            this.b = Boolean.parseBoolean(s2);
        }

        @Override
        public int c() {
            return this.b ? 1 : 0;
        }

        protected GameRuleBoolean d() {
            return this;
        }

        protected GameRuleBoolean e() {
            return new GameRuleBoolean(this.a, this.b);
        }

        @Override
        public void a(GameRuleBoolean gamerules_gameruleboolean, @Nullable MinecraftServer minecraftserver) {
            this.b = gamerules_gameruleboolean.b;
            this.a(minecraftserver);
        }
    }

    public static enum GameRuleCategory {
        a("gamerule.category.player"),
        b("gamerule.category.mobs"),
        c("gamerule.category.spawning"),
        d("gamerule.category.drops"),
        e("gamerule.category.updates"),
        f("gamerule.category.chat"),
        g("gamerule.category.misc");

        private final String h;

        private GameRuleCategory(String s2) {
            this.h = s2;
        }

        public String a() {
            return this.h;
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        private final Supplier<ArgumentType<?>> a;
        private final Function<GameRuleDefinition<T>, T> b;
        final BiConsumer<MinecraftServer, T> c;
        private final h<T> d;

        GameRuleDefinition(Supplier<ArgumentType<?>> supplier, Function<GameRuleDefinition<T>, T> function, BiConsumer<MinecraftServer, T> biconsumer, h<T> gamerules_h) {
            this.a = supplier;
            this.b = function;
            this.c = biconsumer;
            this.d = gamerules_h;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> a(String s2) {
            return CommandDispatcher.a(s2, this.a.get());
        }

        public T a() {
            return (T)((GameRuleValue)this.b.apply(this));
        }

        public void a(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<T> gamerules_gamerulekey) {
            this.d.call(gamerules_gamerulevisitor, gamerules_gamerulekey, this);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int b;

        private static GameRuleDefinition<GameRuleInt> a(int i2, BiConsumer<MinecraftServer, GameRuleInt> biconsumer) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, i2), biconsumer, GameRuleVisitor::c);
        }

        static GameRuleDefinition<GameRuleInt> a(int i2) {
            return GameRuleInt.a(i2, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition, int i2) {
            super(gamerules_gameruledefinition);
            this.b = i2;
        }

        @Override
        protected void a(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.b = IntegerArgumentType.getInteger(commandcontext, (String)s2);
        }

        public int a() {
            return this.b;
        }

        @Override
        public void a(int i2, @Nullable MinecraftServer minecraftserver) {
            this.b = i2;
            this.a(minecraftserver);
        }

        @Override
        public String b() {
            return Integer.toString(this.b);
        }

        @Override
        public void a(String s2) {
            this.b = GameRuleInt.c(s2);
        }

        public boolean b(String s2) {
            try {
                this.b = Integer.parseInt(s2);
                return true;
            }
            catch (NumberFormatException numberformatexception) {
                return false;
            }
        }

        private static int c(String s2) {
            if (!s2.isEmpty()) {
                try {
                    return Integer.parseInt(s2);
                }
                catch (NumberFormatException numberformatexception) {
                    U.warn("Failed to parse integer {}", (Object)s2);
                }
            }
            return 0;
        }

        @Override
        public int c() {
            return this.b;
        }

        protected GameRuleInt d() {
            return this;
        }

        protected GameRuleInt e() {
            return new GameRuleInt(this.a, this.b);
        }

        @Override
        public void a(GameRuleInt gamerules_gameruleint, @Nullable MinecraftServer minecraftserver) {
            this.b = gamerules_gameruleint.b;
            this.a(minecraftserver);
        }
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        final String a;
        private final GameRuleCategory b;

        public GameRuleKey(String s2, GameRuleCategory gamerules_gamerulecategory) {
            this.a = s2;
            this.b = gamerules_gamerulecategory;
        }

        public String toString() {
            return this.a;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof GameRuleKey && ((GameRuleKey)object).a.equals(this.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return "gamerule." + this.a;
        }

        public GameRuleCategory c() {
            return this.b;
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> a;

        public GameRuleValue(GameRuleDefinition<T> gamerules_gameruledefinition) {
            this.a = gamerules_gameruledefinition;
        }

        protected abstract void a(CommandContext<CommandListenerWrapper> var1, String var2);

        public void b(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.a(commandcontext, s2);
            this.a(((CommandListenerWrapper)commandcontext.getSource()).l());
        }

        public void a(@Nullable MinecraftServer minecraftserver) {
            if (minecraftserver != null) {
                this.a.c.accept(minecraftserver, (MinecraftServer)this.g());
            }
        }

        public abstract void a(String var1);

        public abstract String b();

        public String toString() {
            return this.b();
        }

        public abstract int c();

        protected abstract T g();

        protected abstract T f();

        public abstract void a(T var1, @Nullable MinecraftServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void a(GameRuleKey<T> gamerules_gamerulekey, GameRuleDefinition<T> gamerules_gameruledefinition) {
        }

        default public void b(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey, GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition) {
        }

        default public void c(GameRuleKey<GameRuleInt> gamerules_gamerulekey, GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition) {
        }
    }

    private static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

