/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockAccess
extends LevelHeightAccessor {
    @Nullable
    public TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition blockposition, TileEntityTypes<T> tileentitytypes) {
        TileEntity tileentity = this.c_(blockposition);
        return tileentity != null && tileentity.u() == tileentitytypes ? Optional.of(tileentity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int h(BlockPosition blockposition) {
        return this.a_(blockposition).h();
    }

    default public int M() {
        return 15;
    }

    default public Stream<IBlockData> a(AxisAlignedBB axisalignedbb) {
        return BlockPosition.a(axisalignedbb).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext clipblockstatecontext) {
        return IBlockAccess.a(clipblockstatecontext.b(), clipblockstatecontext.a(), clipblockstatecontext, (clipblockstatecontext1, blockposition) -> {
            IBlockData iblockdata = this.a_((BlockPosition)blockposition);
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return clipblockstatecontext1.c().test(iblockdata) ? new MovingObjectPositionBlock(clipblockstatecontext1.a(), EnumDirection.a(vec3d.c, vec3d.d, vec3d.e), BlockPosition.a(clipblockstatecontext1.a()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return MovingObjectPositionBlock.a(clipblockstatecontext1.a(), EnumDirection.a(vec3d.c, vec3d.d, vec3d.e), BlockPosition.a(clipblockstatecontext1.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace raytrace1, BlockPosition blockposition) {
        IBlockData iblockdata = this.a_(blockposition);
        Fluid fluid = this.b_(blockposition);
        Vec3D vec3d = raytrace1.b();
        Vec3D vec3d1 = raytrace1.a();
        VoxelShape voxelshape = raytrace1.a(iblockdata, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock = this.a(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.a(fluid, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock1 = voxelshape1.a(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock.e());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock1.e());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public MovingObjectPositionBlock a(RayTrace raytrace) {
        return IBlockAccess.a(raytrace.b(), raytrace.a(), raytrace, (raytrace1, blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition), raytrace1 -> {
            Vec3D vec3d = raytrace1.b().d(raytrace1.a());
            return MovingObjectPositionBlock.a(raytrace1.a(), EnumDirection.a(vec3d.c, vec3d.d, vec3d.e), BlockPosition.a(raytrace1.a()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock a(Vec3D vec3d, Vec3D vec3d1, BlockPosition blockposition, VoxelShape voxelshape, IBlockData iblockdata) {
        MovingObjectPositionBlock movingobjectpositionblock1;
        MovingObjectPositionBlock movingobjectpositionblock = voxelshape.a(vec3d, vec3d1, blockposition);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = iblockdata.m(this, blockposition).a(vec3d, vec3d1, blockposition)) != null && movingobjectpositionblock1.e().d(vec3d).g() < movingobjectpositionblock.e().d(vec3d).g()) {
            return movingobjectpositionblock.a(movingobjectpositionblock1.b());
        }
        return movingobjectpositionblock;
    }

    default public double a(VoxelShape voxelshape, Supplier<VoxelShape> supplier) {
        if (!voxelshape.b()) {
            return voxelshape.c(EnumDirection.EnumAxis.b);
        }
        double d0 = supplier.get().c(EnumDirection.EnumAxis.b);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double i(BlockPosition blockposition) {
        return this.a(this.a_(blockposition).k(this, blockposition), () -> {
            BlockPosition blockposition1 = blockposition.d();
            return this.a_(blockposition1).k(this, blockposition1);
        });
    }

    public static <T, C> T a(Vec3D vec3d, Vec3D vec3d1, C c0, BiFunction<C, BlockPosition, T> bifunction, Function<C, T> function) {
        T object;
        int k2;
        int j2;
        if (vec3d.equals(vec3d1)) {
            return function.apply(c0);
        }
        double d0 = MathHelper.d(-1.0E-7, vec3d1.c, vec3d.c);
        double d1 = MathHelper.d(-1.0E-7, vec3d1.d, vec3d.d);
        double d2 = MathHelper.d(-1.0E-7, vec3d1.e, vec3d.e);
        double d3 = MathHelper.d(-1.0E-7, vec3d.c, vec3d1.c);
        double d4 = MathHelper.d(-1.0E-7, vec3d.d, vec3d1.d);
        double d5 = MathHelper.d(-1.0E-7, vec3d.e, vec3d1.e);
        int i2 = MathHelper.a(d3);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, j2 = MathHelper.a(d4), k2 = MathHelper.a(d5));
        T t0 = bifunction.apply(c0, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l2 = MathHelper.j(d6);
        int i1 = MathHelper.j(d7);
        int j1 = MathHelper.j(d8);
        double d9 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l2 > 0 ? 1.0 - MathHelper.e(d3) : MathHelper.e(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.e(d4) : MathHelper.e(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - MathHelper.e(d5) : MathHelper.e(d5));
        do {
            if (d12 > 1.0 && d13 > 1.0 && d14 > 1.0) {
                return function.apply(c0);
            }
            if (d12 < d13) {
                if (d12 < d14) {
                    i2 += l2;
                    d12 += d9;
                    continue;
                }
                k2 += j1;
                d14 += d11;
                continue;
            }
            if (d13 < d14) {
                j2 += i1;
                d13 += d10;
                continue;
            }
            k2 += j1;
            d14 += d11;
        } while ((object = bifunction.apply(c0, blockposition_mutableblockposition.d(i2, j2, k2))) == null);
        return object;
    }
}

