/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface ICollisionAccess
extends IBlockAccess {
    public WorldBorder w_();

    @Nullable
    public IBlockAccess c(int var1, int var2);

    default public boolean a(@Nullable Entity var0, VoxelShape var1) {
        return true;
    }

    default public boolean a(IBlockData var0, BlockPosition var1, VoxelShapeCollision var2) {
        VoxelShape var3 = var0.b((IBlockAccess)this, var1, var2);
        return var3.b() || this.a(null, var3.a((double)var1.u(), (double)var1.v(), (double)var1.w()));
    }

    default public boolean f(Entity var0) {
        return this.a(var0, VoxelShapes.a(var0.cE()));
    }

    default public boolean b(AxisAlignedBB var0) {
        return this.a(null, var0);
    }

    default public boolean g(Entity var0) {
        return this.a(var0, var0.cE());
    }

    default public boolean a(@Nullable Entity var0, AxisAlignedBB var1) {
        for (VoxelShape var3 : this.d(var0, var1)) {
            if (var3.b()) continue;
            return false;
        }
        if (!this.b(var0, var1).isEmpty()) {
            return false;
        }
        if (var0 != null) {
            VoxelShape var2 = this.g(var0, var1);
            return var2 == null || !VoxelShapes.c(var2, VoxelShapes.a(var1), OperatorBoolean.i);
        }
        return true;
    }

    public List<VoxelShape> b(@Nullable Entity var1, AxisAlignedBB var2);

    default public Iterable<VoxelShape> c(@Nullable Entity var0, AxisAlignedBB var1) {
        List<VoxelShape> var2 = this.b(var0, var1);
        Iterable var3 = this.d(var0, var1);
        return var2.isEmpty() ? var3 : Iterables.concat(var2, var3);
    }

    default public Iterable<VoxelShape> d(@Nullable Entity var0, AxisAlignedBB var1) {
        return () -> new VoxelShapeSpliterator<VoxelShape>(this, var0, var1, false, (var0, var1) -> var1);
    }

    @Nullable
    private VoxelShape g(Entity var0, AxisAlignedBB var1) {
        WorldBorder var2 = this.w_();
        return var2.a(var0, var1) ? var2.c() : null;
    }

    default public boolean e(@Nullable Entity var02, AxisAlignedBB var12) {
        VoxelShapeSpliterator<VoxelShape> var2 = new VoxelShapeSpliterator<VoxelShape>(this, var02, var12, true, (var0, var1) -> var1);
        while (var2.hasNext()) {
            if (((VoxelShape)var2.next()).b()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPosition> f(Entity var02, AxisAlignedBB var12) {
        BlockPosition var2 = null;
        double var3 = Double.MAX_VALUE;
        VoxelShapeSpliterator<BlockPosition> var5 = new VoxelShapeSpliterator<BlockPosition>(this, var02, var12, false, (var0, var1) -> var0);
        while (var5.hasNext()) {
            BlockPosition var6 = (BlockPosition)var5.next();
            double var7 = var6.b(var02.dg());
            if (!(var7 < var3) && (var7 != var3 || var2 != null && var2.i(var6) >= 0)) continue;
            var2 = var6.i();
            var3 = var7;
        }
        return Optional.ofNullable(var2);
    }

    default public Optional<Vec3D> a(@Nullable Entity var02, VoxelShape var1, Vec3D var2, double var3, double var5, double var7) {
        if (var1.b()) {
            return Optional.empty();
        }
        AxisAlignedBB var9 = var1.a().c(var3, var5, var7);
        VoxelShape var10 = StreamSupport.stream(this.d(var02, var9).spliterator(), false).filter(var0 -> this.w_() == null || this.w_().a(var0.a())).flatMap(var0 -> var0.d().stream()).map(var6 -> var6.c(var3 / 2.0, var5 / 2.0, var7 / 2.0)).map(VoxelShapes::a).reduce(VoxelShapes.a(), VoxelShapes::a);
        VoxelShape var11 = VoxelShapes.a(var1, var10, OperatorBoolean.e);
        return var11.a(var2);
    }
}

