/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_20_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.aH);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.aH, new MinecraftKey("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.aH, new MinecraftKey("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.aH, new MinecraftKey("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 24000;
    public static final int p = 20000000;
    public static final int q = -20000000;
    protected final List<TickingBlockEntity> r = Lists.newArrayList();
    protected final NeighborUpdater s;
    private final List<TickingBlockEntity> a = Lists.newArrayList();
    private boolean b;
    public final Thread c;
    private final boolean d;
    private int e;
    protected int t = RandomSource.a().f();
    protected final int u = 1013904223;
    protected float v;
    public float w;
    protected float x;
    public float y;
    public final RandomSource z = RandomSource.a();
    @Deprecated
    private final RandomSource f = RandomSource.b();
    private final ResourceKey<DimensionManager> D;
    private final Holder<DimensionManager> E;
    public final WorldDataMutable A;
    private final Supplier<GameProfilerFiller> F;
    public final boolean B;
    private final WorldBorder G;
    private final BiomeManager H;
    private final ResourceKey<World> I;
    private final IRegistryCustom J;
    private final DamageSources K;
    private long L;
    private final CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CapturedBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new HashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final SpigotTimings.WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, IRegistryCustom iregistrycustom, Holder<DimensionManager> holder, Supplier<GameProfilerFiller> supplier, boolean flag, boolean flag1, long i2, int j2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).g());
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        SpawnCategory[] spawnCategoryArray = SpawnCategory.values();
        int n2 = spawnCategoryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            SpawnCategory spawnCategory = spawnCategoryArray[n3];
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
            }
            ++n3;
        }
        this.F = supplier;
        this.A = worlddatamutable;
        this.E = holder;
        this.D = holder.e().orElseThrow(() -> new IllegalArgumentException("Dimension must be registered, got " + holder));
        DimensionManager dimensionmanager = holder.a();
        this.I = resourcekey;
        this.B = flag;
        this.G = dimensionmanager.k() != 1.0 ? new WorldBorder(){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.c = Thread.currentThread();
        this.H = new BiomeManager(this, i2);
        this.d = flag1;
        this.s = new CollectingNeighborUpdater(this, j2);
        this.J = iregistrycustom;
        this.K = new DamageSources(iregistrycustom);
        this.w_().world = (WorldServer)this;
        this.w_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
        this.timings = new SpigotTimings.WorldTimingsHandler(this);
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
    }

    @Override
    public boolean r_() {
        return this.B;
    }

    @Override
    @Nullable
    public MinecraftServer n() {
        return null;
    }

    public boolean j(BlockPosition blockposition) {
        return !this.r(blockposition) && World.D(blockposition);
    }

    public static boolean k(BlockPosition blockposition) {
        return !World.b(blockposition.v()) && World.D(blockposition);
    }

    private static boolean D(BlockPosition blockposition) {
        return blockposition.u() >= -30000000 && blockposition.w() >= -30000000 && blockposition.u() < 30000000 && blockposition.w() < 30000000;
    }

    private static boolean b(int i2) {
        return i2 < -20000000 || i2 >= 20000000;
    }

    public Chunk l(BlockPosition blockposition) {
        return this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public Chunk d(int i2, int j2) {
        return (Chunk)this.a(i2, j2, ChunkStatus.n);
    }

    @Override
    @Nullable
    public IChunkAccess a(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        IChunkAccess ichunkaccess = this.J().a(i2, j2, chunkstatus, flag);
        if (ichunkaccess == null && flag) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2) {
        return this.a(blockposition, iblockdata, i2, 512);
    }

    @Override
    public boolean a(BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        IBlockData iblockdata1;
        if (this.captureTreeGeneration) {
            CapturedBlockState blockstate = this.capturedBlockStates.get(blockposition);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, blockposition, i2);
                this.capturedBlockStates.put(blockposition.i(), blockstate);
            }
            blockstate.setData(iblockdata);
            return true;
        }
        if (this.r(blockposition)) {
            return false;
        }
        if (!this.B && this.af()) {
            return false;
        }
        Chunk chunk = this.l(blockposition);
        Block block = iblockdata.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(blockposition)) {
            CapturedBlockState blockstate = CapturedBlockState.getBlockState(this, blockposition, i2);
            this.capturedBlockStates.put(blockposition.i(), blockstate);
            captured = true;
        }
        if ((iblockdata1 = chunk.setBlockState(blockposition, iblockdata, (i2 & 0x40) != 0, (i2 & 0x400) == 0)) == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(blockposition);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(blockposition);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(blockposition, chunk, iblockdata1, iblockdata, iblockdata2, i2, j2);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(blockposition);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.B || (i2 & 4) == 0) && (this.B || chunk == null || chunk.D() != null && chunk.D().a(FullChunkStatus.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            }
            if ((i2 & 1) != 0) {
                this.b(blockposition, iblockdata1.b());
                if (!this.B && iblockdata.n()) {
                    this.c(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag) {
        Fluid fluid = this.b_(blockposition);
        return this.a(blockposition, fluid.g(), 3 | (flag ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition blockposition, boolean flag, @Nullable Entity entity, int i2) {
        boolean flag1;
        IBlockData iblockdata = this.a_(blockposition);
        if (iblockdata.i()) {
            return false;
        }
        Fluid fluid = this.b_(blockposition);
        if (!(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, blockposition, Block.i(iblockdata));
        }
        if (flag) {
            TileEntity tileentity = iblockdata.t() ? this.c_(blockposition) : null;
            Block.a(iblockdata, this, blockposition, tileentity, entity, ItemStack.b);
        }
        if (flag1 = this.a(blockposition, fluid.g(), 3, i2)) {
            this.a(GameEvent.f, blockposition, GameEvent.a.a(entity, iblockdata));
        }
        return flag1;
    }

    public void a(BlockPosition blockposition, IBlockData iblockdata) {
    }

    public boolean b(BlockPosition blockposition, IBlockData iblockdata) {
        return this.a(blockposition, iblockdata, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
    }

    public void a(BlockPosition blockposition, Block block) {
    }

    public void a(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
    }

    public void a(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
    }

    public void a(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
    }

    @Override
    public void a(EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition, BlockPosition blockposition1, int i2, int j2) {
        this.s.a(enumdirection, iblockdata, blockposition, blockposition1, i2, j2);
    }

    @Override
    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        int k2 = i2 >= -30000000 && j2 >= -30000000 && i2 < 30000000 && j2 < 30000000 ? (this.b(SectionPosition.a(i2), SectionPosition.a(j2)) ? this.d(SectionPosition.a(i2), SectionPosition.a(j2)).a(heightmap_type, i2 & 0xF, j2 & 0xF) + 1 : this.C_()) : this.t_() + 1;
        return k2;
    }

    @Override
    public LevelLightEngine s_() {
        return this.J().p();
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        CapturedBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (this.r(blockposition)) {
            return Blocks.nb.n();
        }
        Chunk chunk = this.d(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
        return chunk.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        if (this.r(blockposition)) {
            return FluidTypes.a.g();
        }
        Chunk chunk = this.l(blockposition);
        return chunk.b_(blockposition);
    }

    public boolean N() {
        return !this.x_().a() && this.e < 4;
    }

    public boolean O() {
        return !this.x_().a() && !this.N();
    }

    public void a(@Nullable Entity entity, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        EntityHuman entityhuman1;
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : null;
        this.a(entityhuman, blockposition, soundeffect, soundcategory, f2, f1);
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman, BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1);
    }

    public abstract void a(@Nullable EntityHuman var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.a(entityhuman, d0, d1, d2, BuiltInRegistries.c.d(soundeffect), soundcategory, f2, f1, i2);
    }

    public abstract void a(@Nullable EntityHuman var1, Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, d0, d1, d2, soundeffect, soundcategory, f2, f1, this.f.g());
    }

    public void a(@Nullable EntityHuman entityhuman, Entity entity, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.a(entityhuman, entity, BuiltInRegistries.c.d(soundeffect), soundcategory, f2, f1, this.f.g());
    }

    public void a(BlockPosition blockposition, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
        this.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, soundeffect, soundcategory, f2, f1, flag);
    }

    public void a(double d0, double d1, double d2, SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1, boolean flag) {
    }

    @Override
    public void a(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void a(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public void b(ParticleParam particleparam, boolean flag, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    public float a(float f2) {
        float f1 = this.f(f2);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity tickingblockentity) {
        (this.b ? this.a : this.r).add(tickingblockentity);
    }

    protected void P() {
        GameProfilerFiller gameprofilerfiller = this.ad();
        gameprofilerfiller.a("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.b = true;
        if (!this.a.isEmpty()) {
            this.r.addAll(this.a);
            this.a.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        int tilesThisCycle = 0;
        this.tileLimiter.initTick();
        while (tilesThisCycle < this.r.size() && (tilesThisCycle % 10 != 0 || this.tileLimiter.shouldContinue())) {
            this.tileTickPosition = this.tileTickPosition < this.r.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.r.get(this.tileTickPosition);
            if (tickingblockentity == null) {
                this.getCraftServer().getLogger().severe("Spigot has detected a null entity and has removed it, preventing a crash");
                --tilesThisCycle;
                this.r.remove(this.tileTickPosition--);
            } else if (tickingblockentity.b()) {
                --tilesThisCycle;
                this.r.remove(this.tileTickPosition--);
            } else if (this.m(tickingblockentity.c())) {
                tickingblockentity.a();
            }
            ++this.tileTickPosition;
            ++tilesThisCycle;
        }
        this.timings.tileEntityTick.stopTiming();
        this.b = false;
        gameprofilerfiller.c();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends Entity> void a(Consumer<T> consumer, T t0) {
        try {
            SpigotTimings.tickEntityTimer.startTiming();
            consumer.accept(t0);
            SpigotTimings.tickEntityTimer.stopTiming();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking entity");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being ticked");
            t0.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    public boolean h(Entity entity) {
        return true;
    }

    public boolean a(long i2) {
        return true;
    }

    public boolean m(BlockPosition blockposition) {
        return this.a(ChunkCoordIntPair.a(blockposition));
    }

    public Explosion a(@Nullable Entity entity, double d0, double d1, double d2, float f2, a world_a) {
        return this.a(entity, null, null, d0, d1, d2, f2, false, world_a);
    }

    public Explosion a(@Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.a(entity, null, null, d0, d1, d2, f2, flag, world_a);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, Vec3D vec3d, float f2, boolean flag, a world_a) {
        return this.a(entity, damagesource, explosiondamagecalculator, vec3d.a(), vec3d.b(), vec3d.c(), f2, flag, world_a);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a) {
        return this.a(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, true);
    }

    public Explosion a(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, a world_a, boolean flag1) {
        Explosion.Effect explosion_effect1 = switch (world_a) {
            case net.minecraft.world.level.World$a.a -> Explosion.Effect.a;
            case net.minecraft.world.level.World$a.b -> this.a(GameRules.M);
            case net.minecraft.world.level.World$a.c -> this.X().b(GameRules.c) ? this.a(GameRules.N) : Explosion.Effect.a;
            case net.minecraft.world.level.World$a.d -> this.a(GameRules.O);
            default -> throw new IncompatibleClassChangeError();
        };
        Explosion explosion = new Explosion(this, entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, explosion_effect1);
        explosion.a();
        explosion.a(flag1);
        return explosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> gamerules_gamerulekey) {
        return this.X().b(gamerules_gamerulekey) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    public abstract String F();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.getBlockEntity(blockposition, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        if (this.capturedTileEntities.containsKey(blockposition)) {
            return this.capturedTileEntities.get(blockposition);
        }
        return this.r(blockposition) ? null : (!this.B && Thread.currentThread() != this.c ? null : this.l(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.p();
        if (!this.r(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.i(), tileentity);
                return;
            }
            this.l(blockposition).b(tileentity);
        }
    }

    public void n(BlockPosition blockposition) {
        if (!this.r(blockposition)) {
            this.l(blockposition).d(blockposition);
        }
    }

    public boolean o(BlockPosition blockposition) {
        return this.r(blockposition) ? false : this.J().b(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
    }

    public boolean a(BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
        if (this.r(blockposition)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()), ChunkStatus.n, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(blockposition).a((IBlockAccess)this, blockposition, entity, enumdirection);
    }

    public boolean a(BlockPosition blockposition, Entity entity) {
        return this.a(blockposition, entity, EnumDirection.b);
    }

    public void Q() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.e = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void b(boolean flag, boolean flag1) {
        this.J().a(flag, flag1);
    }

    public BlockPosition R() {
        BlockPosition blockposition = new BlockPosition(this.A.a(), this.A.b(), this.A.c());
        if (!this.w_().a(blockposition)) {
            blockposition = this.a(HeightMap.Type.e, BlockPosition.a(this.w_().a(), 0.0, this.w_().b()));
        }
        return blockposition;
    }

    public float S() {
        return this.A.d();
    }

    protected void T() {
        if (this.A.k()) {
            this.w = 1.0f;
            if (this.A.i()) {
                this.y = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.J().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int i2, int j2) {
        return this.a(i2, j2, ChunkStatus.n, false);
    }

    @Override
    public List<Entity> a(@Nullable Entity entity, AxisAlignedBB axisalignedbb, Predicate<? super Entity> predicate) {
        this.ad().d("getEntities");
        ArrayList list = Lists.newArrayList();
        this.E().a(axisalignedbb, (T entity1) -> {
            if (entity1 != entity && predicate.test((Entity)entity1)) {
                list.add(entity1);
            }
            if (entity1 instanceof EntityEnderDragon) {
                EntityComplexPart[] aentitycomplexpart = ((EntityEnderDragon)entity1).fV();
                int i2 = aentitycomplexpart.length;
                int j2 = 0;
                while (j2 < i2) {
                    EntityComplexPart entitycomplexpart = aentitycomplexpart[j2];
                    if (entity1 != entity && predicate.test(entitycomplexpart)) {
                        list.add(entitycomplexpart);
                    }
                    ++j2;
                }
            }
        });
        return list;
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entitytypetest, axisalignedbb, predicate, list);
        return list;
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list) {
        this.a(entitytypetest, axisalignedbb, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void a(EntityTypeTest<Entity, T> entitytypetest, AxisAlignedBB axisalignedbb, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.ad().d("getEntities");
        this.E().a(entitytypetest, axisalignedbb, (U entity) -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                EntityComplexPart[] aentitycomplexpart = entityenderdragon.fV();
                int j2 = aentitycomplexpart.length;
                int k2 = 0;
                while (k2 < j2) {
                    EntityComplexPart entitycomplexpart = aentitycomplexpart[k2];
                    Entity t0 = (Entity)entitytypetest.a(entitycomplexpart);
                    if (t0 != null && predicate.test(t0)) {
                        list.add((Object)t0);
                        if (list.size() >= i2) {
                            return AbortableIterationConsumer.a.b;
                        }
                    }
                    ++k2;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    @Nullable
    public abstract Entity a(int var1);

    public void p(BlockPosition blockposition) {
        if (this.A(blockposition)) {
            this.l(blockposition).a(true);
        }
    }

    @Override
    public int t_() {
        return 63;
    }

    public void U() {
    }

    public long V() {
        return this.A.e();
    }

    public long W() {
        return this.A.f();
    }

    public boolean a(EntityHuman entityhuman, BlockPosition blockposition) {
        return true;
    }

    public void a(Entity entity, byte b0) {
    }

    public void a(Entity entity, DamageSource damagesource) {
    }

    public void a(BlockPosition blockposition, Block block, int i2, int j2) {
        this.a_(blockposition).a(this, blockposition, i2, j2);
    }

    @Override
    public WorldData u_() {
        return this.A;
    }

    public GameRules X() {
        return this.A.q();
    }

    public float b(float f2) {
        return MathHelper.i(f2, this.x, this.y) * this.d(f2);
    }

    public void c(float f2) {
        float f1;
        this.x = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.y = f1;
    }

    public float d(float f2) {
        return MathHelper.i(f2, this.v, this.w);
    }

    public void e(float f2) {
        float f1;
        this.v = f1 = MathHelper.a(f2, 0.0f, 1.0f);
        this.w = f1;
    }

    public boolean Y() {
        return this.x_().g() && !this.x_().h() ? (double)this.b(1.0f) > 0.9 : false;
    }

    public boolean Z() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean q(BlockPosition blockposition) {
        if (!this.Z()) {
            return false;
        }
        if (!this.g(blockposition)) {
            return false;
        }
        if (this.a(HeightMap.Type.e, blockposition).v() > blockposition.v()) {
            return false;
        }
        BiomeBase biomebase = this.s(blockposition).a();
        return biomebase.a(blockposition) == BiomeBase.Precipitation.b;
    }

    @Nullable
    public abstract WorldMap a(String var1);

    public abstract void a(String var1, WorldMap var2);

    public abstract int t();

    public void b(int i2, BlockPosition blockposition, int j2) {
    }

    public CrashReportSystemDetails a(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            int i2 = this.v().size();
            return String.valueOf(i2) + " total; " + this.v();
        });
        IChunkProvider ichunkprovider = this.J();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.ac().a().toString());
        try {
            this.A.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double d0, double d1, double d2, double d3, double d4, double d5, @Nullable NBTTagCompound nbttagcompound) {
    }

    public abstract Scoreboard I();

    public void c(BlockPosition blockposition, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            if (!this.A(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.gY)) {
                this.a(iblockdata, blockposition1, block, blockposition, false);
                continue;
            }
            if (!iblockdata.g(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.gY)) continue;
            this.a(iblockdata, blockposition1, block, blockposition, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition blockposition) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.A(blockposition)) {
            f2 = this.an();
            i2 = this.l(blockposition).u();
        }
        return new DifficultyDamageScaler(this.ai(), this.W(), i2, f2);
    }

    @Override
    public int v_() {
        return this.e;
    }

    public void c(int i2) {
    }

    @Override
    public WorldBorder w_() {
        return this.G;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager x_() {
        return this.E.a();
    }

    public ResourceKey<DimensionManager> aa() {
        return this.D;
    }

    public Holder<DimensionManager> ab() {
        return this.E;
    }

    public ResourceKey<World> ac() {
        return this.I;
    }

    @Override
    public RandomSource y_() {
        return this.z;
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition blockposition, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(blockposition));
    }

    public abstract CraftingManager q();

    public BlockPosition a(int i2, int j2, int k2, int l2) {
        this.t = this.t * 3 + 1013904223;
        int i1 = this.t >> 2;
        return new BlockPosition(i2 + (i1 & 0xF), j2 + (i1 >> 16 & l2), k2 + (i1 >> 8 & 0xF));
    }

    public boolean r() {
        return false;
    }

    public GameProfilerFiller ad() {
        return this.F.get();
    }

    public Supplier<GameProfilerFiller> ae() {
        return this.F;
    }

    @Override
    public BiomeManager z_() {
        return this.H;
    }

    public final boolean af() {
        return this.d;
    }

    public abstract LevelEntityGetter<Entity> E();

    @Override
    public long A_() {
        return this.L++;
    }

    @Override
    public IRegistryCustom B_() {
        return this.J;
    }

    public DamageSources ag() {
        return this.K;
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

