/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class BlockRespawnAnchor
extends Block {
    public static final int a = 0;
    public static final int b = 4;
    public static final BlockStateInteger c = BlockProperties.aZ;
    private static final ImmutableList<BaseBlockPosition> d = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> e = new ImmutableList.Builder().addAll(d).addAll(d.stream().map(BaseBlockPosition::o).iterator()).addAll(d.stream().map(BaseBlockPosition::p).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public BlockRespawnAnchor(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)this.C.b()).a(c, 0));
    }

    @Override
    public EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        EntityPlayer entityplayer;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (enumhand == EnumHand.a && !BlockRespawnAnchor.a(itemstack) && BlockRespawnAnchor.a(entityhuman.b(EnumHand.b))) {
            return EnumInteractionResult.d;
        }
        if (BlockRespawnAnchor.a(itemstack) && BlockRespawnAnchor.h(iblockdata)) {
            BlockRespawnAnchor.a(entityhuman, world, blockposition, iblockdata);
            if (!entityhuman.fO().d) {
                itemstack.h(1);
            }
            return EnumInteractionResult.a(world.B);
        }
        if (iblockdata.c(c) == 0) {
            return EnumInteractionResult.d;
        }
        if (!BlockRespawnAnchor.a(world)) {
            if (!world.B) {
                this.d(iblockdata, world, blockposition);
            }
            return EnumInteractionResult.a(world.B);
        }
        if (!(world.B || (entityplayer = (EntityPlayer)entityhuman).P() == world.ac() && blockposition.equals(entityplayer.N()))) {
            entityplayer.setRespawnPosition(world.ac(), blockposition, 0.0f, false, true, PlayerSpawnChangeEvent.Cause.RESPAWN_ANCHOR);
            world.a(null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.tM, SoundCategory.e, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.b;
    }

    private static boolean a(ItemStack itemstack) {
        return itemstack.a(Items.eY);
    }

    private static boolean h(IBlockData iblockdata) {
        return iblockdata.c(c) < 4;
    }

    private static boolean a(BlockPosition blockposition, World world) {
        Fluid fluid = world.b_(blockposition);
        if (!fluid.a(TagsFluid.a)) {
            return false;
        }
        if (fluid.b()) {
            return true;
        }
        float f2 = fluid.e();
        if (f2 < 2.0f) {
            return false;
        }
        Fluid fluid1 = world.b_(blockposition.d());
        return !fluid1.a(TagsFluid.a);
    }

    private void d(IBlockData iblockdata, World world, final BlockPosition blockposition) {
        world.a(blockposition, false);
        Stream<EnumDirection> stream = EnumDirection.EnumDirectionLimit.a.a();
        Objects.requireNonNull(blockposition);
        boolean flag = stream.map(blockposition::a).anyMatch(blockposition1 -> BlockRespawnAnchor.a(blockposition1, world));
        final boolean flag1 = flag || world.b_(blockposition.c()).a(TagsFluid.a);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(){

            @Override
            public Optional<Float> a(Explosion explosion, IBlockAccess iblockaccess, BlockPosition blockposition1, IBlockData iblockdata1, Fluid fluid) {
                return blockposition1.equals(blockposition) && flag1 ? Optional.of(Float.valueOf(Blocks.G.d())) : super.a(explosion, iblockaccess, blockposition1, iblockdata1, fluid);
            }
        };
        Vec3D vec3d = blockposition.b();
        world.a(null, world.ag().a(vec3d), explosiondamagecalculator, vec3d, 5.0f, true, World.a.b);
    }

    public static boolean a(World world) {
        return world.x_().m();
    }

    public static void a(@Nullable Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = (IBlockData)iblockdata.a(c, iblockdata.c(c) + 1);
        world.a(blockposition, iblockdata1, 3);
        world.a(GameEvent.c, blockposition, GameEvent.a.a(entity, iblockdata1));
        world.a(null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.tK, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(c) != 0) {
            if (randomsource.a(100) == 0) {
                world.a(null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.tJ, SoundCategory.e, 1.0f, 1.0f);
            }
            double d0 = (double)blockposition.u() + 0.5 + (0.5 - randomsource.j());
            double d1 = (double)blockposition.v() + 1.0;
            double d2 = (double)blockposition.w() + 0.5 + (0.5 - randomsource.j());
            double d3 = (double)randomsource.i() * 0.04;
            world.a(Particles.aB, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{c});
    }

    @Override
    public boolean d_(IBlockData iblockdata) {
        return true;
    }

    public static int a(IBlockData iblockdata, int i2) {
        return MathHelper.d((float)(iblockdata.c(c) - 0) / 4.0f * (float)i2);
    }

    @Override
    public int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return BlockRespawnAnchor.a(iblockdata, 15);
    }

    public static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition) {
        Optional<Vec3D> optional = BlockRespawnAnchor.a(entitytypes, icollisionaccess, blockposition, true);
        return optional.isPresent() ? optional : BlockRespawnAnchor.a(entitytypes, icollisionaccess, blockposition, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entitytypes, ICollisionAccess icollisionaccess, BlockPosition blockposition, boolean flag) {
        Vec3D vec3d;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        UnmodifiableIterator unmodifiableiterator = e.iterator();
        do {
            if (!unmodifiableiterator.hasNext()) {
                return Optional.empty();
            }
            BaseBlockPosition baseblockposition = (BaseBlockPosition)unmodifiableiterator.next();
            blockposition_mutableblockposition.g(blockposition).h(baseblockposition);
        } while ((vec3d = DismountUtil.a(entitytypes, icollisionaccess, blockposition_mutableblockposition, flag)) == null);
        return Optional.of(vec3d);
    }

    @Override
    public boolean a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, PathMode pathmode) {
        return false;
    }
}

