/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SculkSensorBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final int b = 30;
    public static final int c = 10;
    public static final BlockStateEnum<SculkSensorPhase> d = BlockProperties.bo;
    public static final BlockStateInteger e = BlockProperties.aT;
    public static final BlockStateBoolean f = BlockProperties.C;
    protected static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final float[] a = SystemUtils.a(new float[16], (T afloat) -> {
        int[] nArray = new int[16];
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 6;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 10;
        nArray[8] = 12;
        nArray[9] = 14;
        nArray[10] = 15;
        nArray[11] = 18;
        nArray[12] = 19;
        nArray[13] = 21;
        nArray[14] = 22;
        nArray[15] = 24;
        int[] aint = nArray;
        int i2 = 0;
        while (i2 < 16) {
            afloat[i2] = BlockNote.b(aint[i2]);
            ++i2;
        }
    });

    public SculkSensorBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).a(d, SculkSensorPhase.a)).a(e, 0)).a(f, false));
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        BlockPosition blockposition = blockactioncontext.a();
        Fluid fluid = blockactioncontext.q().b_(blockposition);
        return (IBlockData)this.n().a(f, fluid.a() == FluidTypes.c);
    }

    @Override
    public Fluid c_(IBlockData iblockdata) {
        return iblockdata.c(f) != false ? FluidTypes.c.a(false) : super.c_(iblockdata);
    }

    @Override
    public void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (SculkSensorBlock.h(iblockdata) != SculkSensorPhase.b) {
            if (SculkSensorBlock.h(iblockdata) == SculkSensorPhase.c) {
                worldserver.a(blockposition, (IBlockData)iblockdata.a(d, SculkSensorPhase.a), 3);
                if (!iblockdata.c(f).booleanValue()) {
                    worldserver.a(null, blockposition, SoundEffects.uu, SoundCategory.e, 1.0f, worldserver.z.i() * 0.2f + 0.8f);
                }
            }
        } else {
            SculkSensorBlock.a((World)worldserver, blockposition, iblockdata);
        }
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, net.minecraft.world.entity.Entity entity) {
        if (!world.r_() && SculkSensorBlock.n(iblockdata) && entity.ae() != EntityTypes.bi) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            TileEntity tileentity = world.c_(blockposition);
            if (tileentity instanceof SculkSensorBlockEntity) {
                SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    if (sculksensorblockentity.gc().a(worldserver, blockposition, GameEvent.Q, GameEvent.a.a(iblockdata))) {
                        sculksensorblockentity.g().b(worldserver, GameEvent.Q, GameEvent.a.a(entity), entity.dg());
                    }
                }
            }
        }
        super.a(world, blockposition, iblockdata, entity);
    }

    @Override
    public void b(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!(world.r_() || iblockdata.a(iblockdata1.b()) || iblockdata.c(e) <= 0 || world.L().a(blockposition, this))) {
            world.a(blockposition, (IBlockData)iblockdata.a(e, 0), 18);
        }
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.a(iblockdata1.b())) {
            if (SculkSensorBlock.h(iblockdata) == SculkSensorPhase.b) {
                SculkSensorBlock.b(world, blockposition, iblockdata);
            }
            super.a(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    public IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(f).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    private static void b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        Block block = iblockdata.b();
        world.a(blockposition, block);
        world.a(blockposition.d(), block);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new SculkSensorBlockEntity(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return !world.B ? SculkSensorBlock.a(tileentitytypes, TileEntityTypes.I, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculksensorblockentity) -> VibrationSystem.c.a(world1, sculksensorblockentity.gb(), sculksensorblockentity.gc())) : null;
    }

    @Override
    public EnumRenderType b_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    @Override
    public VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return g;
    }

    @Override
    public boolean f_(IBlockData iblockdata) {
        return true;
    }

    @Override
    public int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(e);
    }

    @Override
    public int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.b ? iblockdata.b(iblockaccess, blockposition, enumdirection) : 0;
    }

    public static SculkSensorPhase h(IBlockData iblockdata) {
        return iblockdata.c(d);
    }

    public static boolean n(IBlockData iblockdata) {
        return SculkSensorBlock.h(iblockdata) == SculkSensorPhase.a;
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.c(e).intValue(), 0);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0) {
            world.a(blockposition, (IBlockData)iblockdata.a(e, eventRedstone.getNewCurrent()), 3);
            return;
        }
        world.a(blockposition, (IBlockData)((IBlockData)iblockdata.a(d, SculkSensorPhase.c)).a(e, 0), 3);
        world.a(blockposition, iblockdata.b(), 10);
        SculkSensorBlock.b(world, blockposition, iblockdata);
    }

    @VisibleForTesting
    public int b() {
        return 30;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition blockposition, IBlockData iblockdata, int i2, int j2) {
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), iblockdata.c(e).intValue(), i2);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        i2 = eventRedstone.getNewCurrent();
        world.a(blockposition, (IBlockData)((IBlockData)iblockdata.a(d, SculkSensorPhase.b)).a(e, i2), 3);
        world.a(blockposition, iblockdata.b(), this.b());
        SculkSensorBlock.b(world, blockposition, iblockdata);
        SculkSensorBlock.a(entity, world, blockposition, j2);
        world.a(entity, GameEvent.M, blockposition);
        if (!iblockdata.c(f).booleanValue()) {
            world.a(null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.ut, SoundCategory.e, 1.0f, world.z.i() * 0.2f + 0.8f);
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition blockposition, int i2) {
        EnumDirection[] aenumdirection = EnumDirection.values();
        int j2 = aenumdirection.length;
        int k2 = 0;
        while (k2 < j2) {
            EnumDirection enumdirection = aenumdirection[k2];
            BlockPosition blockposition1 = blockposition.a(enumdirection);
            IBlockData iblockdata = world.a_(blockposition1);
            if (iblockdata.a(TagsBlock.bM)) {
                world.a(VibrationSystem.b(i2), blockposition1, GameEvent.a.a(entity, iblockdata));
                float f2 = a[i2];
                world.a(null, blockposition1, SoundEffects.I, SoundCategory.e, 1.0f, f2);
            }
            ++k2;
        }
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        EnumDirection enumdirection;
        if (SculkSensorBlock.h(iblockdata) == SculkSensorPhase.b && (enumdirection = EnumDirection.b(randomsource)) != EnumDirection.b && enumdirection != EnumDirection.a) {
            double d0 = (double)blockposition.u() + 0.5 + (enumdirection.j() == 0 ? 0.5 - randomsource.j() : (double)enumdirection.j() * 0.6);
            double d1 = (double)blockposition.v() + 0.25;
            double d2 = (double)blockposition.w() + 0.5 + (enumdirection.l() == 0 ? 0.5 - randomsource.j() : (double)enumdirection.l() * 0.6);
            double d3 = (double)randomsource.i() * 0.04;
            world.a(DustColorTransitionOptions.b, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(d, e, f);
    }

    @Override
    public boolean d_(IBlockData iblockdata) {
        return true;
    }

    @Override
    public int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof SculkSensorBlockEntity) {
            SculkSensorBlockEntity sculksensorblockentity = (SculkSensorBlockEntity)tileentity;
            return SculkSensorBlock.h(iblockdata) == SculkSensorPhase.b ? sculksensorblockentity.f() : 0;
        }
        return 0;
    }

    @Override
    public boolean a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, PathMode pathmode) {
        return false;
    }

    @Override
    public boolean g_(IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.a(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }
}

