/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    public long g;
    private int h;
    @Nullable
    public BlockPosition i;
    public boolean j;

    public TileEntityEndGateway(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.v, blockposition, iblockdata);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Age", this.g);
        if (this.i != null) {
            nbttagcompound.a("ExitPortal", GameProfileSerializer.a(this.i));
        }
        if (this.j) {
            nbttagcompound.a("ExactTeleport", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition;
        super.a(nbttagcompound);
        this.g = nbttagcompound.i("Age");
        if (nbttagcompound.b("ExitPortal", 10) && World.k(blockposition = GameProfileSerializer.b(nbttagcompound.p("ExitPortal")))) {
            this.i = blockposition;
        }
        this.j = nbttagcompound.q("ExactTeleport");
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        ++tileentityendgateway.g;
        if (tileentityendgateway.d()) {
            --tileentityendgateway.h;
        }
    }

    public static void b(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        boolean flag = tileentityendgateway.c();
        boolean flag1 = tileentityendgateway.d();
        ++tileentityendgateway.g;
        if (flag1) {
            --tileentityendgateway.h;
        } else {
            List<Entity> list = world.a(Entity.class, new AxisAlignedBB(blockposition), TileEntityEndGateway::a);
            if (!list.isEmpty()) {
                TileEntityEndGateway.a(world, blockposition, iblockdata, list.get(world.z.a(list.size())), tileentityendgateway);
            }
            if (tileentityendgateway.g % 2400L == 0L) {
                TileEntityEndGateway.c(world, blockposition, iblockdata, tileentityendgateway);
            }
        }
        if (flag != tileentityendgateway.c() || flag1 != tileentityendgateway.d()) {
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    public static boolean a(Entity entity) {
        return IEntitySelector.f.test(entity) && !entity.cT().as();
    }

    public boolean c() {
        return this.g < 200L;
    }

    public boolean d() {
        return this.h > 0;
    }

    public float a(float f2) {
        return MathHelper.a(((float)this.g + f2) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float f2) {
        return 1.0f - MathHelper.a(((float)this.h - f2) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound ao_() {
        return this.o();
    }

    private static void c(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        if (!world.B) {
            tileentityendgateway.h = 40;
            world.a(blockposition, iblockdata.b(), 1, 0);
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    @Override
    public boolean a_(int i2, int j2) {
        if (i2 == 1) {
            this.h = 40;
            return true;
        }
        return super.a_(i2, j2);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity, TileEntityEndGateway tileentityendgateway) {
        if (world instanceof WorldServer && !tileentityendgateway.d()) {
            BlockPosition blockposition1;
            WorldServer worldserver = (WorldServer)world;
            tileentityendgateway.h = 100;
            if (tileentityendgateway.i == null && world.getTypeKey() == WorldDimension.d) {
                blockposition1 = TileEntityEndGateway.a(worldserver, blockposition);
                blockposition1 = blockposition1.b(10);
                a.debug("Creating portal at {}", (Object)blockposition1);
                TileEntityEndGateway.a(worldserver, blockposition1, WorldGenEndGatewayConfiguration.a(blockposition, false));
                tileentityendgateway.i = blockposition1;
            }
            if (tileentityendgateway.i != null) {
                Entity entity1;
                BlockPosition blockPosition = blockposition1 = tileentityendgateway.j ? tileentityendgateway.i : TileEntityEndGateway.a(world, tileentityendgateway.i);
                if (entity instanceof EntityEnderPearl) {
                    Entity entity2 = ((EntityEnderPearl)entity).v();
                    if (entity2 instanceof EntityPlayer) {
                        CriterionTriggers.d.a((EntityPlayer)entity2, iblockdata);
                    }
                    if (entity2 != null) {
                        entity1 = entity2;
                        entity.ai();
                    } else {
                        entity1 = entity;
                    }
                } else {
                    entity1 = entity.cT();
                }
                if (entity1 instanceof EntityPlayer) {
                    CraftPlayer player = (CraftPlayer)entity1.getBukkitEntity();
                    Location location = CraftLocation.toBukkit(blockposition1, (org.bukkit.World)world.getWorld()).add(0.5, 0.5, 0.5);
                    location.setPitch(player.getLocation().getPitch());
                    location.setYaw(player.getLocation().getYaw());
                    PlayerTeleportEvent teleEvent = new PlayerTeleportEvent((Player)player, player.getLocation(), location, PlayerTeleportEvent.TeleportCause.END_GATEWAY);
                    Bukkit.getPluginManager().callEvent((Event)teleEvent);
                    if (teleEvent.isCancelled()) {
                        return;
                    }
                    entity1.aq();
                    ((EntityPlayer)entity1).c.teleport(teleEvent.getTo());
                    TileEntityEndGateway.c(world, blockposition, iblockdata, tileentityendgateway);
                    return;
                }
                entity1.aq();
                entity1.n((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
            }
            TileEntityEndGateway.c(world, blockposition, iblockdata, tileentityendgateway);
        }
    }

    private static BlockPosition a(World world, BlockPosition blockposition) {
        BlockPosition blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, blockposition.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)blockposition, (Object)blockposition1);
        return blockposition1.c();
    }

    private static BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = TileEntityEndGateway.b(worldserver, blockposition);
        Chunk chunk = TileEntityEndGateway.a((World)worldserver, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.a(chunk);
        if (blockposition1 == null) {
            BlockPosition blockposition2 = BlockPosition.a(vec3d.c + 0.5, 75.0, vec3d.e + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            worldserver.B_().c(Registries.as).flatMap(iregistry -> iregistry.b(EndFeatures.e)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(worldserver, worldserver.k().g(), RandomSource.a(blockposition2.a()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TileEntityEndGateway.a((IBlockAccess)worldserver, blockposition1, 16, true);
    }

    private static Vec3D b(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = new Vec3D(blockposition.u(), 0.0, blockposition.w()).d();
        boolean flag = true;
        Vec3D vec3d1 = vec3d.a(1024.0);
        int i2 = 16;
        while (!TileEntityEndGateway.a(worldserver, vec3d1) && i2-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(-16.0));
        }
        i2 = 16;
        while (TileEntityEndGateway.a(worldserver, vec3d1) && i2-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean a(WorldServer worldserver, Vec3D vec3d) {
        return TileEntityEndGateway.a((World)worldserver, vec3d).a() == -1;
    }

    private static BlockPosition a(IBlockAccess iblockaccess, BlockPosition blockposition, int i2, boolean flag) {
        BaseBlockPosition blockposition1 = null;
        int j2 = -i2;
        while (j2 <= i2) {
            int k2 = -i2;
            while (k2 <= i2) {
                if (j2 != 0 || k2 != 0 || flag) {
                    int l2 = iblockaccess.aj() - 1;
                    while (l2 > (blockposition1 == null ? iblockaccess.C_() : blockposition1.v())) {
                        BlockPosition blockposition2 = new BlockPosition(blockposition.u() + j2, l2, blockposition.w() + k2);
                        IBlockData iblockdata = iblockaccess.a_(blockposition2);
                        if (iblockdata.r(iblockaccess, blockposition2) && (flag || !iblockdata.a(Blocks.F))) {
                            blockposition1 = blockposition2;
                            break;
                        }
                        --l2;
                    }
                }
                ++k2;
            }
            ++j2;
        }
        return blockposition1 == null ? blockposition : blockposition1;
    }

    private static Chunk a(World world, Vec3D vec3d) {
        return world.d(MathHelper.a(vec3d.c / 16.0), MathHelper.a(vec3d.e / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.d(), 30, chunkcoordintpair.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.f(), i2, chunkcoordintpair.g());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.a(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.a_(blockposition3);
            BlockPosition blockposition4 = blockposition3.c();
            BlockPosition blockposition5 = blockposition3.b(2);
            if (!iblockdata.a(Blocks.fz) || chunk.a_(blockposition4).r(chunk, blockposition4) || chunk.a_(blockposition5).r(chunk, blockposition5)) continue;
            double d1 = blockposition3.c(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void a(WorldServer worldserver, BlockPosition blockposition, WorldGenEndGatewayConfiguration worldgenendgatewayconfiguration) {
        WorldGenerator.L.a(worldgenendgatewayconfiguration, worldserver, worldserver.k().g(), RandomSource.a(), blockposition);
    }

    @Override
    public boolean a(EnumDirection enumdirection) {
        return Block.a(this.q(), this.o, this.p(), enumdirection, this.p().a(enumdirection));
    }

    public int g() {
        int i2 = 0;
        EnumDirection[] aenumdirection = EnumDirection.values();
        int j2 = aenumdirection.length;
        int k2 = 0;
        while (k2 < j2) {
            EnumDirection enumdirection = aenumdirection[k2];
            i2 += this.a(enumdirection) ? 1 : 0;
            ++k2;
        }
        return i2;
    }

    public void a(BlockPosition blockposition, boolean flag) {
        this.j = flag;
        this.i = blockposition;
    }
}

