/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeHolder,
AutoRecipeOutput {
    protected static final int c = 0;
    protected static final int d = 1;
    protected static final int e = 2;
    public static final int f = 0;
    private static final int[] r = new int[1];
    private static final int[] s = new int[]{2, 1};
    private static final int[] t = new int[]{1};
    public static final int g = 1;
    public static final int h = 2;
    public static final int i = 3;
    public static final int j = 4;
    public static final int k = 200;
    public static final int l = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> m;
    public int u;
    int v;
    public int w;
    public int x;
    protected final IContainerProperties n;
    public final Object2IntOpenHashMap<MinecraftKey> y;
    private final CraftingManager.a<IInventory, ? extends RecipeCooking> z;
    private int maxStack = 64;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata, Recipes<? extends RecipeCooking> recipes) {
        super(tileentitytypes, blockposition, iblockdata);
        this.m = NonNullList.a(3, net.minecraft.world.item.ItemStack.b);
        this.n = new IContainerProperties(){

            @Override
            public int a(int i2) {
                switch (i2) {
                    case 0: {
                        return TileEntityFurnace.this.u;
                    }
                    case 1: {
                        return TileEntityFurnace.this.v;
                    }
                    case 2: {
                        return TileEntityFurnace.this.w;
                    }
                    case 3: {
                        return TileEntityFurnace.this.x;
                    }
                }
                return 0;
            }

            @Override
            public void a(int i2, int j2) {
                switch (i2) {
                    case 0: {
                        TileEntityFurnace.this.u = j2;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.v = j2;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.w = j2;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.x = j2;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.y = new Object2IntOpenHashMap();
        this.z = CraftingManager.b(recipes);
    }

    public static Map<Item, Integer> f() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.pM, 20000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iB, 16000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.rr, 2400);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nI, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nJ, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.r, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.C, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.b, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.w, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.i, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.hU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.j, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.jC, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.n, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.m, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.k, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.l, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.aY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cl, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cm, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.oa, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.dT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cv, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.gV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cA, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.gZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.E, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nG, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.qh, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cO, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.ap, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.aE, 800);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nY, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nX, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.ob, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oa, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nZ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.h, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.am, 1200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.a, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.d, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oB, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.p, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oC, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.g, 67);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.me, 4001);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.uZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mZ, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.bv, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nS, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nX, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ob, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.pc, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.rx, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ry, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ac, 300);
        return map;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.m;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ac_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.y;
    }

    private static boolean b(Item item) {
        return item.j().a(TagsItem.ag);
    }

    private static void a(Map<Item, Integer> map, TagKey<Item> tagkey, int i2) {
        for (Holder<Item> holder : BuiltInRegistries.i.c(tagkey)) {
            if (TileEntityFurnace.b(holder.a())) continue;
            map.put(holder.a(), i2);
        }
    }

    private static void a(Map<Item, Integer> map, IMaterial imaterial, int i2) {
        Item item = imaterial.k();
        if (TileEntityFurnace.b(item)) {
            if (SharedConstants.aS) {
                throw SystemUtils.b(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.m(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, i2);
        }
    }

    private boolean i() {
        return this.u > 0;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.m = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.b);
        ContainerUtil.b(nbttagcompound, this.m);
        this.u = nbttagcompound.g("BurnTime");
        this.w = nbttagcompound.g("CookTime");
        this.x = nbttagcompound.g("CookTimeTotal");
        this.v = this.a(this.m.get(1));
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("RecipesUsed");
        for (String s2 : nbttagcompound1.e()) {
            this.y.put((Object)new MinecraftKey(s2), nbttagcompound1.h(s2));
        }
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("BurnTime", (short)this.u);
        nbttagcompound.a("CookTime", (short)this.w);
        nbttagcompound.a("CookTimeTotal", (short)this.x);
        ContainerUtil.a(nbttagcompound, this.m);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.y.forEach((minecraftkey, integer) -> nbttagcompound1.a(minecraftkey.toString(), (int)integer));
        nbttagcompound.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityFurnace tileentityfurnace) {
        boolean flag3;
        boolean flag = tileentityfurnace.i();
        boolean flag1 = false;
        if (tileentityfurnace.i()) {
            --tileentityfurnace.u;
        }
        net.minecraft.world.item.ItemStack itemstack = tileentityfurnace.m.get(1);
        boolean flag2 = !tileentityfurnace.m.get(0).b();
        boolean bl = flag3 = !itemstack.b();
        if (!(tileentityfurnace.i() || flag3 && flag2)) {
            if (!tileentityfurnace.i() && tileentityfurnace.w > 0) {
                tileentityfurnace.w = MathHelper.a(tileentityfurnace.w - 2, 0, tileentityfurnace.x);
            }
        } else {
            IRecipe irecipe = flag2 ? (IRecipe)tileentityfurnace.z.a(tileentityfurnace, world).orElse(null) : null;
            int i2 = tileentityfurnace.ac_();
            if (!tileentityfurnace.i() && TileEntityFurnace.a(world.B_(), irecipe, tileentityfurnace.m, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)fuel, tileentityfurnace.a(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                tileentityfurnace.v = tileentityfurnace.u = furnaceBurnEvent.getBurnTime();
                if (tileentityfurnace.i() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3) {
                        Item item = itemstack.d();
                        itemstack.h(1);
                        if (itemstack.b()) {
                            Item item1 = item.s();
                            tileentityfurnace.m.set(1, item1 == null ? net.minecraft.world.item.ItemStack.b : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (tileentityfurnace.i() && TileEntityFurnace.a(world.B_(), irecipe, tileentityfurnace.m, i2)) {
                if (irecipe != null && tileentityfurnace.w == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(tileentityfurnace.m.get(0));
                    CookingRecipe recipe = (CookingRecipe)irecipe.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, recipe);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    tileentityfurnace.x = event.getTotalCookTime();
                }
                ++tileentityfurnace.w;
                if (tileentityfurnace.w == tileentityfurnace.x) {
                    tileentityfurnace.w = 0;
                    tileentityfurnace.x = TileEntityFurnace.a(world, tileentityfurnace);
                    if (TileEntityFurnace.burn(tileentityfurnace.o, tileentityfurnace.p, world.B_(), irecipe, tileentityfurnace.m, i2)) {
                        tileentityfurnace.a(irecipe);
                    }
                    flag1 = true;
                }
            } else {
                tileentityfurnace.w = 0;
            }
        }
        if (flag != tileentityfurnace.i()) {
            flag1 = true;
            iblockdata = (IBlockData)iblockdata.a(BlockFurnace.b, tileentityfurnace.i());
            world.a(blockposition, iblockdata, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, blockposition, iblockdata);
        }
    }

    private static boolean a(IRegistryCustom iregistrycustom, @Nullable IRecipe<?> irecipe, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (!nonnulllist.get(0).b() && irecipe != null) {
            net.minecraft.world.item.ItemStack itemstack = irecipe.a(iregistrycustom);
            if (itemstack.b()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(2);
            return itemstack1.b() ? true : (!net.minecraft.world.item.ItemStack.b(itemstack1, itemstack) ? false : (itemstack1.L() < i2 && itemstack1.L() < itemstack1.g() ? true : itemstack1.L() < itemstack.g()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable IRecipe<?> irecipe, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (irecipe != null && TileEntityFurnace.a(iregistrycustom, irecipe, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = irecipe.a(iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.b()) {
                if (itemstack2.b()) {
                    nonnulllist.set(2, itemstack1.p());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.L());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aP.k()) && !nonnulllist.get(1).b() && nonnulllist.get(1).a(Items.pK)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.pL));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int a(net.minecraft.world.item.ItemStack itemstack) {
        if (itemstack.b()) {
            return 0;
        }
        Item item = itemstack.d();
        return TileEntityFurnace.f().getOrDefault(item, 0);
    }

    private static int a(World world, TileEntityFurnace tileentityfurnace) {
        return world != null ? tileentityfurnace.z.a(tileentityfurnace, world).map(RecipeCooking::d).orElse(200) : 200;
    }

    public static boolean b(net.minecraft.world.item.ItemStack itemstack) {
        return TileEntityFurnace.f().containsKey(itemstack.d());
    }

    @Override
    public int[] a(EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a ? s : (enumdirection == EnumDirection.b ? r : t);
    }

    @Override
    public boolean a(int i2, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return this.b(i2, itemstack);
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a && i2 == 1 ? itemstack.a(Items.pL) || itemstack.a(Items.pK) : true;
    }

    @Override
    public int b() {
        return this.m.size();
    }

    @Override
    public boolean ab_() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.m.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int i2) {
        return this.m.get(i2);
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int i2, int j2) {
        return ContainerUtil.a(this.m, i2, j2);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(int i2) {
        return ContainerUtil.a(this.m, i2);
    }

    @Override
    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(i2);
        boolean flag = !itemstack.b() && net.minecraft.world.item.ItemStack.c(itemstack1, itemstack);
        this.m.set(i2, itemstack);
        if (itemstack.L() > this.ac_()) {
            itemstack.f(this.ac_());
        }
        if (i2 == 0 && !flag) {
            this.x = TileEntityFurnace.a(this.o, this);
            this.w = 0;
            this.e();
        }
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return IInventory.a(this, entityhuman);
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 == 2) {
            return false;
        }
        if (i2 != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(1);
        return TileEntityFurnace.b(itemstack) || itemstack.a(Items.pK) && !itemstack1.a(Items.pK);
    }

    @Override
    public void a() {
        this.m.clear();
    }

    @Override
    public void a(@Nullable IRecipe<?> irecipe) {
        if (irecipe != null) {
            MinecraftKey minecraftkey = irecipe.e();
            this.y.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public IRecipe<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman entityhuman, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<IRecipe<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.x(), entityplayer.dg(), this.p, entityplayer, itemstack, amount);
        entityplayer.a((Collection<IRecipe<?>>)list);
        for (IRecipe<?> irecipe : list) {
            if (irecipe == null) continue;
            entityplayer.a(irecipe, this.m);
        }
        this.y.clear();
    }

    public List<IRecipe<?>> a(WorldServer worldserver, Vec3D vec3d) {
        return this.getRecipesToAwardAndPopExperience(worldserver, vec3d, this.p, null, null, 0);
    }

    public List<IRecipe<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.y.object2IntEntrySet()) {
            worldserver.q().a((MinecraftKey)entry.getKey()).ifPresent(irecipe -> {
                list.add(irecipe);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)irecipe).b(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.h((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftMagicNumbers.getMaterial(itemstack.d()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.a(worldserver, vec3d, j2);
    }

    @Override
    public void a(AutoRecipeStackManager autorecipestackmanager) {
        for (net.minecraft.world.item.ItemStack itemstack : this.m) {
            autorecipestackmanager.b(itemstack);
        }
    }
}

