/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int f = 8;
    public static final int g = 5;
    private NonNullList<net.minecraft.world.item.ItemStack> j;
    private int k = -1;
    private long l;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.j;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ac_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.r, blockposition, iblockdata);
        this.j = NonNullList.a(5, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.j = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.b);
        if (!this.d(nbttagcompound)) {
            ContainerUtil.b(nbttagcompound, this.j);
        }
        this.k = nbttagcompound.h("TransferCooldown");
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (!this.e(nbttagcompound)) {
            ContainerUtil.a(nbttagcompound, this.j);
        }
        nbttagcompound.a("TransferCooldown", this.k);
    }

    @Override
    public int b() {
        return this.j.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int i2, int j2) {
        this.e((EntityHuman)null);
        return ContainerUtil.a(this.f(), i2, j2);
    }

    @Override
    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.e((EntityHuman)null);
        this.f().set(i2, itemstack);
        if (itemstack.L() > this.ac_()) {
            itemstack.f(this.ac_());
        }
    }

    @Override
    protected IChatBaseComponent g() {
        return IChatBaseComponent.c("container.hopper");
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper) {
        --tileentityhopper.k;
        tileentityhopper.l = world.V();
        if (!tileentityhopper.j()) {
            tileentityhopper.c(0);
            boolean result = TileEntityHopper.a(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.a(world, tileentityhopper));
            if (!result && tileentityhopper.o.spigotConfig.hopperCheck > 1) {
                tileentityhopper.c(tileentityhopper.o.spigotConfig.hopperCheck);
            }
        }
    }

    private static boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper, BooleanSupplier booleansupplier) {
        if (world.B) {
            return false;
        }
        if (!tileentityhopper.j() && iblockdata.c(BlockHopper.b).booleanValue()) {
            boolean flag = false;
            if (!tileentityhopper.ab_()) {
                flag = TileEntityHopper.ejectItems(world, blockposition, iblockdata, tileentityhopper, tileentityhopper);
            }
            if (!tileentityhopper.i()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                tileentityhopper.c(world.spigotConfig.hopperTransfer);
                TileEntityHopper.a(world, blockposition, iblockdata);
                return true;
            }
        }
        return false;
    }

    private boolean i() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.j.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b() && itemstack.L() == itemstack.g());
        return false;
    }

    private static boolean ejectItems(World world, BlockPosition blockposition, IBlockData iblockdata, IInventory iinventory, TileEntityHopper hopper) {
        IInventory iinventory1 = TileEntityHopper.b(world, blockposition, iblockdata);
        if (iinventory1 == null) {
            return false;
        }
        EnumDirection enumdirection = iblockdata.c(BlockHopper.a).g();
        if (TileEntityHopper.b(iinventory1, enumdirection)) {
            return false;
        }
        int i2 = 0;
        while (i2 < iinventory.b()) {
            if (!iinventory.a(i2).b()) {
                net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2).p();
                CraftItemStack oitemstack = CraftItemStack.asCraftMirror(iinventory.a(i2, world.spigotConfig.hopperAmount));
                Object destinationInventory = iinventory1 instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory1) : (iinventory1.getOwner() != null ? iinventory1.getOwner().getInventory() : new CraftInventory(iinventory));
                InventoryMoveItemEvent event = new InventoryMoveItemEvent(iinventory.getOwner().getInventory(), (ItemStack)oitemstack.clone(), (Inventory)destinationInventory, true);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    hopper.a(i2, itemstack);
                    hopper.c(world.spigotConfig.hopperTransfer);
                    return false;
                }
                int origCount = event.getItem().getAmount();
                net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a(iinventory, iinventory1, CraftItemStack.asNMSCopy(event.getItem()), enumdirection);
                if (itemstack1.b()) {
                    iinventory1.e();
                    return true;
                }
                itemstack.h(origCount - itemstack1.L());
                iinventory.a(i2, itemstack);
            }
            ++i2;
        }
        return false;
    }

    private static IntStream a(IInventory iinventory, EnumDirection enumdirection) {
        return iinventory instanceof IWorldInventory ? IntStream.of(((IWorldInventory)iinventory).a(enumdirection)) : IntStream.range(0, iinventory.b());
    }

    private static boolean b(IInventory iinventory, EnumDirection enumdirection) {
        return TileEntityHopper.a(iinventory, enumdirection).allMatch(i2 -> {
            net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
            return itemstack.L() >= itemstack.g();
        });
    }

    private static boolean c(IInventory iinventory, EnumDirection enumdirection) {
        return TileEntityHopper.a(iinventory, enumdirection).allMatch(i2 -> iinventory.a(i2).b());
    }

    public static boolean a(World world, IHopper ihopper) {
        EntityItem entityitem;
        IInventory iinventory = TileEntityHopper.c(world, ihopper);
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.a;
            return TileEntityHopper.c(iinventory, enumdirection) ? false : TileEntityHopper.a(iinventory, enumdirection).anyMatch(i2 -> TileEntityHopper.a(ihopper, iinventory, i2, enumdirection, world));
        }
        Iterator<EntityItem> iterator = TileEntityHopper.b(world, ihopper).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!TileEntityHopper.a((IInventory)ihopper, entityitem = iterator.next()));
        return true;
    }

    private static boolean a(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
        if (!itemstack.b() && TileEntityHopper.a((IInventory)ihopper, iinventory, itemstack, i2, enumdirection)) {
            net.minecraft.world.item.ItemStack itemstack1 = itemstack.p();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(iinventory.a(i2, world.spigotConfig.hopperAmount));
            Object sourceInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent((Inventory)sourceInventory, (ItemStack)oitemstack.clone(), ihopper.getOwner().getInventory(), false);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                iinventory.a(i2, itemstack1);
                if (ihopper instanceof TileEntityHopper) {
                    ((TileEntityHopper)ihopper).c(world.spigotConfig.hopperTransfer);
                }
                return false;
            }
            int origCount = event.getItem().getAmount();
            net.minecraft.world.item.ItemStack itemstack2 = TileEntityHopper.a(iinventory, ihopper, CraftItemStack.asNMSCopy(event.getItem()), null);
            if (itemstack2.b()) {
                iinventory.e();
                return true;
            }
            itemstack1.h(origCount - itemstack2.L());
            iinventory.a(i2, itemstack1);
        }
        return false;
    }

    public static boolean a(IInventory iinventory, EntityItem entityitem) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(iinventory.getOwner().getInventory(), (Item)entityitem.getBukkitEntity());
        entityitem.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = entityitem.j().p();
        net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a(null, iinventory, itemstack, null);
        if (itemstack1.b()) {
            flag = true;
            entityitem.ai();
        } else {
            entityitem.a(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack a(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        if (iinventory1 instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)iinventory1;
            if (enumdirection != null) {
                int[] aint = iworldinventory.a(enumdirection);
                int i2 = 0;
                while (i2 < aint.length && !itemstack.b()) {
                    itemstack = TileEntityHopper.b(iinventory, iinventory1, itemstack, aint[i2], enumdirection);
                    ++i2;
                }
                return itemstack;
            }
        }
        int j2 = iinventory1.b();
        int i3 = 0;
        while (i3 < j2 && !itemstack.b()) {
            itemstack = TileEntityHopper.b(iinventory, iinventory1, itemstack, i3, enumdirection);
            ++i3;
        }
        return itemstack;
    }

    private static boolean a(IInventory iinventory, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory.b(i2, itemstack)) {
            return false;
        }
        if (iinventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory).a(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean a(IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory1.a(iinventory, i2, itemstack)) {
            return false;
        }
        if (iinventory1 instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory1).b(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static net.minecraft.world.item.ItemStack b(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        net.minecraft.world.item.ItemStack itemstack1 = iinventory1.a(i2);
        if (TileEntityHopper.a(iinventory1, itemstack, i2, enumdirection)) {
            boolean flag = false;
            boolean flag1 = iinventory1.ab_();
            if (itemstack1.b()) {
                if (!itemstack.b() && itemstack.L() > iinventory1.ac_()) {
                    itemstack = itemstack.a(iinventory1.ac_());
                }
                iinventory1.a(i2, itemstack);
                itemstack = net.minecraft.world.item.ItemStack.b;
                flag = true;
            } else if (TileEntityHopper.a(itemstack1, itemstack)) {
                int j2 = itemstack.g() - itemstack1.L();
                int k2 = Math.min(itemstack.L(), j2);
                itemstack.h(k2);
                itemstack1.g(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && iinventory1 instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)iinventory1).v()) {
                    int b0 = 0;
                    if (iinventory instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)iinventory;
                        if (tileentityhopper.l >= tileentityhopper1.l) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.c(tileentityhopper.o.spigotConfig.hopperTransfer - b0);
                }
                iinventory1.e();
            }
        }
        return itemstack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = iblockdata.c(BlockHopper.a);
        BlockPosition searchPosition = blockposition.a(enumdirection);
        IInventory inventory = TileEntityHopper.a(world, blockposition.a(enumdirection));
        CraftBlock hopper = CraftBlock.at(world, blockposition);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory c(World world, IHopper ihopper) {
        IInventory inventory = TileEntityHopper.a(world, ihopper.G(), ihopper.I() + 1.0, ihopper.J());
        BlockPosition blockPosition = BlockPosition.a(ihopper.G(), ihopper.I(), ihopper.J());
        CraftBlock hopper = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.c());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> b(World world, IHopper ihopper) {
        return ihopper.aq_().d().stream().flatMap(axisalignedbb -> world.a(EntityItem.class, axisalignedbb.d(ihopper.G() - 0.5, ihopper.I() - 0.5, ihopper.J() - 0.5), IEntitySelector.a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory a(World world, BlockPosition blockposition) {
        return TileEntityHopper.a(world, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5);
    }

    @Nullable
    private static IInventory a(World world, double d0, double d1, double d2) {
        List<Entity> list;
        TileEntity tileentity;
        IInventory object = null;
        BlockPosition blockposition = BlockPosition.a(d0, d1, d2);
        if (!world.spigotConfig.hopperCanLoadChunks && !world.A(blockposition)) {
            return null;
        }
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof IInventoryHolder) {
            object = ((IInventoryHolder)((Object)block)).a(iblockdata, world, blockposition);
        } else if (iblockdata.t() && (tileentity = world.c_(blockposition)) instanceof IInventory && (object = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            object = BlockChest.a((BlockChest)block, iblockdata, world, blockposition, true);
        }
        if (object == null && !(list = world.a((Entity)null, new AxisAlignedBB(d0 - 0.5, d1 - 0.5, d2 - 0.5, d0 + 0.5, d1 + 0.5, d2 + 0.5), (Predicate<? super Entity>)IEntitySelector.d)).isEmpty()) {
            object = (IInventory)((Object)list.get(world.z.a(list.size())));
        }
        return object;
    }

    private static boolean a(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        return itemstack.L() <= itemstack.g() && net.minecraft.world.item.ItemStack.c(itemstack, itemstack1);
    }

    @Override
    public double G() {
        return (double)this.p.u() + 0.5;
    }

    @Override
    public double I() {
        return (double)this.p.v() + 0.5;
    }

    @Override
    public double J() {
        return (double)this.p.w() + 0.5;
    }

    private void c(int i2) {
        this.k = i2;
    }

    private boolean j() {
        return this.k > 0;
    }

    private boolean v() {
        return this.k > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.j;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.j = nonnulllist;
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity, TileEntityHopper tileentityhopper) {
        if (entity instanceof EntityItem && VoxelShapes.c(VoxelShapes.a(entity.cE().d(-blockposition.u(), -blockposition.v(), -blockposition.w())), tileentityhopper.aq_(), OperatorBoolean.i)) {
            TileEntityHopper.a(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.a((IInventory)tileentityhopper, (EntityItem)entity));
        }
    }

    @Override
    protected Container a(int i2, PlayerInventory playerinventory) {
        return new ContainerHopper(i2, playerinventory, this);
    }
}

