/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TileEntitySign
extends TileEntity
implements ICommandListener {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    @Nullable
    public UUID d;
    private SignText e = this.f();
    private SignText f = this.f();
    private boolean g;

    public TileEntitySign(BlockPosition blockposition, IBlockData iblockdata) {
        this((TileEntityTypes)TileEntityTypes.h, blockposition, iblockdata);
    }

    public TileEntitySign(TileEntityTypes tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        super(tileentitytypes, blockposition, iblockdata);
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman entityhuman) {
        Block block = this.q().b();
        if (block instanceof BlockSign) {
            float f1;
            BlockSign blocksign = (BlockSign)block;
            Vec3D vec3d = blocksign.h(this.q());
            double d0 = entityhuman.dn() - ((double)this.p().u() + vec3d.c);
            double d1 = entityhuman.dt() - ((double)this.p().w() + vec3d.e);
            float f2 = blocksign.g(this.q());
            return MathHelper.d(f2, f1 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText b(EntityHuman entityhuman) {
        return this.a(this.a(entityhuman));
    }

    public SignText a(boolean flag) {
        return flag ? this.e : this.f;
    }

    public SignText g() {
        return this.e;
    }

    public SignText i() {
        return this.f;
    }

    public int c() {
        return 10;
    }

    public int d() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = SignText.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e);
        Logger logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("front_text", (NBTBase)nbtbase));
        dataresult = SignText.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f);
        logger = a;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("back_text", (NBTBase)nbtbase));
        nbttagcompound.a("is_waxed", this.g);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        Logger logger;
        DataResult dataresult;
        super.a(nbttagcompound);
        if (nbttagcompound.e("front_text")) {
            dataresult = SignText.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.p("front_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.e = this.a((SignText)signtext);
            });
        }
        if (nbttagcompound.e("back_text")) {
            dataresult = SignText.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.p("back_text"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.f = this.a((SignText)signtext);
            });
        }
        this.g = nbttagcompound.q("is_waxed");
    }

    private SignText a(SignText signtext) {
        int i2 = 0;
        while (i2 < 4) {
            IChatBaseComponent ichatbasecomponent = this.a(signtext.a(i2, false));
            IChatBaseComponent ichatbasecomponent1 = this.a(signtext.a(i2, true));
            signtext = signtext.a(i2, ichatbasecomponent, ichatbasecomponent1);
            ++i2;
        }
        return signtext;
    }

    private IChatBaseComponent a(IChatBaseComponent ichatbasecomponent) {
        World world = this.o;
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a(null, (World)worldserver, this.p), ichatbasecomponent, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ichatbasecomponent;
    }

    public void a(EntityHuman entityhuman, boolean flag, List<FilteredText> list) {
        if (!this.w() && entityhuman.ct().equals(this.v()) && this.o != null) {
            this.a(signtext -> this.setMessages(entityhuman, list, (SignText)signtext, flag), flag);
            this.a((UUID)null);
            this.o.a(this.p(), this.q(), this.q(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)entityhuman.Z().getString());
            ((EntityPlayer)entityhuman).c.a(this.j());
        }
    }

    public boolean a(UnaryOperator<SignText> unaryoperator, boolean flag) {
        SignText signtext = this.a(flag);
        return this.a((SignText)unaryoperator.apply(signtext), flag);
    }

    private SignText setMessages(EntityHuman entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        int i2 = 0;
        while (i2 < list.size()) {
            FilteredText filteredtext = list.get(i2);
            ChatModifier chatmodifier = signtext.a(i2, entityhuman.U()).a();
            signtext = entityhuman.U() ? signtext.a(i2, IChatBaseComponent.b(filteredtext.b()).b(chatmodifier)) : signtext.a(i2, IChatBaseComponent.b(filteredtext.d()).b(chatmodifier), IChatBaseComponent.b(filteredtext.b()).b(chatmodifier));
            ++i2;
        }
        CraftPlayer player = ((EntityPlayer)entityhuman).getBukkitEntity();
        String[] lines = new String[4];
        int j2 = 0;
        while (j2 < list.size()) {
            lines[j2] = CraftChatMessage.fromComponent(signtext.a(j2, entityhuman.U()));
            ++j2;
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.o, this.p), (Player)player, lines, front ? Side.FRONT : Side.BACK);
        entityhuman.dI().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            IChatBaseComponent[] components = CraftSign.sanitizeLines(event.getLines());
            int j3 = 0;
            while (j3 < components.length) {
                signtext = signtext.a(j3, components[j3]);
                ++j3;
            }
        } else {
            signtext = originalText;
        }
        return signtext;
    }

    public boolean a(SignText signtext, boolean flag) {
        return flag ? this.c(signtext) : this.b(signtext);
    }

    private boolean b(SignText signtext) {
        if (signtext != this.f) {
            this.f = signtext;
            this.x();
            return true;
        }
        return false;
    }

    private boolean c(SignText signtext) {
        if (signtext != this.e) {
            this.e = signtext;
            this.x();
            return true;
        }
        return false;
    }

    public boolean a(boolean flag, EntityHuman entityhuman) {
        return this.w() && this.a(flag).b(entityhuman);
    }

    public boolean a(EntityHuman entityhuman, World world, BlockPosition blockposition, boolean flag) {
        boolean flag1 = false;
        IChatBaseComponent[] aichatbasecomponent = this.a(flag).b(entityhuman.U());
        int i2 = aichatbasecomponent.length;
        int j2 = 0;
        while (j2 < i2) {
            IChatBaseComponent ichatbasecomponent = aichatbasecomponent[j2];
            ChatModifier chatmodifier = ichatbasecomponent.a();
            ChatClickable chatclickable = chatmodifier.h();
            if (chatclickable != null && chatclickable.a() == ChatClickable.EnumClickAction.c) {
                entityhuman.cI().aC().a(this.a(entityhuman, world, blockposition), chatclickable.b());
                flag1 = true;
            }
            ++j2;
        }
        return flag1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent) {
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return wrapper.f() != null ? wrapper.f().getBukkitSender(wrapper) : new CraftBlockCommandSender(wrapper, this);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    public boolean q_() {
        return false;
    }

    @Override
    public boolean N_() {
        return false;
    }

    private CommandListenerWrapper a(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition) {
        String s2 = entityhuman == null ? "Sign" : entityhuman.Z().getString();
        IChatBaseComponent object = entityhuman == null ? IChatBaseComponent.b("Sign") : entityhuman.H_();
        return new CommandListenerWrapper(this, Vec3D.b(blockposition), Vec2F.a, (WorldServer)world, 2, s2, object, world.n(), entityhuman);
    }

    public PacketPlayOutTileEntityData j() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound ao_() {
        return this.o();
    }

    @Override
    public boolean t() {
        return true;
    }

    public void a(@Nullable UUID uuid) {
        this.d = uuid;
    }

    @Nullable
    public UUID v() {
        return this.d;
    }

    private void x() {
        this.e();
        if (this.o != null) {
            this.o.a(this.p(), this.q(), this.q(), 3);
        }
    }

    public boolean w() {
        return this.g;
    }

    public boolean b(boolean flag) {
        if (this.g != flag) {
            this.g = flag;
            this.x();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman entityhuman = this.o.b(uuid);
        return entityhuman == null || entityhuman.i(this.p().u(), this.p().v(), this.p().w()) > 64.0;
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntitySign tileentitysign) {
        UUID uuid = tileentitysign.v();
        if (uuid != null) {
            tileentitysign.a(tileentitysign, world, uuid);
        }
    }

    private void a(TileEntitySign tileentitysign, World world, UUID uuid) {
        if (tileentitysign.b(uuid)) {
            tileentitysign.a((UUID)null);
        }
    }
}

