/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] aD = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    protected final boolean aE;
    protected final float aF;
    protected final boolean aG;
    protected final SoundEffectType aH;
    protected final float aI;
    protected final float aJ;
    protected final float aK;
    protected final boolean aL;
    protected final FeatureFlagSet aM;
    protected final Info aN;
    @Nullable
    protected MinecraftKey aO;

    public BlockBase(Info blockbase_info) {
        this.aE = blockbase_info.b;
        this.aO = blockbase_info.l;
        this.aF = blockbase_info.e;
        this.aG = blockbase_info.h;
        this.aH = blockbase_info.c;
        this.aI = blockbase_info.i;
        this.aJ = blockbase_info.j;
        this.aK = blockbase_info.k;
        this.aL = blockbase_info.C;
        this.aM = blockbase_info.D;
        this.aN = blockbase_info;
    }

    @Deprecated
    public void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, PathMode pathmode) {
        switch (pathmode) {
            case a: {
                return !iblockdata.r(iblockaccess, blockposition);
            }
            case b: {
                return iblockaccess.b_(blockposition).a(TagsFluid.a);
            }
            case c: {
                return !iblockdata.r(iblockaccess, blockposition);
            }
        }
        return false;
    }

    @Deprecated
    public IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return iblockdata;
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        return false;
    }

    @Deprecated
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        PacketDebug.a(world, blockposition);
    }

    @Deprecated
    public void b(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        AsyncCatcher.catchOp("block onPlace");
    }

    @Deprecated
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        AsyncCatcher.catchOp("block remove");
        if (iblockdata.t() && !iblockdata.a(iblockdata1.b())) {
            world.n(blockposition);
        }
    }

    @Deprecated
    public EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        return EnumInteractionResult.d;
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        return false;
    }

    @Deprecated
    public EnumRenderType b_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    @Deprecated
    public boolean g_(IBlockData iblockdata) {
        return false;
    }

    @Deprecated
    public boolean f_(IBlockData iblockdata) {
        return false;
    }

    @Deprecated
    public Fluid c_(IBlockData iblockdata) {
        return FluidTypes.a.g();
    }

    @Deprecated
    public boolean d_(IBlockData iblockdata) {
        return false;
    }

    public float al_() {
        return 0.25f;
    }

    public float an_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet m() {
        return this.aM;
    }

    @Deprecated
    public IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return iblockdata;
    }

    @Deprecated
    public IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata;
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return iblockdata.r() && (blockactioncontext.n().b() || !blockactioncontext.n().a(this.k()));
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, FluidType fluidtype) {
        return iblockdata.r() || !iblockdata.e();
    }

    @Deprecated
    public List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        MinecraftKey minecraftkey = this.r();
        if (minecraftkey == LootTables.a) {
            return Collections.emptyList();
        }
        LootParams lootparams = lootparams_a.a(LootContextParameters.g, iblockdata).a(LootContextParameterSets.n);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.n().aH().getLootTable(minecraftkey);
        return loottable.a(lootparams);
    }

    @Deprecated
    public long a(IBlockData iblockdata, BlockPosition blockposition) {
        return MathHelper.a(blockposition);
    }

    @Deprecated
    public VoxelShape f(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.j(iblockaccess, blockposition);
    }

    @Deprecated
    public VoxelShape b_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return this.c(iblockdata, iblockaccess, blockposition, VoxelShapeCollision.a());
    }

    @Deprecated
    public VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.a();
    }

    @Deprecated
    public int g(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.i(iblockaccess, blockposition) ? iblockaccess.M() : (iblockdata.a(iblockaccess, blockposition) ? 0 : 1);
    }

    @Nullable
    @Deprecated
    public ITileInventory b(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return null;
    }

    @Deprecated
    public boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return true;
    }

    @Deprecated
    public float b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.r(iblockaccess, blockposition) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return 0;
    }

    @Deprecated
    public VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return VoxelShapes.b();
    }

    @Deprecated
    public VoxelShape c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.aE ? iblockdata.j(iblockaccess, blockposition) : VoxelShapes.a();
    }

    @Deprecated
    public boolean a_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return Block.a(iblockdata.k(iblockaccess, blockposition));
    }

    @Deprecated
    public boolean h(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return Block.a(iblockdata.c(iblockaccess, blockposition));
    }

    @Deprecated
    public VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.c(iblockdata, iblockaccess, blockposition, voxelshapecollision);
    }

    @Deprecated
    public void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        this.a(iblockdata, worldserver, blockposition, randomsource);
    }

    @Deprecated
    public void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
    }

    @Deprecated
    public float a(IBlockData iblockdata, EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
        float f2 = iblockdata.h(iblockaccess, blockposition);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = entityhuman.e(iblockdata) ? 30 : 100;
        return entityhuman.d(iblockdata) / f2 / (float)i2;
    }

    @Deprecated
    public void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
    }

    @Deprecated
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
    }

    @Deprecated
    public int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    @Deprecated
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
    }

    @Deprecated
    public int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    public final MinecraftKey r() {
        if (this.aO == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.f.b(this.p());
            this.aO = minecraftkey.d("blocks/");
        }
        return this.aO;
    }

    @Deprecated
    public void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
    }

    public abstract Item k();

    protected abstract Block p();

    public MaterialMapColor s() {
        return this.aN.a.apply(this.p().n());
    }

    public float t() {
        return this.aN.f;
    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private final int b;
        private final boolean g;
        private final boolean h;
        private final boolean i;
        @Deprecated
        private final boolean j;
        @Deprecated
        private boolean k;
        private final EnumPistonReaction l;
        private final MaterialMapColor m;
        public final float n;
        private final boolean o;
        private final boolean p;
        private final f q;
        private final f r;
        private final f s;
        private final f t;
        private final f u;
        private final Optional<b> v;
        private final boolean w;
        private final BlockPropertyInstrument x;
        private final boolean y;
        @Nullable
        protected Cache a;
        private Fluid z = FluidTypes.a.g();
        private boolean A;

        protected BlockData(Block block, ImmutableMap<IBlockState<?>, Comparable<?>> immutablemap, MapCodec<IBlockData> mapcodec) {
            super(block, immutablemap, mapcodec);
            Info blockbase_info = block.aN;
            this.b = blockbase_info.d.applyAsInt(this.x());
            this.g = block.g_(this.x());
            this.h = blockbase_info.n;
            this.i = blockbase_info.o;
            this.j = blockbase_info.p;
            this.l = blockbase_info.s;
            this.m = blockbase_info.a.apply(this.x());
            this.n = blockbase_info.f;
            this.o = blockbase_info.g;
            this.p = blockbase_info.m;
            this.q = blockbase_info.x;
            this.r = blockbase_info.y;
            this.s = blockbase_info.z;
            this.t = blockbase_info.A;
            this.u = blockbase_info.B;
            this.v = blockbase_info.E;
            this.w = blockbase_info.t;
            this.x = blockbase_info.u;
            this.y = blockbase_info.v;
        }

        private boolean D() {
            if (((Block)this.e).aN.r) {
                return true;
            }
            if (((Block)this.e).aN.q) {
                return false;
            }
            if (this.a == null) {
                return false;
            }
            VoxelShape voxelshape = this.a.b;
            if (voxelshape.b()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public void a() {
            this.z = ((Block)this.e).c_(this.x());
            this.A = ((Block)this.e).e_(this.x());
            if (!this.b().o()) {
                this.a = new Cache(this.x());
            }
            this.k = this.D();
        }

        public Block b() {
            return (Block)this.e;
        }

        public Holder<Block> c() {
            return ((Block)this.e).q();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bs && block != Blocks.mY && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.k;
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EntityTypes<?> entitytypes) {
            return this.b().aN.w.test(this.x(), iblockaccess, blockposition, entitytypes);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.g : this.b().c(this.x(), iblockaccess, blockposition);
        }

        public int b(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.h : this.b().g(this.x(), iblockaccess, blockposition);
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.a != null && this.a.i != null ? this.a.i[enumdirection.ordinal()] : VoxelShapes.a(this.c(iblockaccess, blockposition), enumdirection);
        }

        public VoxelShape c(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().f(this.x(), iblockaccess, blockposition);
        }

        public boolean f() {
            return this.a == null || this.a.c;
        }

        public boolean g() {
            return this.g;
        }

        public int h() {
            return this.b;
        }

        public boolean i() {
            return this.h;
        }

        public boolean j() {
            return this.i;
        }

        @Deprecated
        public boolean k() {
            return this.j;
        }

        public MaterialMapColor d(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.m;
        }

        public IBlockData a(EnumBlockRotation enumblockrotation) {
            return this.b().a(this.x(), enumblockrotation);
        }

        public IBlockData a(EnumBlockMirror enumblockmirror) {
            return this.b().a(this.x(), enumblockmirror);
        }

        public EnumRenderType l() {
            return this.b().b_(this.x());
        }

        public boolean e(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.u.test(this.x(), iblockaccess, blockposition);
        }

        public float f(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().b(this.x(), iblockaccess, blockposition);
        }

        public boolean g(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.q.test(this.x(), iblockaccess, blockposition);
        }

        public boolean m() {
            return this.b().f_(this.x());
        }

        public int b(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().a(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public boolean n() {
            return this.b().d_(this.x());
        }

        public int a(World world, BlockPosition blockposition) {
            return this.b().a(this.x(), world, blockposition);
        }

        public float h(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.n;
        }

        public float a(EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.x(), entityhuman, iblockaccess, blockposition);
        }

        public int c(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().b(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public EnumPistonReaction o() {
            return this.l;
        }

        public boolean i(IBlockAccess iblockaccess, BlockPosition blockposition) {
            if (this.a != null) {
                return this.a.a;
            }
            IBlockData iblockdata = this.x();
            return iblockdata.p() ? Block.a(iblockdata.c(iblockaccess, blockposition)) : false;
        }

        public boolean p() {
            return this.p;
        }

        public boolean a(IBlockData iblockdata, EnumDirection enumdirection) {
            return this.b().a(this.x(), iblockdata, enumdirection);
        }

        public VoxelShape j(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().a(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape k(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.b : this.b(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().c(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape l(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().b_(this.x(), iblockaccess, blockposition);
        }

        public VoxelShape c(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().b(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape m(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.x(), iblockaccess, blockposition);
        }

        public final boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity) {
            return this.a(iblockaccess, blockposition, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
            return Block.a(this.b(iblockaccess, blockposition, VoxelShapeCollision.a(entity)), enumdirection);
        }

        public Vec3D n(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.v.map(blockbase_b -> blockbase_b.evaluate(this.x(), iblockaccess, blockposition)).orElse(Vec3D.b);
        }

        public boolean q() {
            return !this.v.isEmpty();
        }

        public boolean a(World world, BlockPosition blockposition, int i2, int j2) {
            return this.b().a(this.x(), world, blockposition, i2, j2);
        }

        @Deprecated
        public void a(World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
            this.b().a(this.x(), world, blockposition, block, blockposition1, flag);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.a(generatoraccess, blockposition, i2, 512);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            EnumDirection[] aenumdirection = aD;
            int k2 = aenumdirection.length;
            int l2 = 0;
            while (l2 < k2) {
                EnumDirection enumdirection = aenumdirection[l2];
                blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection);
                generatoraccess.a(enumdirection.g(), this.x(), blockposition_mutableblockposition, blockposition, i2, j2);
                ++l2;
            }
        }

        public final void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.b(generatoraccess, blockposition, i2, 512);
        }

        public void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            this.b().a(this.x(), generatoraccess, blockposition, i2, j2);
        }

        public void a(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
            this.b().b(this.x(), world, blockposition, iblockdata, flag);
        }

        public void b(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
            this.b().a(this.x(), world, blockposition, iblockdata, flag);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().a(this.x(), worldserver, blockposition, randomsource);
        }

        public void b(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().b(this.x(), worldserver, blockposition, randomsource);
        }

        public void a(World world, BlockPosition blockposition, Entity entity) {
            this.b().a(this.x(), world, blockposition, entity);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
            this.b().a(this.x(), worldserver, blockposition, itemstack, flag);
        }

        public List<ItemStack> a(LootParams.a lootparams_a) {
            return this.b().a(this.x(), lootparams_a);
        }

        public EnumInteractionResult a(World world, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
            return this.b().a(this.x(), world, movingobjectpositionblock.a(), entityhuman, enumhand, movingobjectpositionblock);
        }

        public void a(World world, BlockPosition blockposition, EntityHuman entityhuman) {
            this.b().a(this.x(), world, blockposition, entityhuman);
        }

        public boolean o(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.r.test(this.x(), iblockaccess, blockposition);
        }

        public boolean p(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.s.test(this.x(), iblockaccess, blockposition);
        }

        public IBlockData a(EnumDirection enumdirection, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
            return this.b().a(this.x(), enumdirection, iblockdata, generatoraccess, blockposition, blockposition1);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, PathMode pathmode) {
            return this.b().a(this.x(), iblockaccess, blockposition, pathmode);
        }

        public boolean a(BlockActionContext blockactioncontext) {
            return this.b().a(this.x(), blockactioncontext);
        }

        public boolean a(FluidType fluidtype) {
            return this.b().a(this.x(), fluidtype);
        }

        public boolean r() {
            return this.y;
        }

        public boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return this.b().a(this.x(), iworldreader, blockposition);
        }

        public boolean q(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.t.test(this.x(), iblockaccess, blockposition);
        }

        @Nullable
        public ITileInventory b(World world, BlockPosition blockposition) {
            return this.b().b(this.x(), world, blockposition);
        }

        @Override
        public boolean a(TagKey<Block> tagkey) {
            return this.b().q().a(tagkey);
        }

        @Override
        public boolean a(TagKey<Block> tagkey, Predicate<BlockData> predicate) {
            return this.a(tagkey) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> holderset) {
            return holderset.a(this.b().q());
        }

        public Stream<TagKey<Block>> s() {
            return this.b().q().c();
        }

        public boolean t() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> tileentitytypes) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.x(), tileentitytypes) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        public Fluid u() {
            return this.z;
        }

        public boolean v() {
            return this.A;
        }

        public long a(BlockPosition blockposition) {
            return this.b().a(this.x(), blockposition);
        }

        public SoundEffectType w() {
            return this.b().m(this.x());
        }

        public void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
            this.b().a(world, iblockdata, movingobjectpositionblock, iprojectile);
        }

        public boolean d(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.a(iblockaccess, blockposition, enumdirection, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
            return this.a != null ? this.a.a(enumdirection, enumblocksupport) : enumblocksupport.a(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public boolean r(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.d : this.b().a_(this.x(), iblockaccess, blockposition);
        }

        protected abstract IBlockData x();

        public boolean y() {
            return this.o;
        }

        public boolean z() {
            return this.w;
        }

        public BlockPropertyInstrument A() {
            return this.x;
        }

        private static final class Cache {
            private static final EnumDirection[] e = EnumDirection.values();
            private static final int f = EnumBlockSupport.values().length;
            protected final boolean a;
            final boolean g;
            final int h;
            @Nullable
            final VoxelShape[] i;
            protected final VoxelShape b;
            protected final boolean c;
            private final boolean[] j;
            protected final boolean d;

            Cache(IBlockData iblockdata) {
                int i2;
                Block block = iblockdata.b();
                this.a = iblockdata.i(BlockAccessAir.a, BlockPosition.b);
                this.g = block.c(iblockdata, BlockAccessAir.a, BlockPosition.b);
                this.h = block.g(iblockdata, BlockAccessAir.a, BlockPosition.b);
                if (!iblockdata.p()) {
                    this.i = null;
                } else {
                    this.i = new VoxelShape[e.length];
                    VoxelShape voxelshape = block.f(iblockdata, BlockAccessAir.a, BlockPosition.b);
                    EnumDirection[] aenumdirection = e;
                    i2 = aenumdirection.length;
                    int j2 = 0;
                    while (j2 < i2) {
                        EnumDirection enumdirection = aenumdirection[j2];
                        this.i[enumdirection.ordinal()] = VoxelShapes.a(voxelshape, enumdirection);
                        ++j2;
                    }
                }
                this.b = block.c(iblockdata, BlockAccessAir.a, BlockPosition.b, VoxelShapeCollision.a());
                if (!this.b.b() && iblockdata.q()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.f.b(block)));
                }
                this.c = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.b.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.b.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.j = new boolean[e.length * f];
                EnumDirection[] aenumdirection1 = e;
                int k2 = aenumdirection1.length;
                i2 = 0;
                while (i2 < k2) {
                    EnumDirection enumdirection1 = aenumdirection1[i2];
                    EnumBlockSupport[] aenumblocksupport = EnumBlockSupport.values();
                    int l2 = aenumblocksupport.length;
                    int i1 = 0;
                    while (i1 < l2) {
                        EnumBlockSupport enumblocksupport = aenumblocksupport[i1];
                        this.j[Cache.b((EnumDirection)enumdirection1, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(iblockdata, BlockAccessAir.a, BlockPosition.b, enumdirection1);
                        ++i1;
                    }
                    ++i2;
                }
                this.d = Block.a(iblockdata.k(BlockAccessAir.a, BlockPosition.b));
            }

            public boolean a(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return this.j[Cache.b(enumdirection, enumblocksupport)];
            }

            private static int b(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return enumdirection.ordinal() * f + enumblocksupport.ordinal();
            }
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static class Info {
        Function<IBlockData, MaterialMapColor> a = iblockdata -> MaterialMapColor.a;
        boolean b = true;
        SoundEffectType c = SoundEffectType.f;
        ToIntFunction<IBlockData> d = iblockdata -> 0;
        float e;
        float f;
        boolean g;
        boolean h;
        float i = 0.6f;
        float j = 1.0f;
        float k = 1.0f;
        MinecraftKey l;
        boolean m = true;
        boolean n;
        boolean o;
        @Deprecated
        boolean p;
        @Deprecated
        boolean q;
        boolean r;
        EnumPistonReaction s = EnumPistonReaction.a;
        boolean t = true;
        BlockPropertyInstrument u = BlockPropertyInstrument.a;
        boolean v;
        e<EntityTypes<?>> w = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.d(iblockaccess, blockposition, EnumDirection.b) && iblockdata.h() < 14;
        f x = (iblockdata, iblockaccess, blockposition) -> iblockdata.r(iblockaccess, blockposition);
        f y;
        f z = this.y = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.r(iblockaccess, blockposition);
        f A = (iblockdata, iblockaccess, blockposition) -> false;
        f B = (iblockdata, iblockaccess, blockposition) -> false;
        boolean C;
        FeatureFlagSet D = FeatureFlags.e;
        Optional<b> E = Optional.empty();

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase blockbase) {
            Info blockbase_info = new Info();
            blockbase_info.f = blockbase.aN.f;
            blockbase_info.e = blockbase.aN.e;
            blockbase_info.b = blockbase.aN.b;
            blockbase_info.h = blockbase.aN.h;
            blockbase_info.d = blockbase.aN.d;
            blockbase_info.a = blockbase.aN.a;
            blockbase_info.c = blockbase.aN.c;
            blockbase_info.i = blockbase.aN.i;
            blockbase_info.j = blockbase.aN.j;
            blockbase_info.C = blockbase.aN.C;
            blockbase_info.m = blockbase.aN.m;
            blockbase_info.n = blockbase.aN.n;
            blockbase_info.o = blockbase.aN.o;
            blockbase_info.p = blockbase.aN.p;
            blockbase_info.q = blockbase.aN.q;
            blockbase_info.r = blockbase.aN.r;
            blockbase_info.s = blockbase.aN.s;
            blockbase_info.g = blockbase.aN.g;
            blockbase_info.E = blockbase.aN.E;
            blockbase_info.t = blockbase.aN.t;
            blockbase_info.D = blockbase.aN.D;
            blockbase_info.B = blockbase.aN.B;
            blockbase_info.u = blockbase.aN.u;
            blockbase_info.v = blockbase.aN.v;
            return blockbase_info;
        }

        public Info a(EnumColor enumcolor) {
            this.a = iblockdata -> enumcolor.e();
            return this;
        }

        public Info a(MaterialMapColor materialmapcolor) {
            this.a = iblockdata -> materialmapcolor;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> function) {
            this.a = function;
            return this;
        }

        public Info b() {
            this.b = false;
            this.m = false;
            return this;
        }

        public Info c() {
            this.m = false;
            return this;
        }

        public Info a(float f2) {
            this.i = f2;
            return this;
        }

        public Info b(float f2) {
            this.j = f2;
            return this;
        }

        public Info c(float f2) {
            this.k = f2;
            return this;
        }

        public Info a(SoundEffectType soundeffecttype) {
            this.c = soundeffecttype;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> tointfunction) {
            this.d = tointfunction;
            return this;
        }

        public Info a(float f2, float f1) {
            return this.e(f2).f(f1);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float f2) {
            this.a(f2, f2);
            return this;
        }

        public Info e() {
            this.h = true;
            return this;
        }

        public Info f() {
            this.C = true;
            return this;
        }

        public Info g() {
            this.l = LootTables.a;
            return this;
        }

        public Info a(Block block) {
            this.l = block.r();
            return this;
        }

        public Info h() {
            this.o = true;
            return this;
        }

        public Info i() {
            this.p = true;
            return this;
        }

        public Info j() {
            this.r = true;
            return this;
        }

        @Deprecated
        public Info k() {
            this.q = true;
            return this;
        }

        public Info a(EnumPistonReaction enumpistonreaction) {
            this.s = enumpistonreaction;
            return this;
        }

        public Info l() {
            this.n = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> blockbase_e) {
            this.w = blockbase_e;
            return this;
        }

        public Info a(f blockbase_f) {
            this.x = blockbase_f;
            return this;
        }

        public Info b(f blockbase_f) {
            this.y = blockbase_f;
            return this;
        }

        public Info c(f blockbase_f) {
            this.z = blockbase_f;
            return this;
        }

        public Info d(f blockbase_f) {
            this.A = blockbase_f;
            return this;
        }

        public Info e(f blockbase_f) {
            this.B = blockbase_f;
            return this;
        }

        public Info m() {
            this.g = true;
            return this;
        }

        public Info e(float f2) {
            this.f = f2;
            return this;
        }

        public Info f(float f2) {
            this.e = Math.max(0.0f, f2);
            return this;
        }

        public Info a(EnumRandomOffset blockbase_enumrandomoffset) {
            switch (blockbase_enumrandomoffset) {
                case c: {
                    this.E = Optional.of((iblockdata, iblockaccess, blockposition) -> {
                        Block block = iblockdata.b();
                        long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                        double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.an_();
                        float f2 = block.al_();
                        double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        return new Vec3D(d1, d0, d2);
                    });
                    break;
                }
                case b: {
                    this.E = Optional.of((iblockdata, iblockaccess, blockposition) -> {
                        Block block = iblockdata.b();
                        long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                        float f2 = block.al_();
                        double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                        return new Vec3D(d0, 0.0, d1);
                    });
                    break;
                }
                default: {
                    this.E = Optional.empty();
                }
            }
            return this;
        }

        public Info n() {
            this.t = false;
            return this;
        }

        public Info a(FeatureFlag ... afeatureflag) {
            this.D = FeatureFlags.c.a(afeatureflag);
            return this;
        }

        public Info a(BlockPropertyInstrument blockpropertyinstrument) {
            this.u = blockpropertyinstrument;
            return this;
        }

        public Info o() {
            this.v = true;
            return this;
        }
    }

    public static interface b {
        public Vec3D evaluate(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }

    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }
}

