/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess {
    static final Logger n = LogUtils.getLogger();
    private static final TickingBlockEntity o = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.b;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> p = Maps.newHashMap();
    public boolean q;
    public final WorldServer r;
    @Nullable
    private Supplier<FullChunkStatus> s;
    @Nullable
    private c t;
    private final Int2ObjectMap<GameEventListenerRegistry> u;
    private final LevelChunkTicks<Block> v;
    private final LevelChunkTicks<FluidType> w;
    public boolean mustNotSave;
    public boolean needsDecoration;

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair) {
        this(world, chunkcoordintpair, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World world, ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelChunkTicks<Block> levelchunkticks, LevelChunkTicks<FluidType> levelchunkticks1, long i2, @Nullable ChunkSection[] achunksection, @Nullable c chunk_c, @Nullable BlendingData blendingdata) {
        super(chunkcoordintpair, chunkconverter, world, world.B_().d(Registries.ap), i2, achunksection, blendingdata);
        this.r = (WorldServer)world;
        this.u = new Int2ObjectOpenHashMap();
        HeightMap.Type[] aheightmap_type = HeightMap.Type.values();
        int j2 = aheightmap_type.length;
        int k2 = 0;
        while (k2 < j2) {
            HeightMap.Type heightmap_type = aheightmap_type[k2];
            if (ChunkStatus.n.h().contains(heightmap_type)) {
                this.h.put(heightmap_type, new HeightMap(this, heightmap_type));
            }
            ++k2;
        }
        this.t = chunk_c;
        this.v = levelchunkticks;
        this.w = levelchunkticks1;
    }

    /*
     * WARNING - void declaration
     */
    public Chunk(WorldServer worldserver, ProtoChunk protochunk, @Nullable c chunk_c) {
        this(worldserver, protochunk.f(), protochunk.r(), protochunk.G(), protochunk.H(), protochunk.u(), protochunk.d(), chunk_c, protochunk.t());
        void var5_7;
        for (TileEntity tileEntity : protochunk.D().values()) {
            this.a(tileEntity);
        }
        this.j.putAll(protochunk.F());
        boolean bl = false;
        while (var5_7 < protochunk.n().length) {
            this.b[var5_7] = protochunk.n()[var5_7];
            ++var5_7;
        }
        this.a(protochunk.g());
        this.b(protochunk.h());
        for (Map.Entry entry : protochunk.e()) {
            if (!ChunkStatus.n.h().contains(entry.getKey())) continue;
            this.a((HeightMap.Type)entry.getKey(), ((HeightMap)entry.getValue()).a());
        }
        this.i = protochunk.i;
        this.b(protochunk.v());
        this.c = true;
        this.needsDecoration = true;
        this.persistentDataContainer = protochunk.persistentDataContainer;
    }

    @Override
    public TickContainerAccess<Block> o() {
        return this.v;
    }

    @Override
    public TickContainerAccess<FluidType> p() {
        return this.w;
    }

    @Override
    public IChunkAccess.a q() {
        return new IChunkAccess.a(this.v, this.w);
    }

    @Override
    public GameEventListenerRegistry a(int i2) {
        WorldServer world = this.r;
        if (world instanceof WorldServer) {
            WorldServer worldserver = world;
            return (GameEventListenerRegistry)this.u.computeIfAbsent(i2, j2 -> new EuclideanGameEventListenerRegistry(worldserver, i2, this::c));
        }
        return super.a(i2);
    }

    @Override
    public IBlockData a_(BlockPosition blockposition) {
        int i2 = blockposition.u();
        int j2 = blockposition.v();
        int k2 = blockposition.w();
        if (this.r.af()) {
            IBlockData iblockdata = null;
            if (j2 == 60) {
                iblockdata = Blocks.hW.n();
            }
            if (j2 == 70) {
                iblockdata = ChunkProviderDebug.a(i2, k2);
            }
            return iblockdata == null ? Blocks.a.n() : iblockdata;
        }
        try {
            ChunkSection chunksection;
            int l2 = this.e(j2);
            if (l2 >= 0 && l2 < this.m.length && !(chunksection = this.m[l2]).c()) {
                return chunksection.a(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return Blocks.a.n();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting block state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public Fluid b_(BlockPosition blockposition) {
        return this.a(blockposition.u(), blockposition.v(), blockposition.w());
    }

    public Fluid a(int i2, int j2, int k2) {
        try {
            ChunkSection chunksection;
            int l2 = this.e(j2);
            if (l2 >= 0 && l2 < this.m.length && !(chunksection = this.m[l2]).c()) {
                return chunksection.b(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return FluidTypes.a.g();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting fluid state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return this.setBlockState(blockposition, iblockdata, flag, true);
    }

    @Nullable
    public IBlockData setBlockState(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean doPlace) {
        int l2;
        int k2;
        int i2 = blockposition.v();
        ChunkSection chunksection = this.b(this.e(i2));
        boolean flag1 = chunksection.c();
        if (flag1 && iblockdata.i()) {
            return null;
        }
        int j2 = blockposition.u() & 0xF;
        IBlockData iblockdata1 = chunksection.a(j2, k2 = i2 & 0xF, l2 = blockposition.w() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.b();
        ((HeightMap)this.h.get(HeightMap.Type.e)).a(j2, i2, l2, iblockdata);
        ((HeightMap)this.h.get(HeightMap.Type.f)).a(j2, i2, l2, iblockdata);
        ((HeightMap)this.h.get(HeightMap.Type.d)).a(j2, i2, l2, iblockdata);
        ((HeightMap)this.h.get(HeightMap.Type.b)).a(j2, i2, l2, iblockdata);
        boolean flag2 = chunksection.c();
        if (flag1 != flag2) {
            this.r.k().a().a(blockposition, flag2);
        }
        if (LightEngine.a((IBlockAccess)this, blockposition, iblockdata1, iblockdata)) {
            GameProfilerFiller gameprofilerfiller = this.r.ad();
            gameprofilerfiller.a("updateSkyLightSources");
            this.i.a((IBlockAccess)this, j2, i2, l2);
            gameprofilerfiller.b("queueCheckLight");
            this.r.k().a().a(blockposition);
            gameprofilerfiller.c();
        }
        boolean flag3 = iblockdata1.t();
        if (!this.r.B) {
            iblockdata1.b(this.r, blockposition, iblockdata, flag);
        } else if (!iblockdata1.a(block) && flag3) {
            this.d(blockposition);
        }
        if (!chunksection.a(j2, k2, l2).a(block)) {
            return null;
        }
        if (!this.r.B && doPlace && (!this.r.captureBlockStates || block instanceof BlockTileEntity)) {
            iblockdata.a((World)this.r, blockposition, iblockdata1, flag);
        }
        if (iblockdata.t()) {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.c);
            if (tileentity == null) {
                tileentity = ((ITileEntity)((Object)block)).a(blockposition, iblockdata);
                if (tileentity != null) {
                    this.b(tileentity);
                }
            } else {
                tileentity.b(iblockdata);
                this.c(tileentity);
            }
        }
        this.c = true;
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity j(BlockPosition blockposition) {
        IBlockData iblockdata = this.a_(blockposition);
        return !iblockdata.t() ? null : ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition blockposition) {
        return this.a(blockposition, EnumTileEntityState.c);
    }

    @Nullable
    public TileEntity a(BlockPosition blockposition, EnumTileEntityState chunk_enumtileentitystate) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = (TileEntity)this.r.capturedTileEntities.get(blockposition);
        if (tileentity == null) {
            tileentity = (TileEntity)this.k.get(blockposition);
        }
        if (tileentity == null && (nbttagcompound = (NBTTagCompound)this.j.remove(blockposition)) != null && (tileentity1 = this.a(blockposition, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (chunk_enumtileentitystate == EnumTileEntityState.a && (tileentity = this.j(blockposition)) != null) {
                this.b(tileentity);
            }
        } else if (tileentity.r()) {
            this.k.remove(blockposition);
            return null;
        }
        return tileentity;
    }

    public void b(TileEntity tileentity) {
        this.a(tileentity);
        if (this.K()) {
            WorldServer world = this.r;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(tileentity, worldserver);
            }
            this.c(tileentity);
        }
    }

    private boolean K() {
        return this.q || this.r.r_();
    }

    boolean k(BlockPosition blockposition) {
        if (!this.r.w_().a(blockposition)) {
            return false;
        }
        WorldServer world = this.r;
        if (!(world instanceof WorldServer)) {
            return true;
        }
        WorldServer worldserver = world;
        return this.D().a(FullChunkStatus.c) && worldserver.c(ChunkCoordIntPair.a(blockposition));
    }

    @Override
    public void a(TileEntity tileentity) {
        BlockPosition blockposition = tileentity.p();
        if (this.a_(blockposition).t()) {
            tileentity.a(this.r);
            tileentity.s();
            TileEntity tileentity1 = this.k.put(blockposition.i(), tileentity);
            if (tileentity1 != null && tileentity1 != tileentity) {
                tileentity1.ap_();
            }
        } else {
            System.out.println("Attempted to place a tile entity (" + tileentity + ") at " + tileentity.p().u() + "," + tileentity.p().v() + "," + tileentity.p().w() + " (" + this.a_(blockposition) + ") where there was no entity tile!");
            System.out.println("Chunk coordinates: " + this.d.e * 16 + "," + this.d.f * 16);
            new Exception().printStackTrace();
        }
    }

    @Override
    @Nullable
    public NBTTagCompound g(BlockPosition blockposition) {
        TileEntity tileentity = this.c_(blockposition);
        if (tileentity != null && !tileentity.r()) {
            NBTTagCompound nbttagcompound = tileentity.m();
            nbttagcompound.a("keepPacked", false);
            return nbttagcompound;
        }
        NBTTagCompound nbttagcompound = (NBTTagCompound)this.j.get(blockposition);
        if (nbttagcompound != null) {
            nbttagcompound = nbttagcompound.h();
            nbttagcompound.a("keepPacked", true);
        }
        return nbttagcompound;
    }

    @Override
    public void d(BlockPosition blockposition) {
        if (this.K()) {
            TileEntity tileentity = (TileEntity)this.k.remove(blockposition);
            if (!this.j.isEmpty()) {
                this.j.remove(blockposition);
            }
            if (tileentity != null) {
                WorldServer world = this.r;
                if (world instanceof WorldServer) {
                    WorldServer worldserver = world;
                    this.a(tileentity, worldserver);
                }
                tileentity.ap_();
            }
        }
        this.l(blockposition);
    }

    private <T extends TileEntity> void a(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.q().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(worldserver, t0)) != null) {
            int i2 = SectionPosition.a(t0.p().v());
            GameEventListenerRegistry gameeventlistenerregistry = this.a(i2);
            gameeventlistenerregistry.b(gameeventlistener);
        }
    }

    private void c(int i2) {
        this.u.remove(i2);
    }

    private void l(BlockPosition blockposition) {
        d chunk_d = this.p.remove(blockposition);
        if (chunk_d != null) {
            chunk_d.a(o);
        }
    }

    public void E() {
        if (this.t != null) {
            this.t.run(this);
            this.t = null;
        }
    }

    public void loadCallback() {
        CraftServer server = this.r.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.r.A());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.d.e * xRand + (long)this.d.f * zRand ^ this.r.A());
                CraftWorld world = this.r.getWorld();
                if (world != null) {
                    this.r.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.r.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        CraftServer server = this.r.getCraftServer();
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, this.i());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Override
    public boolean i() {
        return super.i() && !this.mustNotSave;
    }

    public boolean C() {
        return false;
    }

    public void a(PacketDataSerializer packetdataserializer, NBTTagCompound nbttagcompound, Consumer<ClientboundLevelChunkPacketData.b> consumer) {
        this.I();
        ChunkSection[] achunksection = this.m;
        int i2 = achunksection.length;
        int j2 = 0;
        while (j2 < i2) {
            ChunkSection chunksection = achunksection[j2];
            chunksection.a(packetdataserializer);
            ++j2;
        }
        HeightMap.Type[] aheightmap_type = HeightMap.Type.values();
        i2 = aheightmap_type.length;
        j2 = 0;
        while (j2 < i2) {
            HeightMap.Type heightmap_type = aheightmap_type[j2];
            String s2 = heightmap_type.a();
            if (nbttagcompound.b(s2, 12)) {
                this.a(heightmap_type, nbttagcompound.o(s2));
            }
            ++j2;
        }
        this.A();
        consumer.accept((blockposition, tileentitytypes, nbttagcompound1) -> {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.a);
            if (tileentity != null && nbttagcompound1 != null && tileentity.u() == tileentitytypes) {
                tileentity.a(nbttagcompound1);
            }
        });
    }

    public void a(PacketDataSerializer packetdataserializer) {
        ChunkSection[] achunksection = this.m;
        int i2 = achunksection.length;
        int j2 = 0;
        while (j2 < i2) {
            ChunkSection chunksection = achunksection[j2];
            chunksection.b(packetdataserializer);
            ++j2;
        }
    }

    public void c(boolean flag) {
        this.q = flag;
    }

    public World F() {
        return this.r;
    }

    public Map<BlockPosition, TileEntity> G() {
        return this.k;
    }

    public void H() {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = 0;
        while (i2 < this.b.length) {
            if (this.b[i2] != null) {
                for (Short oshort : this.b[i2]) {
                    BlockPosition blockposition = ProtoChunk.a(oshort, this.g(i2), chunkcoordintpair);
                    IBlockData iblockdata = this.a_(blockposition);
                    Fluid fluid = iblockdata.u();
                    if (!fluid.c()) {
                        fluid.a(this.r, blockposition);
                    }
                    if (iblockdata.b() instanceof BlockFluids) continue;
                    IBlockData iblockdata1 = Block.b(iblockdata, this.r, blockposition);
                    this.r.a(blockposition, iblockdata1, 20);
                }
                this.b[i2].clear();
            }
            ++i2;
        }
        for (BlockPosition blockposition1 : ImmutableList.copyOf(this.j.keySet())) {
            this.c_(blockposition1);
        }
        this.j.clear();
        this.f.a(this);
    }

    @Nullable
    private TileEntity a(BlockPosition blockposition, NBTTagCompound nbttagcompound) {
        TileEntity tileentity;
        IBlockData iblockdata = this.a_(blockposition);
        if ("DUMMY".equals(nbttagcompound.l("id"))) {
            if (iblockdata.t()) {
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(blockposition, iblockdata);
            } else {
                tileentity = null;
                n.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockposition, (Object)iblockdata);
            }
        } else {
            tileentity = TileEntity.a(blockposition, iblockdata, nbttagcompound);
        }
        if (tileentity != null) {
            tileentity.a(this.r);
            this.b(tileentity);
        } else {
            n.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)blockposition);
        }
        return tileentity;
    }

    public void c(long i2) {
        this.v.a(i2);
        this.w.a(i2);
    }

    public void a(WorldServer worldserver) {
        worldserver.l().a(this.d, this.v);
        worldserver.m().a(this.d, this.w);
    }

    public void b(WorldServer worldserver) {
        worldserver.l().a(this.d);
        worldserver.m().a(this.d);
    }

    @Override
    public ChunkStatus j() {
        return ChunkStatus.n;
    }

    public FullChunkStatus D() {
        return this.s == null ? FullChunkStatus.b : this.s.get();
    }

    public void b(Supplier<FullChunkStatus> supplier) {
        this.s = supplier;
    }

    public void I() {
        this.k.values().forEach(TileEntity::ap_);
        this.k.clear();
        this.p.values().forEach(chunk_d -> chunk_d.a(o));
        this.p.clear();
    }

    public void J() {
        this.k.values().forEach(tileentity -> {
            WorldServer world = this.r;
            if (world instanceof WorldServer) {
                WorldServer worldserver = world;
                this.b(tileentity, worldserver);
            }
            this.c(tileentity);
        });
    }

    private <T extends TileEntity> void b(T t0, WorldServer worldserver) {
        GameEventListener gameeventlistener;
        Block block = t0.q().b();
        if (block instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(worldserver, t0)) != null) {
            this.a(SectionPosition.a(t0.p().v())).a(gameeventlistener);
        }
    }

    private <T extends TileEntity> void c(T t0) {
        IBlockData iblockdata = t0.q();
        BlockEntityTicker<?> blockentityticker = iblockdata.a((World)this.r, t0.u());
        if (blockentityticker == null) {
            this.l(t0.p());
        } else {
            this.p.compute(t0.p(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.a(t0, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.a(tickingblockentity);
                    return chunk_d;
                }
                if (this.K()) {
                    d chunk_d1 = new d(tickingblockentity);
                    this.r.a(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T t0, BlockEntityTicker<T> blockentityticker) {
        return new a(t0, blockentityticker);
    }

    public static enum EnumTileEntityState {
        a,
        b,
        c;

    }

    private class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;

        a(TileEntity tileentity, BlockEntityTicker blockentityticker) {
            this.b = tileentity;
            this.c = blockentityticker;
        }

        @Override
        public void a() {
            BlockPosition blockposition;
            if (!((TileEntity)this.b).r() && ((TileEntity)this.b).l() && Chunk.this.k(blockposition = ((TileEntity)this.b).p())) {
                try {
                    try {
                        GameProfilerFiller gameprofilerfiller = Chunk.this.r.ad();
                        gameprofilerfiller.a(this::d);
                        ((TileEntity)this.b).tickTimer.startTiming();
                        IBlockData iblockdata = Chunk.this.a_(blockposition);
                        if (((TileEntity)this.b).u().a(iblockdata)) {
                            this.c.tick(Chunk.this.r, ((TileEntity)this.b).p(), iblockdata, this.b);
                            this.d = false;
                        } else if (!this.d) {
                            this.d = true;
                            n.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::d), LogUtils.defer(this::c), iblockdata});
                        }
                        gameprofilerfiller.c();
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.a(throwable, "Ticking block entity");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block entity being ticked");
                        ((TileEntity)this.b).a(crashreportsystemdetails);
                        throw new ReportedException(crashreport);
                    }
                }
                finally {
                    ((TileEntity)this.b).tickTimer.stopTiming();
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).r();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).p();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).u()).toString();
        }

        public String toString() {
            String s2 = this.d();
            return "Level ticker for " + s2 + "@" + this.c();
        }
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    private class d
    implements TickingBlockEntity {
        private TickingBlockEntity b;

        d(TickingBlockEntity tickingblockentity) {
            this.b = tickingblockentity;
        }

        void a(TickingBlockEntity tickingblockentity) {
            this.b = tickingblockentity;
        }

        @Override
        public void a() {
            this.b.a();
        }

        @Override
        public boolean b() {
            return this.b.b();
        }

        @Override
        public BlockPosition c() {
            return this.b.c();
        }

        @Override
        public String d() {
            return this.b.d();
        }

        public String toString() {
            return String.valueOf(this.b.toString()) + " <wrapped>";
        }
    }
}

