/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemmed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogUtils.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private final EnumSet<EnumDirection8> e = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> f = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> g = Lists.newArrayList();
    private final int[][] h;
    static final Map<Block, a> i = new IdentityHashMap<Block, a>();
    static final Set<a> j = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor var0) {
        this.h = new int[var0.ak()][];
    }

    public ChunkConverter(NBTTagCompound var02, LevelHeightAccessor var1) {
        this(var1);
        if (var02.b(c, 10)) {
            NBTTagCompound var2 = var02.p(c);
            for (int var3 = 0; var3 < this.h.length; ++var3) {
                String var4 = String.valueOf(var3);
                if (!var2.b(var4, 11)) continue;
                this.h[var3] = var2.n(var4);
            }
        }
        int var2 = var02.h("Sides");
        for (EnumDirection8 var6 : EnumDirection8.values()) {
            if ((var2 & 1 << var6.ordinal()) == 0) continue;
            this.e.add(var6);
        }
        ChunkConverter.a(var02, "neighbor_block_ticks", var0 -> BuiltInRegistries.f.b(MinecraftKey.a(var0)).or(() -> Optional.of(Blocks.a)), this.f);
        ChunkConverter.a(var02, "neighbor_fluid_ticks", var0 -> BuiltInRegistries.d.b(MinecraftKey.a(var0)).or(() -> Optional.of(FluidTypes.a)), this.g);
    }

    private static <T> void a(NBTTagCompound var0, String var1, Function<String, Optional<T>> var2, List<TickListChunk<T>> var3) {
        if (var0.b(var1, 9)) {
            NBTTagList var4 = var0.c(var1, 10);
            for (NBTBase var6 : var4) {
                TickListChunk.a((NBTTagCompound)var6, var2).ifPresent(var3::add);
            }
        }
    }

    public void a(Chunk var0) {
        this.b(var0);
        for (EnumDirection8 var4 : d) {
            ChunkConverter.a(var0, var4);
        }
        World var12 = var0.F();
        this.f.forEach(var1 -> {
            Block var2 = var1.a() == Blocks.a ? var12.a_(var1.b()).b() : (Block)var1.a();
            var12.a(var1.b(), var2, var1.c(), var1.d());
        });
        this.g.forEach(var1 -> {
            FluidType var2 = var1.a() == FluidTypes.a ? var12.b_(var1.b()).a() : (FluidType)var1.a();
            var12.a(var1.b(), var2, var1.c(), var1.d());
        });
        j.forEach(var1 -> var1.a(var12));
    }

    private static void a(Chunk var0, EnumDirection8 var1) {
        World var2 = var0.F();
        if (!var0.r().e.remove((Object)var1)) {
            return;
        }
        Set<EnumDirection> var3 = var1.a();
        boolean var4 = false;
        int var5 = 15;
        boolean var6 = var3.contains(EnumDirection.f);
        boolean var7 = var3.contains(EnumDirection.e);
        boolean var8 = var3.contains(EnumDirection.d);
        boolean var9 = var3.contains(EnumDirection.c);
        boolean var10 = var3.size() == 1;
        ChunkCoordIntPair var11 = var0.f();
        int var12 = var11.d() + (var10 && (var9 || var8) ? 1 : (var7 ? 0 : 15));
        int var13 = var11.d() + (var10 && (var9 || var8) ? 14 : (var7 ? 0 : 15));
        int var14 = var11.e() + (var10 && (var6 || var7) ? 1 : (var9 ? 0 : 15));
        int var15 = var11.e() + (var10 && (var6 || var7) ? 14 : (var9 ? 0 : 15));
        EnumDirection[] var16 = EnumDirection.values();
        BlockPosition.MutableBlockPosition var17 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var19 : BlockPosition.b(var12, var2.C_(), var14, var13, var2.aj() - 1, var15)) {
            IBlockData var20;
            IBlockData var21 = var20 = var2.a_(var19);
            for (EnumDirection var25 : var16) {
                var17.a((BaseBlockPosition)var19, var25);
                var21 = ChunkConverter.a(var21, var25, var2, var19, var17);
            }
            Block.a(var20, var21, var2, var19, 18);
        }
    }

    private static IBlockData a(IBlockData var0, EnumDirection var1, GeneratorAccess var2, BlockPosition var3, BlockPosition var4) {
        return i.getOrDefault(var0.b(), Type.b).a(var0, var1, var2.a_(var4), var2, var3, var4);
    }

    private void b(Chunk var0) {
        int var5;
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair var3 = var0.f();
        World var4 = var0.F();
        for (var5 = 0; var5 < this.h.length; ++var5) {
            ChunkSection var6 = var0.b(var5);
            int[] var7 = this.h[var5];
            this.h[var5] = null;
            if (var7 == null || var7.length <= 0) continue;
            EnumDirection[] var8 = EnumDirection.values();
            DataPaletteBlock<IBlockData> var9 = var6.h();
            int var10 = var0.g(var5);
            int var11 = SectionPosition.c(var10);
            for (int var15 : var7) {
                IBlockData var19;
                int var16 = var15 & 0xF;
                int var17 = var15 >> 8 & 0xF;
                int var18 = var15 >> 4 & 0xF;
                var1.d(var3.d() + var16, var11 + var17, var3.e() + var18);
                IBlockData var20 = var19 = var9.a(var15);
                for (EnumDirection var24 : var8) {
                    var2.a((BaseBlockPosition)var1, var24);
                    if (SectionPosition.a(var1.u()) != var3.e || SectionPosition.a(var1.w()) != var3.f) continue;
                    var20 = ChunkConverter.a(var20, var24, var4, var1, var2);
                }
                Block.a(var19, var20, var4, var1, 18);
            }
        }
        for (var5 = 0; var5 < this.h.length; ++var5) {
            if (this.h[var5] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{var4.g(var5), var3.e, var3.f});
            }
            this.h[var5] = null;
        }
    }

    public boolean a() {
        for (int[] var3 : this.h) {
            if (var3 == null) continue;
            return false;
        }
        return this.e.isEmpty();
    }

    public NBTTagCompound b() {
        Object var3;
        int var2;
        NBTTagCompound var0 = new NBTTagCompound();
        NBTTagCompound var1 = new NBTTagCompound();
        for (var2 = 0; var2 < this.h.length; ++var2) {
            var3 = String.valueOf(var2);
            if (this.h[var2] == null || this.h[var2].length == 0) continue;
            var1.a((String)var3, this.h[var2]);
        }
        if (!var1.g()) {
            var0.a(c, var1);
        }
        var2 = 0;
        for (EnumDirection8 var4 : this.e) {
            var2 |= 1 << var4.ordinal();
        }
        var0.a("Sides", (byte)var2);
        if (!this.f.isEmpty()) {
            var3 = new NBTTagList();
            this.f.forEach(arg_0 -> ChunkConverter.b((NBTTagList)var3, arg_0));
            var0.a("neighbor_block_ticks", (NBTBase)var3);
        }
        if (!this.g.isEmpty()) {
            var3 = new NBTTagList();
            this.g.forEach(arg_0 -> ChunkConverter.a((NBTTagList)var3, arg_0));
            var0.a("neighbor_fluid_ticks", (NBTBase)var3);
        }
        return var0;
    }

    private static /* synthetic */ void a(NBTTagList var02, TickListChunk var1) {
        var02.add(var1.a((T var0) -> BuiltInRegistries.d.b((FluidType)var0).toString()));
    }

    private static /* synthetic */ void b(NBTTagList var02, TickListChunk var1) {
        var02.add(var1.a((T var0) -> BuiltInRegistries.f.b((Block)var0).toString()));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.kO, Blocks.ee, Blocks.lM, Blocks.lN, Blocks.lO, Blocks.lP, Blocks.lQ, Blocks.lR, Blocks.lS, Blocks.lT, Blocks.lU, Blocks.lV, Blocks.lW, Blocks.lX, Blocks.lY, Blocks.lZ, Blocks.ma, Blocks.mb, Blocks.gS, Blocks.gT, Blocks.gU, Blocks.fA, Blocks.L, Blocks.I, Blocks.K, Blocks.cE, Blocks.cF, Blocks.cG, Blocks.cH, Blocks.cI, Blocks.cJ, Blocks.cK, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.cU, Blocks.cW, Blocks.cX, Blocks.da, Blocks.db, Blocks.dc, Blocks.dd, Blocks.df, Blocks.dg, Blocks.dl, Blocks.dm, Blocks.dn, Blocks.do, Blocks.dq, Blocks.dr}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                return var0.a(var1, var3.a_(var5), var3, var4, var5);
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.cv, Blocks.gV}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                if (var2.a(var0.b()) && var1.o().d() && var0.c(BlockChest.c) == BlockPropertyChestType.a && var2.c(BlockChest.c) == BlockPropertyChestType.a) {
                    EnumDirection var6 = var0.c(BlockChest.b);
                    if (var1.o() != var6.o() && var6 == var2.c(BlockChest.b)) {
                        BlockPropertyChestType var7 = var1 == var6.h() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        var3.a(var5, (IBlockData)var2.a(BlockChest.c, var7.a()), 18);
                        if (var6 == EnumDirection.c || var6 == EnumDirection.f) {
                            TileEntity var8 = var3.c_(var4);
                            TileEntity var9 = var3.c_(var5);
                            if (var8 instanceof TileEntityChest && var9 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)var8, (TileEntityChest)var9);
                            }
                        }
                        return (IBlockData)var0.a(BlockChest.c, var7);
                    }
                }
                return var0;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.aI, Blocks.aJ, Blocks.aG, Blocks.aK, Blocks.aH, Blocks.aE, Blocks.aF}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                IBlockData var6 = var0.a(var1, var3.a_(var5), var3, var4, var5);
                if (var0 != var6) {
                    int var7 = var6.c(BlockProperties.aC);
                    List<ObjectSet<BlockPosition>> var8 = this.g.get();
                    if (var8.isEmpty()) {
                        for (int var9 = 0; var9 < 7; ++var9) {
                            var8.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    var8.get(var7).add((Object)var4.i());
                }
                return var0;
            }

            @Override
            public void a(GeneratorAccess var0) {
                BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> var2 = this.g.get();
                for (int var3 = 2; var3 < var2.size(); ++var3) {
                    int var4 = var3 - 1;
                    ObjectSet<BlockPosition> var5 = var2.get(var4);
                    ObjectSet<BlockPosition> var6 = var2.get(var3);
                    for (BlockPosition var8 : var5) {
                        IBlockData var9 = var0.a_(var8);
                        if (var9.c(BlockProperties.aC) < var4) continue;
                        var0.a(var8, (IBlockData)var9.a(BlockProperties.aC, var4), 18);
                        if (var3 == 7) continue;
                        for (EnumDirection var13 : f) {
                            var1.a((BaseBlockPosition)var8, var13);
                            IBlockData var14 = var0.a_(var1);
                            if (!var14.b(BlockProperties.aC) || var9.c(BlockProperties.aC) <= var3) continue;
                            var6.add((Object)var1.i());
                        }
                    }
                }
                var2.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.fe, Blocks.fd}){

            @Override
            public IBlockData a(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
                BlockStemmed var6;
                if (var0.c(BlockStem.b) == 7 && var2.a(var6 = ((BlockStem)var0.b()).a())) {
                    return (IBlockData)var6.b().n().a(BlockFacingHorizontal.aC, var1);
                }
                return var0;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        Type(Block ... var2) {
            this(false, var2);
        }

        Type(boolean var2, Block ... var3) {
            for (Block var7 : var3) {
                i.put(var7, this);
            }
            if (var2) {
                j.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess var0) {
        }
    }
}

