/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public class ChunkGeneratorStructureState {
    private static final Logger a = LogUtils.getLogger();
    private final RandomState b;
    private final WorldChunkManager c;
    private final long d;
    private final long e;
    private final Map<Structure, List<StructurePlacement>> f = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> g = new Object2ObjectArrayMap();
    private boolean h;
    private final List<Holder<StructureSet>> i;

    public static ChunkGeneratorStructureState createForFlat(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, Stream<Holder<StructureSet>> stream, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = stream.filter(holder -> ChunkGeneratorStructureState.a((StructureSet)holder.a(), worldchunkmanager)).toList();
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, 0L, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, HolderLookup<StructureSet> holderlookup, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = holderlookup.b().filter(holder_c -> ChunkGeneratorStructureState.a((StructureSet)holder_c.a(), worldchunkmanager)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, i2, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    private static List<Holder<StructureSet>> injectSpigot(List<Holder<StructureSet>> list, SpigotWorldConfig conf) {
        return list.stream().map(holder -> {
            StructureSet structureset;
            block46: {
                void randomConfig;
                structureset = (StructureSet)holder.a();
                StructurePlacement structurePlacement = structureset.b();
                if (!(structurePlacement instanceof RandomSpreadStructurePlacement var3_4)) break block46;
                String name = holder.e().orElseThrow().a().a();
                int seed = randomConfig.f;
                switch (name) {
                    case "desert_pyramids": {
                        seed = spigotWorldConfig.desertSeed;
                        break;
                    }
                    case "end_cities": {
                        seed = spigotWorldConfig.endCitySeed;
                        break;
                    }
                    case "nether_complexes": {
                        seed = spigotWorldConfig.netherSeed;
                        break;
                    }
                    case "igloos": {
                        seed = spigotWorldConfig.iglooSeed;
                        break;
                    }
                    case "jungle_temples": {
                        seed = spigotWorldConfig.jungleSeed;
                        break;
                    }
                    case "woodland_mansions": {
                        seed = spigotWorldConfig.mansionSeed;
                        break;
                    }
                    case "ocean_monuments": {
                        seed = spigotWorldConfig.monumentSeed;
                        break;
                    }
                    case "nether_fossils": {
                        seed = spigotWorldConfig.fossilSeed;
                        break;
                    }
                    case "ocean_ruins": {
                        seed = spigotWorldConfig.oceanSeed;
                        break;
                    }
                    case "pillager_outposts": {
                        seed = spigotWorldConfig.outpostSeed;
                        break;
                    }
                    case "ruined_portals": {
                        seed = spigotWorldConfig.portalSeed;
                        break;
                    }
                    case "shipwrecks": {
                        seed = spigotWorldConfig.shipwreckSeed;
                        break;
                    }
                    case "swamp_huts": {
                        seed = spigotWorldConfig.swampSeed;
                        break;
                    }
                    case "villages": {
                        seed = spigotWorldConfig.villageSeed;
                    }
                }
                structureset = new StructureSet(structureset.a(), (StructurePlacement)new RandomSpreadStructurePlacement((BaseBlockPosition)randomConfig.c, (StructurePlacement.c)randomConfig.d, (float)randomConfig.e, seed, randomConfig.g, randomConfig.a(), randomConfig.b(), randomConfig.c()));
            }
            return Holder.a(structureset);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean a(StructureSet structureset, WorldChunkManager worldchunkmanager) {
        Stream stream = structureset.a().stream().flatMap(structureset_a -> {
            Structure structure = structureset_a.a().a();
            return structure.a().a();
        });
        Set<Holder<BiomeBase>> set = worldchunkmanager.c();
        Objects.requireNonNull(set);
        return stream.anyMatch(set::contains);
    }

    private ChunkGeneratorStructureState(RandomState randomstate, WorldChunkManager worldchunkmanager, long i2, long j2, List<Holder<StructureSet>> list) {
        this.b = randomstate;
        this.d = i2;
        this.c = worldchunkmanager;
        this.e = j2;
        this.i = list;
    }

    public List<Holder<StructureSet>> a() {
        return this.i;
    }

    private void e() {
        Set<Holder<BiomeBase>> set = this.c.c();
        this.a().forEach(holder -> {
            StructurePlacement structureplacement;
            StructureSet structureset = (StructureSet)holder.a();
            boolean flag = false;
            for (StructureSet.a structureset_a : structureset.a()) {
                Structure structure = structureset_a.a().a();
                Stream<Holder<BiomeBase>> stream = structure.a().a();
                Objects.requireNonNull(set);
                if (!stream.anyMatch(set::contains)) continue;
                this.f.computeIfAbsent(structure, structure1 -> new ArrayList()).add(structureset.b());
                flag = true;
            }
            if (flag && (structureplacement = structureset.b()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                this.g.put(concentricringsstructureplacement, this.a((Holder<StructureSet>)holder, concentricringsstructureplacement));
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> a(Holder<StructureSet> holder, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        if (concentricringsstructureplacement.c() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.b);
        int i2 = concentricringsstructureplacement.a();
        int j2 = concentricringsstructureplacement.c();
        ArrayList<CompletableFuture<ChunkCoordIntPair>> list = new ArrayList<CompletableFuture<ChunkCoordIntPair>>(j2);
        int k2 = concentricringsstructureplacement.b();
        HolderSet<BiomeBase> holderset = concentricringsstructureplacement.d();
        RandomSource randomsource = RandomSource.a();
        randomsource.b(this.e);
        double d0 = randomsource.j() * Math.PI * 2.0;
        int l2 = 0;
        int i1 = 0;
        int j1 = 0;
        while (j1 < j2) {
            double d1 = (double)(4 * i2 + i2 * i1 * 6) + (randomsource.j() - 0.5) * (double)i2 * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            RandomSource randomsource1 = randomsource.d();
            list.add(CompletableFuture.supplyAsync(() -> {
                WorldChunkManager worldchunkmanager = this.c;
                int i2 = SectionPosition.a(k1, 8);
                int j2 = SectionPosition.a(l1, 8);
                Objects.requireNonNull(holderset);
                Pair<BlockPosition, Holder<BiomeBase>> pair = worldchunkmanager.a(i2, 0, j2, 112, holderset::a, randomsource1, this.b.b());
                if (pair != null) {
                    BlockPosition blockposition = (BlockPosition)pair.getFirst();
                    return new ChunkCoordIntPair(SectionPosition.a(blockposition.u()), SectionPosition.a(blockposition.w()));
                }
                return new ChunkCoordIntPair(k1, l1);
            }, SystemUtils.f()));
            d0 += Math.PI * 2 / (double)k2;
            if (++l2 == k2) {
                l2 = 0;
                k2 += 2 * k2 / (++i1 + 1);
                k2 = Math.min(k2, j2 - j1);
                d0 += randomsource.j() * Math.PI * 2.0;
            }
            ++j1;
        }
        return ((CompletableFuture)((Object)SystemUtils.b(list))).thenApply(list1 -> {
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            a.debug("Calculation for {} took {}s", (Object)holder, (Object)d2);
            return list1;
        });
    }

    public void b() {
        if (!this.h) {
            this.e();
            this.h = true;
        }
    }

    @Nullable
    public List<ChunkCoordIntPair> a(ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        this.b();
        CompletableFuture<List<ChunkCoordIntPair>> completablefuture = this.g.get(concentricringsstructureplacement);
        return completablefuture != null ? completablefuture.join() : null;
    }

    public List<StructurePlacement> a(Holder<Structure> holder) {
        this.b();
        return this.f.getOrDefault(holder.a(), List.of());
    }

    public RandomState c() {
        return this.b;
    }

    public boolean a(Holder<StructureSet> holder, int i2, int j2, int k2) {
        StructurePlacement structureplacement = holder.a().b();
        int l2 = i2 - k2;
        while (l2 <= i2 + k2) {
            int i1 = j2 - k2;
            while (i1 <= j2 + k2) {
                if (structureplacement.b(this, l2, i1)) {
                    return true;
                }
                ++i1;
            }
            ++l2;
        }
        return false;
    }

    public long d() {
        return this.d;
    }
}

