/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable {
    public static final int c = 1493;
    private final IOWorker a;
    protected final DataFixer d;
    @Nullable
    private volatile PersistentStructureLegacy b;

    public IChunkLoader(Path path, DataFixer datafixer, boolean flag) {
        this.d = datafixer;
        this.a = new IOWorker(path, flag, "chunk");
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.a.a(chunkcoordintpair, i2);
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        NBTTagCompound nbt;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x2, z2);
        if (cps != null) {
            Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"primary thread");
            if (cps.b(x2, z2)) {
                return true;
            }
        }
        try {
            nbt = this.e(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            NBTTagCompound level = nbt.p("Level");
            if (level.q("TerrainPopulated")) {
                return true;
            }
            ChunkStatus status = ChunkStatus.a(level.l("Status"));
            if (status != null && status.b(ChunkStatus.j)) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        boolean belowZeroGenerationInExistingChunks;
        NBTTagCompound level;
        int i2 = IChunkLoader.a(nbttagcompound);
        if (i2 < 1466 && (level = nbttagcompound.p("Level")).q("TerrainPopulated") && !level.q("LightPopulated")) {
            ChunkProviderServer cps;
            ChunkProviderServer chunkProviderServer = cps = generatoraccess == null ? null : ((WorldServer)generatoraccess).k();
            if (this.check(cps, pos.e - 1, pos.f) && this.check(cps, pos.e - 1, pos.f - 1) && this.check(cps, pos.e, pos.f - 1)) {
                level.a("LightPopulated", true);
            }
        }
        if (i2 < 1493 && (nbttagcompound = DataFixTypes.c.a(this.d, nbttagcompound, i2, 1493)).p("Level").q("hasLegacyStructureData")) {
            PersistentStructureLegacy persistentstructurelegacy = this.a(resourcekey, supplier);
            nbttagcompound = persistentstructurelegacy.a(nbttagcompound);
        }
        boolean stopBelowZero = false;
        boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
        if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
            stopBelowZero = "full".equals(nbttagcompound.p("Level").l("Status"));
        }
        IChunkLoader.a(nbttagcompound, resourcekey, optional);
        nbttagcompound = DataFixTypes.c.a(this.d, nbttagcompound, Math.max(1493, i2));
        if (i2 < SharedConstants.b().d().c()) {
            GameProfileSerializer.g(nbttagcompound);
        }
        if (stopBelowZero) {
            nbttagcompound.a("Status", BuiltInRegistries.o.b(ChunkStatus.m).toString());
        }
        nbttagcompound.r("__context");
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy a(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier) {
        PersistentStructureLegacy persistentstructurelegacy = this.b;
        if (persistentstructurelegacy == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                persistentstructurelegacy = this.b;
                if (persistentstructurelegacy == null) {
                    this.b = persistentstructurelegacy = PersistentStructureLegacy.a(resourcekey, supplier.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void a(NBTTagCompound nbttagcompound, ResourceKey<WorldDimension> resourcekey, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> optional) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.a("dimension", resourcekey.a().toString());
        optional.ifPresent(resourcekey1 -> nbttagcompound1.a("generator", resourcekey1.a().toString()));
        nbttagcompound.a("__context", nbttagcompound1);
    }

    public static int a(NBTTagCompound nbttagcompound) {
        return GameProfileSerializer.b(nbttagcompound, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> e(ChunkCoordIntPair chunkcoordintpair) {
        return this.a.a(chunkcoordintpair);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        this.a.a(chunkcoordintpair, nbttagcompound);
        if (this.b != null) {
            this.b.a(chunkcoordintpair.a());
        }
    }

    public void o() {
        this.a.a(true).join();
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    public ChunkScanAccess p() {
        return this.a;
    }
}

