/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 4096;
    @VisibleForTesting
    protected static final int a = 1024;
    private static final int e = 5;
    private static final int f = 0;
    private static final ByteBuffer g = ByteBuffer.allocateDirect(1);
    private static final String h = ".mcc";
    private static final int i = 128;
    private static final int j = 256;
    private static final int k = 0;
    private final FileChannel l;
    private final Path m;
    final RegionFileCompression n;
    private final ByteBuffer o = ByteBuffer.allocateDirect(8192);
    private final IntBuffer p;
    private final IntBuffer q;
    @VisibleForTesting
    protected final RegionFileBitSet b = new RegionFileBitSet();

    public RegionFile(Path path, Path path1, boolean flag) throws IOException {
        this(path, path1, RegionFileCompression.b, flag);
    }

    public RegionFile(Path path, Path path1, RegionFileCompression regionfilecompression, boolean flag) throws IOException {
        this.n = regionfilecompression;
        if (!Files.isDirectory(path1, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + path1.toAbsolutePath());
        }
        this.m = path1;
        this.p = this.o.asIntBuffer();
        ((Buffer)this.p).limit(1024);
        ((Buffer)this.o).position(4096);
        this.q = this.o.asIntBuffer();
        this.l = flag ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.b.a(0, 2);
        ((Buffer)this.o).position(0);
        int i2 = this.l.read(this.o, 0L);
        if (i2 != -1) {
            if (i2 != 8192) {
                c.warn("Region file {} has truncated header: {}", (Object)path, (Object)i2);
            }
            long j2 = Files.size(path);
            int k2 = 0;
            while (k2 < 1024) {
                int l2 = this.p.get(k2);
                if (l2 != 0) {
                    int i1 = RegionFile.b(l2);
                    int j1 = RegionFile.a(l2);
                    if (j1 == 255) {
                        ByteBuffer realLen = ByteBuffer.allocate(4);
                        this.l.read(realLen, i1 * 4096);
                        j1 = (realLen.getInt(0) + 4) / 4096 + 1;
                    }
                    if (i1 < 2) {
                        c.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{path, k2, i1});
                        this.p.put(k2, 0);
                    } else if (j1 == 0) {
                        c.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)k2);
                        this.p.put(k2, 0);
                    } else if ((long)i1 * 4096L > j2) {
                        c.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{path, k2, i1});
                        this.p.put(k2, 0);
                    } else {
                        this.b.a(i1, j1);
                    }
                }
                ++k2;
            }
        }
    }

    private Path f(ChunkCoordIntPair chunkcoordintpair) {
        String s2 = "c." + chunkcoordintpair.e + "." + chunkcoordintpair.f + h;
        return this.m.resolve(s2);
    }

    @Nullable
    public synchronized DataInputStream a(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        int i2 = this.g(chunkcoordintpair);
        if (i2 == 0) {
            return null;
        }
        int j2 = RegionFile.b(i2);
        int k2 = RegionFile.a(i2);
        if (k2 == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.l.read(realLen, j2 * 4096);
            k2 = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int l2 = k2 * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l2);
        this.l.read(bytebuffer, j2 * 4096);
        ((Buffer)bytebuffer).flip();
        if (bytebuffer.remaining() < 5) {
            c.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{chunkcoordintpair, l2, bytebuffer.remaining()});
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            c.warn("Chunk {} is allocated, but stream is missing", (Object)chunkcoordintpair);
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.a(b0)) {
            if (j1 != 0) {
                c.warn("Chunk has both internal and external streams");
            }
            return this.a(chunkcoordintpair, RegionFile.b(b0));
        }
        if (j1 > bytebuffer.remaining()) {
            c.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{chunkcoordintpair, j1, bytebuffer.remaining()});
            return null;
        }
        if (j1 < 0) {
            c.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)chunkcoordintpair);
            return null;
        }
        return this.a(chunkcoordintpair, b0, RegionFile.a(bytebuffer, j1));
    }

    private static int b() {
        return (int)(SystemUtils.d() / 1000L);
    }

    private static boolean a(byte b0) {
        return (b0 & 0x80) != 0;
    }

    private static byte b(byte b0) {
        return (byte)(b0 & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair chunkcoordintpair, byte b0, InputStream inputstream) throws IOException {
        RegionFileCompression regionfilecompression = RegionFileCompression.a(b0);
        if (regionfilecompression == null) {
            c.error("Chunk {} has invalid chunk stream version {}", (Object)chunkcoordintpair, (Object)b0);
            return null;
        }
        return new DataInputStream(regionfilecompression.a(inputstream));
    }

    @Nullable
    private DataInputStream a(ChunkCoordIntPair chunkcoordintpair, byte b0) throws IOException {
        Path path = this.f(chunkcoordintpair);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            c.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.a(chunkcoordintpair, b0, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream a(ByteBuffer bytebuffer, int i2) {
        return new ByteArrayInputStream(bytebuffer.array(), bytebuffer.position(), i2);
    }

    private int a(int i2, int j2) {
        return i2 << 8 | j2;
    }

    private static int a(int i2) {
        return i2 & 0xFF;
    }

    private static int b(int i2) {
        return i2 >> 8 & 0xFFFFFF;
    }

    private static int c(int i2) {
        return (i2 + 4096 - 1) / 4096;
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair) {
        block12: {
            int l2;
            int k2;
            block14: {
                block13: {
                    byte b0;
                    block10: {
                        block11: {
                            ByteBuffer bytebuffer;
                            block9: {
                                int i2 = this.g(chunkcoordintpair);
                                if (i2 == 0) {
                                    return false;
                                }
                                int j2 = RegionFile.b(i2);
                                k2 = RegionFile.a(i2);
                                bytebuffer = ByteBuffer.allocate(5);
                                try {
                                    this.l.read(bytebuffer, j2 * 4096);
                                    ((Buffer)bytebuffer).flip();
                                    if (bytebuffer.remaining() == 5) break block9;
                                    return false;
                                }
                                catch (IOException ioexception) {
                                    return false;
                                }
                            }
                            l2 = bytebuffer.getInt();
                            b0 = bytebuffer.get();
                            if (!RegionFile.a(b0)) break block10;
                            if (RegionFileCompression.b(RegionFile.b(b0))) break block11;
                            return false;
                        }
                        if (!Files.isRegularFile(this.f(chunkcoordintpair), new LinkOption[0])) {
                            return false;
                        }
                        break block12;
                    }
                    if (RegionFileCompression.b(b0)) break block13;
                    return false;
                }
                if (l2 != 0) break block14;
                return false;
            }
            int i1 = l2 - 1;
            if (i1 >= 0 && i1 <= 4096 * k2) break block12;
            return false;
        }
        return true;
    }

    public DataOutputStream c(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        return new DataOutputStream(this.n.a(new ChunkBuffer(chunkcoordintpair)));
    }

    public void a() throws IOException {
        this.l.force(true);
    }

    public void d(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        int i2 = RegionFile.h(chunkcoordintpair);
        int j2 = this.p.get(i2);
        if (j2 != 0) {
            this.p.put(i2, 0);
            this.q.put(i2, RegionFile.b());
            this.d();
            Files.deleteIfExists(this.f(chunkcoordintpair));
            this.b.b(RegionFile.b(j2), RegionFile.a(j2));
        }
    }

    protected synchronized void a(ChunkCoordIntPair chunkcoordintpair, ByteBuffer bytebuffer) throws IOException {
        b regionfile_b;
        int k1;
        int i2 = RegionFile.h(chunkcoordintpair);
        int j2 = this.p.get(i2);
        int k2 = RegionFile.b(j2);
        int l2 = RegionFile.a(j2);
        int i1 = bytebuffer.remaining();
        int j1 = RegionFile.c(i1);
        if (j1 >= 256) {
            Path path = this.f(chunkcoordintpair);
            c.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{chunkcoordintpair, i1, path});
            j1 = 1;
            k1 = this.b.a(j1);
            regionfile_b = this.a(path, bytebuffer);
            ByteBuffer bytebuffer1 = this.c();
            this.l.write(bytebuffer1, k1 * 4096);
        } else {
            k1 = this.b.a(j1);
            regionfile_b = () -> Files.deleteIfExists(this.f(chunkcoordintpair));
            this.l.write(bytebuffer, k1 * 4096);
        }
        this.p.put(i2, this.a(k1, j1));
        this.q.put(i2, RegionFile.b());
        this.d();
        regionfile_b.run();
        if (k2 != 0) {
            this.b.b(k2, l2);
        }
    }

    private ByteBuffer c() {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(this.n.a() | 0x80));
        ((Buffer)bytebuffer).flip();
        return bytebuffer;
    }

    private b a(Path path, ByteBuffer bytebuffer) throws IOException {
        Path path1 = Files.createTempFile(this.m, "tmp", null, new FileAttribute[0]);
        try (FileChannel filechannel = FileChannel.open(path1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ((Buffer)bytebuffer).position(5);
            filechannel.write(bytebuffer);
        }
        return () -> Files.move(path1, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void d() throws IOException {
        ((Buffer)this.o).position(0);
        this.l.write(this.o, 0L);
    }

    private int g(ChunkCoordIntPair chunkcoordintpair) {
        return this.p.get(RegionFile.h(chunkcoordintpair));
    }

    public boolean e(ChunkCoordIntPair chunkcoordintpair) {
        return this.g(chunkcoordintpair) != 0;
    }

    private static int h(ChunkCoordIntPair chunkcoordintpair) {
        return chunkcoordintpair.j() + chunkcoordintpair.k() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.e();
        }
        finally {
            try {
                this.l.force(true);
            }
            finally {
                this.l.close();
            }
        }
    }

    private void e() throws IOException {
        int j2;
        int i2 = (int)this.l.size();
        if (i2 != (j2 = RegionFile.c(i2) * 4096)) {
            ByteBuffer bytebuffer = g.duplicate();
            ((Buffer)bytebuffer).position(0);
            this.l.write(bytebuffer, j2 - 1);
        }
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkCoordIntPair b;

        public ChunkBuffer(ChunkCoordIntPair chunkcoordintpair) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.n.a());
            this.b = chunkcoordintpair;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            bytebuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.a(this.b, bytebuffer);
        }
    }

    private static interface b {
        public void run() throws IOException;
    }
}

