/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.slf4j.Logger;

public class RegionFileSection<R>
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Sections";
    private final IOWorker d;
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> g;
    private final Function<Runnable, R> h;
    private final DataFixer i;
    private final DataFixTypes j;
    private final IRegistryCustom k;
    protected final LevelHeightAccessor c;

    public RegionFileSection(Path var0, Function<Runnable, Codec<R>> var1, Function<Runnable, R> var2, DataFixer var3, DataFixTypes var4, boolean var5, IRegistryCustom var6, LevelHeightAccessor var7) {
        this.g = var1;
        this.h = var2;
        this.i = var3;
        this.j = var4;
        this.k = var6;
        this.c = var7;
        this.d = new IOWorker(var0, var5, var0.getFileName().toString());
    }

    protected void a(BooleanSupplier var0) {
        while (this.a() && var0.getAsBoolean()) {
            ChunkCoordIntPair var1 = SectionPosition.a(this.f.firstLong()).r();
            this.d(var1);
        }
    }

    public boolean a() {
        return !this.f.isEmpty();
    }

    @Nullable
    protected Optional<R> c(long var0) {
        return (Optional)this.e.get(var0);
    }

    protected Optional<R> d(long var0) {
        if (this.e(var0)) {
            return Optional.empty();
        }
        Optional<R> var2 = this.c(var0);
        if (var2 != null) {
            return var2;
        }
        this.b(SectionPosition.a(var0).r());
        var2 = this.c(var0);
        if (var2 == null) {
            throw SystemUtils.b(new IllegalStateException());
        }
        return var2;
    }

    protected boolean e(long var0) {
        int var2 = SectionPosition.c(SectionPosition.c(var0));
        return this.c.d(var2);
    }

    protected R f(long var0) {
        if (this.e(var0)) {
            throw SystemUtils.b(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> var2 = this.d(var0);
        if (var2.isPresent()) {
            return var2.get();
        }
        R var3 = this.h.apply(() -> this.a(var0));
        this.e.put(var0, Optional.of(var3));
        return var3;
    }

    private void b(ChunkCoordIntPair var0) {
        Optional<NBTTagCompound> var1 = this.c(var0).join();
        RegistryOps<NBTBase> var2 = RegistryOps.a(DynamicOpsNBT.a, this.k);
        this.a(var0, var2, var1.orElse(null));
    }

    private CompletableFuture<Optional<NBTTagCompound>> c(ChunkCoordIntPair var0) {
        return this.d.a(var0).exceptionally(var1 -> {
            if (var1 instanceof IOException) {
                IOException var2 = (IOException)var1;
                a.error("Error reading chunk {} data from disk", (Object)var0, (Object)var2);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)var1);
        });
    }

    private <T> void a(ChunkCoordIntPair var0, DynamicOps<T> var1, @Nullable T var22) {
        if (var22 == null) {
            for (int var32 = this.c.al(); var32 < this.c.am(); ++var32) {
                this.e.put(RegionFileSection.a(var0, var32), Optional.empty());
            }
        } else {
            int var5;
            Dynamic var33 = new Dynamic(var1, var22);
            int var4 = RegionFileSection.a(var33);
            boolean var6 = var4 != (var5 = SharedConstants.b().d().c());
            Dynamic var7 = this.j.a(this.i, var33, var4, var5);
            OptionalDynamic var8 = var7.get(b);
            for (int var9 = this.c.al(); var9 < this.c.am(); ++var9) {
                long var10 = RegionFileSection.a(var0, var9);
                Optional var12 = var8.get(Integer.toString(var9)).result().flatMap(var2 -> this.g.apply(() -> this.a(var10)).parse(var2).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)));
                this.e.put(var10, var12);
                var12.ifPresent(var3 -> {
                    this.b(var10);
                    if (var6) {
                        this.a(var10);
                    }
                });
            }
        }
    }

    private void d(ChunkCoordIntPair var0) {
        RegistryOps<NBTBase> var1 = RegistryOps.a(DynamicOpsNBT.a, this.k);
        Dynamic<NBTBase> var2 = this.a(var0, var1);
        NBTBase var3 = (NBTBase)var2.getValue();
        if (var3 instanceof NBTTagCompound) {
            this.d.a(var0, (NBTTagCompound)var3);
        } else {
            a.error("Expected compound tag, got {}", (Object)var3);
        }
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair var0, DynamicOps<T> var1) {
        HashMap var2 = Maps.newHashMap();
        for (int var32 = this.c.al(); var32 < this.c.am(); ++var32) {
            long var4 = RegionFileSection.a(var0, var32);
            this.f.remove(var4);
            Optional var6 = (Optional)this.e.get(var4);
            if (var6 == null || !var6.isPresent()) continue;
            DataResult var7 = this.g.apply(() -> this.a(var4)).encodeStart(var1, var6.get());
            String var8 = Integer.toString(var32);
            var7.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(var3 -> var2.put(var1.createString(var8), var3));
        }
        return new Dynamic(var1, var1.createMap((Map)ImmutableMap.of((Object)var1.createString(b), (Object)var1.createMap((Map)var2), (Object)var1.createString("DataVersion"), (Object)var1.createInt(SharedConstants.b().d().c()))));
    }

    private static long a(ChunkCoordIntPair var0, int var1) {
        return SectionPosition.b(var0.e, var1, var0.f);
    }

    protected void b(long var0) {
    }

    protected void a(long var0) {
        Optional var2 = (Optional)this.e.get(var0);
        if (var2 == null || !var2.isPresent()) {
            a.warn("No data for position: {}", (Object)SectionPosition.a(var0));
            return;
        }
        this.f.add(var0);
    }

    private static int a(Dynamic<?> var0) {
        return var0.get("DataVersion").asInt(1945);
    }

    public void a(ChunkCoordIntPair var0) {
        if (this.a()) {
            for (int var1 = this.c.al(); var1 < this.c.am(); ++var1) {
                long var2 = RegionFileSection.a(var0, var1);
                if (!this.f.contains(var2)) continue;
                this.d(var0);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.d.close();
    }
}

