/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public final class DimensionManager
extends Record {
    private final OptionalLong k;
    private final boolean l;
    private final boolean m;
    private final boolean n;
    private final boolean o;
    private final double p;
    private final boolean q;
    private final boolean r;
    private final int s;
    private final int t;
    private final int u;
    private final TagKey<Block> v;
    private final MinecraftKey w;
    private final float x;
    private final a y;
    public static final int a = BlockPosition.c;
    public static final int b = 16;
    public static final int c = (1 << a) - 32;
    public static final int d = (c >> 1) - 1;
    public static final int e = d - c + 1;
    public static final int f = d << 4;
    public static final int g = e << 4;
    public static final Codec<DimensionManager> h = ExtraCodecs.c(RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.a((MapCodec<Optional<Long>>)Codec.LONG.optionalFieldOf("fixed_time")).forGetter(DimensionManager::f), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::g), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::h), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::i), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::j), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::k), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::l), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::m), (App)Codec.intRange((int)e, (int)d).fieldOf("min_y").forGetter(DimensionManager::n), (App)Codec.intRange((int)16, (int)c).fieldOf("height").forGetter(DimensionManager::o), (App)Codec.intRange((int)0, (int)c).fieldOf("logical_height").forGetter(DimensionManager::p), (App)TagKey.b(Registries.e).fieldOf("infiniburn").forGetter(DimensionManager::q), (App)MinecraftKey.a.fieldOf("effects").orElse((Object)BuiltinDimensionTypes.e).forGetter(DimensionManager::r), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::s), (App)net.minecraft.world.level.dimension.DimensionManager$a.a.forGetter(DimensionManager::t)).apply((Applicative)var0, DimensionManager::new)));
    private static final int z = 8;
    public static final float[] i = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> j = RegistryFileCodec.a(Registries.au, h);

    public DimensionManager(OptionalLong var0, boolean var1, boolean var2, boolean var3, boolean var4, double var5, boolean var7, boolean var8, int var9, int var10, int var11, TagKey<Block> var12, MinecraftKey var13, float var14, a var15) {
        if (var10 < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (var9 + var10 > d + 1) {
            throw new IllegalStateException("min_y + height cannot be higher than: " + (d + 1));
        }
        if (var11 > var10) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (var10 % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (var9 % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
        this.k = var0;
        this.l = var1;
        this.m = var2;
        this.n = var3;
        this.o = var4;
        this.p = var5;
        this.q = var7;
        this.r = var8;
        this.s = var9;
        this.t = var10;
        this.u = var11;
        this.v = var12;
        this.w = var13;
        this.x = var14;
        this.y = var15;
    }

    @Deprecated
    public static DataResult<ResourceKey<World>> a(Dynamic<?> var0) {
        Optional var1 = var0.asNumber().result();
        if (var1.isPresent()) {
            int var2 = ((Number)var1.get()).intValue();
            if (var2 == -1) {
                return DataResult.success(World.i);
            }
            if (var2 == 0) {
                return DataResult.success(World.h);
            }
            if (var2 == 1) {
                return DataResult.success(World.j);
            }
        }
        return World.g.parse(var0);
    }

    public static double a(DimensionManager var0, DimensionManager var1) {
        double var2 = var0.k();
        double var4 = var1.k();
        return var2 / var4;
    }

    public static Path a(ResourceKey<World> var0, Path var1) {
        if (var0 == World.h) {
            return var1;
        }
        if (var0 == World.j) {
            return var1.resolve("DIM1");
        }
        if (var0 == World.i) {
            return var1.resolve("DIM-1");
        }
        return var1.resolve("dimensions").resolve(var0.a().b()).resolve(var0.a().a());
    }

    public boolean a() {
        return this.k.isPresent();
    }

    public float a(long var0) {
        double var2 = MathHelper.e((double)this.k.orElse(var0) / 24000.0 - 0.25);
        double var4 = 0.5 - Math.cos(var2 * Math.PI) / 2.0;
        return (float)(var2 * 2.0 + var4) / 3.0f;
    }

    public int b(long var0) {
        return (int)(var0 / 24000L % 8L + 8L) % 8;
    }

    public boolean b() {
        return this.y.a();
    }

    public boolean c() {
        return this.y.b();
    }

    public IntProvider d() {
        return this.y.c();
    }

    public int e() {
        return this.y.d();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DimensionManager.class, "fixedTime;hasSkyLight;hasCeiling;ultraWarm;natural;coordinateScale;bedWorks;respawnAnchorWorks;minY;height;logicalHeight;infiniburn;effectsLocation;ambientLight;monsterSettings", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y"}, this, var0);
    }

    public OptionalLong f() {
        return this.k;
    }

    public boolean g() {
        return this.l;
    }

    public boolean h() {
        return this.m;
    }

    public boolean i() {
        return this.n;
    }

    public boolean j() {
        return this.o;
    }

    public double k() {
        return this.p;
    }

    public boolean l() {
        return this.q;
    }

    public boolean m() {
        return this.r;
    }

    public int n() {
        return this.s;
    }

    public int o() {
        return this.t;
    }

    public int p() {
        return this.u;
    }

    public TagKey<Block> q() {
        return this.v;
    }

    public MinecraftKey r() {
        return this.w;
    }

    public float s() {
        return this.x;
    }

    public a t() {
        return this.y;
    }

    public static final class a
    extends Record {
        private final boolean b;
        private final boolean c;
        private final IntProvider d;
        private final int e;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.BOOL.fieldOf("piglin_safe").forGetter(a::a), (App)Codec.BOOL.fieldOf("has_raids").forGetter(a::b), (App)IntProvider.b(0, 15).fieldOf("monster_spawn_light_level").forGetter(a::c), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(a::d)).apply((Applicative)var0, a::new));

        public a(boolean var0, boolean var1, IntProvider var2, int var3) {
            this.b = var0;
            this.c = var1;
            this.d = var2;
            this.e = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piglinSafe;hasRaids;monsterSpawnLightTest;monsterSpawnBlockLightLimit", "b", "c", "d", "e"}, this, var0);
        }

        public boolean a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }

        public IntProvider c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }
    }
}

